/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorEmbeddedComponentManager {
    private static final Key<ComponentInlays> COMPONENT_INLAYS_KEY = Key.create((String)"editor.embedded.component.inlays");
    private static final int RESIZE_POINT_DELTA = JBUI.scale((int)5);
    private static final EditorEmbeddedComponentManager ourInstance = new EditorEmbeddedComponentManager();

    private EditorEmbeddedComponentManager() {
    }

    @NotNull
    public static EditorEmbeddedComponentManager getInstance() {
        EditorEmbeddedComponentManager editorEmbeddedComponentManager = ourInstance;
        if (editorEmbeddedComponentManager == null) {
            EditorEmbeddedComponentManager.$$$reportNull$$$0(0);
        }
        return editorEmbeddedComponentManager;
    }

    @Nullable
    public Inlay<?> addComponent(@NotNull EditorEx editor, @NotNull JComponent component2, @NotNull Properties properties) {
        if (editor == null) {
            EditorEmbeddedComponentManager.$$$reportNull$$$0(1);
        }
        if (component2 == null) {
            EditorEmbeddedComponentManager.$$$reportNull$$$0(2);
        }
        if (properties == null) {
            EditorEmbeddedComponentManager.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ComponentInlays inlays = EditorEmbeddedComponentManager.getComponentInlaysFor(editor);
        return inlays.add(component2, properties.resizePolicy, properties.rendererFactory, properties.relatesToPrecedingText, properties.showAbove, properties.priority, properties.offset);
    }

    @NotNull
    private static ComponentInlays getComponentInlaysFor(@NotNull EditorEx editor) {
        if (editor == null) {
            EditorEmbeddedComponentManager.$$$reportNull$$$0(4);
        }
        if (!COMPONENT_INLAYS_KEY.isIn((UserDataHolder)editor)) {
            COMPONENT_INLAYS_KEY.set((UserDataHolder)editor, (Object)new ComponentInlays(editor));
        }
        ComponentInlays componentInlays = (ComponentInlays)COMPONENT_INLAYS_KEY.get((UserDataHolder)editor);
        if (componentInlays == null) {
            EditorEmbeddedComponentManager.$$$reportNull$$$0(5);
        }
        return componentInlays;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/EditorEmbeddedComponentManager";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorEmbeddedComponentManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentInlaysFor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addComponent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getComponentInlaysFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ComponentInlays
    implements Disposable {
        private final EditorEx myEditor;
        private final List<Inlay<? extends MyRenderer>> myInlays;
        private final ResizeListener myResizeListener;

        ComponentInlays(@NotNull EditorEx editor) {
            if (editor == null) {
                ComponentInlays.$$$reportNull$$$0(0);
            }
            this.myEditor = editor;
            this.myInlays = new ArrayList<Inlay<? extends MyRenderer>>();
            this.myResizeListener = new ResizeListener();
            this.setup();
        }

        @Nullable
        Inlay<MyRenderer> add(final @NotNull JComponent component2, @NotNull ResizePolicy policy, @Nullable Properties.RendererFactory rendererFactory, boolean relatesToPrecedingText, boolean showAbove, int priority, int offset) {
            if (component2 == null) {
                ComponentInlays.$$$reportNull$$$0(1);
            }
            if (policy == null) {
                ComponentInlays.$$$reportNull$$$0(2);
            }
            MyRenderer renderer = new MyRenderer(component2, policy, rendererFactory);
            final Inlay inlay = this.myEditor.getInlayModel().addBlockElement(offset, relatesToPrecedingText, showAbove, priority, (EditorCustomElementRenderer)renderer);
            if (inlay == null) {
                return null;
            }
            renderer.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    inlay.update();
                    this.updateAllInlaysBelow(component2.getBounds());
                }
            });
            component2.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    this.updateSize((Inlay<? extends MyRenderer>)inlay);
                    inlay.update();
                    this.updateAllInlaysBelow(component2.getBounds());
                }
            });
            renderer.addMouseWheelListener(this.myEditor.getContentComponent()::dispatchEvent);
            this.update((Inlay<? extends MyRenderer>)inlay);
            inlay.update();
            this.myEditor.getContentComponent().add(renderer);
            this.myInlays.add((Inlay<? extends MyRenderer>)inlay);
            Disposer.register((Disposable)inlay, () -> {
                this.myEditor.getContentComponent().remove(renderer);
                this.myInlays.remove(inlay);
            });
            return inlay;
        }

        private void updateAllInlaysBelow(@NotNull Rectangle bounds2) {
            if (bounds2 == null) {
                ComponentInlays.$$$reportNull$$$0(3);
            }
            for (Inlay<? extends MyRenderer> i : this.getInlaysBelow(bounds2.y)) {
                this.update(i);
            }
        }

        private void setup() {
            EditorUtil.disposeWithEditor(this.myEditor, this);
            this.myEditor.getFoldingModel().addListener(new FoldingListener(){

                @Override
                public void onFoldProcessingEnd() {
                    for (Inlay inlay : myInlays) {
                        this.update((Inlay<? extends MyRenderer>)inlay);
                    }
                }
            }, this);
            this.myEditor.getInlayModel().addListener((InlayModel.Listener)new InlayModel.SimpleAdapter(){

                public void onRemoved(@NotNull Inlay inlay) {
                    if (inlay == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    Disposer.dispose((Disposable)inlay);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlay", "com/intellij/openapi/editor/impl/EditorEmbeddedComponentManager$ComponentInlays$4", "onRemoved"));
                }
            }, (Disposable)this);
            ComponentAdapter viewportListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int maxY = ((ComponentInlays)this).myEditor.getScrollPane().getViewport().getViewRect().y;
                    for (Inlay inlay : this.getInlaysBelow(maxY)) {
                        this.updateSize((Inlay<? extends MyRenderer>)inlay);
                    }
                }
            };
            JViewport viewport = this.myEditor.getScrollPane().getViewport();
            viewport.addComponentListener(viewportListener);
            Disposer.register((Disposable)this, () -> viewport.removeComponentListener(viewportListener));
            this.myEditor.addEditorMouseListener(this.myResizeListener);
            this.myEditor.addEditorMouseMotionListener(this.myResizeListener);
        }

        @NotNull
        private Collection<Inlay<? extends MyRenderer>> getInlaysBelow(int y) {
            List list2 = ContainerUtil.filter(this.myInlays, inlay -> {
                Rectangle bounds2 = ((MyRenderer)inlay.getRenderer()).getBounds();
                return bounds2 != null && bounds2.y + bounds2.height >= y;
            });
            if (list2 == null) {
                ComponentInlays.$$$reportNull$$$0(4);
            }
            return list2;
        }

        private void update(@NotNull Inlay<? extends MyRenderer> inlay) {
            if (inlay == null) {
                ComponentInlays.$$$reportNull$$$0(5);
            }
            Rectangle bounds2 = inlay.getBounds();
            MyRenderer renderer = (MyRenderer)inlay.getRenderer();
            if (bounds2 == null) {
                renderer.setVisible(false);
                return;
            }
            JScrollBar vsb = this.myEditor.getScrollPane().getVerticalScrollBar();
            renderer.setLocation(new Point(this.isVerticalScrollbarFlipped() ? vsb.getWidth() : 0, bounds2.getLocation().y));
            renderer.setVisible(true);
            this.updateSize(inlay);
        }

        private boolean isVerticalScrollbarFlipped() {
            Object flipProperty = this.myEditor.getScrollPane().getClientProperty(JBScrollPane.Flip.class);
            return flipProperty == JBScrollPane.Flip.HORIZONTAL || flipProperty == JBScrollPane.Flip.BOTH;
        }

        private void updateSize(@NotNull Inlay<? extends MyRenderer> inlay) {
            MyRenderer renderer;
            if (inlay == null) {
                ComponentInlays.$$$reportNull$$$0(6);
            }
            if (!(renderer = (MyRenderer)inlay.getRenderer()).isVisible() || this.myResizeListener.isResizeInProgress(renderer)) {
                return;
            }
            int componentWidth = renderer.getPreferredWidth();
            int componentHeight = renderer.getPreferredHeight();
            JScrollPane scrollPane = this.myEditor.getScrollPane();
            int visibleWidth = scrollPane.getViewport().getWidth() - scrollPane.getVerticalScrollBar().getWidth();
            int minWidth = renderer.isWidthSet() ? componentWidth : visibleWidth;
            int width = Math.min(componentWidth, minWidth);
            Dimension newSize = new Dimension(Math.max(width, 0), Math.max(componentHeight, 0));
            if (!renderer.getSize().equals(newSize)) {
                renderer.setSize(newSize);
            }
        }

        public void dispose() {
            this.myEditor.setCustomCursor(this, null);
            for (int i = this.myInlays.size() - 1; i > -1; --i) {
                Disposer.dispose((Disposable)((Disposable)this.myInlays.get(i)));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "policy";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bounds";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/EditorEmbeddedComponentManager$ComponentInlays";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inlay";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/EditorEmbeddedComponentManager$ComponentInlays";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInlaysBelow";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "updateAllInlaysBelow";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "updateSize";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class ResizeListener
        implements EditorMouseListener,
        EditorMouseMotionListener {
            private ResizeInfo info;

            private ResizeListener() {
            }

            public void mouseMoved(EditorMouseEvent e) {
                ResizeInfo info = this.getInfoForResizeUnder(e.getMouseEvent().getPoint());
                if (info == null) {
                    this.resetCursor();
                    return;
                }
                ComponentInlays.this.myEditor.setCustomCursor(ComponentInlays.this, info.direction.cursor);
            }

            public void mousePressed(EditorMouseEvent event) {
                Point point = event.getMouseEvent().getPoint();
                this.info = this.getInfoForResizeUnder(point);
                if (this.info == null) {
                    return;
                }
                event.consume();
            }

            public void mouseReleased(@NotNull EditorMouseEvent event) {
                if (event == null) {
                    ResizeListener.$$$reportNull$$$0(0);
                }
                this.info = null;
                this.resetCursor();
            }

            public void mouseDragged(@NotNull EditorMouseEvent event) {
                if (event == null) {
                    ResizeListener.$$$reportNull$$$0(1);
                }
                if (this.info == null) {
                    return;
                }
                Point currentPoint = event.getMouseEvent().getPoint();
                MyRenderer renderer = (MyRenderer)this.info.inlay.getRenderer();
                int xDelta = this.info.direction.xMultiplier * (currentPoint.x - renderer.getX() - renderer.getWidth());
                int yDelta = this.info.direction.yMultiplier * (currentPoint.y - renderer.getY() - renderer.getHeight());
                Dimension size = renderer.getSize();
                int newWidth = Math.max(Math.max(((MyRenderer)this.info.inlay.getRenderer()).getMinimumSize().width, size.width + xDelta), 0);
                int newHeight = Math.max(Math.max(((MyRenderer)this.info.inlay.getRenderer()).getMinimumSize().height, size.height + yDelta), 0);
                renderer.setCustomWidth(newWidth);
                renderer.setCustomHeight(newHeight);
                renderer.setSize(newWidth, newHeight);
                renderer.revalidate();
                renderer.repaint(50L);
                this.scrollTo(renderer.getBounds());
                event.consume();
            }

            public void mouseExited(@NotNull EditorMouseEvent event) {
                if (event == null) {
                    ResizeListener.$$$reportNull$$$0(2);
                }
                this.resetCursor();
            }

            boolean isResizeInProgress(@NotNull MyRenderer wrapper2) {
                if (wrapper2 == null) {
                    ResizeListener.$$$reportNull$$$0(3);
                }
                return this.info != null && wrapper2 == this.info.inlay.getRenderer();
            }

            private void scrollTo(@NotNull Rectangle inlayBounds) {
                if (inlayBounds == null) {
                    ResizeListener.$$$reportNull$$$0(4);
                }
                Rectangle contentComponentBounds = ComponentInlays.this.myEditor.getScrollPane().getViewport().getViewRect();
                int compMinX = contentComponentBounds.x;
                int compMaxX = compMinX + contentComponentBounds.width;
                int compMinY = contentComponentBounds.y;
                int compMaxY = compMinY + contentComponentBounds.height;
                int inlayMaxX = inlayBounds.x + inlayBounds.width;
                int inlayMaxY = inlayBounds.y + inlayBounds.height;
                JScrollBar hsb = ComponentInlays.this.myEditor.getScrollPane().getHorizontalScrollBar();
                JScrollBar vsb = ComponentInlays.this.myEditor.getScrollPane().getVerticalScrollBar();
                int hsbNewValue = hsb.getValue() + this.info.direction.xMultiplier * (inlayMaxX > compMaxX ? inlayMaxX - compMaxX : (inlayMaxX < compMinX ? inlayMaxX - compMinX : 0));
                int vsbNewValue = vsb.getValue() + this.info.direction.yMultiplier * (inlayMaxY > compMaxY ? inlayMaxY - compMaxY : (inlayMaxY < compMinY ? inlayMaxY - compMinY : 0));
                hsb.setValue(Math.max(0, hsbNewValue));
                vsb.setValue(Math.max(0, vsbNewValue));
            }

            private void resetCursor() {
                if (this.info == null) {
                    ComponentInlays.this.myEditor.setCustomCursor(ComponentInlays.this, null);
                }
            }

            @Nullable
            private ResizeInfo getInfoForResizeUnder(@NotNull Point point) {
                if (point == null) {
                    ResizeListener.$$$reportNull$$$0(5);
                }
                return (ResizeInfo)ContainerUtil.getFirstItem((List)ContainerUtil.mapNotNull((Collection)ComponentInlays.this.myInlays, inlay -> {
                    boolean dragFromRight;
                    ResizePolicy policy = ((MyRenderer)inlay.getRenderer()).resizePolicy;
                    if (!policy.isResizable()) {
                        return null;
                    }
                    Rectangle bounds2 = inlay.getBounds();
                    if (bounds2 == null) {
                        return null;
                    }
                    int pressY = point.y;
                    int pressX = point.x;
                    int inlayTY = bounds2.y;
                    int inlayLX = bounds2.x;
                    int inlayBY = bounds2.y + bounds2.height;
                    int inlayRX = bounds2.x + bounds2.width;
                    boolean dragFromBottom = policy.isResizableFromBottom() && this.isInside(pressX, inlayLX, inlayRX) && this.isNearTo(pressY, inlayBY);
                    boolean bl = dragFromRight = policy.isResizableFromRight() && this.isInside(pressY, inlayTY, inlayBY) && this.isNearTo(pressX, inlayRX);
                    ResizeDirection direction = dragFromBottom && dragFromRight ? ResizeDirection.BOTTOM_RIGHT : (dragFromBottom ? ResizeDirection.BOTTOM : (dragFromRight ? ResizeDirection.RIGHT : null));
                    return direction == null ? null : new ResizeInfo((Inlay<? extends MyRenderer>)inlay, direction);
                }));
            }

            private boolean isNearTo(int value2, int coordinate) {
                return this.isInside(value2, coordinate, coordinate);
            }

            private boolean isInside(int value2, int min, int max) {
                return value2 > min - RESIZE_POINT_DELTA && value2 < max + RESIZE_POINT_DELTA;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "wrapper";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inlayBounds";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "point";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorEmbeddedComponentManager$ComponentInlays$ResizeListener";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseReleased";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseDragged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseExited";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isResizeInProgress";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "scrollTo";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getInfoForResizeUnder";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static enum ResizeDirection {
            BOTTOM(0, 1, Cursor.getPredefinedCursor(9)),
            RIGHT(1, 0, Cursor.getPredefinedCursor(11)),
            BOTTOM_RIGHT(1, 1, Cursor.getPredefinedCursor(5));

            final int xMultiplier;
            final int yMultiplier;
            final Cursor cursor;

            private ResizeDirection(@NotNull int xMultiplier, int yMultiplier, Cursor cursor) {
                if (cursor == null) {
                    ResizeDirection.$$$reportNull$$$0(0);
                }
                this.xMultiplier = xMultiplier;
                this.yMultiplier = yMultiplier;
                this.cursor = cursor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cursor", "com/intellij/openapi/editor/impl/EditorEmbeddedComponentManager$ComponentInlays$ResizeDirection", "<init>"));
            }
        }

        private static class ResizeInfo {
            final Inlay<? extends MyRenderer> inlay;
            final ResizeDirection direction;
            final int startWidth;

            ResizeInfo(@NotNull Inlay<? extends MyRenderer> inlay, @NotNull ResizeDirection direction) {
                if (inlay == null) {
                    ResizeInfo.$$$reportNull$$$0(0);
                }
                if (direction == null) {
                    ResizeInfo.$$$reportNull$$$0(1);
                }
                this.inlay = inlay;
                this.direction = direction;
                this.startWidth = ((MyRenderer)inlay.getRenderer()).getWidth();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "inlay";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "direction";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/editor/impl/EditorEmbeddedComponentManager$ComponentInlays$ResizeInfo";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class MyRenderer
    extends JPanel
    implements EditorCustomElementRenderer {
        private static final int UNDEFINED = -1;
        final ResizePolicy resizePolicy;
        private final Properties.RendererFactory myRendererFactory;
        private int myCustomWidth;
        private int myCustomHeight;

        MyRenderer(@NotNull JComponent component2, @NotNull ResizePolicy resizePolicy, @Nullable Properties.RendererFactory rendererFactory) {
            if (component2 == null) {
                MyRenderer.$$$reportNull$$$0(0);
            }
            if (resizePolicy == null) {
                MyRenderer.$$$reportNull$$$0(1);
            }
            super(new BorderLayout());
            this.myCustomWidth = -1;
            this.myCustomHeight = -1;
            this.resizePolicy = resizePolicy;
            this.myRendererFactory = rendererFactory;
            this.add((Component)component2, "Center");
            this.setOpaque(false);
        }

        @Nullable
        public GutterIconRenderer calcGutterIconRenderer(@NotNull Inlay inlay) {
            if (inlay == null) {
                MyRenderer.$$$reportNull$$$0(2);
            }
            return this.myRendererFactory == null ? null : this.myRendererFactory.createRenderer(inlay);
        }

        void setCustomWidth(int customWidth) {
            if (customWidth != this.getPreferredWidth()) {
                this.myCustomWidth = customWidth;
            }
        }

        void setCustomHeight(int customHeight) {
            if (customHeight != this.getPreferredHeight()) {
                this.myCustomHeight = customHeight;
            }
        }

        int getPreferredWidth() {
            return this.isWidthSet() ? this.myCustomWidth : this.getPreferredSize().width;
        }

        int getPreferredHeight() {
            return this.myCustomHeight == -1 ? this.getPreferredSize().height : this.myCustomHeight;
        }

        boolean isWidthSet() {
            return this.myCustomWidth != -1;
        }

        public int calcHeightInPixels(@NotNull Inlay inlay) {
            if (inlay == null) {
                MyRenderer.$$$reportNull$$$0(3);
            }
            return Math.max(this.getHeight(), 0);
        }

        public int calcWidthInPixels(@NotNull Inlay inlay) {
            if (inlay == null) {
                MyRenderer.$$$reportNull$$$0(4);
            }
            return Math.max(this.getWidth(), 0);
        }

        public void paint(@NotNull Inlay inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
            Rectangle currentBounds;
            if (inlay == null) {
                MyRenderer.$$$reportNull$$$0(5);
            }
            if (g == null) {
                MyRenderer.$$$reportNull$$$0(6);
            }
            if (targetRegion == null) {
                MyRenderer.$$$reportNull$$$0(7);
            }
            if (textAttributes == null) {
                MyRenderer.$$$reportNull$$$0(8);
            }
            if ((currentBounds = inlay.getBounds()) == null || Objects.equals(currentBounds, this.getBounds())) {
                return;
            }
            this.setBounds(currentBounds);
            this.revalidate();
            this.repaint(50L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Composite old = g2d.getComposite();
            try {
                g2d.setComposite(AlphaComposite.SrcOver);
                super.paint(g);
            }
            finally {
                g2d.setComposite(old);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resizePolicy";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inlay";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetRegion";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textAttributes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/EditorEmbeddedComponentManager$MyRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calcGutterIconRenderer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calcHeightInPixels";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calcWidthInPixels";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Properties {
        final ResizePolicy resizePolicy;
        final RendererFactory rendererFactory;
        final boolean relatesToPrecedingText;
        final boolean showAbove;
        final int priority;
        final int offset;

        public Properties(@NotNull ResizePolicy resizePolicy, @Nullable RendererFactory rendererFactory, boolean relatesToPrecedingText, boolean showAbove, int priority, int offset) {
            if (resizePolicy == null) {
                Properties.$$$reportNull$$$0(0);
            }
            this.resizePolicy = resizePolicy;
            this.rendererFactory = rendererFactory;
            this.relatesToPrecedingText = relatesToPrecedingText;
            this.showAbove = showAbove;
            this.priority = priority;
            this.offset = offset;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resizePolicy", "com/intellij/openapi/editor/impl/EditorEmbeddedComponentManager$Properties", "<init>"));
        }

        public static interface RendererFactory {
            @Nullable
            public GutterIconRenderer createRenderer(@NotNull Inlay<?> var1);
        }
    }

    public static class ResizePolicy {
        private static final int RIGHT = 2;
        private static final int BOTTOM = 4;
        private static final ResizePolicy ourAny = new ResizePolicy(6);
        private static final ResizePolicy ourNone = new ResizePolicy(0);
        private final int myFlags;

        private ResizePolicy(int flags) {
            this.myFlags = flags;
        }

        public boolean isResizable() {
            return this.isResizableFromRight() || this.isResizableFromBottom();
        }

        public static ResizePolicy any() {
            return ourAny;
        }

        @NotNull
        public static ResizePolicy none() {
            ResizePolicy resizePolicy = ourNone;
            if (resizePolicy == null) {
                ResizePolicy.$$$reportNull$$$0(0);
            }
            return resizePolicy;
        }

        public boolean isResizableFromRight() {
            return (this.myFlags & 2) != 0;
        }

        public boolean isResizableFromBottom() {
            return (this.myFlags & 4) != 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorEmbeddedComponentManager$ResizePolicy", "none"));
        }
    }
}

