/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.ide.startup.ServiceNotReadyException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.constraints.ConstrainedExecution;
import com.intellij.openapi.application.constraints.ExpirableConstrainedExecution;
import com.intellij.openapi.application.constraints.Expiration;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.AsyncExecutionServiceImpl;
import com.intellij.openapi.application.impl.InSmartMode;
import com.intellij.openapi.application.impl.WithDocumentsCommitted;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.RunnableCallable;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@VisibleForTesting
public class NonBlockingReadActionImpl<T>
extends ExpirableConstrainedExecution<NonBlockingReadActionImpl<T>>
implements NonBlockingReadAction<T> {
    private static final Logger LOG = Logger.getInstance(NonBlockingReadActionImpl.class);
    private static final Executor SYNC_DUMMY_EXECUTOR = __ -> {
        throw new UnsupportedOperationException();
    };
    @Nullable
    private final Pair<ModalityState, Consumer<T>> myEdtFinish;
    @Nullable
    private final List<Object> myCoalesceEquality;
    @Nullable
    private final ProgressIndicator myProgressIndicator;
    private final Callable<T> myComputation;
    private static final Set<Submission> ourTasks = ContainerUtil.newConcurrentSet();
    private static final Map<List<Object>, Submission> ourTasksByEquality = new HashMap<List<Object>, Submission>();
    private static final AtomicInteger ourUnboundedSubmissionCount = new AtomicInteger();

    NonBlockingReadActionImpl(@NotNull Callable<T> computation) {
        if (computation == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(0);
        }
        this(computation, null, new ConstrainedExecution.ContextConstraint[0], new BooleanSupplier[0], Collections.emptySet(), null, null);
    }

    private NonBlockingReadActionImpl(@NotNull Callable<T> computation, @Nullable Pair<ModalityState, Consumer<T>> edtFinish, ConstrainedExecution.ContextConstraint @NotNull [] constraints, BooleanSupplier @NotNull [] cancellationConditions, @NotNull Set<? extends Expiration> expirationSet, @Nullable List<Object> coalesceEquality, @Nullable ProgressIndicator progressIndicator2) {
        if (computation == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(1);
        }
        if (expirationSet == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(2);
        }
        if (constraints == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(3);
        }
        if (cancellationConditions == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(4);
        }
        super(constraints, cancellationConditions, expirationSet);
        this.myComputation = computation;
        this.myEdtFinish = edtFinish;
        this.myCoalesceEquality = coalesceEquality;
        this.myProgressIndicator = progressIndicator2;
    }

    @Override
    @NotNull
    protected NonBlockingReadActionImpl<T> cloneWith(ConstrainedExecution.ContextConstraint @NotNull [] constraints, BooleanSupplier @NotNull [] cancellationConditions, @NotNull Set<? extends Expiration> expirationSet) {
        if (expirationSet == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(5);
        }
        if (constraints == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(6);
        }
        if (cancellationConditions == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(7);
        }
        return new NonBlockingReadActionImpl<T>(this.myComputation, this.myEdtFinish, constraints, cancellationConditions, expirationSet, this.myCoalesceEquality, this.myProgressIndicator);
    }

    @Override
    public void dispatchLaterUnconstrained(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().invokeLaterOnWriteThread(runnable2, ModalityState.any());
    }

    public NonBlockingReadAction<T> inSmartMode(@NotNull Project project) {
        if (project == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(9);
        }
        return (NonBlockingReadAction)this.withConstraint(new InSmartMode(project), NonBlockingReadActionImpl.earlyDisposable((Disposable)project));
    }

    public NonBlockingReadAction<T> withDocumentsCommitted(@NotNull Project project) {
        if (project == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(10);
        }
        return (NonBlockingReadAction)this.withConstraint(new WithDocumentsCommitted(project, ModalityState.any()), NonBlockingReadActionImpl.earlyDisposable((Disposable)project));
    }

    public NonBlockingReadAction<T> expireWhen(@NotNull BooleanSupplier expireCondition) {
        if (expireCondition == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(11);
        }
        return (NonBlockingReadAction)this.cancelIf(expireCondition);
    }

    @Override
    @NotNull
    public NonBlockingReadActionImpl<T> expireWith(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(12);
        }
        NonBlockingReadActionImpl nonBlockingReadActionImpl = (NonBlockingReadActionImpl)super.expireWith(NonBlockingReadActionImpl.earlyDisposable(parentDisposable));
        if (nonBlockingReadActionImpl == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(13);
        }
        return nonBlockingReadActionImpl;
    }

    private static Disposable earlyDisposable(Disposable disposable2) {
        return disposable2 instanceof ProjectEx && !((ProjectEx)disposable2).isDisposed() ? ((ProjectEx)disposable2).getEarlyDisposable() : disposable2;
    }

    public NonBlockingReadAction<T> wrapProgress(@NotNull ProgressIndicator progressIndicator2) {
        if (progressIndicator2 == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(14);
        }
        LOG.assertTrue(this.myProgressIndicator == null, (Object)"Unspecified behaviour. Outer progress indicator is already set for the action.");
        return new NonBlockingReadActionImpl<T>(this.myComputation, this.myEdtFinish, this.getConstraints(), this.getCancellationConditions(), this.getExpirationSet(), this.myCoalesceEquality, progressIndicator2);
    }

    public NonBlockingReadAction<T> finishOnUiThread(@NotNull ModalityState modality, @NotNull Consumer<T> uiThreadAction) {
        if (modality == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(15);
        }
        if (uiThreadAction == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(16);
        }
        return new NonBlockingReadActionImpl<T>(this.myComputation, Pair.create((Object)modality, uiThreadAction), this.getConstraints(), this.getCancellationConditions(), this.getExpirationSet(), this.myCoalesceEquality, this.myProgressIndicator);
    }

    public NonBlockingReadAction<T> coalesceBy(Object ... equality) {
        if (equality == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(17);
        }
        if (this.myCoalesceEquality != null) {
            throw new IllegalStateException("Setting equality twice is not allowed");
        }
        if (equality.length == 0) {
            throw new IllegalArgumentException("Equality should include at least one object");
        }
        if (equality.length == 1 && NonBlockingReadActionImpl.isTooCommon(equality[0])) {
            throw new IllegalArgumentException("Equality should be unique: passing " + equality[0] + " is likely to interfere with unrelated computations from different places");
        }
        return new NonBlockingReadActionImpl<T>(this.myComputation, this.myEdtFinish, this.getConstraints(), this.getCancellationConditions(), this.getExpirationSet(), ContainerUtil.newArrayList((Object[])equality), this.myProgressIndicator);
    }

    private static boolean isTooCommon(Object o) {
        return o instanceof Project || o instanceof PsiElement || o instanceof Document || o instanceof VirtualFile || o instanceof Editor || o instanceof FileEditor || o instanceof Class || o instanceof KClass || o instanceof String || o == null;
    }

    public T executeSynchronously() throws ProcessCanceledException {
        if (this.myEdtFinish != null || this.myCoalesceEquality != null) {
            throw new IllegalStateException((this.myEdtFinish != null ? "finishOnUiThread" : "coalesceBy") + " is not supported with synchronous non-blocking read actions");
        }
        ProgressIndicator outerIndicator = this.myProgressIndicator != null ? this.myProgressIndicator : ProgressIndicatorProvider.getGlobalProgressIndicator();
        return new Submission(SYNC_DUMMY_EXECUTOR, outerIndicator).executeSynchronously();
    }

    public CancellablePromise<T> submit(@NotNull Executor backgroundThreadExecutor) {
        if (backgroundThreadExecutor == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(18);
        }
        Submission submission = new Submission(backgroundThreadExecutor, this.myProgressIndicator);
        if (this.myCoalesceEquality == null) {
            submission.transferToBgThread();
        } else {
            submission.submitOrScheduleCoalesced(this.myCoalesceEquality);
        }
        return submission;
    }

    public static void waitForAsyncTaskCompletion() {
        assert (!ApplicationManager.getApplication().isWriteAccessAllowed());
        for (Submission task2 : ourTasks) {
            NonBlockingReadActionImpl.waitForTask(task2);
        }
    }

    private static void waitForTask(@NotNull Submission task2) {
        if (task2 == null) {
            NonBlockingReadActionImpl.$$$reportNull$$$0(19);
        }
        int iteration = 0;
        while (!task2.isDone() && iteration++ < 60000) {
            UIUtil.dispatchAllInvocationEvents();
            try {
                task2.blockingGet(1, TimeUnit.MILLISECONDS);
                return;
            }
            catch (TimeoutException timeoutException) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (!task2.isDone()) {
            System.err.println(ThreadDumper.dumpThreadsToString());
            throw new AssertionError((Object)("Too long async task " + (Object)((Object)task2)));
        }
    }

    static Map<List<Object>, Submission> getTasksByEquality() {
        return ourTasksByEquality;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expirationSet";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancellationConditions";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expireCondition";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/impl/NonBlockingReadActionImpl";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiThreadAction";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equality";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backgroundThreadExecutor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/impl/NonBlockingReadActionImpl";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "expireWith";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "cloneWith";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "dispatchLaterUnconstrained";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "inSmartMode";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "withDocumentsCommitted";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "expireWhen";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "expireWith";
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "wrapProgress";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "finishOnUiThread";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "coalesceBy";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "submit";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "waitForTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Submission
    extends AsyncPromise<T> {
        @NotNull
        private final Executor backendExecutor;
        private volatile ProgressIndicator currentIndicator;
        private final ModalityState creationModality;
        @Nullable
        private final BooleanSupplier myExpireCondition;
        @Nullable
        private Submission myReplacement;
        @Nullable
        private final ProgressIndicator myProgressIndicator;
        private int myUseCount;
        private final AtomicBoolean myCleaned;
        private final Expiration.Handle myExpirationHandle;

        Submission(@Nullable Executor backgroundThreadExecutor, ProgressIndicator outerIndicator) {
            Expiration expiration;
            if (backgroundThreadExecutor == null) {
                Submission.$$$reportNull$$$0(0);
            }
            this.creationModality = ModalityState.defaultModalityState();
            this.myCleaned = new AtomicBoolean();
            this.backendExecutor = backgroundThreadExecutor;
            if (NonBlockingReadActionImpl.this.myCoalesceEquality != null) {
                this.acquire();
            }
            this.myExpireCondition = NonBlockingReadActionImpl.this.composeCancellationCondition();
            this.myProgressIndicator = outerIndicator;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Creating " + (Object)((Object)this));
            }
            if (this.hasUnboundedExecutor()) {
                this.preventTooManySubmissions();
            }
            if (this.shouldTrackInTests()) {
                ourTasks.add(this);
            }
            this.myExpirationHandle = (expiration = NonBlockingReadActionImpl.this.composeExpiration()) == null ? null : expiration.invokeOnExpiration(() -> ((Submission)this).cancel());
        }

        private boolean shouldTrackInTests() {
            return this.backendExecutor != SYNC_DUMMY_EXECUTOR && ApplicationManager.getApplication().isUnitTestMode();
        }

        private boolean hasUnboundedExecutor() {
            return this.backendExecutor == AppExecutorUtil.getAppExecutorService();
        }

        private void preventTooManySubmissions() {
            if (ourUnboundedSubmissionCount.incrementAndGet() % 107 == 0) {
                String dump = "Thread dump:\n" + ThreadDumper.dumpThreadsToString();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(dump);
                }
                Attachment attachment = new Attachment("threadDump.txt", dump);
                attachment.setIncluded(true);
                LOG.error("Too many non-blocking read actions submitted at once. Please use coalesceBy, BoundedTaskExecutor or another way of limiting the number of concurrently running threads.", new Attachment[]{attachment});
            }
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean result2 = super.cancel(mayInterruptIfRunning);
            this.cleanupIfNeeded();
            return result2;
        }

        public void setResult(@Nullable T t) {
            super.setResult(t);
            this.cleanupIfNeeded();
        }

        public boolean setError(@NotNull Throwable error) {
            if (error == null) {
                Submission.$$$reportNull$$$0(1);
            }
            boolean result2 = super.setError(error);
            this.cleanupIfNeeded();
            return result2;
        }

        protected boolean shouldLogErrors() {
            return this.backendExecutor != SYNC_DUMMY_EXECUTOR;
        }

        private void cleanupIfNeeded() {
            if (this.myCleaned.compareAndSet(false, true)) {
                this.cleanup();
            }
        }

        private void cleanup() {
            ProgressIndicator indicator;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Cleaning " + (Object)((Object)this));
            }
            if ((indicator = this.currentIndicator) != null) {
                indicator.cancel();
            }
            if (NonBlockingReadActionImpl.this.myCoalesceEquality != null) {
                this.release();
            }
            if (this.myExpirationHandle != null) {
                this.myExpirationHandle.unregisterHandler();
            }
            if (this.hasUnboundedExecutor()) {
                ourUnboundedSubmissionCount.decrementAndGet();
            }
            if (this.shouldTrackInTests()) {
                ourTasks.remove((Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void acquire() {
            assert (NonBlockingReadActionImpl.this.myCoalesceEquality != null);
            Map map2 = ourTasksByEquality;
            synchronized (map2) {
                ++this.myUseCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void release() {
            assert (NonBlockingReadActionImpl.this.myCoalesceEquality != null);
            Map map2 = ourTasksByEquality;
            synchronized (map2) {
                if (--this.myUseCount == 0 && ourTasksByEquality.get(NonBlockingReadActionImpl.this.myCoalesceEquality) == this) {
                    this.scheduleReplacementIfAny();
                }
            }
        }

        private void scheduleReplacementIfAny() {
            if (this.myReplacement == null || this.myReplacement.isDone()) {
                ourTasksByEquality.remove(NonBlockingReadActionImpl.this.myCoalesceEquality, (Object)this);
            } else {
                ourTasksByEquality.put(NonBlockingReadActionImpl.this.myCoalesceEquality, this.myReplacement);
                this.myReplacement.transferToBgThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void submitOrScheduleCoalesced(@NotNull List<Object> coalesceEquality) {
            if (coalesceEquality == null) {
                Submission.$$$reportNull$$$0(2);
            }
            Map map2 = ourTasksByEquality;
            synchronized (map2) {
                if (this.isDone()) {
                    return;
                }
                Submission current2 = (Submission)((Object)ourTasksByEquality.get(coalesceEquality));
                if (current2 == null) {
                    ourTasksByEquality.put(coalesceEquality, this);
                    this.transferToBgThread();
                } else {
                    if (!current2.getComputationOrigin().equals(this.getComputationOrigin())) {
                        this.reportCoalescingConflict(current2);
                    }
                    if (current2.myReplacement != null) {
                        current2.myReplacement.cancel();
                        assert (current2 == ourTasksByEquality.get(coalesceEquality));
                    }
                    current2.myReplacement = this;
                    current2.cancel();
                }
            }
        }

        private void reportCoalescingConflict(Submission current2) {
            ourTasks.remove((Object)this);
            LOG.error("Same coalesceBy arguments are already used by " + current2.getComputationOrigin() + " so they can cancel each other. Please make them more unique.");
        }

        @NotNull
        private String getComputationOrigin() {
            String name;
            int dollars;
            Object computation = NonBlockingReadActionImpl.this.myComputation;
            if (computation instanceof RunnableCallable) {
                computation = ((RunnableCallable)computation).getDelegate();
            }
            String string = (dollars = (name = computation.getClass().getName()).indexOf("$$Lambda")) >= 0 ? name.substring(0, dollars) : name;
            if (string == null) {
                Submission.$$$reportNull$$$0(3);
            }
            return string;
        }

        void transferToBgThread() {
            ApplicationEx app;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Submitting " + (Object)((Object)this));
            }
            if ((app = ApplicationManagerEx.getApplicationEx()).isWriteActionInProgress() || app.isWriteActionPending()) {
                this.rescheduleLater();
                return;
            }
            if (NonBlockingReadActionImpl.this.myCoalesceEquality != null) {
                this.acquire();
            }
            this.backendExecutor.execute(() -> {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Running in background " + (Object)((Object)this));
                }
                try {
                    if (!this.attemptComputation()) {
                        this.rescheduleLater();
                    }
                }
                finally {
                    if (NonBlockingReadActionImpl.this.myCoalesceEquality != null) {
                        this.release();
                    }
                }
            });
        }

        T executeSynchronously() {
            do {
                this.attemptComputation();
                if (this.isCancelled()) {
                    throw new ProcessCanceledException();
                }
                if (this.isDone()) {
                    try {
                        return this.blockingGet(0, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException e) {
                        throw new RuntimeException(e);
                    }
                }
                Semaphore semaphore = new Semaphore(1);
                NonBlockingReadActionImpl.this.dispatchLaterUnconstrained(() -> {
                    if (this.checkObsolete()) {
                        semaphore.up();
                    } else {
                        NonBlockingReadActionImpl.this.scheduleWithinConstraints(() -> ((Semaphore)semaphore).up(), null);
                    }
                });
                ProgressIndicatorUtils.awaitWithCheckCanceled(semaphore, this.myProgressIndicator);
            } while (!this.isCancelled());
            throw new ProcessCanceledException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean attemptComputation() {
            SensitiveProgressWrapper indicator;
            SensitiveProgressWrapper sensitiveProgressWrapper = indicator = this.myProgressIndicator != null ? new SensitiveProgressWrapper(this.myProgressIndicator){

                @Override
                @NotNull
                public ModalityState getModalityState() {
                    ModalityState modalityState = Submission.this.creationModality;
                    if (modalityState == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return modalityState;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/NonBlockingReadActionImpl$Submission$1", "getModalityState"));
                }
            } : new EmptyProgressIndicator(this.creationModality);
            if (this.myProgressIndicator != null) {
                indicator.setIndeterminate(this.myProgressIndicator.isIndeterminate());
            }
            this.currentIndicator = indicator;
            try {
                boolean success;
                Ref unsatisfiedConstraint = Ref.create();
                Runnable runnable2 = () -> this.insideReadAction(indicator, (Ref<ConstrainedExecution.ContextConstraint>)unsatisfiedConstraint);
                if (ApplicationManager.getApplication().isReadAccessAllowed()) {
                    runnable2.run();
                    success = true;
                    if (!unsatisfiedConstraint.isNull()) {
                        throw new IllegalStateException("Constraint " + unsatisfiedConstraint + " cannot be satisfied");
                    }
                } else {
                    success = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(runnable2, indicator);
                }
                boolean bl = success && unsatisfiedConstraint.isNull();
                return bl;
            }
            finally {
                this.currentIndicator = null;
            }
        }

        private void rescheduleLater() {
            if (Promises.isPending((Promise)this)) {
                NonBlockingReadActionImpl.this.dispatchLaterUnconstrained(() -> this.reschedule());
            }
        }

        private void reschedule() {
            if (!this.checkObsolete()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Rescheduling " + (Object)((Object)this));
                }
                NonBlockingReadActionImpl.this.scheduleWithinConstraints(() -> this.transferToBgThread(), null);
            }
        }

        private void insideReadAction(ProgressIndicator indicator, Ref<ConstrainedExecution.ContextConstraint> outUnsatisfiedConstraint) {
            try {
                if (this.checkObsolete()) {
                    return;
                }
                ConstrainedExecution.ContextConstraint constraint = (ConstrainedExecution.ContextConstraint)ContainerUtil.find((Object[])NonBlockingReadActionImpl.this.getConstraints(), t -> !t.isCorrectContext());
                if (constraint != null) {
                    outUnsatisfiedConstraint.set((Object)constraint);
                    return;
                }
                Object result2 = NonBlockingReadActionImpl.this.myComputation.call();
                if (NonBlockingReadActionImpl.this.myEdtFinish != null) {
                    this.safeTransferToEdt(result2, NonBlockingReadActionImpl.this.myEdtFinish);
                } else {
                    this.setResult(result2);
                }
            }
            catch (ServiceNotReadyException e) {
                throw e;
            }
            catch (ProcessCanceledException e) {
                if (!indicator.isCanceled()) {
                    this.setError(e);
                }
                throw e;
            }
            catch (Throwable e) {
                this.setError(e);
            }
        }

        private boolean checkObsolete() {
            if (Promises.isRejected((Promise)this)) {
                return true;
            }
            if (this.myExpireCondition != null && this.myExpireCondition.getAsBoolean()) {
                this.cancel();
                return true;
            }
            if (this.myProgressIndicator != null && this.myProgressIndicator.isCanceled()) {
                this.cancel();
                return true;
            }
            return false;
        }

        private void safeTransferToEdt(T result2, Pair<? extends ModalityState, ? extends Consumer<T>> edtFinish) {
            if (Promises.isRejected((Promise)this)) {
                return;
            }
            long stamp = AsyncExecutionServiceImpl.getWriteActionCounter();
            ApplicationManager.getApplication().invokeLater(() -> {
                if (stamp != AsyncExecutionServiceImpl.getWriteActionCounter()) {
                    this.reschedule();
                    return;
                }
                if (this.checkObsolete()) {
                    return;
                }
                this.setResult(result2);
                if (this.isSucceeded()) {
                    ((Consumer)edtFinish.second).accept(result2);
                }
            }, (ModalityState)edtFinish.first);
        }

        public String toString() {
            return "Submission{" + NonBlockingReadActionImpl.this.myComputation + ", " + this.getState() + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "backgroundThreadExecutor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "error";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "coalesceEquality";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/application/impl/NonBlockingReadActionImpl$Submission";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/application/impl/NonBlockingReadActionImpl$Submission";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComputationOrigin";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setError";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "submitOrScheduleCoalesced";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

