/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.internal.inspector.UiInspectorUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ActionPopupMenuImpl
implements ActionPopupMenu,
ApplicationActivationListener {
    private static final Logger LOG = Logger.getInstance(ActionPopupMenuImpl.class);
    private final Application myApp;
    private final MyMenu myMenu;
    private final ActionManagerImpl myManager;
    private Getter<? extends DataContext> myDataContextProvider;
    private MessageBusConnection myConnection;
    private IdeFrame myFrame;
    private boolean myIsToolWindowContextMenu;

    ActionPopupMenuImpl(@NotNull String place, @NotNull ActionGroup group, @NotNull ActionManagerImpl actionManager, @Nullable PresentationFactory factory) {
        if (place == null) {
            ActionPopupMenuImpl.$$$reportNull$$$0(0);
        }
        if (group == null) {
            ActionPopupMenuImpl.$$$reportNull$$$0(1);
        }
        if (actionManager == null) {
            ActionPopupMenuImpl.$$$reportNull$$$0(2);
        }
        this.myManager = actionManager;
        this.myMenu = new MyMenu(place, group, factory);
        this.myApp = ApplicationManager.getApplication();
    }

    @NotNull
    public JPopupMenu getComponent() {
        MyMenu myMenu = this.myMenu;
        if (myMenu == null) {
            ActionPopupMenuImpl.$$$reportNull$$$0(3);
        }
        return myMenu;
    }

    @NotNull
    public String getPlace() {
        String string = this.myMenu.myPlace;
        if (string == null) {
            ActionPopupMenuImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public ActionGroup getActionGroup() {
        ActionGroup actionGroup = this.myMenu.myGroup;
        if (actionGroup == null) {
            ActionPopupMenuImpl.$$$reportNull$$$0(5);
        }
        return actionGroup;
    }

    void setDataContextProvider(@NotNull Getter<? extends DataContext> dataContextProvider) {
        if (dataContextProvider == null) {
            ActionPopupMenuImpl.$$$reportNull$$$0(6);
        }
        this.myDataContextProvider = dataContextProvider;
    }

    public void setTargetComponent(@NotNull JComponent component2) {
        if (component2 == null) {
            ActionPopupMenuImpl.$$$reportNull$$$0(7);
        }
        this.myDataContextProvider = () -> DataManager.getInstance().getDataContext((Component)component2);
        this.myIsToolWindowContextMenu = ComponentUtil.getParentOfType(InternalDecorator.class, (Component)component2) != null;
    }

    boolean isToolWindowContextMenu() {
        return this.myIsToolWindowContextMenu;
    }

    public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
        if (ideFrame == null) {
            ActionPopupMenuImpl.$$$reportNull$$$0(8);
        }
        if (this.myFrame == ideFrame) {
            this.myMenu.setVisible(false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManager";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/impl/ActionPopupMenuImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContextProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideFrame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionPopupMenuImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlace";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setDataContextProvider";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setTargetComponent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applicationDeactivated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyMenu
    extends JBPopupMenu {
        @NotNull
        private final String myPlace;
        @NotNull
        private final ActionGroup myGroup;
        private DataContext myContext;
        private final PresentationFactory myPresentationFactory;

        MyMenu(@NotNull String place, @Nullable ActionGroup group, PresentationFactory factory) {
            if (place == null) {
                MyMenu.$$$reportNull$$$0(0);
            }
            if (group == null) {
                MyMenu.$$$reportNull$$$0(1);
            }
            this.myPlace = place;
            this.myGroup = group;
            this.myPresentationFactory = factory != null ? factory : new MenuItemPresentationFactory();
            this.addPopupMenuListener(new MyPopupMenuListener());
            UiInspectorUtil.registerProvider((JComponent)((Object)this), () -> UiInspectorUtil.collectActionGroupInfo("Menu", this.myGroup, this.myPlace));
        }

        public void show(@NotNull Component component2, int x, int y) {
            if (component2 == null) {
                MyMenu.$$$reportNull$$$0(2);
            }
            if (!component2.isShowing()) {
                throw new IllegalArgumentException("component must be shown on the screen (" + component2 + ")");
            }
            this.removeAll();
            int x2 = Math.max(0, Math.min(x, component2.getWidth() - 1));
            int y2 = Math.max(0, Math.min(y, component2.getHeight() - 1));
            this.myContext = ActionPopupMenuImpl.this.myDataContextProvider != null ? (DataContext)ActionPopupMenuImpl.this.myDataContextProvider.get() : DataManager.getInstance().getDataContext(component2, x2, y2);
            long time = -System.currentTimeMillis();
            Utils.fillMenu(this.myGroup, (JComponent)((Object)this), true, this.myPresentationFactory, this.myContext, this.myPlace, false, LaterInvocator.isInModalContext(), false);
            if ((time += System.currentTimeMillis()) > 1000L) {
                LOG.warn(time + "ms to fill popup menu " + this.myPlace);
            }
            if (this.getComponentCount() == 0) {
                LOG.warn("no components in popup menu " + this.myPlace);
                return;
            }
            if (ActionPopupMenuImpl.this.myApp != null && ActionPopupMenuImpl.this.myApp.isActive()) {
                Component frame = ComponentUtil.findUltimateParent((Component)component2);
                if (frame instanceof IdeFrame) {
                    ActionPopupMenuImpl.this.myFrame = (IdeFrame)frame;
                }
                ActionPopupMenuImpl.this.myConnection = ActionPopupMenuImpl.this.myApp.getMessageBus().connect();
                ActionPopupMenuImpl.this.myConnection.subscribe(ApplicationActivationListener.TOPIC, (Object)ActionPopupMenuImpl.this);
            }
            assert (component2.isShowing()) : "Component: " + component2;
            super.show(component2, x, y);
        }

        public void setVisible(boolean b) {
            super.setVisible(b);
            if (!b) {
                ReflectionUtil.resetField((Object)((Object)this), (String)"invoker");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionPopupMenuImpl$MyMenu";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "show";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class MyPopupMenuListener
        implements PopupMenuListener {
            private MyPopupMenuListener() {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                this.disposeMenu();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                this.disposeMenu();
            }

            private void disposeMenu() {
                ActionPopupMenuImpl.this.myManager.removeActionPopup(ActionPopupMenuImpl.this);
                MyMenu.this.removeAll();
                if (ActionPopupMenuImpl.this.myConnection != null) {
                    ActionPopupMenuImpl.this.myConnection.disconnect();
                }
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                MyMenu.this.removeAll();
                Utils.fillMenu(MyMenu.this.myGroup, (JComponent)((Object)MyMenu.this), !UISettings.getInstance().getDisableMnemonics(), MyMenu.this.myPresentationFactory, MyMenu.this.myContext, MyMenu.this.myPlace, false, LaterInvocator.isInModalContext(), false);
                ActionPopupMenuImpl.this.myManager.addActionPopup(ActionPopupMenuImpl.this);
            }
        }
    }
}

