/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.notification.EventLogCategory;
import com.intellij.notification.EventLogConsole;
import com.intellij.notification.EventLogToolWindowFactory;
import com.intellij.notification.LogModel;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.impl.NotificationCollector;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.content.Content;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class EventLog {
    public static final String LOG_REQUESTOR = "Internal log requestor";
    public static final String LOG_TOOL_WINDOW_ID = "Event Log";
    public static final String HELP_ID = "reference.toolwindows.event.log";
    private static final String A_CLOSING = "</a>";
    private static final Pattern TAG_PATTERN = Pattern.compile("<[^>]*>");
    private static final Pattern A_PATTERN = Pattern.compile("<a ([^>]* )?href=[\"']([^>]*)[\"'][^>]*>");
    private static final Set<String> NEW_LINES = ContainerUtil.newHashSet((Object[])new String[]{"<br>", "</br>", "<br/>", "<p>", "</p>", "<p/>", "<pre>", "</pre>"});
    private static final String DEFAULT_CATEGORY = "";
    private final LogModel myModel = new LogModel(null);
    private static final String[] HTML_TAGS = new String[]{"a", "abbr", "acronym", "address", "applet", "area", "article", "aside", "audio", "b", "base", "basefont", "bdi", "bdo", "big", "blockquote", "body", "br", "button", "canvas", "caption", "center", "cite", "code", "col", "colgroup", "command", "datalist", "dd", "del", "details", "dfn", "dir", "div", "dl", "dt", "em", "embed", "fieldset", "figcaption", "figure", "font", "footer", "form", "frame", "frameset", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hgroup", "hr", "html", "i", "iframe", "img", "input", "ins", "kbd", "keygen", "label", "legend", "li", "link", "map", "mark", "menu", "meta", "meter", "nav", "noframes", "noscript", "object", "ol", "optgroup", "option", "output", "p", "param", "pre", "progress", "q", "rp", "rt", "ruby", "s", "samp", "script", "section", "select", "small", "source", "span", "strike", "strong", "style", "sub", "summary", "sup", "table", "tbody", "td", "textarea", "tfoot", "th", "thead", "time", "title", "tr", "track", "tt", "u", "ul", "var", "video", "wbr"};
    private static final String[] SKIP_TAGS = new String[]{"html", "body", "b", "i", "font"};

    public static void expireNotification(@NotNull Notification notification) {
        if (notification == null) {
            EventLog.$$$reportNull$$$0(0);
        }
        EventLog.getApplicationService().myModel.removeNotification(notification);
        for (Project p : ProjectUtil.getOpenProjects()) {
            if (p.isDisposed()) continue;
            EventLog.getProjectService(p).myProjectModel.removeNotification(notification);
        }
    }

    public static void showNotification(@NotNull Project project, @NotNull String groupId2, @NotNull List<String> ids) {
        if (project == null) {
            EventLog.$$$reportNull$$$0(1);
        }
        if (groupId2 == null) {
            EventLog.$$$reportNull$$$0(2);
        }
        if (ids == null) {
            EventLog.$$$reportNull$$$0(3);
        }
        EventLog.getProjectService(project).showNotification(groupId2, ids);
    }

    private static EventLog getApplicationService() {
        return (EventLog)ApplicationManager.getApplication().getService(EventLog.class);
    }

    @NotNull
    public static LogModel getLogModel(@Nullable Project project) {
        LogModel logModel = project != null ? EventLog.getProjectService(project).myProjectModel : EventLog.getApplicationService().myModel;
        if (logModel == null) {
            EventLog.$$$reportNull$$$0(4);
        }
        return logModel;
    }

    @NotNull
    public static List<Notification> getNotifications(@NotNull Project project) {
        ProjectTracker service;
        if (project == null) {
            EventLog.$$$reportNull$$$0(5);
        }
        List<Notification> list2 = (service = (ProjectTracker)project.getServiceIfCreated(ProjectTracker.class)) == null ? Collections.emptyList() : service.myProjectModel.getNotifications();
        if (list2 == null) {
            EventLog.$$$reportNull$$$0(6);
        }
        return list2;
    }

    public static void markAllAsRead(@Nullable Project project) {
        LogModel model = EventLog.getLogModel(project);
        HashSet<String> groups = new HashSet<String>();
        for (Notification notification : model.getNotifications()) {
            groups.add(notification.getGroupId());
            model.removeNotification(notification);
            notification.expire();
        }
        if (project != null && !groups.isEmpty()) {
            EventLog.clearNMore(project, groups);
        }
    }

    public static void clearNMore(@NotNull Project project, @NotNull Collection<String> groups) {
        if (project == null) {
            EventLog.$$$reportNull$$$0(7);
        }
        if (groups == null) {
            EventLog.$$$reportNull$$$0(8);
        }
        EventLog.getProjectService(project).clearNMore(groups);
    }

    @Nullable
    public static Trinity<Notification, String, Long> getStatusMessage(@Nullable Project project) {
        return EventLog.getLogModel(project).getStatusMessage();
    }

    public static LogEntry formatForLog(final @NotNull Notification notification, String indent) {
        if (notification == null) {
            EventLog.$$$reportNull$$$0(9);
        }
        DocumentImpl logDoc = new DocumentImpl(DEFAULT_CATEGORY, true);
        AtomicBoolean showMore = new AtomicBoolean(false);
        LinkedHashMap links = new LinkedHashMap();
        ArrayList<RangeMarker> lineSeparators = new ArrayList<RangeMarker>();
        String title = notification.getTitle();
        String subtitle = notification.getSubtitle();
        if (StringUtil.isNotEmpty((String)title) && StringUtil.isNotEmpty((String)subtitle)) {
            title = title + " (" + subtitle + ")";
        }
        title = EventLog.truncateLongString(showMore, title);
        String content2 = EventLog.truncateLongString(showMore, notification.getContent());
        RangeMarker afterTitle = null;
        boolean hasHtml = EventLog.parseHtmlContent(EventLog.addIndents(title, indent), notification, logDoc, showMore, (Map<RangeMarker, HyperlinkInfo>)links, lineSeparators);
        if (StringUtil.isNotEmpty((String)title) && StringUtil.isNotEmpty((String)content2)) {
            EventLog.appendText(logDoc, ": ");
            afterTitle = logDoc.createRangeMarker(logDoc.getTextLength() - 2, logDoc.getTextLength());
        }
        int titleLength = logDoc.getTextLength();
        hasHtml |= EventLog.parseHtmlContent(EventLog.addIndents(content2, indent), notification, logDoc, showMore, (Map<RangeMarker, HyperlinkInfo>)links, lineSeparators);
        List actions = notification.getActions();
        if (!actions.isEmpty()) {
            String text2 = "<p>" + StringUtil.join((Collection)actions, (Function)new Function<AnAction, String>(){
                private int index;

                public String fun(AnAction action2) {
                    return "<a href=\"" + this.index++ + "\">" + action2.getTemplatePresentation().getText() + EventLog.A_CLOSING;
                }
            }, (String)(EventLog.isLongLine(actions) ? "<br>" : "&nbsp;&nbsp;&nbsp;")) + "</p>";
            Notification n = new Notification(DEFAULT_CATEGORY, DEFAULT_CATEGORY, ".", NotificationType.INFORMATION, new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification n, @NotNull HyperlinkEvent event) {
                    Object source;
                    if (n == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (event == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    DataContext context = (source = event.getSource()) instanceof Component ? DataManager.getInstance().getDataContext((Component)source) : null;
                    AnAction action2 = (AnAction)notification.getActions().get(Integer.parseInt(event.getDescription()));
                    NotificationCollector.getInstance().logNotificationActionInvoked(notification, action2, NotificationCollector.NotificationPlace.EVENT_LOG);
                    Notification.fire((Notification)notification, (AnAction)action2, (DataContext)context);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "n";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/notification/EventLog$2";
                    objectArray[2] = "hyperlinkUpdate";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            if (title.length() > 0 || content2.length() > 0) {
                lineSeparators.add(logDoc.createRangeMarker(TextRange.from((int)logDoc.getTextLength(), (int)0)));
            }
            hasHtml |= EventLog.parseHtmlContent(text2, n, logDoc, showMore, (Map<RangeMarker, HyperlinkInfo>)links, lineSeparators);
        }
        String status = EventLog.getStatusText(logDoc, showMore, lineSeparators, indent, hasHtml);
        EventLog.indentNewLines(logDoc, lineSeparators, afterTitle, hasHtml, indent);
        ArrayList<Pair<TextRange, HyperlinkInfo>> list2 = new ArrayList<Pair<TextRange, HyperlinkInfo>>();
        for (RangeMarker marker : links.keySet()) {
            if (!marker.isValid()) {
                showMore.set(true);
                continue;
            }
            list2.add((Pair<TextRange, HyperlinkInfo>)Pair.create((Object)new TextRange(marker.getStartOffset(), marker.getEndOffset()), links.get(marker)));
        }
        if (showMore.get()) {
            String sb = "show balloon";
            if (!logDoc.getText().endsWith(" ")) {
                EventLog.appendText(logDoc, " ");
            }
            EventLog.appendText(logDoc, "(" + sb + ")");
            list2.add((Pair<TextRange, HyperlinkInfo>)new Pair((Object)TextRange.from((int)(logDoc.getTextLength() - 1 - sb.length()), (int)sb.length()), (Object)new ShowBalloon(notification)));
        }
        return new LogEntry(logDoc.getText(), status, list2, titleLength);
    }

    @NotNull
    private static String addIndents(@NotNull String text2, @NotNull String indent) {
        if (text2 == null) {
            EventLog.$$$reportNull$$$0(10);
        }
        if (indent == null) {
            EventLog.$$$reportNull$$$0(11);
        }
        String string = StringUtil.replace((String)text2, (String)"\n", (String)("\n" + indent));
        if (string == null) {
            EventLog.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static boolean isLongLine(@NotNull List<? extends AnAction> actions) {
        int size;
        if (actions == null) {
            EventLog.$$$reportNull$$$0(13);
        }
        if ((size = actions.size()) > 3) {
            return true;
        }
        if (size > 1) {
            int length = 0;
            for (AnAction anAction : actions) {
                length += StringUtil.length((CharSequence)anAction.getTemplatePresentation().getText());
            }
            return length > 30;
        }
        return false;
    }

    @NotNull
    private static String truncateLongString(AtomicBoolean showMore, String title) {
        if (title.length() > 1000) {
            showMore.set(true);
            String string = title.substring(0, 1000) + "...";
            if (string == null) {
                EventLog.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = title;
        if (string == null) {
            EventLog.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static void indentNewLines(DocumentImpl logDoc, List<RangeMarker> lineSeparators, RangeMarker afterTitle, boolean hasHtml, String indent) {
        if (!hasHtml) {
            int i = -1;
            while ((i = StringUtil.indexOf((CharSequence)logDoc.getText(), (char)'\n', (int)(i + 1))) >= 0) {
                lineSeparators.add(logDoc.createRangeMarker(i, i + 1));
            }
        }
        if (!lineSeparators.isEmpty() && afterTitle != null && afterTitle.isValid()) {
            lineSeparators.add(afterTitle);
        }
        int nextLineStart = -1;
        for (RangeMarker separator : lineSeparators) {
            int start2;
            if (!separator.isValid() || (start2 = separator.getStartOffset()) == nextLineStart) continue;
            logDoc.replaceString(start2, separator.getEndOffset(), "\n" + indent);
            nextLineStart = start2 + 1 + indent.length();
            while (nextLineStart < logDoc.getTextLength() && Character.isWhitespace(logDoc.getCharsSequence().charAt(nextLineStart))) {
                logDoc.deleteString(nextLineStart, nextLineStart + 1);
            }
        }
    }

    private static String getStatusText(DocumentImpl logDoc, AtomicBoolean showMore, List<? extends RangeMarker> lineSeparators, String indent, boolean hasHtml) {
        DocumentImpl statusDoc = new DocumentImpl(logDoc.getImmutableCharSequence(), true);
        ArrayList<RangeMarker> statusSeparators = new ArrayList<RangeMarker>();
        for (RangeMarker rangeMarker : lineSeparators) {
            if (!rangeMarker.isValid()) continue;
            statusSeparators.add(statusDoc.createRangeMarker(rangeMarker.getStartOffset(), rangeMarker.getEndOffset()));
        }
        EventLog.removeJavaNewLines(statusDoc, statusSeparators, indent, hasHtml);
        EventLog.insertNewLineSubstitutors(statusDoc, showMore, statusSeparators);
        return statusDoc.getText();
    }

    private static boolean parseHtmlContent(String text2, Notification notification, Document document, AtomicBoolean showMore, Map<RangeMarker, HyperlinkInfo> links, List<RangeMarker> lineSeparators) {
        String content2 = StringUtil.convertLineSeparators((String)text2);
        int initialLen = document.getTextLength();
        boolean hasHtml = false;
        while (true) {
            Matcher tagMatcher;
            if (!(tagMatcher = TAG_PATTERN.matcher(content2)).find()) break;
            String tagStart = tagMatcher.group();
            EventLog.appendText(document, content2.substring(0, tagMatcher.start()));
            Matcher aMatcher = A_PATTERN.matcher(tagStart);
            if (aMatcher.matches()) {
                String href = aMatcher.group(2);
                int linkEnd = content2.indexOf(A_CLOSING, tagMatcher.end());
                if (linkEnd > 0) {
                    String linkText = content2.substring(tagMatcher.end(), linkEnd).replaceAll(TAG_PATTERN.pattern(), DEFAULT_CATEGORY);
                    int linkStart = document.getTextLength();
                    EventLog.appendText(document, linkText);
                    links.put(document.createRangeMarker(linkStart, document.getTextLength()), new NotificationHyperlinkInfo(notification, href));
                    content2 = content2.substring(linkEnd + A_CLOSING.length());
                    continue;
                }
            }
            if (EventLog.isTag(HTML_TAGS, tagStart)) {
                hasHtml = true;
                if (NEW_LINES.contains(tagStart)) {
                    if (initialLen != document.getTextLength()) {
                        lineSeparators.add(document.createRangeMarker(TextRange.from((int)document.getTextLength(), (int)0)));
                    }
                } else if (!EventLog.isTag(SKIP_TAGS, tagStart)) {
                    showMore.set(true);
                }
            } else {
                EventLog.appendText(document, content2.substring(tagMatcher.start(), tagMatcher.end()));
            }
            content2 = content2.substring(tagMatcher.end());
        }
        EventLog.appendText(document, content2);
        lineSeparators.removeIf(next -> next.getEndOffset() == document.getTextLength());
        return hasHtml;
    }

    private static boolean isTag(String @NotNull [] tags, @NotNull String tag2) {
        if (tag2 == null) {
            EventLog.$$$reportNull$$$0(16);
        }
        if (tags == null) {
            EventLog.$$$reportNull$$$0(17);
        }
        tag2 = tag2.substring(1, tag2.length() - 1);
        int index = (tag2 = StringUtil.trimEnd((String)StringUtil.trimStart((String)tag2, (String)"/"), (String)"/")).indexOf(32);
        if (index != -1) {
            tag2 = tag2.substring(0, index);
        }
        return ArrayUtil.indexOf((Object[])tags, (Object)tag2) != -1;
    }

    private static void insertNewLineSubstitutors(Document document, AtomicBoolean showMore, List<? extends RangeMarker> lineSeparators) {
        for (RangeMarker rangeMarker : lineSeparators) {
            boolean spaceBefore;
            if (!rangeMarker.isValid()) {
                showMore.set(true);
                continue;
            }
            int offset = rangeMarker.getStartOffset();
            if (offset == 0 || offset == document.getTextLength()) continue;
            boolean bl = spaceBefore = offset > 0 && Character.isWhitespace(document.getCharsSequence().charAt(offset - 1));
            if (offset < document.getTextLength()) {
                boolean spaceAfter = Character.isWhitespace(document.getCharsSequence().charAt(offset));
                int next = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)offset, (String)" \t");
                if (next < document.getTextLength() && !Character.isLowerCase(document.getCharsSequence().charAt(next))) {
                    document.insertString(offset, (CharSequence)((spaceBefore ? DEFAULT_CATEGORY : " ") + "//" + (spaceAfter ? DEFAULT_CATEGORY : " ")));
                    continue;
                }
                if (spaceAfter) continue;
            }
            if (spaceBefore) continue;
            document.insertString(offset, (CharSequence)" ");
        }
    }

    private static void removeJavaNewLines(Document document, List<? super RangeMarker> lineSeparators, String indent, boolean hasHtml) {
        CharSequence text2 = document.getCharsSequence();
        int i = 0;
        while ((i = StringUtil.indexOf((CharSequence)text2, (char)'\n', (int)i)) >= 0) {
            int j = i + 1;
            if (StringUtil.startsWith((CharSequence)text2, (int)j, (CharSequence)indent)) {
                j += indent.length();
            }
            document.deleteString(i, j);
            if (hasHtml) continue;
            lineSeparators.add((RangeMarker)document.createRangeMarker(TextRange.from((int)i, (int)0)));
        }
    }

    private static void appendText(Document document, String text2) {
        text2 = StringUtil.replace((String)text2, (String)"&nbsp;", (String)" ");
        text2 = StringUtil.replace((String)text2, (String)"&raquo;", (String)">>");
        text2 = StringUtil.replace((String)text2, (String)"&laquo;", (String)"<<");
        text2 = StringUtil.replace((String)text2, (String)"&hellip;", (String)"...");
        document.insertString(document.getTextLength(), (CharSequence)StringUtil.unescapeXmlEntities((String)text2));
    }

    @Nullable
    public static ToolWindow getEventLog(@Nullable Project project) {
        return project == null ? null : ToolWindowManager.getInstance((Project)project).getToolWindow(LOG_TOOL_WINDOW_ID);
    }

    public static void toggleLog(@Nullable Project project, @Nullable Notification notification) {
        ToolWindow eventLog = EventLog.getEventLog(project);
        if (eventLog != null) {
            if (!eventLog.isVisible()) {
                EventLog.activate(eventLog, notification == null ? null : notification.getGroupId(), null);
            } else {
                eventLog.hide(null);
            }
        }
    }

    private static void activate(@NotNull ToolWindow eventLog, @Nullable String groupId2, @Nullable Runnable runnable2) {
        if (eventLog == null) {
            EventLog.$$$reportNull$$$0(18);
        }
        eventLog.activate(() -> {
            if (groupId2 == null) {
                return;
            }
            String contentName = EventLog.getContentName(groupId2);
            Content content2 = eventLog.getContentManager().findContent(contentName);
            if (content2 != null) {
                eventLog.getContentManager().setSelectedContent(content2);
            }
            if (runnable2 != null) {
                runnable2.run();
            }
        }, true);
    }

    @NotNull
    private static String getContentName(@NotNull String groupId2) {
        if (groupId2 == null) {
            EventLog.$$$reportNull$$$0(19);
        }
        for (EventLogCategory category : EventLogCategory.EP_NAME.getExtensionList()) {
            if (!category.acceptsNotification(groupId2)) continue;
            String string = category.getDisplayName();
            if (string == null) {
                EventLog.$$$reportNull$$$0(20);
            }
            return string;
        }
        return DEFAULT_CATEGORY;
    }

    @NotNull
    static ProjectTracker getProjectService(@NotNull Project project) {
        if (project == null) {
            EventLog.$$$reportNull$$$0(21);
        }
        ProjectTracker projectTracker = (ProjectTracker)project.getService(ProjectTracker.class);
        if (projectTracker == null) {
            EventLog.$$$reportNull$$$0(22);
        }
        return projectTracker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 12: 
            case 14: 
            case 15: 
            case 20: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 12: 
            case 14: 
            case 15: 
            case 20: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 4: 
            case 6: 
            case 12: 
            case 14: 
            case 15: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/notification/EventLog";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indent";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/notification/EventLog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotifications";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "addIndents";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "truncateLongString";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentName";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "expireNotification";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
            case 4: 
            case 6: 
            case 12: 
            case 14: 
            case 15: 
            case 20: 
            case 22: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNotifications";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "clearNMore";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "formatForLog";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addIndents";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isLongLine";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isTag";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "activate";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getContentName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getProjectService";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 12: 
            case 14: 
            case 15: 
            case 20: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class MyNotificationListener
    implements Notifications {
        MyNotificationListener() {
        }

        public void notify(@NotNull Notification notification) {
            ProjectManager projectManager;
            Project[] openProjects;
            if (notification == null) {
                MyNotificationListener.$$$reportNull$$$0(0);
            }
            Project[] projectArray = openProjects = (projectManager = ProjectManager.getInstanceIfCreated()) == null ? null : projectManager.getOpenProjects();
            if (openProjects == null || openProjects.length == 0) {
                EventLog.getApplicationService().myModel.addNotification(notification);
            } else {
                for (Project p : openProjects) {
                    if (p.isDisposed()) continue;
                    EventLog.getProjectService(p).printNotification(notification);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/EventLog$MyNotificationListener", "notify"));
        }
    }

    static final class ShowBalloon
    implements HyperlinkInfo {
        private final Notification myNotification;
        private RangeHighlighter myRangeHighlighter;

        ShowBalloon(Notification notification) {
            this.myNotification = notification;
        }

        public void setRangeHighlighter(RangeHighlighter rangeHighlighter) {
            this.myRangeHighlighter = rangeHighlighter;
        }

        public void navigate(Project project) {
            ShowBalloon.hideBalloon(this.myNotification);
            for (Notification notification : EventLog.getLogModel(project).getNotifications()) {
                ShowBalloon.hideBalloon(notification);
            }
            EventLogConsole console = Objects.requireNonNull(EventLog.getProjectService(project).getConsole(this.myNotification));
            if (this.myRangeHighlighter == null || !this.myRangeHighlighter.isValid()) {
                return;
            }
            RelativePoint target2 = console.getRangeHighlighterLocation(this.myRangeHighlighter);
            if (target2 != null) {
                IdeFrame frame = WindowManager.getInstance().getIdeFrame(project);
                assert (frame != null);
                Balloon balloon = NotificationsManagerImpl.createBalloon(frame, this.myNotification, true, true, BalloonLayoutData.fullContent(), (Disposable)project);
                balloon.show(target2, Balloon.Position.above);
                NotificationCollector.getInstance().logBalloonShownFromEventLog(this.myNotification);
            }
        }

        private static void hideBalloon(Notification notification) {
            Balloon balloon = notification.getBalloon();
            if (balloon != null) {
                balloon.hide(true);
            }
        }
    }

    private static final class NotificationHyperlinkInfo
    implements HyperlinkInfo {
        private final Notification myNotification;
        private final String myHref;

        NotificationHyperlinkInfo(Notification notification, String href) {
            this.myNotification = notification;
            this.myHref = href;
        }

        public void navigate(Project project) {
            NotificationListener listener2 = this.myNotification.getListener();
            if (listener2 != null) {
                EventLogConsole console = Objects.requireNonNull(EventLog.getProjectService(project).getConsole(this.myNotification));
                JComponent component2 = console.getConsoleEditor().getContentComponent();
                listener2.hyperlinkUpdate(this.myNotification, IJSwingUtilities.createHyperlinkEvent(this.myHref, component2));
            }
        }
    }

    static final class ProjectTracker
    implements Disposable {
        private final Map<String, EventLogConsole> myCategoryMap;
        private final List<Notification> myInitial;
        private final LogModel myProjectModel;
        @NotNull
        private final Project myProject;

        ProjectTracker(@NotNull Project project) {
            if (project == null) {
                ProjectTracker.$$$reportNull$$$0(0);
            }
            this.myCategoryMap = ContainerUtil.newConcurrentMap();
            this.myInitial = ContainerUtil.createLockFreeCopyOnWriteList();
            this.myProjectModel = new LogModel(project);
            this.myProject = project;
            EventLog appService = (EventLog)ApplicationManager.getApplication().getServiceIfCreated(EventLog.class);
            if (appService != null) {
                for (Notification notification : appService.myModel.takeNotifications()) {
                    this.printNotification(notification);
                }
            }
            project.getMessageBus().connect().subscribe(Notifications.TOPIC, (Object)new Notifications(){

                public void notify(@NotNull Notification notification) {
                    if (notification == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.printNotification(notification);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/EventLog$ProjectTracker$1", "notify"));
                }
            });
        }

        public void dispose() {
            EventLog appService = (EventLog)ApplicationManager.getApplication().getServiceIfCreated(EventLog.class);
            if (appService != null) {
                appService.myModel.setStatusMessage(null, 0L);
            }
            StatusBar.Info.set((String)EventLog.DEFAULT_CATEGORY, null, (String)EventLog.LOG_REQUESTOR);
        }

        void initDefaultContent() {
            this.createNewContent(EventLog.DEFAULT_CATEGORY);
            if (this.myInitial.isEmpty()) {
                return;
            }
            ArrayList<Notification> notifications = new ArrayList<Notification>(this.myInitial);
            this.myInitial.clear();
            StartupManager.getInstance((Project)this.myProject).runAfterOpened(() -> {
                for (Notification notification : notifications) {
                    if (ShutDownTracker.isShutdownHookRunning()) {
                        return;
                    }
                    EventLogConsole console = Objects.requireNonNull(this.getConsole(notification));
                    GuiUtils.invokeLaterIfNeeded(() -> console.doPrintNotification(notification), (ModalityState)ModalityState.NON_MODAL, (Condition)this.myProject.getDisposed());
                }
            });
        }

        private void printNotification(Notification notification) {
            if (!NotificationsConfigurationImpl.getSettings(notification.getGroupId()).isShouldLog()) {
                return;
            }
            this.myProjectModel.addNotification(notification);
            NotificationCollector.getInstance().logNotificationLoggedInEventLog(this.myProject, notification);
            EventLogConsole console = this.getConsole(notification);
            if (console == null) {
                this.myInitial.add(notification);
            } else {
                StartupManager.getInstance((Project)this.myProject).runAfterOpened(() -> {
                    if (!ShutDownTracker.isShutdownHookRunning()) {
                        GuiUtils.invokeLaterIfNeeded(() -> console.doPrintNotification(notification), (ModalityState)ModalityState.NON_MODAL, (Condition)this.myProject.getDisposed());
                    }
                });
            }
        }

        private void showNotification(@NotNull String groupId2, @NotNull List<String> ids) {
            ToolWindow eventLog;
            if (groupId2 == null) {
                ProjectTracker.$$$reportNull$$$0(1);
            }
            if (ids == null) {
                ProjectTracker.$$$reportNull$$$0(2);
            }
            if ((eventLog = EventLog.getEventLog(this.myProject)) != null) {
                EventLog.activate(eventLog, groupId2, () -> {
                    EventLogConsole console = this.getConsole(groupId2);
                    if (console != null) {
                        console.showNotification(ids);
                    }
                });
            }
        }

        private void clearNMore(@NotNull Collection<String> groups) {
            if (groups == null) {
                ProjectTracker.$$$reportNull$$$0(3);
            }
            for (String group : groups) {
                EventLogConsole console = this.myCategoryMap.get(EventLog.getContentName(group));
                if (console == null) continue;
                console.clearNMore();
            }
        }

        @Nullable
        private EventLogConsole getConsole(@NotNull Notification notification) {
            if (notification == null) {
                ProjectTracker.$$$reportNull$$$0(4);
            }
            return this.getConsole(notification.getGroupId());
        }

        @Nullable
        private EventLogConsole getConsole(@NotNull String groupId2) {
            if (groupId2 == null) {
                ProjectTracker.$$$reportNull$$$0(5);
            }
            if (this.myCategoryMap.get(EventLog.DEFAULT_CATEGORY) == null) {
                return null;
            }
            String name = EventLog.getContentName(groupId2);
            EventLogConsole console = this.myCategoryMap.get(name);
            return console == null ? this.createNewContent(name) : console;
        }

        @NotNull
        private EventLogConsole createNewContent(@NotNull String name) {
            if (name == null) {
                ProjectTracker.$$$reportNull$$$0(6);
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            ToolWindow toolWindow = Objects.requireNonNull(ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(EventLog.LOG_TOOL_WINDOW_ID));
            EventLogConsole newConsole = new EventLogConsole(this.myProjectModel, toolWindow.getDisposable());
            EventLogToolWindowFactory.createContent(this.myProject, toolWindow, newConsole, name);
            this.myCategoryMap.put(name, newConsole);
            EventLogConsole eventLogConsole = newConsole;
            if (eventLogConsole == null) {
                ProjectTracker.$$$reportNull$$$0(7);
            }
            return eventLogConsole;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ids";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groups";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/notification/EventLog$ProjectTracker";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/notification/EventLog$ProjectTracker";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNewContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "showNotification";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "clearNMore";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getConsole";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createNewContent";
                    break;
                }
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class LogEntry {
        public final String message;
        public final String status;
        public final List<Pair<TextRange, HyperlinkInfo>> links;
        public final int titleLength;

        public LogEntry(@NotNull String message, @NotNull String status, @NotNull List<Pair<TextRange, HyperlinkInfo>> links, int titleLength) {
            if (message == null) {
                LogEntry.$$$reportNull$$$0(0);
            }
            if (status == null) {
                LogEntry.$$$reportNull$$$0(1);
            }
            if (links == null) {
                LogEntry.$$$reportNull$$$0(2);
            }
            this.message = message;
            this.status = status;
            this.links = links;
            this.titleLength = titleLength;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "status";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "links";
                    break;
                }
            }
            objectArray[1] = "com/intellij/notification/EventLog$LogEntry";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

