/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;

public class DarculaTabbedPaneUI
extends BasicTabbedPaneUI {
    private TabStyle tabStyle;
    private PropertyChangeListener panePropertyListener;
    private MouseListener paneMouseListener;
    private MouseMotionListener paneMouseMotionListener;
    private int hoverTab = -1;
    private static final JBValue OFFSET = new JBValue.Float(1.0f);
    private static final JBValue FONT_SIZE_OFFSET = new JBValue.UIInteger("TabbedPane.fontSizeOffset", -1);

    public static ComponentUI createUI(JComponent c) {
        return new DarculaTabbedPaneUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.modifyFontSize();
        Object rStyle = UIManager.get("TabbedPane.tabFillStyle");
        this.tabStyle = rStyle != null ? TabStyle.valueOf(rStyle.toString()) : TabStyle.underline;
        this.contentBorderInsets = this.tabPane.getTabLayoutPolicy() == 0 ? JBUI.insetsTop((int)1) : JBUI.emptyInsets();
    }

    private void modifyFontSize() {
        if (SystemInfo.isMac || SystemInfo.isLinux) {
            Font font = UIManager.getFont("TabbedPane.font");
            this.tabPane.setFont(this.tabPane.getFont().deriveFont((float)font.getSize() + (float)FONT_SIZE_OFFSET.get()));
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.panePropertyListener = evt -> {
            String propName = evt.getPropertyName();
            if ("JTabbedPane.hasFullBorder".equals(propName) || "tabLayoutPolicy".equals(propName)) {
                boolean fullBorder;
                boolean bl = fullBorder = this.tabPane.getClientProperty("JTabbedPane.hasFullBorder") == Boolean.TRUE;
                this.contentBorderInsets = this.tabPane.getTabLayoutPolicy() == 0 ? (fullBorder ? JBUI.insets((int)1) : JBUI.insetsTop((int)1)) : (fullBorder ? JBUI.insets((int)0, (int)1, (int)1, (int)1) : JBUI.emptyInsets());
                this.tabPane.revalidate();
                this.tabPane.repaint();
            } else if ("enabled".equals(propName)) {
                for (int ti = 0; ti < this.tabPane.getTabCount(); ++ti) {
                    Component tc = this.tabPane.getTabComponentAt(ti);
                    if (tc == null) continue;
                    tc.setEnabled(evt.getNewValue() == Boolean.TRUE);
                }
                this.tabPane.repaint();
            }
        };
        this.tabPane.addPropertyChangeListener(this.panePropertyListener);
        this.paneMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                DarculaTabbedPaneUI.this.hoverTab = DarculaTabbedPaneUI.this.tabForCoordinate(DarculaTabbedPaneUI.this.tabPane, e.getX(), e.getY());
                DarculaTabbedPaneUI.this.tabPane.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                DarculaTabbedPaneUI.this.hoverTab = -1;
                DarculaTabbedPaneUI.this.tabPane.repaint();
            }
        };
        this.tabPane.addMouseListener(this.paneMouseListener);
        this.paneMouseMotionListener = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                DarculaTabbedPaneUI.this.hoverTab = DarculaTabbedPaneUI.this.tabForCoordinate(DarculaTabbedPaneUI.this.tabPane, e.getX(), e.getY());
                DarculaTabbedPaneUI.this.tabPane.repaint();
            }
        };
        this.tabPane.addMouseMotionListener(this.paneMouseMotionListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.panePropertyListener != null) {
            this.tabPane.removePropertyChangeListener(this.panePropertyListener);
        }
        if (this.paneMouseListener != null) {
            this.tabPane.removeMouseListener(this.paneMouseListener);
        }
        if (this.paneMouseMotionListener != null) {
            this.tabPane.removeMouseMotionListener(this.paneMouseMotionListener);
        }
    }

    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        JBInsets i = JBInsets.create((Insets)this.contentBorderInsets);
        DarculaTabbedPaneUI.rotateInsets(this.contentBorderInsets, (Insets)i, tabPlacement);
        return i;
    }

    @Override
    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            Rectangle bounds2 = g.getClipBounds();
            g.setColor((Color)JBColor.namedColor((String)"TabbedPane.contentAreaColor", (int)0xBFBFBF));
            if (tabPlacement == 2 || tabPlacement == 4) {
                g.fillRect(bounds2.x + bounds2.width - OFFSET.get(), bounds2.y, OFFSET.get(), bounds2.y + bounds2.height);
            } else {
                g.fillRect(bounds2.x, bounds2.y + bounds2.height - OFFSET.get(), bounds2.x + bounds2.width, OFFSET.get());
            }
        }
        super.paintTabArea(g, tabPlacement, selectedIndex);
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        switch (this.tabStyle) {
            case fill: {
                if (this.tabPane.isEnabled()) {
                    g.setColor(isSelected ? JBUI.CurrentTheme.TabbedPane.ENABLED_SELECTED_COLOR : (tabIndex == this.hoverTab ? JBUI.CurrentTheme.TabbedPane.HOVER_COLOR : this.tabPane.getBackground()));
                    break;
                }
                g.setColor(isSelected ? JBUI.CurrentTheme.TabbedPane.DISABLED_SELECTED_COLOR : this.tabPane.getBackground());
                break;
            }
            default: {
                Color c = this.tabPane.getBackground();
                if (this.tabPane.isEnabled()) {
                    if (this.tabPane.hasFocus() && isSelected) {
                        c = JBUI.CurrentTheme.TabbedPane.FOCUS_COLOR;
                    } else if (tabIndex == this.hoverTab) {
                        c = JBUI.CurrentTheme.TabbedPane.HOVER_COLOR;
                    }
                }
                g.setColor(c);
            }
        }
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            if (tabPlacement == 2 || tabPlacement == 4) {
                w -= OFFSET.get();
            } else {
                h -= OFFSET.get();
            }
        }
        g.fillRect(x, y, w, h);
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        View v = this.getTextViewForTab(tabIndex);
        if (v != null || this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
            super.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
        } else {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            g.setFont(font);
            g.setColor(JBUI.CurrentTheme.TabbedPane.DISABLED_TEXT_COLOR);
            UIUtilities.drawStringUnderlineCharAt((JComponent)this.tabPane, (Graphics)g, (String)title, (int)mnemIndex, (int)textRect.x, (int)(textRect.y + metrics.getAscent()));
        }
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (isSelected && this.tabStyle == TabStyle.underline) {
            g.setColor(this.tabPane.isEnabled() ? JBUI.CurrentTheme.TabbedPane.ENABLED_SELECTED_COLOR : JBUI.CurrentTheme.TabbedPane.DISABLED_SELECTED_COLOR);
            boolean wrap = this.tabPane.getTabLayoutPolicy() == 0;
            switch (tabPlacement) {
                case 2: {
                    int offset = JBUI.CurrentTheme.TabbedPane.SELECTION_HEIGHT.get() - (wrap ? OFFSET.get() : 0);
                    g.fillRect(x + w - offset, y, JBUI.CurrentTheme.TabbedPane.SELECTION_HEIGHT.get(), h);
                    break;
                }
                case 4: {
                    int offset = wrap ? OFFSET.get() : 0;
                    g.fillRect(x - offset, y, JBUI.CurrentTheme.TabbedPane.SELECTION_HEIGHT.get(), h);
                    break;
                }
                case 3: {
                    int offset = wrap ? OFFSET.get() : 0;
                    g.fillRect(x, y - offset, w, JBUI.CurrentTheme.TabbedPane.SELECTION_HEIGHT.get());
                    break;
                }
                default: {
                    int offset = JBUI.CurrentTheme.TabbedPane.SELECTION_HEIGHT.get() - (wrap ? OFFSET.get() : 0);
                    g.fillRect(x, y + h - offset, w, JBUI.CurrentTheme.TabbedPane.SELECTION_HEIGHT.get());
                }
            }
        }
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        int delta = JBUI.CurrentTheme.TabbedPane.SELECTION_HEIGHT.get();
        if (this.tabPane.getTabLayoutPolicy() == 0) {
            delta -= OFFSET.get();
        }
        switch (tabPlacement) {
            case 2: 
            case 4: {
                return 0;
            }
            case 3: {
                return delta / 2;
            }
        }
        return -delta / 2;
    }

    @Override
    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        int delta = JBUI.CurrentTheme.TabbedPane.SELECTION_HEIGHT.get();
        if (this.tabPane.getTabLayoutPolicy() == 0) {
            delta -= OFFSET.get();
        }
        switch (tabPlacement) {
            case 1: 
            case 3: {
                return 0;
            }
            case 2: {
                return -delta / 2;
            }
        }
        return delta / 2;
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        return super.calculateTabWidth(tabPlacement, tabIndex, metrics) - 3;
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        int height = super.calculateTabHeight(tabPlacement, tabIndex, fontHeight) - 2;
        int minHeight = JBUI.CurrentTheme.TabbedPane.TAB_HEIGHT.get() - (this.tabPane.getTabLayoutPolicy() == 0 ? OFFSET.get() : 0);
        return Math.max(height, minHeight);
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    private static enum TabStyle {
        underline,
        fill;

    }
}

