/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.impl.AbstractUrl;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NonNls;

public class LibraryModuleGroupUrl
extends AbstractUrl {
    @NonNls
    private static final String ELEMENT_TYPE = "libraryModuleGroup";

    public LibraryModuleGroupUrl(String moduleName) {
        super(null, moduleName, ELEMENT_TYPE);
    }

    @Override
    public Object[] createPath(Project project) {
        Module module;
        Module module2 = module = this.moduleName != null ? ModuleManager.getInstance((Project)project).findModuleByName(this.moduleName) : null;
        if (module == null) {
            return null;
        }
        return new Object[]{new LibraryGroupElement(module)};
    }

    @Override
    protected AbstractUrl createUrl(String moduleName, String url) {
        return new LibraryModuleGroupUrl(moduleName);
    }

    @Override
    public AbstractUrl createUrlByElement(Object element2) {
        if (element2 instanceof LibraryGroupElement) {
            LibraryGroupElement libraryGroupElement = (LibraryGroupElement)element2;
            return new LibraryModuleGroupUrl(libraryGroupElement.getModule() != null ? libraryGroupElement.getModule().getName() : null);
        }
        return null;
    }
}

