/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.newui.ColorButton;
import com.intellij.ide.plugins.newui.ErrorComponent;
import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.ide.plugins.newui.InstallButton;
import com.intellij.ide.plugins.newui.LicensePanel;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.OneLineProgressIndicator;
import com.intellij.ide.plugins.newui.PluginLogo;
import com.intellij.ide.plugins.newui.RestartButton;
import com.intellij.ide.plugins.newui.TagComponent;
import com.intellij.ide.plugins.newui.TextHorizontalLayout;
import com.intellij.ide.plugins.newui.UpdateButton;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.LicensingFacade;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ButtonUI;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListPluginComponent
extends JPanel {
    public static final Color DisabledColor = JBColor.namedColor((String)"Plugins.disabledForeground", (Color)new JBColor(0xB1B1B1, 0x696969));
    public static final Color GRAY_COLOR = JBColor.namedColor((String)"Label.infoForeground", (Color)new JBColor((Color)Gray._120, (Color)Gray._135));
    private static final Color HOVER_COLOR = JBColor.namedColor((String)"Plugins.lightSelectionBackground", (Color)new JBColor(0xF5F9FF, 3553595));
    private final MyPluginModel myPluginModel;
    private final LinkListener<Object> mySearchListener;
    private final boolean myMarketplace;
    public IdeaPluginDescriptor myPlugin;
    private boolean myUninstalled;
    private boolean myOnlyUpdateMode;
    public IdeaPluginDescriptor myUpdateDescriptor;
    private final JLabel myNameComponent;
    private final JLabel myIconComponent;
    private final BaselineLayout myLayout;
    protected JButton myRestartButton;
    protected InstallButton myInstallButton;
    protected JButton myUpdateButton;
    private JCheckBox myEnableDisableButton;
    private JComponent myAlignButton;
    private JLabel myRating;
    private JLabel myDownloads;
    private JLabel myVersion;
    private JLabel myVendor;
    private LicensePanel myLicensePanel;
    private LicensePanel myUpdateLicensePanel;
    private JPanel myErrorPanel;
    private JComponent myErrorComponent;
    private OneLineProgressIndicator myIndicator;
    private EventHandler myEventHandler;
    protected EventHandler.SelectionType mySelection;
    public static boolean HANDLE_FOCUS_ON_SELECTION = true;

    public ListPluginComponent(@NotNull MyPluginModel pluginModel, @NotNull IdeaPluginDescriptor plugin, @NotNull LinkListener<Object> searchListener, boolean marketplace) {
        if (pluginModel == null) {
            ListPluginComponent.$$$reportNull$$$0(0);
        }
        if (plugin == null) {
            ListPluginComponent.$$$reportNull$$$0(1);
        }
        if (searchListener == null) {
            ListPluginComponent.$$$reportNull$$$0(2);
        }
        this.myNameComponent = new JLabel();
        this.myIconComponent = new JLabel(AllIcons.Plugins.PluginLogo_40);
        this.myLayout = new BaselineLayout();
        this.mySelection = EventHandler.SelectionType.NONE;
        this.myPlugin = plugin;
        this.myPluginModel = pluginModel;
        this.mySearchListener = searchListener;
        this.myMarketplace = marketplace;
        pluginModel.addComponent(this);
        this.setOpaque(true);
        this.setBorder(JBUI.Borders.empty((int)10));
        this.setLayout((LayoutManager)((Object)this.myLayout));
        this.myIconComponent.setVerticalAlignment(1);
        this.myIconComponent.setOpaque(false);
        this.myLayout.setIconComponent(this.myIconComponent);
        this.myNameComponent.setText(this.myPlugin.getName());
        this.myLayout.setNameComponent((JLabel)RelativeFont.BOLD.install((Component)this.myNameComponent));
        this.createTag();
        this.createButtons();
        this.createMetricsPanel();
        this.createLicensePanel();
        if (marketplace) {
            this.updateIcon(false, false);
        } else {
            this.updateErrors();
        }
        if (MyPluginModel.isInstallingOrUpdate(this.myPlugin)) {
            this.showProgress(false);
        }
        this.updateColors(EventHandler.SelectionType.NONE);
    }

    public EventHandler.SelectionType getSelection() {
        return this.mySelection;
    }

    public void setSelection(@NotNull EventHandler.SelectionType type) {
        if (type == null) {
            ListPluginComponent.$$$reportNull$$$0(3);
        }
        this.setSelection(type, type == EventHandler.SelectionType.SELECTION);
    }

    public void setSelection(@NotNull EventHandler.SelectionType type, boolean scrollAndFocus) {
        if (type == null) {
            ListPluginComponent.$$$reportNull$$$0(4);
        }
        this.mySelection = type;
        if (scrollAndFocus) {
            this.scrollToVisible();
            if (this.getParent() != null && type == EventHandler.SelectionType.SELECTION && HANDLE_FOCUS_ON_SELECTION) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this, true));
            }
        }
        this.updateColors(type);
        this.repaint();
    }

    public void scrollToVisible() {
        JComponent parent = (JComponent)this.getParent();
        if (parent == null) {
            return;
        }
        Rectangle bounds2 = this.getBounds();
        if (!parent.getVisibleRect().contains(bounds2)) {
            parent.scrollRectToVisible(bounds2);
        }
    }

    private void createButtons() {
        if (this.myMarketplace) {
            if (InstalledPluginsState.getInstance().wasInstalled(this.myPlugin.getPluginId())) {
                this.myRestartButton = new RestartButton(this.myPluginModel);
                this.myLayout.addButtonComponent(this.myRestartButton);
            } else {
                this.myInstallButton = new InstallButton(false);
                this.myLayout.addButtonComponent(this.myInstallButton);
                this.myInstallButton.addActionListener(e -> this.myPluginModel.installOrUpdatePlugin(this, this.myPlugin, null, ModalityState.stateForComponent((Component)this.myInstallButton)));
                this.myInstallButton.setEnabled(PluginManagerCore.getPlugin(this.myPlugin.getPluginId()) == null, IdeBundle.message((String)"plugin.status.installed", (Object[])new Object[0]));
                ColorButton.setWidth72(this.myInstallButton);
            }
        } else {
            final JCheckBox enableDisableButton = ListPluginComponent.createEnableDisableButton();
            if (this.myPlugin instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)this.myPlugin).isDeleted()) {
                this.myRestartButton = new RestartButton(this.myPluginModel);
                this.myLayout.addButtonComponent(this.myRestartButton);
                this.myUninstalled = true;
            } else {
                PluginId id2;
                InstalledPluginsState pluginsState = InstalledPluginsState.getInstance();
                if (pluginsState.wasInstalled(id2 = this.myPlugin.getPluginId()) || pluginsState.wasUpdated(id2)) {
                    this.myRestartButton = new RestartButton(this.myPluginModel);
                    this.myLayout.addButtonComponent(this.myRestartButton);
                } else {
                    this.myEnableDisableButton = enableDisableButton;
                    this.myLayout.addButtonComponent(this.myEnableDisableButton);
                    this.myEnableDisableButton.setOpaque(false);
                    this.myEnableDisableButton.setSelected(this.isEnabledState());
                    this.myEnableDisableButton.addActionListener(e -> this.myPluginModel.changeEnableDisable(this.myPlugin));
                }
            }
            this.myAlignButton = new JComponent(){

                @Override
                public Dimension getPreferredSize() {
                    return enableDisableButton.getPreferredSize();
                }
            };
            this.myLayout.addButtonComponent(this.myAlignButton);
            this.myAlignButton.setOpaque(false);
        }
    }

    @NotNull
    private static JCheckBox createEnableDisableButton() {
        return new JCheckBox(){
            int myBaseline = -1;

            @Override
            public int getBaseline(int width, int height) {
                if (this.myBaseline == -1) {
                    JCheckBox checkBox2 = new JCheckBox("Foo", true);
                    Dimension size = checkBox2.getPreferredSize();
                    this.myBaseline = checkBox2.getBaseline(size.width, size.height) - JBUIScale.scale((int)1);
                }
                return this.myBaseline;
            }

            @Override
            public void setUI(ButtonUI ui) {
                this.myBaseline = -1;
                super.setUI(ui);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                return new Dimension(size.width + JBUIScale.scale((int)8), size.height + JBUIScale.scale((int)2));
            }
        };
    }

    private void createMetricsPanel() {
        String vendor;
        NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)((Object)new TextHorizontalLayout(JBUIScale.scale((int)7))));
        panel2.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        this.myLayout.addLineComponent((JComponent)panel2);
        if (this.myMarketplace) {
            String rating;
            String downloads = PluginManagerConfigurable.getDownloads(this.myPlugin);
            if (downloads != null) {
                this.myDownloads = ListPluginComponent.createRatingLabel((JPanel)panel2, downloads, AllIcons.Plugins.Downloads);
            }
            if ((rating = PluginManagerConfigurable.getRating(this.myPlugin)) != null) {
                this.myRating = ListPluginComponent.createRatingLabel((JPanel)panel2, rating, AllIcons.Plugins.Rating);
            }
        } else {
            String version2;
            String string = version2 = !this.myPlugin.isBundled() || this.myPlugin.allowBundledUpdate() ? this.myPlugin.getVersion() : IdeBundle.message((String)"plugin.status.bundled", (Object[])new Object[0]);
            if (!StringUtil.isEmptyOrSpaces((String)version2)) {
                this.myVersion = ListPluginComponent.createRatingLabel((JPanel)panel2, version2, null);
            }
        }
        String string = vendor = this.myPlugin.isBundled() ? null : StringUtil.trim((String)this.myPlugin.getVendor());
        if (!StringUtil.isEmptyOrSpaces((String)vendor)) {
            this.myVendor = ListPluginComponent.createRatingLabel((JPanel)panel2, "fix_label", vendor, null, null, true);
        }
    }

    private void createTag() {
        if (this.myPlugin.getProductCode() != null) {
            String tag2 = (String)ContainerUtil.getFirstItem(PluginManagerConfigurable.getTags(this.myPlugin));
            if (tag2 == null) {
                return;
            }
            TagComponent component2 = new TagComponent(tag2);
            component2.setListener(this.mySearchListener, (Object)component2);
            this.myLayout.setTagComponent((JComponent)((Object)PluginManagerConfigurable.setTinyFont(component2)));
        }
    }

    private void setTagTooltip(@Nullable String text2) {
        if (this.myLayout.myTagComponent != null) {
            this.myLayout.myTagComponent.setToolTipText(text2);
        }
    }

    private void createLicensePanel() {
        String productCode = this.myPlugin.getProductCode();
        LicensingFacade instance = LicensingFacade.getInstance();
        if (this.myMarketplace || productCode == null || instance == null) {
            return;
        }
        LicensePanel licensePanel = new LicensePanel(true);
        String stamp = instance.getConfirmationStamp(productCode);
        if (stamp == null) {
            if (ApplicationManager.getApplication().isEAP()) {
                this.setTagTooltip("The license is not required for EAP version");
                return;
            }
            licensePanel.setText(IdeBundle.message((String)"label.text.plugin.no.license", (Object[])new Object[0]), true, false);
        } else {
            licensePanel.setTextFromStamp(stamp, instance.getExpirationDate(productCode));
        }
        this.setTagTooltip(licensePanel.getMessage());
        if (licensePanel.isNotification()) {
            licensePanel.setBorder((Border)JBUI.Borders.emptyTop((int)3));
            this.myLayout.addLineComponent((JComponent)((Object)licensePanel));
            this.myLicensePanel = licensePanel;
        }
    }

    public void setOnlyUpdateMode(@Nullable IdeaPluginDescriptor descriptor2) {
        this.myOnlyUpdateMode = true;
        if (this.myEnableDisableButton != null) {
            this.myLayout.removeButtonComponent(this.myEnableDisableButton);
            this.myEnableDisableButton = null;
        }
        this.setUpdateDescriptor(descriptor2);
    }

    public void setUpdateDescriptor(@Nullable IdeaPluginDescriptor descriptor2) {
        if (this.myUpdateDescriptor == null && descriptor2 == null) {
            return;
        }
        if (this.myIndicator != null || this.isRestartEnabled()) {
            return;
        }
        this.myUpdateDescriptor = descriptor2;
        if (descriptor2 == null) {
            if (this.myVersion != null) {
                this.myVersion.setText(this.myPlugin.getVersion());
            }
            if (this.myUpdateLicensePanel != null) {
                this.myLayout.removeLineComponent((JComponent)((Object)this.myUpdateLicensePanel));
                this.myUpdateLicensePanel = null;
            }
            if (this.myUpdateButton != null) {
                this.myUpdateButton.setVisible(false);
            }
            if (this.myAlignButton != null) {
                this.myAlignButton.setVisible(false);
            }
        } else {
            if (this.myVersion != null) {
                this.myVersion.setText(PluginManagerConfigurable.getVersion(this.myPlugin, descriptor2));
            }
            if (this.myPlugin.getProductCode() == null && descriptor2.getProductCode() != null) {
                if (this.myUpdateLicensePanel == null) {
                    this.myUpdateLicensePanel = new LicensePanel(true);
                    this.myLayout.addLineComponent((JComponent)((Object)this.myUpdateLicensePanel));
                    this.myUpdateLicensePanel.setBorder((Border)JBUI.Borders.emptyTop((int)3));
                    this.myUpdateLicensePanel.setVisible(this.myErrorPanel == null);
                    if (this.myEventHandler != null) {
                        this.myEventHandler.addAll((Component)((Object)this.myUpdateLicensePanel));
                    }
                }
                this.myUpdateLicensePanel.setText(IdeBundle.message((String)"label.next.plugin.version.is.paid.use.the.trial.for.up.to.30.days.or", (Object[])new Object[0]), true, false);
                this.myUpdateLicensePanel.showBuyPlugin(() -> this.myUpdateDescriptor);
                this.myUpdateLicensePanel.setVisible(true);
            }
            if (this.myUpdateButton == null) {
                this.myUpdateButton = new UpdateButton();
                this.myLayout.addButtonComponent(this.myUpdateButton, 0);
                this.myUpdateButton.addActionListener(e -> this.myPluginModel.installOrUpdatePlugin(this, this.myPlugin, this.myUpdateDescriptor, ModalityState.stateForComponent((Component)this.myUpdateButton)));
            } else {
                this.myUpdateButton.setEnabled(true);
                this.myUpdateButton.setVisible(true);
            }
            if (this.myAlignButton != null) {
                this.myAlignButton.setVisible(this.myEnableDisableButton != null && !this.myEnableDisableButton.isVisible());
            }
        }
        this.doLayout();
    }

    public void setListeners(@NotNull EventHandler eventHandler) {
        if (eventHandler == null) {
            ListPluginComponent.$$$reportNull$$$0(5);
        }
        this.myEventHandler = eventHandler;
        eventHandler.addAll(this);
    }

    protected void updateColors(@NotNull EventHandler.SelectionType type) {
        if (type == null) {
            ListPluginComponent.$$$reportNull$$$0(6);
        }
        this.updateColors(GRAY_COLOR, type == EventHandler.SelectionType.NONE ? PluginManagerConfigurable.MAIN_BG_COLOR : HOVER_COLOR);
    }

    protected void updateColors(@NotNull Color grayedFg, @NotNull Color background) {
        Color color;
        if (grayedFg == null) {
            ListPluginComponent.$$$reportNull$$$0(7);
        }
        if (background == null) {
            ListPluginComponent.$$$reportNull$$$0(8);
        }
        this.setBackground(background);
        Color nameForeground = null;
        Color otherForeground = grayedFg;
        boolean calcColor = true;
        if (this.mySelection != EventHandler.SelectionType.NONE && (color = UIManager.getColor("Plugins.selectionForeground")) != null) {
            nameForeground = otherForeground = color;
            calcColor = false;
        }
        if (calcColor && !this.myMarketplace) {
            boolean enabled;
            boolean bl = enabled = !this.myUninstalled && (MyPluginModel.isInstallingOrUpdate(this.myPlugin) || this.myPluginModel.isEnabled(this.myPlugin));
            if (!enabled) {
                nameForeground = otherForeground = DisabledColor;
            }
        }
        this.myNameComponent.setForeground(nameForeground);
        if (this.myRating != null) {
            this.myRating.setForeground(otherForeground);
        }
        if (this.myDownloads != null) {
            this.myDownloads.setForeground(otherForeground);
        }
        if (this.myVersion != null) {
            this.myVersion.setForeground(otherForeground);
        }
        if (this.myVendor != null) {
            this.myVendor.setForeground(otherForeground);
        }
    }

    public void updateErrors() {
        Ref enableAction = new Ref();
        String message = this.myPluginModel.getErrorMessage(this.myPlugin, (Ref<? super String>)enableAction);
        boolean errors = message != null;
        this.updateIcon(errors, this.myUninstalled || !this.myPluginModel.isEnabled(this.myPlugin));
        if (this.myAlignButton != null) {
            this.myAlignButton.setVisible(this.myRestartButton != null);
        }
        if (errors) {
            boolean addListeners;
            boolean bl = addListeners = this.myErrorComponent == null && this.myEventHandler != null;
            if (this.myErrorPanel == null) {
                this.myErrorPanel = new NonOpaquePanel();
                this.myLayout.addLineComponent(this.myErrorPanel);
            }
            this.myErrorComponent = ErrorComponent.show(this.myErrorPanel, "Center", this.myErrorComponent, message, (String)enableAction.get(), enableAction.isNull() ? null : () -> this.myPluginModel.enableRequiredPlugins(this.myPlugin));
            this.myErrorComponent.setBorder((Border)JBUI.Borders.emptyTop((int)5));
            if (addListeners) {
                this.myEventHandler.addAll(this.myErrorPanel);
            }
        } else if (this.myErrorPanel != null) {
            this.myLayout.removeLineComponent(this.myErrorPanel);
            this.myErrorPanel = null;
            this.myErrorComponent = null;
        }
        if (this.myLicensePanel != null) {
            this.myLicensePanel.setVisible(!errors);
        }
        if (this.myUpdateLicensePanel != null) {
            this.myUpdateLicensePanel.setVisible(!errors);
        }
    }

    protected void updateIcon(boolean errors, boolean disabled) {
        this.myIconComponent.setIcon(PluginLogo.getIcon(this.myPlugin, false, false, errors, disabled));
    }

    public void showProgress() {
        this.showProgress(true);
    }

    private void showProgress(boolean repaint) {
        this.myIndicator = new OneLineProgressIndicator(false);
        this.myIndicator.setCancelRunnable(() -> this.myPluginModel.finishInstall(this.myPlugin, null, false, false, true));
        this.myLayout.setProgressComponent(this.myIndicator.createBaselineWrapper());
        MyPluginModel.addProgress(this.myPlugin, this.myIndicator);
        if (repaint) {
            this.fullRepaint();
        }
    }

    public void hideProgress(boolean success, boolean restartRequired) {
        this.myIndicator = null;
        this.myLayout.removeProgressComponent();
        if (success) {
            if (restartRequired) {
                this.enableRestart();
            } else if (this.myInstallButton != null) {
                this.myInstallButton.setEnabled(false, IdeBundle.message((String)"plugin.status.installed", (Object[])new Object[0]));
            } else if (this.myUpdateButton != null) {
                this.myUpdateButton.setEnabled(false);
                this.myUpdateButton.setText(IdeBundle.message((String)"plugin.status.installed", (Object[])new Object[0]));
            }
        }
        this.fullRepaint();
    }

    public void clearProgress() {
        this.myIndicator = null;
    }

    public void enableRestart() {
        if (this.myInstallButton != null) {
            this.myLayout.removeButtonComponent(this.myInstallButton);
            this.myInstallButton = null;
        }
        if (this.myUpdateButton != null) {
            this.myLayout.removeButtonComponent(this.myUpdateButton);
            this.myUpdateButton = null;
        }
        if (this.myEnableDisableButton != null) {
            this.myLayout.removeButtonComponent(this.myEnableDisableButton);
            this.myEnableDisableButton = null;
        }
        if (this.myRestartButton == null) {
            this.myRestartButton = new RestartButton(this.myPluginModel);
            this.myLayout.addButtonComponent(this.myRestartButton, 0);
        }
        if (this.myAlignButton != null) {
            this.myAlignButton.setVisible(true);
        }
    }

    public void updateEnabledState() {
        if (!this.myUninstalled && this.myEnableDisableButton != null) {
            this.myEnableDisableButton.setSelected(this.isEnabledState());
        }
        this.updateErrors();
        this.setSelection(this.mySelection, false);
    }

    public void updateAfterUninstall(boolean needRestartForUninstall) {
        this.myUninstalled = true;
        this.updateColors(this.mySelection);
        if (needRestartForUninstall) {
            this.enableRestart();
        }
    }

    public void updatePlugin() {
        if (!this.myMarketplace && this.myUpdateButton != null && this.myUpdateButton.isVisible() && this.myUpdateButton.isEnabled()) {
            this.myUpdateButton.doClick();
        }
    }

    protected boolean isEnabledState() {
        return this.myPluginModel.isEnabled(this.myPlugin);
    }

    public boolean isMarketplace() {
        return this.myMarketplace;
    }

    public boolean isRestartEnabled() {
        return this.myRestartButton != null && this.myRestartButton.isVisible();
    }

    public boolean isUpdatedWithoutRestart() {
        return this.myUpdateButton != null && this.myUpdateButton.isVisible() && !this.myUpdateButton.isEnabled();
    }

    public boolean underProgress() {
        return this.myIndicator != null;
    }

    public void close() {
        if (this.myIndicator != null) {
            MyPluginModel.removeProgress(this.myPlugin, this.myIndicator);
            this.myIndicator = null;
        }
        this.myPluginModel.removeComponent(this);
    }

    /*
     * WARNING - void declaration
     */
    public void createPopupMenu(@NotNull DefaultActionGroup group, final @NotNull List<? extends ListPluginComponent> selection) {
        void var5_12;
        if (group == null) {
            ListPluginComponent.$$$reportNull$$$0(9);
        }
        if (selection == null) {
            ListPluginComponent.$$$reportNull$$$0(10);
        }
        for (ListPluginComponent listPluginComponent : selection) {
            if (!MyPluginModel.isInstallingOrUpdate(listPluginComponent.myPlugin)) continue;
            return;
        }
        boolean restart = true;
        for (ListPluginComponent listPluginComponent : selection) {
            if (listPluginComponent.myRestartButton != null) continue;
            restart = false;
            break;
        }
        if (restart) {
            group.add((AnAction)new ButtonAnAction(selection.get((int)0).myRestartButton));
            return;
        }
        int n = selection.size();
        if (this.myMarketplace) {
            JButton[] jButtonArray = new JButton[n];
            for (int i = 0; i < n; ++i) {
                InstallButton button2 = selection.get((int)i).myInstallButton;
                if (button2 == null || !button2.isVisible() || !button2.isEnabled()) {
                    return;
                }
                jButtonArray[i] = button2;
            }
            group.add((AnAction)new ButtonAnAction(jButtonArray));
            return;
        }
        JButton[] jButtonArray = new JButton[n];
        for (int i = 0; i < n; ++i) {
            JButton button3 = selection.get((int)i).myUpdateButton;
            if (button3 == null || !button3.isVisible() || !button3.isEnabled()) {
                Object var5_11 = null;
                break;
            }
            jButtonArray[i] = button3;
        }
        if (var5_12 != null) {
            group.add((AnAction)new ButtonAnAction((JButton[])var5_12));
            if (n > 1) {
                return;
            }
        }
        if (this.myOnlyUpdateMode) {
            return;
        }
        final Pair<Boolean, IdeaPluginDescriptor[]> result2 = ListPluginComponent.getSelectionNewState(selection);
        group.add((AnAction)new MyAnAction((Boolean)result2.first != false ? IdeBundle.message((String)"plugins.configurable.enable.button", (Object[])new Object[0]) : IdeBundle.message((String)"plugins.configurable.disable.button", (Object[])new Object[0]), null, 32){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                ListPluginComponent.this.myPluginModel.changeEnableDisable((IdeaPluginDescriptor[])result2.second, (Boolean)result2.first);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/newui/ListPluginComponent$3", "actionPerformed"));
            }
        });
        for (ListPluginComponent listPluginComponent : selection) {
            if (!listPluginComponent.myUninstalled && !listPluginComponent.myPlugin.isBundled()) continue;
            return;
        }
        if (group.getChildrenCount() > 0) {
            group.addSeparator();
        }
        group.add((AnAction)new MyAnAction(IdeBundle.message((String)"plugins.configurable.uninstall.button", (Object[])new Object[0]), "EditorDelete", EventHandler.DELETE_CODE){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (!MyPluginModel.showUninstallDialog(ListPluginComponent.this, selection)) {
                    return;
                }
                for (ListPluginComponent component2 : selection) {
                    ListPluginComponent.this.myPluginModel.uninstallAndUpdateUi(component2, component2.myPlugin);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/plugins/newui/ListPluginComponent$4", "actionPerformed"));
            }
        });
    }

    public void handleKeyAction(int keyCode, @NotNull List<? extends ListPluginComponent> selection) {
        block22: {
            boolean bl;
            boolean restart;
            block20: {
                block21: {
                    if (selection == null) {
                        ListPluginComponent.$$$reportNull$$$0(11);
                    }
                    for (ListPluginComponent listPluginComponent : selection) {
                        if (!MyPluginModel.isInstallingOrUpdate(listPluginComponent.myPlugin)) continue;
                        return;
                    }
                    restart = true;
                    for (ListPluginComponent listPluginComponent : selection) {
                        if (listPluginComponent.myRestartButton != null) continue;
                        restart = false;
                        break;
                    }
                    if (this.myMarketplace) {
                        if (keyCode == 10) {
                            if (restart) {
                                selection.get((int)0).myRestartButton.doClick();
                            }
                            for (ListPluginComponent listPluginComponent : selection) {
                                InstallButton installButton = listPluginComponent.myInstallButton;
                                if (installButton != null && installButton.isVisible() && installButton.isEnabled()) continue;
                                return;
                            }
                            for (ListPluginComponent listPluginComponent : selection) {
                                listPluginComponent.myInstallButton.doClick();
                            }
                        }
                        return;
                    }
                    boolean bl2 = true;
                    for (ListPluginComponent listPluginComponent : selection) {
                        JButton button3 = listPluginComponent.myUpdateButton;
                        if (button3 != null && button3.isVisible() && button3.isEnabled()) continue;
                        bl = false;
                        break;
                    }
                    if (keyCode != 10) break block20;
                    if (!restart) break block21;
                    selection.get((int)0).myRestartButton.doClick();
                    break block22;
                }
                if (!bl) break block22;
                for (ListPluginComponent listPluginComponent : selection) {
                    listPluginComponent.myUpdateButton.doClick();
                }
                break block22;
            }
            if (!restart && !bl) {
                if (this.myOnlyUpdateMode) {
                    return;
                }
                if (keyCode == 32) {
                    if (selection.size() == 1) {
                        this.myPluginModel.changeEnableDisable(selection.get((int)0).myPlugin);
                    } else {
                        Pair<Boolean, IdeaPluginDescriptor[]> pair = ListPluginComponent.getSelectionNewState(selection);
                        this.myPluginModel.changeEnableDisable((IdeaPluginDescriptor[])pair.second, (Boolean)pair.first);
                    }
                } else if (keyCode == EventHandler.DELETE_CODE) {
                    for (ListPluginComponent listPluginComponent : selection) {
                        if (!listPluginComponent.myUninstalled && !listPluginComponent.myPlugin.isBundled()) continue;
                        return;
                    }
                    if (!MyPluginModel.showUninstallDialog(this, selection)) {
                        return;
                    }
                    for (ListPluginComponent listPluginComponent : selection) {
                        this.myPluginModel.uninstallAndUpdateUi(this, listPluginComponent.myPlugin);
                    }
                }
            }
        }
    }

    protected void fullRepaint() {
        Container parent = this.getParent();
        parent.doLayout();
        parent.revalidate();
        parent.repaint();
    }

    @NotNull
    public IdeaPluginDescriptor getPluginDescriptor() {
        IdeaPluginDescriptor ideaPluginDescriptor = this.myPlugin;
        if (ideaPluginDescriptor == null) {
            ListPluginComponent.$$$reportNull$$$0(12);
        }
        return ideaPluginDescriptor;
    }

    @NotNull
    private static Pair<Boolean, IdeaPluginDescriptor[]> getSelectionNewState(@NotNull List<? extends ListPluginComponent> selection) {
        if (selection == null) {
            ListPluginComponent.$$$reportNull$$$0(13);
        }
        boolean state = selection.get(0).isEnabledState();
        boolean setTrue = false;
        ListIterator<? extends ListPluginComponent> I = selection.listIterator(1);
        while (I.hasNext()) {
            if (state == I.next().isEnabledState()) continue;
            setTrue = true;
            break;
        }
        int size = selection.size();
        IdeaPluginDescriptor[] plugins2 = new IdeaPluginDescriptor[size];
        for (int i = 0; i < size; ++i) {
            plugins2[i] = selection.get((int)i).myPlugin;
        }
        Pair pair = Pair.create((Object)(setTrue || !state ? 1 : 0), (Object)plugins2);
        if (pair == null) {
            ListPluginComponent.$$$reportNull$$$0(14);
        }
        return pair;
    }

    @NotNull
    static JLabel createRatingLabel(@NotNull JPanel panel2, @NotNull String text2, @Nullable Icon icon2) {
        if (panel2 == null) {
            ListPluginComponent.$$$reportNull$$$0(15);
        }
        if (text2 == null) {
            ListPluginComponent.$$$reportNull$$$0(16);
        }
        return ListPluginComponent.createRatingLabel(panel2, null, text2, icon2, null, true);
    }

    @NotNull
    static JLabel createRatingLabel(@NotNull JPanel panel2, @Nullable Object constraints, @NotNull String text2, @Nullable Icon icon2, @Nullable Color color, boolean tiny) {
        if (panel2 == null) {
            ListPluginComponent.$$$reportNull$$$0(17);
        }
        if (text2 == null) {
            ListPluginComponent.$$$reportNull$$$0(18);
        }
        JLabel label2 = new JLabel(text2, icon2, 0);
        label2.setOpaque(false);
        label2.setIconTextGap(2);
        if (color != null) {
            label2.setForeground(color);
        }
        panel2.add((Component)(tiny ? PluginManagerConfigurable.setTinyFont(label2) : label2), constraints);
        JLabel jLabel = label2;
        if (jLabel == null) {
            ListPluginComponent.$$$reportNull$$$0(19);
        }
        return jLabel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 14: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 14: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchListener";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventHandler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grayedFg";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "background";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 12: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/ListPluginComponent";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/ListPluginComponent";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginDescriptor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionNewState";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createRatingLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSelection";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setListeners";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateColors";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createPopupMenu";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "handleKeyAction";
                break;
            }
            case 12: 
            case 14: 
            case 19: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSelectionNewState";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createRatingLabel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 14: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class BaselineLayout
    extends AbstractLayoutManager {
        private final JBValue myHGap = new JBValue.Float(10.0f);
        private final JBValue myHOffset = new JBValue.Float(8.0f);
        private final JBValue myButtonOffset = new JBValue.Float(6.0f);
        private JComponent myIconComponent;
        private JLabel myNameComponent;
        private JComponent myProgressComponent;
        private JComponent myTagComponent;
        private final List<JComponent> myButtonComponents = new ArrayList<JComponent>();
        private final List<JComponent> myLineComponents = new ArrayList<JComponent>();
        private boolean[] myButtonEnableStates;

        private BaselineLayout() {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension result2 = new Dimension(this.myNameComponent.getPreferredSize());
            if (this.myProgressComponent == null) {
                int count;
                if (this.myTagComponent != null) {
                    Dimension size = this.myTagComponent.getPreferredSize();
                    result2.width += size.width + 2 * this.myHOffset.get();
                    result2.height = Math.max(result2.height, size.height);
                }
                if ((count = this.myButtonComponents.size()) > 0) {
                    int visibleCount = 0;
                    for (Component component2 : this.myButtonComponents) {
                        if (!component2.isVisible()) continue;
                        Dimension size = component2.getPreferredSize();
                        result2.width += size.width;
                        result2.height = Math.max(result2.height, size.height);
                        ++visibleCount;
                    }
                    if (visibleCount > 0) {
                        result2.width += this.myHOffset.get();
                        result2.width += (visibleCount - 1) * this.myButtonOffset.get();
                    }
                }
            } else {
                Dimension size = this.myProgressComponent.getPreferredSize();
                result2.width += this.myHOffset.get() + size.width;
                result2.height = Math.max(result2.height, size.height);
            }
            for (JComponent component3 : this.myLineComponents) {
                if (!component3.isVisible()) continue;
                Dimension size = component3.getPreferredSize();
                result2.width = Math.max(result2.width, size.width);
                result2.height += size.height;
            }
            Dimension iconSize = this.myIconComponent.getPreferredSize();
            result2.width += iconSize.width + this.myHGap.get();
            result2.height = Math.max(result2.height, iconSize.height);
            JBInsets.addTo((Dimension)result2, (Insets)ListPluginComponent.this.getInsets());
            return result2;
        }

        public void layoutContainer(Container parent) {
            Insets insets = ListPluginComponent.this.getInsets();
            int x = insets.left;
            int y = insets.top;
            Dimension iconSize = this.myIconComponent.getPreferredSize();
            this.myIconComponent.setBounds(x, y, iconSize.width, iconSize.height);
            x += iconSize.width + this.myHGap.get();
            int calcNameWidth = this.calculateNameWidth();
            Dimension nameSize = this.myNameComponent.getPreferredSize();
            int baseline = (y += JBUIScale.scale((int)2)) + this.myNameComponent.getBaseline(nameSize.width, nameSize.height);
            this.myNameComponent.setToolTipText(calcNameWidth < nameSize.width ? this.myNameComponent.getText() : null);
            nameSize.width = Math.min(nameSize.width, calcNameWidth);
            this.myNameComponent.setBounds(x, y, nameSize.width, nameSize.height);
            y += nameSize.height;
            int width = ListPluginComponent.this.getWidth();
            if (this.myProgressComponent == null) {
                if (this.myTagComponent != null) {
                    this.setBaselineBounds(x + nameSize.width + this.myHOffset.get(), baseline, this.myTagComponent, this.myTagComponent.getPreferredSize());
                }
                int lastX = width - insets.right;
                for (int i = this.myButtonComponents.size() - 1; i >= 0; --i) {
                    Component component2 = this.myButtonComponents.get(i);
                    if (!component2.isVisible()) continue;
                    Dimension size = component2.getPreferredSize();
                    this.setBaselineBounds(lastX -= size.width, baseline, component2, size);
                    lastX -= this.myButtonOffset.get();
                }
            } else {
                Dimension size = this.myProgressComponent.getPreferredSize();
                this.setBaselineBounds(width - size.width - insets.right, baseline, this.myProgressComponent, size);
            }
            int lineWidth = width - x - insets.right;
            for (JComponent jComponent : this.myLineComponents) {
                if (!jComponent.isVisible()) continue;
                int lineHeight = jComponent.getPreferredSize().height;
                jComponent.setBounds(x, y, lineWidth, lineHeight);
                y += lineHeight;
            }
        }

        private int calculateNameWidth() {
            Insets insets = ListPluginComponent.this.getInsets();
            int width = ListPluginComponent.this.getWidth() - insets.left - insets.right - this.myIconComponent.getPreferredSize().width - this.myHGap.get();
            if (this.myProgressComponent != null) {
                return width - this.myProgressComponent.getPreferredSize().width - this.myHOffset.get();
            }
            if (this.myTagComponent != null) {
                width -= this.myTagComponent.getPreferredSize().width + 2 * this.myHOffset.get();
            }
            int visibleCount = 0;
            for (Component component2 : this.myButtonComponents) {
                if (!component2.isVisible()) continue;
                width -= component2.getPreferredSize().width;
                ++visibleCount;
            }
            width -= this.myButtonOffset.get() * (visibleCount - 1);
            if (visibleCount > 0) {
                width -= this.myHOffset.get();
            }
            return width;
        }

        private void setBaselineBounds(int x, int y, @NotNull Component component2, @NotNull Dimension size) {
            if (component2 == null) {
                BaselineLayout.$$$reportNull$$$0(0);
            }
            if (size == null) {
                BaselineLayout.$$$reportNull$$$0(1);
            }
            component2.setBounds(x, y - component2.getBaseline(size.width, size.height), size.width, size.height);
        }

        public void setIconComponent(@NotNull JComponent iconComponent) {
            if (iconComponent == null) {
                BaselineLayout.$$$reportNull$$$0(2);
            }
            assert (this.myIconComponent == null);
            this.myIconComponent = iconComponent;
            ListPluginComponent.this.add(iconComponent);
        }

        public void setNameComponent(@NotNull JLabel nameComponent) {
            if (nameComponent == null) {
                BaselineLayout.$$$reportNull$$$0(3);
            }
            assert (this.myNameComponent == null);
            this.myNameComponent = nameComponent;
            ListPluginComponent.this.add(this.myNameComponent);
        }

        public void setTagComponent(@NotNull JComponent component2) {
            if (component2 == null) {
                BaselineLayout.$$$reportNull$$$0(4);
            }
            assert (this.myTagComponent == null);
            this.myTagComponent = component2;
            ListPluginComponent.this.add(this.myTagComponent);
        }

        public void addLineComponent(@NotNull JComponent component2) {
            if (component2 == null) {
                BaselineLayout.$$$reportNull$$$0(5);
            }
            this.myLineComponents.add(component2);
            ListPluginComponent.this.add(component2);
        }

        public void removeLineComponent(@NotNull JComponent component2) {
            if (component2 == null) {
                BaselineLayout.$$$reportNull$$$0(6);
            }
            this.myLineComponents.remove(component2);
            ListPluginComponent.this.remove(component2);
        }

        public void addButtonComponent(@NotNull JComponent component2) {
            if (component2 == null) {
                BaselineLayout.$$$reportNull$$$0(7);
            }
            this.addButtonComponent(component2, -1);
        }

        public void addButtonComponent(@NotNull JComponent component2, int index) {
            if (component2 == null) {
                BaselineLayout.$$$reportNull$$$0(8);
            }
            if (this.myButtonComponents.isEmpty() || index == -1) {
                this.myButtonComponents.add(component2);
            } else {
                this.myButtonComponents.add(index, component2);
            }
            ListPluginComponent.this.add(component2);
            this.updateVisibleOther();
        }

        public void removeButtonComponent(@NotNull JComponent component2) {
            if (component2 == null) {
                BaselineLayout.$$$reportNull$$$0(9);
            }
            this.myButtonComponents.remove(component2);
            ListPluginComponent.this.remove(component2);
            this.updateVisibleOther();
        }

        public void setProgressComponent(@NotNull JComponent progressComponent) {
            if (progressComponent == null) {
                BaselineLayout.$$$reportNull$$$0(10);
            }
            assert (this.myProgressComponent == null);
            this.myProgressComponent = progressComponent;
            ListPluginComponent.this.add(progressComponent);
            if (ListPluginComponent.this.myEventHandler != null) {
                ListPluginComponent.this.myEventHandler.addAll(progressComponent);
                ListPluginComponent.this.myEventHandler.updateHover(ListPluginComponent.this);
            }
            this.setVisibleOther(false);
            ListPluginComponent.this.doLayout();
        }

        public void removeProgressComponent() {
            if (this.myProgressComponent == null) {
                return;
            }
            ListPluginComponent.this.remove(this.myProgressComponent);
            this.myProgressComponent = null;
            this.setVisibleOther(true);
            ListPluginComponent.this.doLayout();
        }

        private void updateVisibleOther() {
            if (this.myProgressComponent != null) {
                this.myButtonEnableStates = null;
                this.setVisibleOther(false);
            }
        }

        private void setVisibleOther(boolean value2) {
            if (this.myTagComponent != null) {
                this.myTagComponent.setVisible(value2);
            }
            if (this.myButtonComponents.isEmpty()) {
                return;
            }
            if (value2) {
                assert (this.myButtonEnableStates != null && this.myButtonEnableStates.length == this.myButtonComponents.size());
                int size = this.myButtonComponents.size();
                for (int i = 0; i < size; ++i) {
                    this.myButtonComponents.get(i).setVisible(this.myButtonEnableStates[i]);
                }
                this.myButtonEnableStates = null;
            } else {
                assert (this.myButtonEnableStates == null);
                this.myButtonEnableStates = new boolean[this.myButtonComponents.size()];
                int size = this.myButtonComponents.size();
                for (int i = 0; i < size; ++i) {
                    Component component2 = this.myButtonComponents.get(i);
                    this.myButtonEnableStates[i] = component2.isVisible();
                    component2.setVisible(false);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "size";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iconComponent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameComponent";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressComponent";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/newui/ListPluginComponent$BaselineLayout";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setBaselineBounds";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setIconComponent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setNameComponent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setTagComponent";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addLineComponent";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeLineComponent";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addButtonComponent";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeButtonComponent";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setProgressComponent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class MyAnAction
    extends DumbAwareAction {
        MyAnAction(@Nls @Nullable String text2, @Nullable String actionId, int keyCode) {
            super(text2);
            ShortcutSet shortcutSet = null;
            if (actionId != null) {
                shortcutSet = EventHandler.getShortcuts(actionId);
            }
            if (shortcutSet == null) {
                shortcutSet = new CustomShortcutSet(KeyStroke.getKeyStroke(keyCode, 0));
            }
            this.setShortcutSet(shortcutSet);
        }
    }

    public static class ButtonAnAction
    extends DumbAwareAction {
        private final JButton[] myButtons;

        ButtonAnAction(JButton ... buttons) {
            if (buttons == null) {
                ButtonAnAction.$$$reportNull$$$0(0);
            }
            super(buttons[0].getText());
            this.myButtons = buttons;
            this.setShortcutSet(CommonShortcuts.ENTER);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ButtonAnAction.$$$reportNull$$$0(1);
            }
            for (JButton button2 : this.myButtons) {
                button2.doClick();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buttons";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/plugins/newui/ListPluginComponent$ButtonAnAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

