/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.PluginException;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.CachingSemiGraph;
import com.intellij.ide.plugins.ClassPathXmlPathResolver;
import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.ide.plugins.DescriptorLoadingContext;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PathBasedJdomXIncluder;
import com.intellij.ide.plugins.PluginError;
import com.intellij.ide.plugins.PluginLoadingResult;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerState;
import com.intellij.ide.plugins.PluginXmlPathResolver;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionInstantiationException;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SafeJdomFactory;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.serialization.SerializationException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.lang.UrlClassLoader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginManagerCore {
    public static final String META_INF = "META-INF/";
    public static final String IDEA_IS_INTERNAL_PROPERTY = "idea.is.internal";
    public static final String DISABLED_PLUGINS_FILENAME = "disabled_plugins.txt";
    public static final PluginId CORE_ID = PluginId.getId((String)"com.intellij");
    public static final String CORE_PLUGIN_ID = "com.intellij";
    public static final PluginId JAVA_PLUGIN_ID = PluginId.getId((String)"com.intellij.java");
    private static final PluginId JAVA_MODULE_ID = PluginId.getId((String)"com.intellij.modules.java");
    public static final String PLUGIN_XML = "plugin.xml";
    public static final String PLUGIN_XML_PATH = "META-INF/plugin.xml";
    private static final PluginId ALL_MODULES_MARKER = PluginId.getId((String)"com.intellij.modules.all");
    public static final String VENDOR_JETBRAINS = "JetBrains";
    private static final String MODULE_DEPENDENCY_PREFIX = "com.intellij.module";
    private static final PluginId SPECIAL_IDEA_PLUGIN_ID = PluginId.getId((String)"IDEA CORE");
    private static final String PROPERTY_PLUGIN_PATH = "plugin.path";
    public static final String DISABLE = "disable";
    public static final String ENABLE = "enable";
    public static final String EDIT = "edit";
    private static volatile Set<PluginId> ourDisabledPlugins;
    private static Reference<Map<PluginId, Set<String>>> ourBrokenPluginVersions;
    private static volatile IdeaPluginDescriptorImpl[] ourPlugins;
    static volatile List<IdeaPluginDescriptorImpl> ourLoadedPlugins;
    private static List<PluginError> ourLoadingErrors;
    public static volatile boolean isUnitTestMode;
    @ApiStatus.Internal
    public static String ourPluginError;
    @ApiStatus.Internal
    public static Set<PluginId> ourPluginsToDisable;
    @ApiStatus.Internal
    public static Set<PluginId> ourPluginsToEnable;
    private static Set<PluginId> ourShadowedBundledPlugins;
    private static Boolean isRunningFromSources;
    private static volatile CompletableFuture<DescriptorListLoadingContext> descriptorListFuture;
    private static BuildNumber ourBuildNumber;
    @Nullable
    private static Runnable disabledPluginListener;

    @Nullable
    @ApiStatus.Internal
    public static String getPluginsCompatibleBuild() {
        return System.getProperty("idea.plugins.compatible.build");
    }

    @ApiStatus.Internal
    public static void setDisabledPluginListener(@NotNull Runnable value2) {
        if (value2 == null) {
            PluginManagerCore.$$$reportNull$$$0(0);
        }
        disabledPluginListener = value2;
    }

    @NotNull
    public static @NotNull IdeaPluginDescriptor @NotNull [] getPlugins() {
        IdeaPluginDescriptor[] result2 = ourPlugins;
        if (result2 == null) {
            PluginManagerCore.loadAndInitializePlugins(null, null);
            if (ourPlugins == null) {
                PluginManagerCore.$$$reportNull$$$0(1);
            }
            return ourPlugins;
        }
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(2);
        }
        return result2;
    }

    @NotNull
    public static List<? extends IdeaPluginDescriptor> getLoadedPlugins() {
        return PluginManagerCore.getLoadedPlugins(null);
    }

    @NotNull
    @ApiStatus.Internal
    public static List<IdeaPluginDescriptorImpl> getLoadedPlugins(@Nullable ClassLoader coreClassLoader) {
        List<IdeaPluginDescriptorImpl> result2 = ourLoadedPlugins;
        if (result2 == null) {
            PluginManagerCore.loadAndInitializePlugins(null, coreClassLoader);
            List<IdeaPluginDescriptorImpl> list2 = ourLoadedPlugins;
            if (list2 == null) {
                PluginManagerCore.$$$reportNull$$$0(3);
            }
            return list2;
        }
        List<IdeaPluginDescriptorImpl> list3 = result2;
        if (list3 == null) {
            PluginManagerCore.$$$reportNull$$$0(4);
        }
        return list3;
    }

    @ApiStatus.Internal
    public static boolean arePluginsInitialized() {
        return ourPlugins != null;
    }

    @ApiStatus.Internal
    static synchronized void doSetPlugins(@NotNull @NotNull IdeaPluginDescriptorImpl @NotNull [] value2) {
        if (value2 == null) {
            PluginManagerCore.$$$reportNull$$$0(5);
        }
        ourPlugins = value2;
        ourLoadedPlugins = Collections.unmodifiableList(PluginManagerCore.getOnlyEnabledPlugins(value2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static void loadDisabledPlugins(@NotNull String configPath, @NotNull Collection<PluginId> disabledPlugins) {
        Path file2;
        if (configPath == null) {
            PluginManagerCore.$$$reportNull$$$0(6);
        }
        if (disabledPlugins == null) {
            PluginManagerCore.$$$reportNull$$$0(7);
        }
        if (!Files.isRegularFile(file2 = Paths.get(configPath, DISABLED_PLUGINS_FILENAME), new LinkOption[0])) {
            return;
        }
        List requiredPlugins = StringUtil.split((String)System.getProperty("idea.required.plugins.id", ""), (String)",");
        try {
            boolean updateDisablePluginsList = false;
            try (BufferedReader reader = Files.newBufferedReader(file2);){
                String id2;
                while ((id2 = reader.readLine()) != null) {
                    if (!requiredPlugins.contains(id2 = id2.trim()) && !ApplicationInfoImpl.getShadowInstance().isEssentialPlugin(id2)) {
                        disabledPlugins.add(PluginId.getId((String)id2));
                        continue;
                    }
                    updateDisablePluginsList = true;
                }
            }
            finally {
                if (updateDisablePluginsList) {
                    PluginManagerCore.savePluginsList(disabledPlugins, file2, false);
                    PluginManagerCore.fireEditDisablePlugins();
                }
            }
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().info("Unable to load disabled plugins list from " + file2, (Throwable)e);
        }
    }

    public static void dontLoadDisabledPlugins() {
        ourDisabledPlugins = Collections.emptySet();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    @NotNull
    public static List<String> getDisabledPlugins() {
        final Set<PluginId> list2 = PluginManagerCore.getDisabledIds();
        return new AbstractList<String>(){

            @Override
            public boolean contains(Object o) {
                return list2.contains(o);
            }

            @Override
            public int size() {
                return list2.size();
            }

            @Override
            public String get(int index) {
                if (index < 0 || index >= list2.size()) {
                    throw new IndexOutOfBoundsException("index=" + index + " size=" + list2.size());
                }
                Iterator iterator2 = list2.iterator();
                for (int i = 0; i < index; ++i) {
                    iterator2.next();
                }
                return ((PluginId)iterator2.next()).getIdString();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static Set<PluginId> getDisabledIds() {
        Set<PluginId> result2 = ourDisabledPlugins;
        if (result2 != null) {
            Set<PluginId> set = result2;
            if (set == null) {
                PluginManagerCore.$$$reportNull$$$0(8);
            }
            return set;
        }
        if (System.getProperty("idea.ignore.disabled.plugins") != null) {
            Set<PluginId> set = Collections.emptySet();
            if (set == null) {
                PluginManagerCore.$$$reportNull$$$0(9);
            }
            return set;
        }
        Class<PluginManagerCore> clazz = PluginManagerCore.class;
        synchronized (PluginManagerCore.class) {
            block10: {
                result2 = ourDisabledPlugins;
                if (result2 == null) break block10;
                Set<PluginId> set = result2;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                if (set == null) {
                    PluginManagerCore.$$$reportNull$$$0(10);
                }
                return set;
            }
            result2 = new LinkedHashSet<PluginId>();
            PluginManagerCore.loadDisabledPlugins(PathManager.getConfigPath(), result2);
            ourDisabledPlugins = result2;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            Set<PluginId> set = result2;
            if (set == null) {
                PluginManagerCore.$$$reportNull$$$0(11);
            }
            return set;
        }
    }

    @NotNull
    public static Set<PluginId> disabledPlugins() {
        Set<PluginId> set = Collections.unmodifiableSet(PluginManagerCore.getDisabledIds());
        if (set == null) {
            PluginManagerCore.$$$reportNull$$$0(12);
        }
        return set;
    }

    public static boolean isDisabled(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(13);
        }
        return PluginManagerCore.getDisabledIds().contains(pluginId);
    }

    @Deprecated
    public static boolean isDisabled(@NotNull String pluginId) {
        if (pluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(14);
        }
        return PluginManagerCore.getDisabledIds().contains(PluginId.getId((String)pluginId));
    }

    public static boolean isBrokenPlugin(@NotNull IdeaPluginDescriptor descriptor2) {
        PluginId pluginId;
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(15);
        }
        if ((pluginId = descriptor2.getPluginId()) == null) {
            return true;
        }
        Set<String> set = PluginManagerCore.getBrokenPluginVersions().get(pluginId);
        return set != null && set.contains(descriptor2.getVersion());
    }

    @NotNull
    private static Map<PluginId, Set<String>> getBrokenPluginVersions() {
        Map<PluginId, Set<String>> result2 = (Map<PluginId, Set<String>>)com.intellij.reference.SoftReference.dereference(ourBrokenPluginVersions);
        if (result2 != null) {
            Map<PluginId, Set<String>> map2 = result2;
            if (map2 == null) {
                PluginManagerCore.$$$reportNull$$$0(16);
            }
            return map2;
        }
        if (System.getProperty("idea.ignore.disabled.plugins") != null) {
            result2 = Collections.emptyMap();
            ourBrokenPluginVersions = new SoftReference(result2);
            Map<PluginId, Set<String>> map3 = result2;
            if (map3 == null) {
                PluginManagerCore.$$$reportNull$$$0(17);
            }
            return map3;
        }
        result2 = new HashMap();
        try (InputStream resource = PluginManagerCore.class.getResourceAsStream("/brokenPlugins.txt");
             BufferedReader br = new BufferedReader(new InputStreamReader(resource, StandardCharsets.UTF_8));){
            String s;
            while ((s = br.readLine()) != null) {
                List tokens;
                if ((s = s.trim()).startsWith("//") || (tokens = ParametersListUtil.parse((String)s)).isEmpty()) continue;
                if (tokens.size() == 1) {
                    throw new RuntimeException("brokenPlugins.txt is broken. The line contains plugin name, but does not contains version: " + s);
                }
                PluginId pluginId = PluginId.getId((String)((String)tokens.get(0)));
                List versions = tokens.subList(1, tokens.size());
                Set<String> set = result2.get(pluginId);
                if (set == null) {
                    set = new HashSet<String>();
                    result2.put(pluginId, set);
                }
                set.addAll(versions);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read /brokenPlugins.txt", e);
        }
        ourBrokenPluginVersions = new SoftReference<Map<PluginId, Set<String>>>(result2);
        Map<PluginId, Set<String>> map4 = result2;
        if (map4 == null) {
            PluginManagerCore.$$$reportNull$$$0(18);
        }
        return map4;
    }

    private static void fireEditDisablePlugins() {
        if (disabledPluginListener != null) {
            disabledPluginListener.run();
        }
    }

    public static void savePluginsList(@NotNull Collection<PluginId> ids, @NotNull Path file2, boolean append) throws IOException {
        if (ids == null) {
            PluginManagerCore.$$$reportNull$$$0(19);
        }
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(20);
        }
        Files.createDirectories(file2.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = append ? Files.newBufferedWriter(file2, StandardOpenOption.APPEND, StandardOpenOption.CREATE) : Files.newBufferedWriter(file2, new OpenOption[0]);){
            PluginManagerCore.writePluginsList(ids, writer);
        }
    }

    public static void writePluginsList(@NotNull Collection<PluginId> ids, @NotNull Writer writer) throws IOException {
        if (ids == null) {
            PluginManagerCore.$$$reportNull$$$0(21);
        }
        if (writer == null) {
            PluginManagerCore.$$$reportNull$$$0(22);
        }
        ArrayList<PluginId> sortedIds = new ArrayList<PluginId>(ids);
        sortedIds.sort(null);
        String separator = LineSeparator.getSystemLineSeparator().getSeparatorString();
        for (PluginId id2 : sortedIds) {
            writer.write(id2.getIdString());
            writer.write(separator);
        }
    }

    @Deprecated
    public static boolean disablePlugin(@NotNull String id2) {
        if (id2 == null) {
            PluginManagerCore.$$$reportNull$$$0(23);
        }
        return PluginManagerCore.disablePlugin(PluginId.getId((String)id2));
    }

    public static boolean disablePlugin(@NotNull PluginId id2) {
        Set<PluginId> disabledPlugins;
        if (id2 == null) {
            PluginManagerCore.$$$reportNull$$$0(24);
        }
        return (disabledPlugins = PluginManagerCore.getDisabledIds()).add(id2) && PluginManagerCore.trySaveDisabledPlugins(disabledPlugins);
    }

    public static boolean enablePlugin(@NotNull PluginId id2) {
        Set<PluginId> disabledPlugins;
        if (id2 == null) {
            PluginManagerCore.$$$reportNull$$$0(25);
        }
        return (disabledPlugins = PluginManagerCore.getDisabledIds()).remove(id2) && PluginManagerCore.trySaveDisabledPlugins(disabledPlugins);
    }

    @Deprecated
    public static boolean enablePlugin(@NotNull String id2) {
        if (id2 == null) {
            PluginManagerCore.$$$reportNull$$$0(26);
        }
        return PluginManagerCore.enablePlugin(PluginId.getId((String)id2));
    }

    static boolean trySaveDisabledPlugins(@NotNull Collection<PluginId> disabledPlugins) {
        if (disabledPlugins == null) {
            PluginManagerCore.$$$reportNull$$$0(27);
        }
        try {
            PluginManagerCore.saveDisabledPlugins(disabledPlugins, false);
            return true;
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().warn("Unable to save disabled plugins list", (Throwable)e);
            return false;
        }
    }

    public static void saveDisabledPlugins(@NotNull Collection<PluginId> ids, boolean append) throws IOException {
        if (ids == null) {
            PluginManagerCore.$$$reportNull$$$0(28);
        }
        PluginManagerCore.saveDisabledPlugins(PathManager.getConfigPath(), ids, append);
    }

    public static void saveDisabledPlugins(@NotNull String configPath, @NotNull Collection<PluginId> ids, boolean append) throws IOException {
        if (configPath == null) {
            PluginManagerCore.$$$reportNull$$$0(29);
        }
        if (ids == null) {
            PluginManagerCore.$$$reportNull$$$0(30);
        }
        Path plugins2 = Paths.get(configPath, DISABLED_PLUGINS_FILENAME);
        PluginManagerCore.savePluginsList(ids, plugins2, append);
        ourDisabledPlugins = null;
        PluginManagerCore.fireEditDisablePlugins();
    }

    public static boolean isModuleDependency(@NotNull PluginId dependentPluginId) {
        if (dependentPluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(31);
        }
        return dependentPluginId.getIdString().startsWith(MODULE_DEPENDENCY_PREFIX);
    }

    @ApiStatus.Internal
    @NotNull
    public static PluginException createPluginException(@NotNull String errorMessage, @Nullable Throwable cause, @NotNull Class<?> pluginClass) {
        ClassLoader classLoader;
        if (errorMessage == null) {
            PluginManagerCore.$$$reportNull$$$0(32);
        }
        if (pluginClass == null) {
            PluginManagerCore.$$$reportNull$$$0(33);
        }
        PluginId pluginId = (classLoader = pluginClass.getClassLoader()) instanceof PluginClassLoader ? ((PluginClassLoader)((Object)classLoader)).getPluginId() : PluginManagerCore.getPluginByClassName(pluginClass.getName());
        return new PluginException(errorMessage, cause, pluginId);
    }

    @Nullable
    public static PluginId getPluginByClassName(@NotNull String className) {
        PluginId id2;
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(34);
        }
        return (id2 = PluginManagerCore.getPluginOrPlatformByClassName(className)) == null || CORE_ID == id2 ? null : id2;
    }

    @Nullable
    public static PluginId getPluginOrPlatformByClassName(@NotNull String className) {
        PluginDescriptor result2;
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(35);
        }
        return (result2 = PluginManagerCore.getPluginDescriptorOrPlatformByClassName(className)) == null ? null : result2.getPluginId();
    }

    @Nullable
    @ApiStatus.Internal
    public static PluginDescriptor getPluginDescriptorOrPlatformByClassName(@NotNull String className) {
        List<IdeaPluginDescriptorImpl> loadedPlugins;
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(36);
        }
        if ((loadedPlugins = ourLoadedPlugins) == null || className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("kotlin.") || className.startsWith("groovy.")) {
            return null;
        }
        IdeaPluginDescriptorImpl result2 = null;
        for (IdeaPluginDescriptorImpl o : loadedPlugins) {
            ClassLoader classLoader = o.getPluginClassLoader();
            if (classLoader == null || !PluginManagerCore.hasLoadedClass(className, classLoader)) continue;
            result2 = o;
            break;
        }
        if (result2 == null) {
            return null;
        }
        if (result2.getPluginId() != CORE_ID || className.startsWith("com.jetbrains.") || className.startsWith("org.jetbrains.") || className.startsWith("com.intellij.") || className.startsWith("org.intellij.") || className.startsWith("com.android.") || className.startsWith("git4idea.") || className.startsWith("org.angularjs.")) {
            return result2;
        }
        String root = PathManager.getResourceRoot((ClassLoader)result2.getPluginClassLoader(), (String)("/" + className.replace('.', '/') + ".class"));
        if (root == null) {
            return null;
        }
        for (IdeaPluginDescriptorImpl o : loadedPlugins) {
            Path path;
            if (!o.getUseIdeaClassLoader() || !root.startsWith(FileUtilRt.toSystemIndependentName((String)(path = o.getPluginPath()).toString()))) continue;
            result2 = o;
            break;
        }
        return result2;
    }

    private static boolean hasLoadedClass(@NotNull String className, @NotNull ClassLoader loader) {
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(37);
        }
        if (loader == null) {
            PluginManagerCore.$$$reportNull$$$0(38);
        }
        if (loader instanceof UrlClassLoader) {
            return ((UrlClassLoader)loader).hasLoadedClass(className);
        }
        Class<?> aClass = loader.getClass();
        if (PluginManagerCore.isInstanceofUrlClassLoader(aClass)) {
            try {
                return (Boolean)aClass.getMethod("hasLoadedClass", String.class).invoke((Object)loader, className);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean isInstanceofUrlClassLoader(Class<?> aClass) {
        String urlClassLoaderName = UrlClassLoader.class.getName();
        while (aClass != null) {
            if (aClass.getName().equals(urlClassLoaderName)) {
                return true;
            }
            aClass = aClass.getSuperclass();
        }
        return false;
    }

    @Nullable
    private static IdeaPluginDescriptorImpl getImplicitDependency(@NotNull IdeaPluginDescriptor descriptor2, @Nullable IdeaPluginDescriptorImpl javaDep, boolean hasAllModules) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(39);
        }
        if (descriptor2.getPluginId() == CORE_ID || descriptor2.getPluginId() == JAVA_PLUGIN_ID || VENDOR_JETBRAINS.equals(descriptor2.getVendor()) || !hasAllModules || javaDep == null) {
            return null;
        }
        return PluginManagerCore.hasModuleDependencies(descriptor2) ? null : javaDep;
    }

    static boolean hasModuleDependencies(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(40);
        }
        for (PluginId depId : descriptor2.getDependentPluginIds()) {
            if (depId != JAVA_PLUGIN_ID && depId != JAVA_MODULE_ID && !PluginManagerCore.isModuleDependency(depId)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static ClassLoader createPluginClassLoader(ClassLoader @NotNull [] parentLoaders, @NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull UrlClassLoader.Builder urlLoaderBuilder) {
        List<Path> classPath;
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(41);
        }
        if (urlLoaderBuilder == null) {
            PluginManagerCore.$$$reportNull$$$0(42);
        }
        if (parentLoaders == null) {
            PluginManagerCore.$$$reportNull$$$0(43);
        }
        if ((classPath = descriptor2.jarFiles) == null) {
            classPath = descriptor2.collectClassPath();
        } else {
            descriptor2.jarFiles = null;
        }
        if (descriptor2.getUseIdeaClassLoader()) {
            ClassLoader classLoader;
            PluginManagerCore.getLogger().warn(descriptor2.getPluginId() + " uses deprecated `use-idea-classloader` attribute");
            ClassLoader loader = PluginManagerCore.class.getClassLoader();
            try {
                MethodHandle addURL = MethodHandles.lookup().findVirtual(loader.getClass(), "addURL", MethodType.methodType(Void.TYPE, URL.class));
                for (Path pathElement : classPath) {
                    addURL.invoke(loader, PluginManagerCore.localFileToUrl(pathElement, descriptor2));
                }
                classLoader = loader;
            }
            catch (Throwable t) {
                throw new IllegalStateException("An unexpected core classloader: " + loader.getClass(), t);
            }
            if (classLoader == null) {
                PluginManagerCore.$$$reportNull$$$0(44);
            }
            return classLoader;
        }
        ArrayList<URL> urls = new ArrayList<URL>(classPath.size());
        for (Path pathElement : classPath) {
            urls.add(PluginManagerCore.localFileToUrl(pathElement, descriptor2));
        }
        return new PluginClassLoader(urlLoaderBuilder.urls(urls), parentLoaders, descriptor2.getPluginId(), (IdeaPluginDescriptor)descriptor2, descriptor2.getVersion(), descriptor2.getPluginPath());
    }

    @NotNull
    private static URL localFileToUrl(@NotNull Path file2, @NotNull IdeaPluginDescriptor descriptor2) {
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(45);
        }
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(46);
        }
        try {
            return new URL("file", "", file2.normalize().toUri().getRawPath());
        }
        catch (MalformedURLException e) {
            throw new PluginException("Corrupted path element: `" + file2 + '`', (Throwable)e, descriptor2.getPluginId());
        }
    }

    public static synchronized void invalidatePlugins() {
        ourPlugins = null;
        ourLoadedPlugins = null;
        ourDisabledPlugins = null;
        ourShadowedBundledPlugins = null;
    }

    private static void logPlugins(@NotNull @NotNull IdeaPluginDescriptorImpl @NotNull [] plugins2) {
        if (plugins2 == null) {
            PluginManagerCore.$$$reportNull$$$0(47);
        }
        StringBuilder bundled = new StringBuilder();
        StringBuilder disabled = new StringBuilder();
        StringBuilder custom = new StringBuilder();
        for (IdeaPluginDescriptorImpl descriptor2 : plugins2) {
            StringBuilder target2 = !descriptor2.isEnabled() ? disabled : (descriptor2.isBundled() || descriptor2.getPluginId() == SPECIAL_IDEA_PLUGIN_ID ? bundled : custom);
            if (target2.length() > 0) {
                target2.append(", ");
            }
            target2.append(descriptor2.getName());
            String version2 = descriptor2.getVersion();
            if (version2 == null) continue;
            target2.append(" (").append(version2).append(')');
        }
        Logger logger = PluginManagerCore.getLogger();
        logger.info("Loaded bundled plugins: " + bundled);
        if (custom.length() > 0) {
            logger.info("Loaded custom plugins: " + custom);
        }
        if (disabled.length() > 0) {
            logger.info("Disabled plugins: " + disabled);
        }
    }

    public static boolean isRunningFromSources() {
        Boolean result2 = isRunningFromSources;
        if (result2 == null) {
            isRunningFromSources = result2 = Boolean.valueOf(Files.isDirectory(Paths.get(PathManager.getHomePath(), ".idea"), new LinkOption[0]));
        }
        return result2;
    }

    private static void prepareLoadingPluginsErrorMessage(@NotNull List<PluginError> errors, @NotNull List<String> actions) {
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(48);
        }
        if (actions == null) {
            PluginManagerCore.$$$reportNull$$$0(49);
        }
        ourLoadingErrors = errors;
        ArrayList<PluginError> errorsToReport = new ArrayList<PluginError>();
        for (PluginError error : errors) {
            if (!error.isNotifyUser()) continue;
            errorsToReport.add(error);
        }
        String message = "Problems found loading plugins:\n  " + errors.stream().map(PluginError::toString).collect(Collectors.joining("\n  "));
        Application app = ApplicationManager.getApplication();
        if (app == null || !app.isHeadlessEnvironment() || isUnitTestMode) {
            if (!errorsToReport.isEmpty()) {
                String errorMessage = Stream.concat(errorsToReport.stream().map(o -> o.toUserError() + "."), actions.stream()).collect(Collectors.joining("<p/>"));
                ourPluginError = ourPluginError == null ? errorMessage : ourPluginError + "<p/>\n" + errorMessage;
            }
            if (!errors.isEmpty()) {
                PluginManagerCore.getLogger().warn(message);
            }
        } else if (!errors.isEmpty()) {
            PluginManagerCore.getLogger().error(message);
        }
    }

    @Nullable
    public static String getLoadingError(@NotNull IdeaPluginDescriptor pluginDescriptor) {
        PluginError error;
        if (pluginDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(50);
        }
        if ((error = PluginManagerCore.findErrorForPlugin(ourLoadingErrors, pluginDescriptor.getPluginId())) != null) {
            String reason = error.getIncompatibleReason();
            if (reason != null) {
                return "Incompatible (" + reason + ")";
            }
            return error.getMessage();
        }
        return null;
    }

    @Nullable
    public static PluginId getFirstDisabledDependency(@NotNull IdeaPluginDescriptor pluginDescriptor) {
        PluginError error;
        if (pluginDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(51);
        }
        if ((error = PluginManagerCore.findErrorForPlugin(ourLoadingErrors, pluginDescriptor.getPluginId())) != null) {
            return error.getDisabledDependency();
        }
        return null;
    }

    @Nullable
    private static PluginError findErrorForPlugin(@Nullable List<PluginError> errors, @NotNull PluginId pluginId) {
        if (pluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(52);
        }
        if (errors == null) {
            return null;
        }
        for (PluginError error : errors) {
            if (error.plugin == null || !error.plugin.getPluginId().equals(pluginId)) continue;
            return error;
        }
        return null;
    }

    @NotNull
    private static CachingSemiGraph<IdeaPluginDescriptorImpl> createPluginIdGraph(@NotNull List<IdeaPluginDescriptorImpl> descriptors, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap, boolean withOptional) {
        if (descriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(53);
        }
        if (idToDescriptorMap == null) {
            PluginManagerCore.$$$reportNull$$$0(54);
        }
        IdeaPluginDescriptorImpl javaDep = idToDescriptorMap.get(JAVA_MODULE_ID);
        boolean hasAllModules = idToDescriptorMap.containsKey(ALL_MODULES_MARKER);
        HashSet uniqueCheck = new HashSet();
        return new CachingSemiGraph<IdeaPluginDescriptorImpl>(descriptors, rootDescriptor -> {
            PluginId[] dependentPluginIds = rootDescriptor.getDependentPluginIds();
            IdeaPluginDescriptorImpl implicitDep = PluginManagerCore.getImplicitDependency(rootDescriptor, javaDep, hasAllModules);
            PluginId[] optionalDependentPluginIds = withOptional ? rootDescriptor.getOptionalDependentPluginIds() : PluginId.EMPTY_ARRAY;
            int capacity = dependentPluginIds.length - (withOptional ? 0 : optionalDependentPluginIds.length);
            if (capacity == 0) {
                return implicitDep == null ? Collections.emptyList() : Collections.singletonList(implicitDep);
            }
            uniqueCheck.clear();
            ArrayList<IdeaPluginDescriptorImpl> plugins2 = new ArrayList<IdeaPluginDescriptorImpl>(capacity + (implicitDep == null ? 0 : 1));
            if (implicitDep != null) {
                if (rootDescriptor == implicitDep) {
                    PluginManagerCore.getLogger().error("Plugin " + rootDescriptor + " depends on self");
                } else {
                    uniqueCheck.add(implicitDep);
                    plugins2.add(implicitDep);
                }
            }
            boolean excludeOptional = !withOptional && optionalDependentPluginIds.length > 0 && optionalDependentPluginIds.length != dependentPluginIds.length;
            block0: for (PluginId dependentPluginId : dependentPluginIds) {
                IdeaPluginDescriptorImpl dep;
                if (excludeOptional) {
                    for (PluginId id2 : optionalDependentPluginIds) {
                        if (id2 == dependentPluginId) continue block0;
                    }
                }
                if ((dep = (IdeaPluginDescriptorImpl)idToDescriptorMap.get(dependentPluginId)) == null) continue;
                if (rootDescriptor == dep) {
                    if (rootDescriptor.getPluginId() == CORE_ID) continue;
                    PluginManagerCore.getLogger().error("Plugin " + rootDescriptor + " depends on self");
                    continue;
                }
                if (!uniqueCheck.add(dep)) continue;
                plugins2.add(dep);
            }
            return plugins2;
        });
    }

    private static void checkPluginCycles(@NotNull List<IdeaPluginDescriptorImpl> descriptors, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap, @NotNull List<PluginError> errors) {
        CachingSemiGraph<IdeaPluginDescriptorImpl> graph2;
        DFSTBuilder builder2;
        if (descriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(55);
        }
        if (idToDescriptorMap == null) {
            PluginManagerCore.$$$reportNull$$$0(56);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(57);
        }
        if ((builder2 = new DFSTBuilder(GraphGenerator.generate(graph2 = PluginManagerCore.createPluginIdGraph(descriptors, idToDescriptorMap, true)))).isAcyclic()) {
            return;
        }
        StringBuilder cyclePresentation = new StringBuilder();
        for (Collection component2 : builder2.getComponents()) {
            if (component2.size() < 2) continue;
            if (cyclePresentation.length() > 0) {
                cyclePresentation.append(", ");
            }
            String separator = " <-> ";
            for (IdeaPluginDescriptor descriptor2 : component2) {
                descriptor2.setEnabled(false);
                cyclePresentation.append(descriptor2.getPluginId());
                cyclePresentation.append(separator);
            }
            cyclePresentation.setLength(cyclePresentation.length() - separator.length());
        }
        if (cyclePresentation.length() > 0) {
            errors.add(new PluginError(null, "Plugins should not have cyclic dependencies: " + cyclePresentation, null));
        }
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromDir(@NotNull Path file2, @NotNull String descriptorRelativePath, @Nullable Path pluginPath, @NotNull DescriptorLoadingContext context) {
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(58);
        }
        if (descriptorRelativePath == null) {
            PluginManagerCore.$$$reportNull$$$0(59);
        }
        if (context == null) {
            PluginManagerCore.$$$reportNull$$$0(60);
        }
        Path descriptorFile = file2.resolve(descriptorRelativePath);
        try {
            IdeaPluginDescriptorImpl descriptor2 = new IdeaPluginDescriptorImpl(pluginPath == null ? file2 : pluginPath, context.isBundled);
            Element element2 = JDOMUtil.load((Path)descriptorFile, (SafeJdomFactory)context.parentContext.getXmlFactory());
            descriptor2.readExternal(element2, descriptorFile.getParent(), context.pathResolver, context, descriptor2);
            return descriptor2;
        }
        catch (NoSuchFileException e) {
            return null;
        }
        catch (SerializationException | IOException | JDOMException e) {
            if (context.isEssential) {
                ExceptionUtil.rethrow((Throwable)e);
            }
            context.parentContext.result.reportCannotLoad(context.parentContext, file2, (Exception)e);
        }
        catch (Throwable e) {
            if (context.isEssential) {
                ExceptionUtil.rethrow((Throwable)e);
            }
            context.parentContext.getLogger().warn("Cannot load " + descriptorFile, e);
        }
        return null;
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromJar(@NotNull Path file2, @NotNull String fileName, @NotNull PathBasedJdomXIncluder.PathResolver<?> pathResolver, @NotNull DescriptorLoadingContext context, @Nullable Path pluginPath) {
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(61);
        }
        if (fileName == null) {
            PluginManagerCore.$$$reportNull$$$0(62);
        }
        if (pathResolver == null) {
            PluginManagerCore.$$$reportNull$$$0(63);
        }
        if (context == null) {
            PluginManagerCore.$$$reportNull$$$0(64);
        }
        SafeJdomFactory factory = context.parentContext.getXmlFactory();
        try {
            Element element2;
            Path metaInf = context.open(file2).getPath("/META-INF", new String[0]);
            try {
                element2 = JDOMUtil.load((Path)metaInf.resolve(fileName), (SafeJdomFactory)factory);
            }
            catch (NoSuchFileException ignore) {
                return null;
            }
            IdeaPluginDescriptorImpl descriptor2 = new IdeaPluginDescriptorImpl(pluginPath == null ? file2 : pluginPath, context.isBundled);
            if (descriptor2.readExternal(element2, metaInf, pathResolver, context, descriptor2)) {
                descriptor2.jarFiles = Collections.singletonList(descriptor2.getPluginPath());
            }
            return descriptor2;
        }
        catch (InvalidDataException | SerializationException e) {
            if (context.isEssential) {
                ExceptionUtil.rethrow((Throwable)e);
            }
            context.parentContext.result.reportCannotLoad(context.parentContext, file2, (Exception)e);
        }
        catch (Throwable e) {
            if (context.isEssential) {
                ExceptionUtil.rethrow((Throwable)e);
            }
            context.parentContext.getLogger().info("Cannot load " + file2 + "!/META-INF/" + fileName, e);
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static IdeaPluginDescriptorImpl loadDescriptor(@NotNull File file2, @NotNull String fileName) {
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(65);
        }
        if (fileName == null) {
            PluginManagerCore.$$$reportNull$$$0(66);
        }
        return PluginManager.loadDescriptor(file2.toPath(), fileName, PluginManagerCore.disabledPlugins(), false);
    }

    @ApiStatus.Internal
    @Nullable
    public static IdeaPluginDescriptorImpl loadDescriptor(@NotNull Path file2, boolean isBundled, @NotNull DescriptorListLoadingContext parentContext) {
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(67);
        }
        if (parentContext == null) {
            PluginManagerCore.$$$reportNull$$$0(68);
        }
        try (DescriptorLoadingContext context = new DescriptorLoadingContext(parentContext, isBundled, false, PathBasedJdomXIncluder.DEFAULT_PATH_RESOLVER);){
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginManagerCore.loadDescriptorFromFileOrDir(file2, PLUGIN_XML, context, Files.isDirectory(file2, new LinkOption[0]));
            return ideaPluginDescriptorImpl;
        }
    }

    @Nullable
    static IdeaPluginDescriptorImpl loadDescriptorFromFileOrDir(@NotNull Path file2, @NotNull String pathName, @NotNull DescriptorLoadingContext context, boolean isDirectory) {
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(69);
        }
        if (pathName == null) {
            PluginManagerCore.$$$reportNull$$$0(70);
        }
        if (context == null) {
            PluginManagerCore.$$$reportNull$$$0(71);
        }
        if (isDirectory) {
            return PluginManagerCore.loadDescriptorFromDirAndNormalize(file2, pathName, context);
        }
        if (StringUtilRt.endsWithIgnoreCase((CharSequence)file2.getFileName().toString(), (CharSequence)".jar")) {
            return PluginManagerCore.loadDescriptorFromJar(file2, pathName, context.pathResolver, context, null);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromDirAndNormalize(@NotNull Path file2, @NotNull String pathName, @NotNull DescriptorLoadingContext context) {
        void files2;
        String descriptorRelativePath;
        IdeaPluginDescriptorImpl descriptor2;
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(72);
        }
        if (pathName == null) {
            PluginManagerCore.$$$reportNull$$$0(73);
        }
        if (context == null) {
            PluginManagerCore.$$$reportNull$$$0(74);
        }
        if ((descriptor2 = PluginManagerCore.loadDescriptorFromDir(file2, descriptorRelativePath = META_INF + pathName, null, context)) != null) {
            return descriptor2;
        }
        try (DirectoryStream<Path> s = Files.newDirectoryStream(file2.resolve("lib"));){
            List files22 = ContainerUtil.collect(s.iterator());
        }
        catch (IOException e) {
            return null;
        }
        if (files2.isEmpty()) {
            return null;
        }
        PluginManagerCore.putMoreLikelyPluginJarsFirst(file2, (List<Path>)files2);
        List<Path> pluginJarFiles = null;
        ArrayList<Path> dirs = null;
        for (Path path : files2) {
            if (Files.isDirectory(path, new LinkOption[0])) {
                if (dirs == null) {
                    dirs = new ArrayList<Path>();
                }
                dirs.add(path);
                continue;
            }
            String string = path.toString();
            if (!StringUtilRt.endsWithIgnoreCase((CharSequence)string, (CharSequence)".jar") && !StringUtilRt.endsWithIgnoreCase((CharSequence)string, (CharSequence)".zip")) continue;
            if (files2.size() == 1) {
                pluginJarFiles = Collections.singletonList(path);
                break;
            }
            if (pluginJarFiles == null) {
                pluginJarFiles = new ArrayList<Path>();
            }
            pluginJarFiles.add(path);
        }
        if (pluginJarFiles != null) {
            PluginXmlPathResolver pathResolver = new PluginXmlPathResolver(pluginJarFiles, context);
            for (Path path : pluginJarFiles) {
                descriptor2 = PluginManagerCore.loadDescriptorFromJar(path, pathName, pathResolver, context, file2);
                if (descriptor2 == null) continue;
                descriptor2.jarFiles = pluginJarFiles;
                return descriptor2;
            }
        }
        if (dirs == null) {
            return null;
        }
        for (Path path : dirs) {
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginManagerCore.loadDescriptorFromDir(path, descriptorRelativePath, file2, context);
            if (ideaPluginDescriptorImpl == null) continue;
            if (descriptor2 != null) {
                context.parentContext.getLogger().info("Cannot load " + file2 + " because two or more plugin.xml's detected");
                return null;
            }
            descriptor2 = ideaPluginDescriptorImpl;
        }
        return descriptor2;
    }

    private static void putMoreLikelyPluginJarsFirst(@NotNull Path pluginDir, @NotNull List<Path> filesInLibUnderPluginDir) {
        if (pluginDir == null) {
            PluginManagerCore.$$$reportNull$$$0(75);
        }
        if (filesInLibUnderPluginDir == null) {
            PluginManagerCore.$$$reportNull$$$0(76);
        }
        String pluginDirName = pluginDir.getFileName().toString();
        filesInLibUnderPluginDir.sort((o1, o2) -> {
            boolean o1StartsWithNeededName;
            boolean o1IsVersioned;
            boolean o1StartsWithResources;
            String o2Name = o2.getFileName().toString();
            String o1Name = o1.getFileName().toString();
            boolean o2StartsWithResources = o2Name.startsWith("resources");
            if (o2StartsWithResources != (o1StartsWithResources = o1Name.startsWith("resources"))) {
                return o2StartsWithResources ? -1 : 1;
            }
            boolean o2IsVersioned = PluginManagerCore.fileNameIsLikeVersionedLibraryName(o2Name);
            if (o2IsVersioned != (o1IsVersioned = PluginManagerCore.fileNameIsLikeVersionedLibraryName(o1Name))) {
                return o2IsVersioned ? -1 : 1;
            }
            boolean o2StartsWithNeededName = StringUtil.startsWithIgnoreCase((String)o2Name, (String)pluginDirName);
            if (o2StartsWithNeededName != (o1StartsWithNeededName = StringUtil.startsWithIgnoreCase((String)o1Name, (String)pluginDirName))) {
                return o2StartsWithNeededName ? 1 : -1;
            }
            return o1Name.length() - o2Name.length();
        });
    }

    private static boolean fileNameIsLikeVersionedLibraryName(@NotNull String name) {
        int i;
        if (name == null) {
            PluginManagerCore.$$$reportNull$$$0(77);
        }
        if ((i = name.lastIndexOf(45)) == -1) {
            return false;
        }
        if (i + 1 < name.length()) {
            char c = name.charAt(i + 1);
            if (Character.isDigit(c)) {
                return true;
            }
            return (c == 'm' || c == 'M') && i + 2 < name.length() && Character.isDigit(name.charAt(i + 2));
        }
        return false;
    }

    private static void loadDescriptorsFromDir(@NotNull Path dir, boolean isBundled, @NotNull DescriptorListLoadingContext context) throws ExecutionException, InterruptedException {
        if (dir == null) {
            PluginManagerCore.$$$reportNull$$$0(78);
        }
        if (context == null) {
            PluginManagerCore.$$$reportNull$$$0(79);
        }
        ArrayList<Future<IdeaPluginDescriptorImpl>> tasks = new ArrayList<Future<IdeaPluginDescriptorImpl>>();
        ExecutorService executorService = context.getExecutorService();
        try {
            Throwable throwable = null;
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(dir);){
                for (Path file2 : dirStream) {
                    tasks.add(executorService.submit(() -> PluginManagerCore.loadDescriptor(file2, isBundled, context)));
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (IOException ignore) {
            return;
        }
        for (Future future2 : tasks) {
            IdeaPluginDescriptorImpl descriptor2 = (IdeaPluginDescriptorImpl)future2.get();
            if (descriptor2 == null) continue;
            context.result.add(descriptor2, context, false);
        }
    }

    private static void prepareLoadingPluginsErrorMessage(@NotNull Map<PluginId, String> disabledIds, @NotNull Set<PluginId> disabledRequiredIds, @NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idMap, @NotNull List<PluginError> errors) {
        if (disabledIds == null) {
            PluginManagerCore.$$$reportNull$$$0(80);
        }
        if (disabledRequiredIds == null) {
            PluginManagerCore.$$$reportNull$$$0(81);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(82);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(83);
        }
        ArrayList<String> actions = new ArrayList<String>();
        if (!disabledIds.isEmpty()) {
            String text2 = "<br><a href=\"disable\">Disable ";
            if (disabledIds.size() == 1) {
                PluginId id2 = disabledIds.keySet().iterator().next();
                text2 = text2 + (idMap.containsKey(id2) ? PluginManagerCore.toPresentableName(idMap.get(id2)) : PluginManagerCore.toPresentableName(id2.getIdString()));
            } else {
                text2 = text2 + "not loaded plugins";
            }
            actions.add(text2 + "</a>");
            if (!disabledRequiredIds.isEmpty()) {
                String name = disabledRequiredIds.size() == 1 ? PluginManagerCore.toPresentableName(idMap.get(disabledRequiredIds.iterator().next())) : "all necessary plugins";
                actions.add("<a href=\"enable\">Enable " + name + "</a>");
            }
            actions.add("<a href=\"edit\">Open plugin manager</a>");
        }
        PluginManagerCore.prepareLoadingPluginsErrorMessage(errors, actions);
    }

    @NotNull
    public static List<? extends IdeaPluginDescriptor> testLoadDescriptorsFromClassPath(@NotNull ClassLoader loader) throws ExecutionException, InterruptedException {
        if (loader == null) {
            PluginManagerCore.$$$reportNull$$$0(84);
        }
        LinkedHashMap<URL, String> urlsFromClassPath = new LinkedHashMap<URL, String>();
        PluginManagerCore.collectPluginFilesInClassPath(loader, urlsFromClassPath);
        DescriptorListLoadingContext context = new DescriptorListLoadingContext(0, Collections.emptySet(), new PluginLoadingResult(Collections.emptyMap(), BuildNumber.currentVersion(), false));
        try (DescriptorLoadingContext loadingContext = new DescriptorLoadingContext(context, true, true, new ClassPathXmlPathResolver(loader));){
            PluginManagerCore.loadDescriptorsFromClassPath(urlsFromClassPath, loadingContext, null);
        }
        context.result.finishLoading();
        List<IdeaPluginDescriptorImpl> list2 = context.result.getEnabledPlugins();
        if (list2 == null) {
            PluginManagerCore.$$$reportNull$$$0(85);
        }
        return list2;
    }

    private static void loadDescriptorsFromClassPath(@NotNull Map<URL, String> urls, @NotNull DescriptorLoadingContext context, @Nullable URL platformPluginURL) throws ExecutionException, InterruptedException {
        if (urls == null) {
            PluginManagerCore.$$$reportNull$$$0(86);
        }
        if (context == null) {
            PluginManagerCore.$$$reportNull$$$0(87);
        }
        if (urls.isEmpty()) {
            return;
        }
        ArrayList<Future<IdeaPluginDescriptorImpl>> tasks = new ArrayList<Future<IdeaPluginDescriptorImpl>>(urls.size());
        ExecutorService executorService = context.parentContext.getExecutorService();
        for (Map.Entry<URL, String> entry : urls.entrySet()) {
            URL uRL = entry.getKey();
            tasks.add(executorService.submit(() -> PluginManagerCore.loadDescriptorFromResource(url, (String)entry.getValue(), context.copy(url.equals(platformPluginURL)))));
        }
        PluginLoadingResult result2 = context.parentContext.result;
        for (Future future2 : tasks) {
            IdeaPluginDescriptorImpl descriptor2 = (IdeaPluginDescriptorImpl)future2.get();
            if (descriptor2 == null) continue;
            descriptor2.setUseCoreClassLoader();
            result2.add(descriptor2, context.parentContext, false);
        }
    }

    @Nullable
    private static URL computePlatformPluginUrlAndCollectPluginUrls(@NotNull ClassLoader loader, @NotNull Map<URL, String> urls) {
        if (loader == null) {
            PluginManagerCore.$$$reportNull$$$0(88);
        }
        if (urls == null) {
            PluginManagerCore.$$$reportNull$$$0(89);
        }
        String platformPrefix = System.getProperty("idea.platform.prefix");
        URL result2 = null;
        if (platformPrefix != null) {
            if ((platformPrefix.equals("idea") || platformPrefix.equals("WebStorm")) && !PluginManagerCore.isRunningFromSources()) {
                urls.put(loader.getResource(PLUGIN_XML_PATH), PLUGIN_XML);
                return null;
            }
            String fileName = platformPrefix + "Plugin.xml";
            URL resource = loader.getResource(META_INF + fileName);
            if (resource != null) {
                urls.put(resource, fileName);
                result2 = resource;
            }
        }
        PluginManagerCore.collectPluginFilesInClassPath(loader, urls);
        return result2;
    }

    private static void collectPluginFilesInClassPath(@NotNull ClassLoader loader, @NotNull Map<URL, String> urls) {
        if (loader == null) {
            PluginManagerCore.$$$reportNull$$$0(90);
        }
        if (urls == null) {
            PluginManagerCore.$$$reportNull$$$0(91);
        }
        try {
            Enumeration<URL> enumeration = loader.getResources(PLUGIN_XML_PATH);
            while (enumeration.hasMoreElements()) {
                urls.put(enumeration.nextElement(), PLUGIN_XML);
            }
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().info((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromResource(@NotNull URL resource, @NotNull String pathName, @NotNull DescriptorLoadingContext loadingContext) {
        if (resource == null) {
            PluginManagerCore.$$$reportNull$$$0(92);
        }
        if (pathName == null) {
            PluginManagerCore.$$$reportNull$$$0(93);
        }
        if (loadingContext == null) {
            PluginManagerCore.$$$reportNull$$$0(94);
        }
        try {
            if ("file".equals(resource.getProtocol())) {
                Path file2 = Paths.get(StringUtil.trimEnd((String)FileUtilRt.toSystemIndependentName((String)PluginManagerCore.urlToFile(resource).toString()), (String)pathName), new String[0]).getParent();
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginManagerCore.loadDescriptorFromFileOrDir(file2, pathName, loadingContext, Files.isDirectory(file2, new LinkOption[0]));
                return ideaPluginDescriptorImpl;
            }
            if ("jar".equals(resource.getProtocol())) {
                String path = resource.getFile();
                Path file3 = PluginManagerCore.urlToFile(path.substring(0, path.indexOf("!/")));
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginManagerCore.loadDescriptorFromJar(file3, pathName, loadingContext.pathResolver, loadingContext, null);
                return ideaPluginDescriptorImpl;
            }
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = null;
            return ideaPluginDescriptorImpl;
        }
        catch (Throwable e) {
            if (loadingContext.isEssential) {
                ExceptionUtil.rethrow((Throwable)e);
            }
            loadingContext.parentContext.getLogger().info("Cannot load " + resource, e);
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = null;
            return ideaPluginDescriptorImpl;
        }
        finally {
            loadingContext.close();
        }
    }

    @NotNull
    private static Path urlToFile(@NotNull String url) throws URISyntaxException {
        Path path;
        if (url == null) {
            PluginManagerCore.$$$reportNull$$$0(95);
        }
        try {
            path = Paths.get(new URI(url));
        }
        catch (URISyntaxException e) {
            if (url.indexOf(32) > 0) {
                Path path2 = Paths.get(new URI(StringUtil.replace((String)url, (String)" ", (String)"%20")));
                if (path2 == null) {
                    PluginManagerCore.$$$reportNull$$$0(97);
                }
                return path2;
            }
            throw e;
        }
        if (path == null) {
            PluginManagerCore.$$$reportNull$$$0(96);
        }
        return path;
    }

    @NotNull
    private static Path urlToFile(URL url) throws URISyntaxException, MalformedURLException {
        Path path;
        try {
            path = Paths.get(url.toURI());
        }
        catch (URISyntaxException e) {
            String str = url.toString();
            if (str.indexOf(32) > 0) {
                Path path2 = Paths.get(new URL(StringUtil.replace((String)str, (String)" ", (String)"%20")).toURI());
                if (path2 == null) {
                    PluginManagerCore.$$$reportNull$$$0(99);
                }
                return path2;
            }
            throw e;
        }
        if (path == null) {
            PluginManagerCore.$$$reportNull$$$0(98);
        }
        return path;
    }

    private static void loadDescriptorsFromProperty(@NotNull PluginLoadingResult result2, @NotNull DescriptorListLoadingContext context) {
        String pathProperty;
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(100);
        }
        if (context == null) {
            PluginManagerCore.$$$reportNull$$$0(101);
        }
        if ((pathProperty = System.getProperty(PROPERTY_PLUGIN_PATH)) == null) {
            return;
        }
        StringTokenizer t = new StringTokenizer(pathProperty, File.pathSeparator + ",");
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            IdeaPluginDescriptorImpl descriptor2 = PluginManagerCore.loadDescriptor(Paths.get(s, new String[0]), false, context);
            if (descriptor2 == null) continue;
            result2.add(descriptor2, context, true);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static List<? extends IdeaPluginDescriptor> loadUncachedDescriptors() {
        List<IdeaPluginDescriptorImpl> list2 = PluginManagerCore.loadDescriptors().result.getEnabledPlugins();
        if (list2 == null) {
            PluginManagerCore.$$$reportNull$$$0(102);
        }
        return list2;
    }

    public static void scheduleDescriptorLoading() {
        PluginManagerCore.getOrScheduleLoading();
    }

    @NotNull
    private static synchronized CompletableFuture<DescriptorListLoadingContext> getOrScheduleLoading() {
        CompletableFuture<DescriptorListLoadingContext> future2 = descriptorListFuture;
        if (future2 != null) {
            CompletableFuture<DescriptorListLoadingContext> completableFuture = future2;
            if (completableFuture == null) {
                PluginManagerCore.$$$reportNull$$$0(103);
            }
            return completableFuture;
        }
        descriptorListFuture = future2 = CompletableFuture.supplyAsync(() -> {
            Activity activity = StartUpMeasurer.startActivity((String)"plugin descriptor loading");
            DescriptorListLoadingContext context = PluginManagerCore.loadDescriptors();
            activity.end();
            return context;
        }, AppExecutorUtil.getAppExecutorService());
        CompletableFuture<DescriptorListLoadingContext> completableFuture = future2;
        if (completableFuture == null) {
            PluginManagerCore.$$$reportNull$$$0(104);
        }
        return completableFuture;
    }

    @ApiStatus.Internal
    @NotNull
    public static List<IdeaPluginDescriptorImpl> getEnabledPluginRawList() {
        List<IdeaPluginDescriptorImpl> list2 = PluginManagerCore.getOrScheduleLoading().join().result.getEnabledPlugins();
        if (list2 == null) {
            PluginManagerCore.$$$reportNull$$$0(105);
        }
        return list2;
    }

    @ApiStatus.Internal
    @NotNull
    public static CompletionStage<List<IdeaPluginDescriptorImpl>> initPlugins(@NotNull ClassLoader coreClassLoader) {
        CompletableFuture<DescriptorListLoadingContext> future2;
        if (coreClassLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(106);
        }
        if ((future2 = descriptorListFuture) == null) {
            future2 = CompletableFuture.completedFuture(null);
        }
        CompletionStage completionStage = future2.thenApply(context -> {
            PluginManagerCore.loadAndInitializePlugins(context, coreClassLoader);
            return ourLoadedPlugins;
        });
        if (completionStage == null) {
            PluginManagerCore.$$$reportNull$$$0(107);
        }
        return completionStage;
    }

    @ApiStatus.Internal
    @NotNull
    private static DescriptorListLoadingContext loadDescriptors() {
        PluginLoadingResult result2 = new PluginLoadingResult(PluginManagerCore.getBrokenPluginVersions(), PluginManagerCore.getBuildNumber());
        LinkedHashMap<URL, String> urlsFromClassPath = new LinkedHashMap<URL, String>();
        ClassLoader classLoader = PluginManagerCore.class.getClassLoader();
        URL platformPluginURL = PluginManagerCore.computePlatformPluginUrlAndCollectPluginUrls(classLoader, urlsFromClassPath);
        int flags = 1;
        boolean isUnitTestMode = PluginManagerCore.isUnitTestMode;
        if (isUnitTestMode) {
            flags |= 2;
        }
        try (DescriptorListLoadingContext context = new DescriptorListLoadingContext(flags, PluginManagerCore.disabledPlugins(), result2);){
            try (DescriptorLoadingContext loadingContext = new DescriptorLoadingContext(context, true, true, new ClassPathXmlPathResolver(classLoader));){
                PluginManagerCore.loadDescriptorsFromClassPath(urlsFromClassPath, loadingContext, platformPluginURL);
            }
            PluginManagerCore.loadDescriptorsFromDir(Paths.get(PathManager.getPluginsPath(), new String[0]), false, context);
            if (!isUnitTestMode) {
                PluginManagerCore.loadDescriptorsFromDir(Paths.get(PathManager.getPreInstalledPluginsPath(), new String[0]), true, context);
            }
            PluginManagerCore.loadDescriptorsFromProperty(result2, context);
            if (isUnitTestMode && result2.enabledPluginCount() <= 1) {
                context.usePluginClassLoader = true;
                PluginManagerCore.loadDescriptorsFromDir(Paths.get(PathManager.getPreInstalledPluginsPath(), new String[0]), true, context);
            }
        }
        context.result.finishLoading();
        DescriptorListLoadingContext descriptorListLoadingContext = context;
        if (descriptorListLoadingContext == null) {
            PluginManagerCore.$$$reportNull$$$0(108);
        }
        return descriptorListLoadingContext;
    }

    private static void mergeOptionalConfigs(@NotNull List<IdeaPluginDescriptorImpl> enabledPlugins, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap) {
        if (enabledPlugins == null) {
            PluginManagerCore.$$$reportNull$$$0(109);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(110);
        }
        if (PluginManagerCore.isRunningFromSources()) {
            for (IdeaPluginDescriptorImpl descriptor2 : enabledPlugins) {
                if (!descriptor2.isUseCoreClassLoader() || descriptor2.optionalConfigs == null) continue;
                descriptor2.optionalConfigs.forEach((id2, entries) -> {
                    IdeaPluginDescriptorImpl dependent = (IdeaPluginDescriptorImpl)idMap.get(id2);
                    if (dependent != null && !dependent.isUseCoreClassLoader()) {
                        entries.clear();
                    }
                });
            }
        }
        for (IdeaPluginDescriptorImpl rootDescriptor : enabledPlugins) {
            PluginManagerCore.mergeOptionalDescriptors(rootDescriptor, rootDescriptor, idMap);
        }
        for (IdeaPluginDescriptorImpl descriptor2 : enabledPlugins) {
            descriptor2.optionalConfigs = null;
        }
    }

    private static void mergeOptionalDescriptors(@NotNull IdeaPluginDescriptorImpl mergedDescriptor, @NotNull IdeaPluginDescriptorImpl rootDescriptor, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap) {
        Map<PluginId, List<IdeaPluginDescriptorImpl>> optionalDescriptors;
        if (mergedDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(111);
        }
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(112);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(113);
        }
        if ((optionalDescriptors = rootDescriptor.optionalConfigs) == null) {
            return;
        }
        optionalDescriptors.forEach((dependencyId, entries) -> {
            IdeaPluginDescriptorImpl dependencyDescriptor = (IdeaPluginDescriptorImpl)idMap.get(dependencyId);
            if (dependencyDescriptor == null || !dependencyDescriptor.isEnabled()) {
                return;
            }
            block0: for (IdeaPluginDescriptorImpl descriptor2 : entries) {
                for (PluginId id2 : descriptor2.getDependentPluginIds()) {
                    IdeaPluginDescriptorImpl dependentDescriptor = (IdeaPluginDescriptorImpl)idMap.get(id2);
                    if ((dependentDescriptor == null || !dependentDescriptor.isEnabled()) && !PluginManagerCore.isOptional(descriptor2, id2)) continue block0;
                }
                mergedDescriptor.mergeOptionalConfig(descriptor2);
                PluginManagerCore.mergeOptionalDescriptors(mergedDescriptor, descriptor2, idMap);
            }
        });
    }

    private static boolean isOptional(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull PluginId id2) {
        PluginId[] optional;
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(114);
        }
        if (id2 == null) {
            PluginManagerCore.$$$reportNull$$$0(115);
        }
        if ((optional = descriptor2.getOptionalDependentPluginIds()).length == 0) {
            return false;
        }
        if (optional.length == descriptor2.getDependentPluginIds().length) {
            return true;
        }
        for (PluginId otherId : optional) {
            if (id2 != otherId) continue;
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public static void initClassLoader(@NotNull IdeaPluginDescriptorImpl rootDescriptor) {
        ClassLoader[] classLoaderArray;
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(116);
        }
        Map<PluginId, IdeaPluginDescriptorImpl> idMap = PluginManagerCore.buildPluginIdMap(ContainerUtil.concat(PluginManagerCore.getLoadedPlugins(null), Collections.singletonList(rootDescriptor)));
        LinkedHashSet<ClassLoader> loaders = new LinkedHashSet<ClassLoader>();
        PluginManagerCore.processAllDependencies(rootDescriptor, true, idMap, descriptor2 -> {
            ClassLoader loader = descriptor2.getPluginClassLoader();
            if (loader == null) {
                PluginManagerCore.getLogger().error(rootDescriptor.formatErrorMessage("requires missing class loader for " + PluginManagerCore.toPresentableName(descriptor2)));
            } else {
                loaders.add(loader);
            }
            return FileVisitResult.SKIP_SUBTREE;
        });
        IdeaPluginDescriptorImpl javaDep = idMap.get(JAVA_MODULE_ID);
        boolean hasAllModules = idMap.containsKey(ALL_MODULES_MARKER);
        IdeaPluginDescriptorImpl implicitDependency = PluginManagerCore.getImplicitDependency(rootDescriptor, javaDep, hasAllModules);
        if (implicitDependency != null && implicitDependency.getPluginClassLoader() != null) {
            loaders.add(implicitDependency.getPluginClassLoader());
        }
        if (loaders.isEmpty()) {
            ClassLoader[] classLoaderArray2 = new ClassLoader[1];
            classLoaderArray = classLoaderArray2;
            classLoaderArray2[0] = PluginManagerCore.class.getClassLoader();
        } else {
            classLoaderArray = loaders.toArray(new ClassLoader[0]);
        }
        ClassLoader[] array = classLoaderArray;
        rootDescriptor.setLoader(PluginManagerCore.createPluginClassLoader(array, rootDescriptor, PluginManagerCore.createUrlClassLoaderBuilder()));
    }

    @NotNull
    private static UrlClassLoader.Builder createUrlClassLoaderBuilder() {
        UrlClassLoader.Builder builder2 = UrlClassLoader.build().allowLock().useCache().urlsInterned();
        if (builder2 == null) {
            PluginManagerCore.$$$reportNull$$$0(117);
        }
        return builder2;
    }

    @NotNull
    static BuildNumber getBuildNumber() {
        BuildNumber result2 = ourBuildNumber;
        if (result2 == null) {
            result2 = BuildNumber.fromString((String)PluginManagerCore.getPluginsCompatibleBuild());
            if (result2 == null) {
                if (isUnitTestMode) {
                    result2 = BuildNumber.currentVersion();
                } else {
                    try {
                        result2 = ApplicationInfoImpl.getShadowInstance().getApiVersionAsNumber();
                    }
                    catch (RuntimeException ignore) {
                        result2 = BuildNumber.currentVersion();
                    }
                }
            }
            ourBuildNumber = result2;
        }
        BuildNumber buildNumber = result2;
        if (buildNumber == null) {
            PluginManagerCore.$$$reportNull$$$0(118);
        }
        return buildNumber;
    }

    private static void disableIncompatiblePlugins(@NotNull List<IdeaPluginDescriptorImpl> descriptors, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap, @NotNull List<PluginError> errors) {
        if (descriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(119);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(120);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(121);
        }
        String selectedIds = System.getProperty("idea.load.plugins.id");
        String selectedCategory = System.getProperty("idea.load.plugins.category");
        IdeaPluginDescriptorImpl coreDescriptor = idMap.get(CORE_ID);
        LinkedHashSet<IdeaPluginDescriptor> explicitlyEnabled = null;
        if (selectedIds != null) {
            HashSet set = new HashSet();
            List list2 = StringUtil.split((String)selectedIds, (String)",");
            for (String it : list2) {
                set.add(PluginId.getId((String)it));
            }
            set.addAll(((ApplicationInfoImpl)ApplicationInfoImpl.getShadowInstance()).getEssentialPluginsIds());
            explicitlyEnabled = new LinkedHashSet(set.size());
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                PluginId id2 = (PluginId)iterator2.next();
                IdeaPluginDescriptorImpl descriptor2 = idMap.get(id2);
                if (descriptor2 == null) continue;
                explicitlyEnabled.add(descriptor2);
            }
        } else if (selectedCategory != null) {
            explicitlyEnabled = new LinkedHashSet<IdeaPluginDescriptor>();
            for (IdeaPluginDescriptor ideaPluginDescriptor : descriptors) {
                if (!selectedCategory.equals(ideaPluginDescriptor.getCategory())) continue;
                explicitlyEnabled.add(ideaPluginDescriptor);
            }
        }
        if (explicitlyEnabled != null) {
            LinkedHashSet<IdeaPluginDescriptor> finalExplicitlyEnabled = explicitlyEnabled;
            HashSet<IdeaPluginDescriptor> hashSet = new HashSet<IdeaPluginDescriptor>();
            for (IdeaPluginDescriptor descriptor4 : new ArrayList(explicitlyEnabled)) {
                PluginManagerCore.processAllDependencies(descriptor4, false, idMap, hashSet, dependency -> {
                    finalExplicitlyEnabled.add((IdeaPluginDescriptor)dependency);
                    return FileVisitResult.CONTINUE;
                });
            }
        }
        boolean shouldLoadPlugins = Boolean.parseBoolean(System.getProperty("idea.load.plugins", "true"));
        for (IdeaPluginDescriptorImpl descriptor5 : descriptors) {
            if (descriptor5 == coreDescriptor) continue;
            if (explicitlyEnabled != null) {
                if (explicitlyEnabled.contains(descriptor5)) continue;
                descriptor5.setEnabled(false);
                PluginManagerCore.getLogger().info("Plugin " + PluginManagerCore.toPresentableName(descriptor5) + " " + (selectedIds != null ? "is not in 'idea.load.plugins.id' system property" : "category doesn't match 'idea.load.plugins.category' system property"));
                continue;
            }
            if (shouldLoadPlugins) continue;
            descriptor5.setEnabled(false);
            errors.add(new PluginError(descriptor5, "is skipped (plugins loading disabled)", null));
        }
    }

    public static boolean isCompatible(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(122);
        }
        return !PluginManagerCore.isIncompatible(descriptor2);
    }

    public static boolean isCompatible(@NotNull IdeaPluginDescriptor descriptor2, @Nullable BuildNumber buildNumber) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(123);
        }
        return !PluginManagerCore.isIncompatible(descriptor2, buildNumber);
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(124);
        }
        return PluginManagerCore.isIncompatible(descriptor2, PluginManagerCore.getBuildNumber());
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor2, @Nullable BuildNumber buildNumber) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(125);
        }
        if (buildNumber == null) {
            buildNumber = PluginManagerCore.getBuildNumber();
        }
        return PluginManagerCore.isIncompatible(buildNumber, descriptor2.getSinceBuild(), descriptor2.getUntilBuild()) != null;
    }

    @Nullable
    static String isIncompatible(@NotNull BuildNumber buildNumber, @Nullable String sinceBuild, @Nullable String untilBuild) {
        if (buildNumber == null) {
            PluginManagerCore.$$$reportNull$$$0(126);
        }
        try {
            BuildNumber untilBuildNumber;
            BuildNumber sinceBuildNumber;
            String message = null;
            BuildNumber buildNumber2 = sinceBuildNumber = sinceBuild == null ? null : BuildNumber.fromString((String)sinceBuild, null, null);
            if (sinceBuildNumber != null && sinceBuildNumber.compareTo(buildNumber) > 0) {
                message = "since build " + sinceBuildNumber + " > " + buildNumber;
            }
            BuildNumber buildNumber3 = untilBuildNumber = untilBuild == null ? null : BuildNumber.fromString((String)untilBuild, null, null);
            if (untilBuildNumber != null && untilBuildNumber.compareTo(buildNumber) < 0) {
                message = message == null ? "" : message + ", ";
                message = message + "until build " + untilBuildNumber + " < " + buildNumber;
            }
            return message;
        }
        catch (Exception e) {
            PluginManagerCore.getLogger().error((Throwable)e);
            return "version check failed";
        }
    }

    private static void checkEssentialPluginsAreAvailable(@NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap) {
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(127);
        }
        List<PluginId> required = ((ApplicationInfoImpl)ApplicationInfoImpl.getShadowInstance()).getEssentialPluginsIds();
        ArrayList<String> missing = null;
        for (PluginId id2 : required) {
            IdeaPluginDescriptorImpl descriptor2 = idMap.get(id2);
            if (descriptor2 != null && descriptor2.isEnabled()) continue;
            if (missing == null) {
                missing = new ArrayList<String>();
            }
            missing.add(id2.getIdString());
        }
        if (missing != null) {
            throw new EssentialPluginMissingException(missing);
        }
    }

    @NotNull
    static PluginManagerState initializePlugins(@NotNull DescriptorListLoadingContext context, @NotNull ClassLoader coreLoader, boolean checkEssentialPlugins) {
        if (context == null) {
            PluginManagerCore.$$$reportNull$$$0(128);
        }
        if (coreLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(129);
        }
        PluginLoadingResult loadingResult = context.result;
        ArrayList<PluginError> errors = new ArrayList<PluginError>(loadingResult.getErrors());
        if (loadingResult.duplicateModuleMap != null) {
            loadingResult.duplicateModuleMap.forEach((id2, values2) -> errors.add(new PluginError(null, "Module " + id2 + " is declared by plugins:\n  " + StringUtil.join((Iterable)values2, (String)"\n  "), null)));
        }
        Map<PluginId, IdeaPluginDescriptorImpl> idMap = loadingResult.idMap;
        IdeaPluginDescriptorImpl coreDescriptor = idMap.get(CORE_ID);
        if (checkEssentialPlugins && coreDescriptor == null) {
            throw new EssentialPluginMissingException(Collections.singletonList(CORE_ID + " (platform prefix: " + System.getProperty("idea.platform.prefix") + ")"));
        }
        List<IdeaPluginDescriptorImpl> descriptors = loadingResult.getEnabledPlugins();
        PluginManagerCore.disableIncompatiblePlugins(descriptors, idMap, errors);
        PluginManagerCore.checkPluginCycles(descriptors, idMap, errors);
        IdeaPluginDescriptorImpl[] sortedRequired = PluginManagerCore.getTopologicallySorted(PluginManagerCore.createPluginIdGraph(descriptors, idMap, false));
        LinkedHashSet<PluginId> enabledIds = new LinkedHashSet<PluginId>();
        LinkedHashMap<PluginId, String> disabledIds = new LinkedHashMap<PluginId, String>();
        LinkedHashSet<PluginId> disabledRequiredIds = new LinkedHashSet<PluginId>();
        for (IdeaPluginDescriptorImpl descriptor2 : sortedRequired) {
            boolean wasEnabled = descriptor2.isEnabled();
            if (wasEnabled && PluginManagerCore.computePluginEnabled(descriptor2, enabledIds, idMap, disabledRequiredIds, context.disabledPlugins, errors)) {
                enabledIds.add(descriptor2.getPluginId());
                enabledIds.addAll(descriptor2.getModules());
                continue;
            }
            descriptor2.setEnabled(false);
            if (!wasEnabled) continue;
            disabledIds.put(descriptor2.getPluginId(), descriptor2.getName());
        }
        PluginManagerCore.prepareLoadingPluginsErrorMessage(disabledIds, disabledRequiredIds, idMap, errors);
        CachingSemiGraph<IdeaPluginDescriptorImpl> graph2 = PluginManagerCore.createPluginIdGraph(Arrays.asList(sortedRequired), idMap, true);
        IdeaPluginDescriptorImpl[] sortedAll = PluginManagerCore.getTopologicallySorted(graph2);
        List<IdeaPluginDescriptorImpl> enabledPlugins = PluginManagerCore.getOnlyEnabledPlugins(sortedAll);
        PluginManagerCore.mergeOptionalConfigs(enabledPlugins, idMap);
        PluginManagerCore.configureClassLoaders(coreLoader, graph2, coreDescriptor, enabledPlugins, context.usePluginClassLoader);
        if (checkEssentialPlugins) {
            PluginManagerCore.checkEssentialPluginsAreAvailable(idMap);
        }
        HashSet<PluginId> effectiveDisabledIds = disabledIds.isEmpty() ? Collections.emptySet() : new HashSet<PluginId>(disabledIds.keySet());
        return new PluginManagerState(sortedAll, enabledPlugins, disabledRequiredIds, effectiveDisabledIds, idMap);
    }

    private static void configureClassLoaders(@NotNull ClassLoader coreLoader, @NotNull CachingSemiGraph<IdeaPluginDescriptorImpl> graph2, @Nullable IdeaPluginDescriptor coreDescriptor, @NotNull List<IdeaPluginDescriptorImpl> enabledPlugins, boolean usePluginClassLoader) {
        if (coreLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(130);
        }
        if (graph2 == null) {
            PluginManagerCore.$$$reportNull$$$0(131);
        }
        if (enabledPlugins == null) {
            PluginManagerCore.$$$reportNull$$$0(132);
        }
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        ClassLoader[] emptyClassLoaderArray = new ClassLoader[]{};
        UrlClassLoader.Builder urlClassLoaderBuilder = PluginManagerCore.createUrlClassLoaderBuilder();
        for (IdeaPluginDescriptorImpl rootDescriptor : enabledPlugins) {
            ClassLoader[] classLoaderArray;
            if (rootDescriptor == coreDescriptor || rootDescriptor.isUseCoreClassLoader()) {
                rootDescriptor.setLoader(coreLoader);
                continue;
            }
            if (!usePluginClassLoader) {
                rootDescriptor.setLoader(null);
                continue;
            }
            loaders.clear();
            List<IdeaPluginDescriptorImpl> dependencies = graph2.getInList(rootDescriptor);
            if (!dependencies.isEmpty()) {
                loaders.ensureCapacity(dependencies.size());
                for (IdeaPluginDescriptorImpl descriptor2 : dependencies) {
                    ClassLoader loader = descriptor2.getPluginClassLoader();
                    if (loader == null) {
                        PluginManagerCore.getLogger().error(rootDescriptor.formatErrorMessage("requires missing class loader for " + PluginManagerCore.toPresentableName(descriptor2)));
                        continue;
                    }
                    loaders.add(loader);
                }
            }
            if (loaders.isEmpty()) {
                ClassLoader[] classLoaderArray2 = new ClassLoader[1];
                classLoaderArray = classLoaderArray2;
                classLoaderArray2[0] = coreLoader;
            } else {
                classLoaderArray = loaders.toArray(emptyClassLoaderArray);
            }
            ClassLoader[] parentLoaders = classLoaderArray;
            rootDescriptor.setLoader(PluginManagerCore.createPluginClassLoader(parentLoaders, rootDescriptor, urlClassLoaderBuilder));
        }
    }

    @NotNull
    private static @NotNull IdeaPluginDescriptorImpl @NotNull [] getTopologicallySorted(@NotNull CachingSemiGraph<IdeaPluginDescriptorImpl> graph2) {
        if (graph2 == null) {
            PluginManagerCore.$$$reportNull$$$0(133);
        }
        DFSTBuilder requiredOnlyGraph = new DFSTBuilder(GraphGenerator.generate(graph2));
        IdeaPluginDescriptorImpl[] sortedRequired = graph2.getNodes().toArray(IdeaPluginDescriptorImpl.EMPTY_ARRAY);
        Comparator comparator2 = requiredOnlyGraph.comparator();
        Arrays.sort(sortedRequired, (o1, o2) -> {
            if (o1.getPluginId() == CORE_ID) {
                return -1;
            }
            if (o2.getPluginId() == CORE_ID) {
                return 1;
            }
            return comparator2.compare(o1, o2);
        });
        if (sortedRequired == null) {
            PluginManagerCore.$$$reportNull$$$0(134);
        }
        return sortedRequired;
    }

    @NotNull
    @ApiStatus.Internal
    public static Map<PluginId, IdeaPluginDescriptorImpl> buildPluginIdMap(@NotNull List<IdeaPluginDescriptorImpl> descriptors) {
        if (descriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(135);
        }
        LinkedHashMap<PluginId, IdeaPluginDescriptorImpl> idMap = new LinkedHashMap<PluginId, IdeaPluginDescriptorImpl>(descriptors.size());
        Map<PluginId, List<IdeaPluginDescriptorImpl>> duplicateMap = null;
        for (IdeaPluginDescriptorImpl descriptor2 : descriptors) {
            Map<PluginId, List<IdeaPluginDescriptorImpl>> newDuplicateMap = PluginManagerCore.checkAndPut(descriptor2, descriptor2.getPluginId(), idMap, duplicateMap);
            if (newDuplicateMap != null) {
                duplicateMap = newDuplicateMap;
                continue;
            }
            for (PluginId module : descriptor2.getModules()) {
                newDuplicateMap = PluginManagerCore.checkAndPut(descriptor2, module, idMap, duplicateMap);
                if (newDuplicateMap == null) continue;
                duplicateMap = newDuplicateMap;
            }
        }
        LinkedHashMap<PluginId, IdeaPluginDescriptorImpl> linkedHashMap = idMap;
        if (linkedHashMap == null) {
            PluginManagerCore.$$$reportNull$$$0(136);
        }
        return linkedHashMap;
    }

    @Nullable
    private static Map<PluginId, List<IdeaPluginDescriptorImpl>> checkAndPut(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull PluginId id2, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap, @Nullable Map<PluginId, List<IdeaPluginDescriptorImpl>> duplicateMap) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(137);
        }
        if (id2 == null) {
            PluginManagerCore.$$$reportNull$$$0(138);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(139);
        }
        if (duplicateMap != null && duplicateMap.containsKey(id2)) {
            ContainerUtilRt.putValue((Object)id2, (Object)descriptor2, duplicateMap);
            return duplicateMap;
        }
        IdeaPluginDescriptorImpl existingDescriptor = idMap.put(id2, descriptor2);
        if (existingDescriptor == null) {
            return null;
        }
        idMap.remove(id2);
        if (duplicateMap == null) {
            duplicateMap = new LinkedHashMap<PluginId, List<IdeaPluginDescriptorImpl>>();
        }
        ArrayList<IdeaPluginDescriptorImpl> list2 = new ArrayList<IdeaPluginDescriptorImpl>();
        list2.add(existingDescriptor);
        list2.add(descriptor2);
        duplicateMap.put(id2, list2);
        return duplicateMap;
    }

    private static boolean computePluginEnabled(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull Set<PluginId> loadedIds, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap, @NotNull Set<PluginId> disabledRequiredIds, @NotNull Set<PluginId> disabledPlugins, @NotNull List<PluginError> errors) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(140);
        }
        if (loadedIds == null) {
            PluginManagerCore.$$$reportNull$$$0(141);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(142);
        }
        if (disabledRequiredIds == null) {
            PluginManagerCore.$$$reportNull$$$0(143);
        }
        if (disabledPlugins == null) {
            PluginManagerCore.$$$reportNull$$$0(144);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(145);
        }
        if (descriptor2.getPluginId() == CORE_ID || descriptor2.isImplementationDetail()) {
            return true;
        }
        if (descriptor2.getDependentPluginIds().length == descriptor2.getOptionalDependentPluginIds().length) {
            return true;
        }
        boolean result2 = true;
        for (PluginId depId : descriptor2.getDependentPluginIds()) {
            String depName;
            if (loadedIds.contains(depId) || PluginManagerCore.isOptional(descriptor2, depId)) continue;
            result2 = false;
            IdeaPluginDescriptor dep = idMap.get(depId);
            if (dep != null && disabledPlugins.contains(depId)) {
                disabledRequiredIds.add(dep.getPluginId());
            }
            String string = depName = dep == null ? null : dep.getName();
            if (depName == null) {
                if (PluginManagerCore.findErrorForPlugin(errors, depId) != null) {
                    errors.add(new PluginError(descriptor2, "depends on plugin " + PluginManagerCore.toPresentableName(depId.getIdString()) + " that failed to load", null));
                    continue;
                }
                errors.add(new PluginError(descriptor2, "requires " + PluginManagerCore.toPresentableName(depId.getIdString()) + " plugin to be installed", null));
                continue;
            }
            PluginError error = new PluginError(descriptor2, "requires " + PluginManagerCore.toPresentableName(depName) + " plugin to be enabled", null);
            error.setDisabledDependency(dep.getPluginId());
            errors.add(error);
        }
        return result2;
    }

    private static String toPresentableName(@Nullable IdeaPluginDescriptor descriptor2) {
        return PluginManagerCore.toPresentableName(descriptor2 == null ? null : descriptor2.getName());
    }

    @NotNull
    private static String toPresentableName(@Nullable String s) {
        String string = "\"" + (s == null ? "" : s) + "\"";
        if (string == null) {
            PluginManagerCore.$$$reportNull$$$0(146);
        }
        return string;
    }

    public static void registerExtensionPointAndExtensions(@NotNull Path pluginRoot, @NotNull String fileName, @NotNull ExtensionsArea area) {
        IdeaPluginDescriptorImpl descriptor2;
        if (pluginRoot == null) {
            PluginManagerCore.$$$reportNull$$$0(147);
        }
        if (fileName == null) {
            PluginManagerCore.$$$reportNull$$$0(148);
        }
        if (area == null) {
            PluginManagerCore.$$$reportNull$$$0(149);
        }
        DescriptorListLoadingContext parentContext = DescriptorListLoadingContext.createSingleDescriptorContext(PluginManagerCore.disabledPlugins());
        try (DescriptorLoadingContext context = new DescriptorLoadingContext(parentContext, true, true, PathBasedJdomXIncluder.DEFAULT_PATH_RESOLVER);){
            descriptor2 = Files.isDirectory(pluginRoot, new LinkOption[0]) ? PluginManagerCore.loadDescriptorFromDir(pluginRoot, META_INF + fileName, null, context) : PluginManagerCore.loadDescriptorFromJar(pluginRoot, fileName, PathBasedJdomXIncluder.DEFAULT_PATH_RESOLVER, context, null);
        }
        if (descriptor2 != null) {
            descriptor2.registerExtensionPoints((ExtensionsAreaImpl)area, (ComponentManager)ApplicationManager.getApplication());
            descriptor2.registerExtensions((ExtensionsAreaImpl)area, (ComponentManager)ApplicationManager.getApplication(), false);
        } else {
            PluginManagerCore.getLogger().error("Cannot load " + fileName + " from " + pluginRoot);
        }
    }

    private static synchronized void loadAndInitializePlugins(@Nullable DescriptorListLoadingContext context, @Nullable ClassLoader coreLoader) {
        if (coreLoader == null) {
            Class callerClass = ReflectionUtil.findCallerClass((int)1);
            assert (callerClass != null);
            coreLoader = callerClass.getClassLoader();
        }
        try {
            if (context == null) {
                context = PluginManagerCore.loadDescriptors();
            }
            Activity loadPluginsActivity = StartUpMeasurer.startActivity((String)"plugin initialization");
            PluginManagerState initResult = PluginManagerCore.initializePlugins(context, coreLoader, !isUnitTestMode);
            ourPlugins = initResult.sortedPlugins;
            PluginLoadingResult result2 = context.result;
            if (!result2.incompletePlugins.isEmpty()) {
                int oldSize = initResult.sortedPlugins.length;
                Object[] all = new IdeaPluginDescriptorImpl[oldSize + result2.incompletePlugins.size()];
                System.arraycopy(initResult.sortedPlugins, 0, all, 0, oldSize);
                ArrayUtil.copy(result2.incompletePlugins.values(), (Object[])all, (int)oldSize);
                ourPlugins = all;
            }
            ourPluginsToDisable = initResult.effectiveDisabledIds;
            ourPluginsToEnable = initResult.disabledRequiredIds;
            ourLoadedPlugins = initResult.sortedEnabledPlugins;
            ourShadowedBundledPlugins = result2.getShadowedBundledIds();
            loadPluginsActivity.end();
            loadPluginsActivity.setDescription("plugin count: " + ourLoadedPlugins.size());
            PluginManagerCore.logPlugins(initResult.sortedPlugins);
        }
        catch (ExtensionInstantiationException e) {
            throw new PluginException((Throwable)e, e.getExtensionOwnerId());
        }
        catch (RuntimeException e) {
            PluginManagerCore.getLogger().error((Throwable)e);
            throw e;
        }
    }

    @NotNull
    public static Logger getLogger() {
        Logger logger = Logger.getInstance((String)"#com.intellij.ide.plugins.PluginManager");
        if (logger == null) {
            PluginManagerCore.$$$reportNull$$$0(150);
        }
        return logger;
    }

    @Nullable
    public static IdeaPluginDescriptor getPlugin(@Nullable PluginId id2) {
        if (id2 != null) {
            for (IdeaPluginDescriptor plugin : PluginManagerCore.getPlugins()) {
                if (id2 != plugin.getPluginId()) continue;
                return plugin;
            }
        }
        return null;
    }

    @Nullable
    public static IdeaPluginDescriptor findPluginByModuleDependency(@NotNull PluginId id2) {
        if (id2 == null) {
            PluginManagerCore.$$$reportNull$$$0(151);
        }
        for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
            if (!(descriptor2 instanceof IdeaPluginDescriptorImpl) || !((IdeaPluginDescriptorImpl)descriptor2).getModules().contains(id2)) continue;
            return descriptor2;
        }
        return null;
    }

    public static boolean isPluginInstalled(PluginId id2) {
        return PluginManagerCore.getPlugin(id2) != null;
    }

    @NotNull
    @ApiStatus.Internal
    public static Map<PluginId, IdeaPluginDescriptorImpl> buildPluginIdMap() {
        LoadingState.COMPONENTS_REGISTERED.checkOccurred();
        return PluginManagerCore.buildPluginIdMap(Arrays.asList(ourPlugins));
    }

    @ApiStatus.Internal
    public static boolean processAllDependencies(@NotNull IdeaPluginDescriptor rootDescriptor, boolean withOptionalDeps, @NotNull Function<IdeaPluginDescriptor, FileVisitResult> consumer) {
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(152);
        }
        if (consumer == null) {
            PluginManagerCore.$$$reportNull$$$0(153);
        }
        return PluginManagerCore.processAllDependencies(rootDescriptor, withOptionalDeps, PluginManagerCore.buildPluginIdMap(), consumer);
    }

    @ApiStatus.Internal
    public static boolean processAllDependencies(@NotNull IdeaPluginDescriptor rootDescriptor, boolean withOptionalDeps, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToMap, @NotNull Function<IdeaPluginDescriptor, FileVisitResult> consumer) {
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(154);
        }
        if (idToMap == null) {
            PluginManagerCore.$$$reportNull$$$0(155);
        }
        if (consumer == null) {
            PluginManagerCore.$$$reportNull$$$0(156);
        }
        return PluginManagerCore.processAllDependencies(rootDescriptor, withOptionalDeps, idToMap, new HashSet<IdeaPluginDescriptor>(), consumer);
    }

    @ApiStatus.Internal
    private static boolean processAllDependencies(@NotNull IdeaPluginDescriptor rootDescriptor, boolean withOptionalDeps, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToMap, @NotNull Set<IdeaPluginDescriptor> depProcessed, @NotNull Function<IdeaPluginDescriptor, FileVisitResult> consumer) {
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(157);
        }
        if (idToMap == null) {
            PluginManagerCore.$$$reportNull$$$0(158);
        }
        if (depProcessed == null) {
            PluginManagerCore.$$$reportNull$$$0(159);
        }
        if (consumer == null) {
            PluginManagerCore.$$$reportNull$$$0(160);
        }
        block6: for (PluginId id2 : rootDescriptor.getDependentPluginIds()) {
            IdeaPluginDescriptorImpl descriptor2 = idToMap.get(id2);
            if (descriptor2 == null) continue;
            if (!withOptionalDeps) {
                for (PluginId otherId : rootDescriptor.getOptionalDependentPluginIds()) {
                    if (otherId == id2) continue block6;
                }
            }
            switch (consumer.apply(descriptor2)) {
                case TERMINATE: {
                    return false;
                }
                case CONTINUE: {
                    if (!depProcessed.add(descriptor2)) continue block6;
                    PluginManagerCore.processAllDependencies(descriptor2, withOptionalDeps, idToMap, depProcessed, consumer);
                    continue block6;
                }
                case SKIP_SUBTREE: {
                    continue block6;
                }
                case SKIP_SIBLINGS: {
                    throw new UnsupportedOperationException("FileVisitResult.SKIP_SIBLINGS is not supported");
                }
            }
        }
        return true;
    }

    @NotNull
    private static List<IdeaPluginDescriptorImpl> getOnlyEnabledPlugins(IdeaPluginDescriptorImpl[] sortedAll) {
        ArrayList<IdeaPluginDescriptorImpl> enabledPlugins = new ArrayList<IdeaPluginDescriptorImpl>(sortedAll.length);
        for (IdeaPluginDescriptorImpl descriptor2 : sortedAll) {
            if (!descriptor2.isEnabled()) continue;
            enabledPlugins.add(descriptor2);
        }
        ArrayList<IdeaPluginDescriptorImpl> arrayList = enabledPlugins;
        if (arrayList == null) {
            PluginManagerCore.$$$reportNull$$$0(161);
        }
        return arrayList;
    }

    @Deprecated
    public static void addDisablePluginListener(@NotNull Runnable listener2) {
        if (listener2 == null) {
            PluginManagerCore.$$$reportNull$$$0(162);
        }
        PluginManager.getInstance().addDisablePluginListener(listener2);
    }

    @Deprecated
    public static void removeDisablePluginListener(@NotNull Runnable listener2) {
        if (listener2 == null) {
            PluginManagerCore.$$$reportNull$$$0(163);
        }
        PluginManager.getInstance().removeDisablePluginListener(listener2);
    }

    public static synchronized boolean isUpdatedBundledPlugin(@NotNull PluginDescriptor plugin) {
        if (plugin == null) {
            PluginManagerCore.$$$reportNull$$$0(164);
        }
        return ourShadowedBundledPlugins != null && ourShadowedBundledPlugins.contains(plugin.getPluginId());
    }

    static {
        isUnitTestMode = Boolean.getBoolean("idea.is.unit.test");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 44: 
            case 85: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 117: 
            case 118: 
            case 134: 
            case 136: 
            case 146: 
            case 150: 
            case 161: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 44: 
            case 85: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 117: 
            case 118: 
            case 134: 
            case 136: 
            case 146: 
            case 150: 
            case 161: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 44: 
            case 85: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 117: 
            case 118: 
            case 134: 
            case 136: 
            case 146: 
            case 150: 
            case 161: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 6: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configPath";
                break;
            }
            case 7: 
            case 27: 
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledPlugins";
                break;
            }
            case 13: 
            case 14: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 15: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 114: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 137: 
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 19: 
            case 21: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 20: 
            case 45: 
            case 58: 
            case 61: 
            case 65: 
            case 67: 
            case 69: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 115: 
            case 138: 
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentPluginId";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginClass";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 38: 
            case 84: 
            case 88: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlLoaderBuilder";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentLoaders";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 48: 
            case 57: 
            case 83: 
            case 121: 
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 53: 
            case 55: 
            case 119: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToDescriptorMap";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorRelativePath";
                break;
            }
            case 60: 
            case 64: 
            case 71: 
            case 74: 
            case 79: 
            case 87: 
            case 101: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 62: 
            case 66: 
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathResolver";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentContext";
                break;
            }
            case 70: 
            case 73: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathName";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDir";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesInLibUnderPluginDir";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledIds";
                break;
            }
            case 81: 
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledRequiredIds";
                break;
            }
            case 82: 
            case 110: 
            case 113: 
            case 120: 
            case 127: 
            case 139: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idMap";
                break;
            }
            case 86: 
            case 89: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadingContext";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreClassLoader";
                break;
            }
            case 109: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enabledPlugins";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergedDescriptor";
                break;
            }
            case 112: 
            case 116: 
            case 152: 
            case 154: 
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDescriptor";
                break;
            }
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildNumber";
                break;
            }
            case 129: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreLoader";
                break;
            }
            case 131: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadedIds";
                break;
            }
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginRoot";
                break;
            }
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 153: 
            case 156: 
            case 160: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 155: 
            case 158: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToMap";
                break;
            }
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depProcessed";
                break;
            }
            case 162: 
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 164: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlugins";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedPlugins";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledIds";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "disabledPlugins";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrokenPluginVersions";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createPluginClassLoader";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "testLoadDescriptorsFromClassPath";
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "urlToFile";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "loadUncachedDescriptors";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrScheduleLoading";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledPluginRawList";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "initPlugins";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDescriptors";
                break;
            }
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "createUrlClassLoaderBuilder";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildNumber";
                break;
            }
            case 134: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopologicallySorted";
                break;
            }
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPluginIdMap";
                break;
            }
            case 146: {
                objectArray = objectArray2;
                objectArray2[1] = "toPresentableName";
                break;
            }
            case 150: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 161: {
                objectArray = objectArray2;
                objectArray2[1] = "getOnlyEnabledPlugins";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setDisabledPluginListener";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 44: 
            case 85: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 117: 
            case 118: 
            case 134: 
            case 136: 
            case 146: 
            case 150: 
            case 161: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doSetPlugins";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadDisabledPlugins";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isDisabled";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isBrokenPlugin";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "savePluginsList";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "writePluginsList";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "disablePlugin";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "enablePlugin";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "trySaveDisabledPlugins";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "saveDisabledPlugins";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDependency";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createPluginException";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getPluginByClassName";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getPluginOrPlatformByClassName";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getPluginDescriptorOrPlatformByClassName";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "hasLoadedClass";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitDependency";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "hasModuleDependencies";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createPluginClassLoader";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "localFileToUrl";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "logPlugins";
                break;
            }
            case 48: 
            case 49: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "prepareLoadingPluginsErrorMessage";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getLoadingError";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getFirstDisabledDependency";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "findErrorForPlugin";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "createPluginIdGraph";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "checkPluginCycles";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromDir";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromJar";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptor";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromFileOrDir";
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromDirAndNormalize";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "putMoreLikelyPluginJarsFirst";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "fileNameIsLikeVersionedLibraryName";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorsFromDir";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "testLoadDescriptorsFromClassPath";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorsFromClassPath";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "computePlatformPluginUrlAndCollectPluginUrls";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "collectPluginFilesInClassPath";
                break;
            }
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromResource";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "urlToFile";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorsFromProperty";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "initPlugins";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "mergeOptionalConfigs";
                break;
            }
            case 111: 
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "mergeOptionalDescriptors";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "isOptional";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "initClassLoader";
                break;
            }
            case 119: 
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "disableIncompatiblePlugins";
                break;
            }
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 124: 
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "isIncompatible";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "checkEssentialPluginsAreAvailable";
                break;
            }
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "initializePlugins";
                break;
            }
            case 130: 
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "configureClassLoaders";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "getTopologicallySorted";
                break;
            }
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "buildPluginIdMap";
                break;
            }
            case 137: 
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "checkAndPut";
                break;
            }
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "computePluginEnabled";
                break;
            }
            case 147: 
            case 148: 
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPointAndExtensions";
                break;
            }
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "findPluginByModuleDependency";
                break;
            }
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "processAllDependencies";
                break;
            }
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "addDisablePluginListener";
                break;
            }
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "removeDisablePluginListener";
                break;
            }
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "isUpdatedBundledPlugin";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 44: 
            case 85: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 117: 
            case 118: 
            case 134: 
            case 136: 
            case 146: 
            case 150: 
            case 161: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class EssentialPluginMissingException
    extends RuntimeException {
        public final List<String> pluginIds;

        EssentialPluginMissingException(@NotNull List<String> ids) {
            if (ids == null) {
                EssentialPluginMissingException.$$$reportNull$$$0(0);
            }
            super("Missing essential plugins: " + StringUtil.join(ids, (String)", "));
            this.pluginIds = ids;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "com/intellij/ide/plugins/PluginManagerCore$EssentialPluginMissingException", "<init>"));
        }
    }
}

