/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PendingDynamicPluginInstall;
import com.intellij.ide.plugins.PluginInstallCallbackData;
import com.intellij.ide.plugins.PluginInstallOperation;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginStateListener;
import com.intellij.ide.plugins.PluginStateManager;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.io.Decompressor;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginInstaller {
    private static final Logger LOG = Logger.getInstance(PluginInstaller.class);
    public static final String UNKNOWN_HOST_MARKER = "__unknown_repository__";
    static final Object ourLock = new Object();
    private static final String PLUGINS_PRESELECTION_PATH = "plugins.preselection.path";

    private PluginInstaller() {
    }

    public static boolean prepareToInstall(List<PluginNode> pluginsToInstall, List<? extends IdeaPluginDescriptor> allPlugins, boolean allowInstallWithoutRestart, PluginManagerMain.PluginEnabler pluginEnabler, Runnable onSuccess2, @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            PluginInstaller.$$$reportNull$$$0(0);
        }
        PluginInstallOperation operation = new PluginInstallOperation(pluginsToInstall, allPlugins, pluginEnabler, indicator);
        operation.setAllowInstallWithoutRestart(allowInstallWithoutRestart);
        operation.run();
        boolean success = operation.isSuccess();
        if (success) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (allowInstallWithoutRestart) {
                    for (PendingDynamicPluginInstall install : operation.getPendingDynamicPluginInstalls()) {
                        PluginInstaller.installAndLoadDynamicPlugin(install.getFile(), null, install.getPluginDescriptor());
                    }
                }
                if (onSuccess2 != null) {
                    onSuccess2.run();
                }
            });
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean prepareToUninstall(@NotNull IdeaPluginDescriptor pluginDescriptor) throws IOException {
        if (pluginDescriptor == null) {
            PluginInstaller.$$$reportNull$$$0(1);
        }
        Object object = ourLock;
        synchronized (object) {
            if (PluginManagerCore.isPluginInstalled(pluginDescriptor.getPluginId())) {
                if (pluginDescriptor.isBundled()) {
                    LOG.error("Plugin is bundled: " + pluginDescriptor.getPluginId());
                } else {
                    boolean needRestart;
                    boolean bl = needRestart = !DynamicPlugins.allowLoadUnloadWithoutRestart((IdeaPluginDescriptorImpl)pluginDescriptor);
                    if (needRestart) {
                        PluginInstaller.uninstallAfterRestart(pluginDescriptor);
                    }
                    PluginStateManager.fireState(pluginDescriptor, false);
                    return needRestart;
                }
            }
        }
        return false;
    }

    private static void uninstallAfterRestart(IdeaPluginDescriptor pluginDescriptor) throws IOException {
        StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)new StartupActionScriptManager.DeleteCommand(pluginDescriptor.getPath()));
    }

    public static boolean uninstallDynamicPlugin(@Nullable JComponent parentComponent, IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
        boolean uninstalledWithoutRestart;
        boolean bl = uninstalledWithoutRestart = parentComponent != null ? DynamicPlugins.unloadPluginWithProgress(parentComponent, (IdeaPluginDescriptorImpl)pluginDescriptor, false, isUpdate) : DynamicPlugins.unloadPlugin((IdeaPluginDescriptorImpl)pluginDescriptor, false, isUpdate);
        if (uninstalledWithoutRestart) {
            FileUtil.delete((File)pluginDescriptor.getPath());
        } else {
            try {
                PluginInstaller.uninstallAfterRestart(pluginDescriptor);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return uninstalledWithoutRestart;
    }

    public static void installAfterRestart(@NotNull File sourceFile, boolean deleteSourceFile, @Nullable File existingPlugin, @NotNull IdeaPluginDescriptor descriptor2) throws IOException {
        if (sourceFile == null) {
            PluginInstaller.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            PluginInstaller.$$$reportNull$$$0(3);
        }
        ArrayList<Object> commands = new ArrayList<Object>();
        if (existingPlugin != null) {
            commands.add(new StartupActionScriptManager.DeleteCommand(existingPlugin));
        }
        String pluginsPath = PathManager.getPluginsPath();
        if (sourceFile.getName().endsWith(".jar")) {
            commands.add(new StartupActionScriptManager.CopyCommand(sourceFile, new File(pluginsPath, sourceFile.getName())));
        } else {
            commands.add(new StartupActionScriptManager.DeleteCommand(new File(pluginsPath, PluginInstaller.rootEntryName(sourceFile))));
            commands.add(new StartupActionScriptManager.UnzipCommand(sourceFile, new File(pluginsPath)));
        }
        if (deleteSourceFile) {
            commands.add(new StartupActionScriptManager.DeleteCommand(sourceFile));
        }
        StartupActionScriptManager.addActionCommands(commands);
        PluginStateManager.fireState(descriptor2, true);
    }

    @Nullable
    public static File installWithoutRestart(File sourceFile, IdeaPluginDescriptorImpl descriptor2, Component parent) {
        Ref ref = new Ref();
        Ref refTarget = new Ref();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            String pluginsPath = PathManager.getPluginsPath();
            try {
                File target2;
                if (sourceFile.getName().endsWith(".jar")) {
                    target2 = new File(pluginsPath, sourceFile.getName());
                    FileUtilRt.copy((File)sourceFile, (File)target2);
                } else {
                    target2 = new File(pluginsPath, PluginInstaller.rootEntryName(sourceFile));
                    FileUtil.delete((File)target2);
                    new Decompressor.Zip(sourceFile).extract(new File(pluginsPath));
                }
                refTarget.set((Object)target2);
            }
            catch (IOException e) {
                ref.set((Object)e);
            }
        }, IdeBundle.message((String)"progress.title.installing.plugin", (Object[])new Object[0]), false, null, parent instanceof JComponent ? (JComponent)parent : null);
        IOException exception = (IOException)ref.get();
        if (exception != null) {
            Messages.showErrorDialog((Component)parent, (String)IdeBundle.message((String)"message.plugin.installation.failed.0", (Object[])new Object[]{exception.getMessage()}));
        }
        PluginStateManager.fireState(descriptor2, true);
        return exception != null ? null : (File)refTarget.get();
    }

    private static String rootEntryName(File zip) throws IOException {
        try (ZipFile zipFile = new ZipFile(zip);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                String name = zipEntry.getName();
                int i = name.indexOf(47);
                if (i <= 0) continue;
                String string = name.substring(0, i);
                return string;
            }
        }
        throw new IOException("Corrupted archive (no file entries): " + zip);
    }

    public static void addStateListener(@NotNull PluginStateListener listener2) {
        if (listener2 == null) {
            PluginInstaller.$$$reportNull$$$0(4);
        }
        PluginStateManager.addStateListener(listener2);
    }

    public static boolean install(@NotNull InstalledPluginsTableModel model, @NotNull File file2, @NotNull Consumer<? super PluginInstallCallbackData> callback2, @Nullable Component parent) {
        if (model == null) {
            PluginInstaller.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            PluginInstaller.$$$reportNull$$$0(6);
        }
        if (callback2 == null) {
            PluginInstaller.$$$reportNull$$$0(7);
        }
        try {
            boolean installWithoutRestart;
            IdeaPluginDescriptorImpl pluginDescriptor = PluginManager.loadDescriptorFromArtifact(file2.toPath(), null);
            if (pluginDescriptor == null) {
                MessagesEx.showErrorDialog(parent, "Fail to load plugin descriptor from file " + file2.getName(), CommonBundle.getErrorTitle());
                return false;
            }
            InstalledPluginsState ourState = InstalledPluginsState.getInstance();
            if (ourState.wasInstalled(pluginDescriptor.getPluginId())) {
                String message = "Plugin '" + pluginDescriptor.getName() + "' was already installed";
                MessagesEx.showWarningDialog(parent, message, "Install Plugin");
                return false;
            }
            if (PluginManagerCore.isIncompatible(pluginDescriptor)) {
                String message = "Plugin '" + pluginDescriptor.getName() + "' is incompatible with this installation";
                MessagesEx.showErrorDialog(parent, message, CommonBundle.getErrorTitle());
                return false;
            }
            IdeaPluginDescriptor installedPlugin = PluginManagerCore.getPlugin(pluginDescriptor.getPluginId());
            if (installedPlugin != null && ApplicationInfoEx.getInstanceEx().isEssentialPlugin(installedPlugin.getPluginId())) {
                String message = "Plugin '" + pluginDescriptor.getName() + "' is a core part of " + ApplicationNamesInfo.getInstance().getFullProductName() + ". In order to update it to a newer version you should update the IDE.";
                MessagesEx.showErrorDialog(parent, message, CommonBundle.getErrorTitle());
                return false;
            }
            File oldFile = null;
            if (installedPlugin != null && !installedPlugin.isBundled()) {
                oldFile = installedPlugin.getPath();
            }
            boolean bl = installWithoutRestart = oldFile == null && DynamicPlugins.allowLoadUnloadWithoutRestart(pluginDescriptor);
            if (!installWithoutRestart) {
                PluginInstaller.installAfterRestart(file2, false, oldFile, pluginDescriptor);
            }
            ourState.onPluginInstall(pluginDescriptor, installedPlugin != null, !installWithoutRestart);
            PluginInstaller.checkInstalledPluginDependencies(model, pluginDescriptor, parent);
            callback2.consume((Object)new PluginInstallCallbackData(file2, pluginDescriptor, !installWithoutRestart));
            return true;
        }
        catch (IOException ex) {
            MessagesEx.showErrorDialog(parent, ex.getMessage(), CommonBundle.getErrorTitle());
            return false;
        }
    }

    @Nullable
    public static IdeaPluginDescriptorImpl installAndLoadDynamicPlugin(@NotNull File file2, @Nullable Component parent, IdeaPluginDescriptorImpl pluginDescriptor) {
        IdeaPluginDescriptorImpl targetDescriptor;
        File targetFile;
        if (file2 == null) {
            PluginInstaller.$$$reportNull$$$0(8);
        }
        if ((targetFile = PluginInstaller.installWithoutRestart(file2, pluginDescriptor, parent)) != null && (targetDescriptor = PluginManager.loadDescriptor(targetFile.toPath(), "plugin.xml")) != null) {
            DynamicPlugins.loadPlugin(targetDescriptor, false);
            return targetDescriptor;
        }
        return null;
    }

    private static void checkInstalledPluginDependencies(@NotNull InstalledPluginsTableModel model, @NotNull IdeaPluginDescriptorImpl pluginDescriptor, @Nullable Component parent) {
        if (model == null) {
            PluginInstaller.$$$reportNull$$$0(9);
        }
        if (pluginDescriptor == null) {
            PluginInstaller.$$$reportNull$$$0(10);
        }
        HashSet<PluginId> notInstalled = new HashSet<PluginId>();
        HashSet<PluginId> disabledIds = new HashSet<PluginId>();
        PluginId[] dependentPluginIds = pluginDescriptor.getDependentPluginIds();
        Object[] optionalDependentPluginIds = pluginDescriptor.getOptionalDependentPluginIds();
        for (PluginId id2 : dependentPluginIds) {
            if (ArrayUtilRt.find((Object[])optionalDependentPluginIds, (Object)id2) > -1) continue;
            boolean disabled = model.isDisabled(id2);
            boolean enabled = model.isEnabled(id2);
            if (!(enabled || disabled || PluginManagerCore.isModuleDependency(id2))) {
                notInstalled.add(id2);
                continue;
            }
            if (!disabled) continue;
            disabledIds.add(id2);
        }
        if (!notInstalled.isEmpty()) {
            String deps = StringUtil.join(notInstalled, PluginId::toString, (String)", ");
            String message = "Plugin " + pluginDescriptor.getName() + " depends on unknown plugin" + (notInstalled.size() > 1 ? "s " : " ") + deps;
            MessagesEx.showWarningDialog(parent, message, "Install Plugin");
        }
        if (!disabledIds.isEmpty()) {
            HashSet<IdeaPluginDescriptor> dependencies = new HashSet<IdeaPluginDescriptor>();
            for (IdeaPluginDescriptor ideaPluginDescriptor : model.getAllPlugins()) {
                if (!disabledIds.contains(ideaPluginDescriptor.getPluginId())) continue;
                dependencies.add(ideaPluginDescriptor);
            }
            String part = "disabled plugin" + (dependencies.size() > 1 ? "s " : " ");
            String deps = StringUtil.join(dependencies, PluginDescriptor::getName, (String)", ");
            String message = "Plugin " + pluginDescriptor.getName() + " depends on " + part + deps + ". Enable " + part.trim() + "?";
            if (Messages.showOkCancelDialog((String)message, (String)IdeBundle.message((String)"dialog.title.install.plugin", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.install", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon()) == 0) {
                model.enableRows(dependencies.toArray(new IdeaPluginDescriptor[0]), Boolean.TRUE);
            }
        }
    }

    static void chooseAndInstall(@NotNull InstalledPluginsTableModel model, @Nullable Component parent, @NotNull Consumer<? super PluginInstallCallbackData> callback2) {
        if (model == null) {
            PluginInstaller.$$$reportNull$$$0(11);
        }
        if (callback2 == null) {
            PluginInstaller.$$$reportNull$$$0(12);
        }
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(false, false, true, true, false, false){

            public boolean isFileSelectable(VirtualFile file2) {
                String extension = file2.getExtension();
                return Comparing.strEqual((String)extension, (String)"jar") || Comparing.strEqual((String)extension, (String)"zip");
            }
        };
        descriptor2.setTitle(IdeBundle.message((String)"chooser.title.plugin.file", (Object[])new Object[0]));
        descriptor2.setDescription(IdeBundle.message((String)"chooser.description.jar.and.zip.archives.are.accepted", (Object[])new Object[0]));
        String oldPath = PropertiesComponent.getInstance().getValue(PLUGINS_PRESELECTION_PATH);
        VirtualFile toSelect2 = oldPath == null ? null : VfsUtil.findFileByIoFile((File)new File(FileUtil.toSystemDependentName((String)oldPath)), (boolean)false);
        FileChooser.chooseFile((FileChooserDescriptor)descriptor2, null, (Component)parent, (VirtualFile)toSelect2, virtualFile -> {
            File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
            PropertiesComponent.getInstance().setValue(PLUGINS_PRESELECTION_PATH, FileUtil.toSystemIndependentName((String)file2.getParent()));
            PluginInstaller.install(model, file2, callback2, parent);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/plugins/PluginInstaller";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareToInstall";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareToUninstall";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "installAfterRestart";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addStateListener";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "installAndLoadDynamicPlugin";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "checkInstalledPluginDependencies";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "chooseAndInstall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

