/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PathBasedJdomXIncluder;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import gnu.trove.THashMap;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class DescriptorLoadingContext
implements AutoCloseable {
    final Map<Path, FileSystem> openedFiles;
    final DescriptorListLoadingContext parentContext;
    final boolean isBundled;
    final boolean isEssential;
    final PathBasedJdomXIncluder.PathResolver<?> pathResolver;

    DescriptorLoadingContext(@NotNull DescriptorListLoadingContext parentContext, boolean isBundled, boolean isEssential, @NotNull PathBasedJdomXIncluder.PathResolver<?> pathResolver) {
        if (parentContext == null) {
            DescriptorLoadingContext.$$$reportNull$$$0(0);
        }
        if (pathResolver == null) {
            DescriptorLoadingContext.$$$reportNull$$$0(1);
        }
        this.openedFiles = new THashMap();
        this.parentContext = parentContext;
        this.isBundled = isBundled;
        this.isEssential = isEssential;
        this.pathResolver = pathResolver;
    }

    boolean isPluginDisabled(@NotNull PluginId id2) {
        if (id2 == null) {
            DescriptorLoadingContext.$$$reportNull$$$0(2);
        }
        return id2 != PluginManagerCore.CORE_ID && this.parentContext.disabledPlugins.contains(id2);
    }

    boolean isBroken(@NotNull IdeaPluginDescriptorImpl descriptor2) {
        if (descriptor2 == null) {
            DescriptorLoadingContext.$$$reportNull$$$0(3);
        }
        if (descriptor2.getVersion() == null || descriptor2.isBundled() || descriptor2.isImplementationDetail()) {
            return false;
        }
        Set<String> set = this.parentContext.result.brokenPluginVersions.get(descriptor2.getPluginId());
        return set != null && set.contains(descriptor2.getVersion());
    }

    @NotNull
    FileSystem open(@NotNull Path file2) throws IOException {
        FileSystem result2;
        if (file2 == null) {
            DescriptorLoadingContext.$$$reportNull$$$0(4);
        }
        if ((result2 = this.openedFiles.get(file2)) == null) {
            result2 = FileSystems.newFileSystem(file2, null);
            this.openedFiles.put(file2, result2);
        }
        FileSystem fileSystem = result2;
        if (fileSystem == null) {
            DescriptorLoadingContext.$$$reportNull$$$0(5);
        }
        return fileSystem;
    }

    @Override
    public void close() {
        for (FileSystem file2 : this.openedFiles.values()) {
            try {
                file2.close();
            }
            catch (IOException iOException) {}
        }
    }

    @NotNull
    public DescriptorLoadingContext copy(boolean isEssential) {
        return new DescriptorLoadingContext(this.parentContext, this.isBundled, isEssential, this.pathResolver);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathResolver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/DescriptorLoadingContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/DescriptorLoadingContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "open";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPluginDisabled";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isBroken";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "open";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

