/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.instrument;

import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.AdviceAdapter;

class LockWrappingClassVisitor
extends ClassVisitor {
    private static final Set<String> METHODS_TO_WRAP = ContainerUtil.set((Object[])new String[]{"paint", "paintComponent", "paintChildren", "doLayout", "layout", "getPreferredSize", "paintTrack", "getListCellRendererComponent", "getElementText"});
    private final Set<String> myMethodsToAnnotate;

    LockWrappingClassVisitor(ClassWriter cw, Set<String> methodsToAnnotate) {
        super(458752, (ClassVisitor)cw);
        this.myMethodsToAnnotate = methodsToAnnotate;
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor2, String signature, String[] exceptions) {
        MethodVisitor mv = this.cv.visitMethod(access, name, descriptor2, signature, exceptions);
        if (METHODS_TO_WRAP.contains(name) || this.myMethodsToAnnotate.contains(name)) {
            return new MyAdviceAdapter(this.api, mv, access, name, descriptor2);
        }
        return mv;
    }

    private static class MyAdviceAdapter
    extends AdviceAdapter {
        private static final String applicationUtil = "com/intellij/openapi/application/ex/ApplicationUtil";
        private static final String acquireLock = "acquireWriteIntentLockIfNeeded";
        private static final String releaseLock = "releaseWriteIntentLockIfNeeded";
        private static final String acquireLockSignature = "()Z";
        private static final String releaseLockSignature = "(Z)V";
        private int newVarIndex;

        protected MyAdviceAdapter(int api, MethodVisitor methodVisitor, int access, String name, String descriptor2) {
            super(api, methodVisitor, access, name, descriptor2);
        }

        protected void onMethodEnter() {
            this.newVarIndex = this.newLocal(Type.BOOLEAN_TYPE);
            this.mv.visitMethodInsn(184, applicationUtil, acquireLock, acquireLockSignature, false);
            this.mv.visitVarInsn(54, this.newVarIndex);
        }

        protected void onMethodExit(int opcode) {
            this.mv.visitVarInsn(21, this.newVarIndex);
            this.mv.visitMethodInsn(184, applicationUtil, releaseLock, releaseLockSignature, false);
        }
    }
}

