/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.ide.gdpr.ConfirmedConsent;
import com.intellij.ide.gdpr.Consent;
import com.intellij.ide.gdpr.ConsentAttributes;
import com.intellij.ide.gdpr.ConsentBase;
import com.intellij.ide.gdpr.Locations;
import com.intellij.ide.gdpr.Version;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConsentOptions {
    private static final Logger LOG = Logger.getInstance(ConsentOptions.class);
    private static final String CONSENTS_CONFIRMATION_PROPERTY = "jb.consents.confirmation.enabled";
    private static final String STATISTICS_OPTION_ID = "rsch.send.usage.stat";
    private final boolean myIsEAP;
    private final IOBackend myBackend;

    @NotNull
    private static String getBundledResourcePath() {
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        String string = appInfo.isVendorJetBrains() ? "/consents.json" : "/consents-" + appInfo.getShortCompanyName() + ".json";
        if (string == null) {
            ConsentOptions.$$$reportNull$$$0(0);
        }
        return string;
    }

    ConsentOptions(IOBackend backend, boolean isEap) {
        this.myBackend = backend;
        this.myIsEAP = isEap;
    }

    public static ConsentOptions getInstance() {
        return InstanceHolder.ourInstance;
    }

    public boolean isEAP() {
        return this.myIsEAP;
    }

    @Nullable
    public Consent getUsageStatsConsent() {
        return this.loadDefaultConsents().get(STATISTICS_OPTION_ID);
    }

    public Permission isSendingUsageStatsAllowed() {
        ConfirmedConsent confirmedConsent = this.getConfirmedConsent(STATISTICS_OPTION_ID);
        return confirmedConsent == null ? Permission.UNDEFINED : (confirmedConsent.isAccepted() ? Permission.YES : Permission.NO);
    }

    public boolean setSendingUsageStatsAllowed(boolean allowed) {
        Consent defConsent = this.loadDefaultConsents().get(STATISTICS_OPTION_ID);
        if (defConsent != null && !defConsent.isDeleted()) {
            this.saveConfirmedConsents(Collections.singleton(new ConfirmedConsent(defConsent.getId(), defConsent.getVersion(), allowed, 0L)));
            return true;
        }
        return false;
    }

    @Nullable
    public String getConfirmedConsentsString() {
        Map<String, Consent> defaults = this.loadDefaultConsents();
        if (!defaults.isEmpty()) {
            String str = ConsentOptions.confirmedConsentToExternalString(this.loadConfirmedConsents().values().stream().filter(c -> {
                Consent def = (Consent)defaults.get(c.getId());
                return def != null && !def.isDeleted();
            }));
            return StringUtilRt.isEmptyOrSpaces((CharSequence)str) ? null : str;
        }
        return null;
    }

    public void applyServerUpdates(@Nullable String json) {
        if (StringUtilRt.isEmptyOrSpaces((CharSequence)json)) {
            return;
        }
        try {
            Map<String, ConfirmedConsent> confirmed;
            Collection<ConsentAttributes> fromServer = ConsentOptions.fromJson(json);
            Map<String, Consent> defaults = this.loadDefaultConsents();
            if (ConsentOptions.applyServerChangesToDefaults(defaults, fromServer)) {
                this.myBackend.writeDefaultConsents(ConsentOptions.consentsToJson(defaults.values().stream()));
            }
            if (ConsentOptions.applyServerChangesToConfirmedConsents(confirmed = this.loadConfirmedConsents(), fromServer)) {
                this.myBackend.writeConfirmedConsents(ConsentOptions.confirmedConsentToExternalString(confirmed.values().stream()));
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
    }

    @NotNull
    public Pair<List<Consent>, Boolean> getConsents() {
        Map<String, Consent> allDefaults = this.loadDefaultConsents();
        if (this.myIsEAP) {
            allDefaults.remove(STATISTICS_OPTION_ID);
        }
        if (allDefaults.isEmpty()) {
            return new Pair(Collections.emptyList(), (Object)Boolean.FALSE);
        }
        Map<String, ConfirmedConsent> allConfirmed = this.loadConfirmedConsents();
        ArrayList<Consent> result2 = new ArrayList<Consent>();
        for (Map.Entry<String, Consent> entry : allDefaults.entrySet()) {
            Consent base = entry.getValue();
            if (base.isDeleted()) continue;
            ConfirmedConsent confirmed = allConfirmed.get(base.getId());
            result2.add(confirmed == null ? base : base.derive(confirmed.isAccepted()));
        }
        result2.sort(Comparator.comparing(ConsentBase::getId));
        boolean confirmationEnabled = Boolean.parseBoolean(System.getProperty(CONSENTS_CONFIRMATION_PROPERTY, "true"));
        return new Pair(result2, (Object)(confirmationEnabled && ConsentOptions.needReconfirm(allDefaults, allConfirmed) ? 1 : 0));
    }

    public void setConsents(@NotNull Collection<Consent> confirmedByUser) {
        if (confirmedByUser == null) {
            ConsentOptions.$$$reportNull$$$0(1);
        }
        this.saveConfirmedConsents(ContainerUtil.map(confirmedByUser, c -> new ConfirmedConsent(c.getId(), c.getVersion(), c.isAccepted(), 0L)));
    }

    @Nullable
    private ConfirmedConsent getConfirmedConsent(String consentId) {
        Consent defConsent = this.loadDefaultConsents().get(consentId);
        if (defConsent != null && defConsent.isDeleted()) {
            return null;
        }
        return this.loadConfirmedConsents().get(consentId);
    }

    private void saveConfirmedConsents(@NotNull Collection<ConfirmedConsent> updates) {
        if (updates == null) {
            ConsentOptions.$$$reportNull$$$0(2);
        }
        if (!updates.isEmpty()) {
            try {
                Map<String, ConfirmedConsent> allConfirmed = this.loadConfirmedConsents();
                long stamp = System.currentTimeMillis();
                for (ConfirmedConsent consent : updates) {
                    consent.setAcceptanceTime(stamp);
                    allConfirmed.put(consent.getId(), consent);
                }
                this.myBackend.writeConfirmedConsents(ConsentOptions.confirmedConsentToExternalString(allConfirmed.values().stream()));
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    private static boolean needReconfirm(Map<String, Consent> defaults, Map<String, ConfirmedConsent> confirmed) {
        for (Consent defConsent : defaults.values()) {
            Version defaultVersion;
            if (defConsent.isDeleted()) continue;
            ConfirmedConsent confirmedConsent = confirmed.get(defConsent.getId());
            if (confirmedConsent == null) {
                return true;
            }
            Version confirmedVersion = confirmedConsent.getVersion();
            if (!confirmedVersion.isOlder(defaultVersion = defConsent.getVersion()) || confirmedVersion.getMajor() == defaultVersion.getMajor()) continue;
            return true;
        }
        return false;
    }

    private static boolean applyServerChangesToConfirmedConsents(Map<String, ConfirmedConsent> base, Collection<? extends ConsentAttributes> fromServer) {
        boolean changes = false;
        for (ConsentAttributes consentAttributes : fromServer) {
            ConfirmedConsent change;
            ConfirmedConsent current2 = base.get(consentAttributes.consentId);
            if (current2 == null || (change = new ConfirmedConsent(consentAttributes)).getVersion().isOlder(current2.getVersion()) || current2.getAcceptanceTime() >= consentAttributes.acceptanceTime) continue;
            base.put(change.getId(), change);
            changes = true;
        }
        return changes;
    }

    private static boolean applyServerChangesToDefaults(@NotNull Map<String, Consent> base, @NotNull Collection<ConsentAttributes> fromServer) {
        if (base == null) {
            ConsentOptions.$$$reportNull$$$0(3);
        }
        if (fromServer == null) {
            ConsentOptions.$$$reportNull$$$0(4);
        }
        boolean changes = false;
        for (ConsentAttributes update2 : fromServer) {
            Consent newConsent = new Consent(update2);
            Consent current2 = base.get(newConsent.getId());
            if (current2 != null && !newConsent.getVersion().isNewer(current2.getVersion()) && newConsent.isDeleted() == current2.isDeleted()) continue;
            base.put(newConsent.getId(), newConsent);
            changes = true;
        }
        return changes;
    }

    @NotNull
    private static Collection<ConsentAttributes> fromJson(@Nullable String json) {
        if (StringUtilRt.isEmptyOrSpaces((CharSequence)json)) {
            List<ConsentAttributes> list2 = Collections.emptyList();
            if (list2 == null) {
                ConsentOptions.$$$reportNull$$$0(5);
            }
            return list2;
        }
        ArrayList<ConsentAttributes> result2 = new ArrayList<ConsentAttributes>();
        try (JsonReader reader = new JsonReader((Reader)new StringReader(json));){
            reader.beginArray();
            while (reader.hasNext()) {
                result2.add(ConsentOptions.readConsentAttributes(reader));
            }
            reader.endArray();
        }
        catch (Throwable e) {
            LOG.info(e);
        }
        ArrayList<ConsentAttributes> arrayList = result2;
        if (arrayList == null) {
            ConsentOptions.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    private static ConsentAttributes readConsentAttributes(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            ConsentOptions.$$$reportNull$$$0(7);
        }
        ConsentAttributes attributes = new ConsentAttributes();
        reader.beginObject();
        block18: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "consentId": {
                    attributes.consentId = reader.nextString();
                    continue block18;
                }
                case "version": {
                    attributes.version = reader.nextString();
                    continue block18;
                }
                case "text": {
                    attributes.text = reader.nextString();
                    continue block18;
                }
                case "printableName": {
                    attributes.printableName = reader.nextString();
                    continue block18;
                }
                case "accepted": {
                    attributes.accepted = reader.peek() == JsonToken.STRING ? Boolean.parseBoolean(reader.nextString()) : reader.nextBoolean();
                    continue block18;
                }
                case "deleted": {
                    attributes.deleted = reader.peek() == JsonToken.STRING ? Boolean.parseBoolean(reader.nextString()) : reader.nextBoolean();
                    continue block18;
                }
                case "acceptanceTime": {
                    attributes.acceptanceTime = reader.nextLong();
                    continue block18;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        ConsentAttributes consentAttributes = attributes;
        if (consentAttributes == null) {
            ConsentOptions.$$$reportNull$$$0(8);
        }
        return consentAttributes;
    }

    @NotNull
    private static String consentsToJson(@NotNull Stream<Consent> consents) {
        if (consents == null) {
            ConsentOptions.$$$reportNull$$$0(9);
        }
        Gson gson2 = new GsonBuilder().disableHtmlEscaping().create();
        String string = gson2.toJson((Object)consents.map(Consent::toConsentAttributes).toArray());
        if (string == null) {
            ConsentOptions.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    private static String confirmedConsentToExternalString(@NotNull Stream<ConfirmedConsent> consents) {
        if (consents == null) {
            ConsentOptions.$$$reportNull$$$0(11);
        }
        String string = consents.map(ConfirmedConsent::toExternalString).collect(Collectors.joining(";"));
        if (string == null) {
            ConsentOptions.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private Map<String, Consent> loadDefaultConsents() {
        HashMap<String, Consent> result2 = new HashMap<String, Consent>();
        for (ConsentAttributes attributes : ConsentOptions.fromJson(this.myBackend.readBundledConsents())) {
            result2.put(attributes.consentId, new Consent(attributes));
        }
        try {
            ConsentOptions.applyServerChangesToDefaults(result2, ConsentOptions.fromJson(this.myBackend.readDefaultConsents()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        HashMap<String, Consent> hashMap = result2;
        if (hashMap == null) {
            ConsentOptions.$$$reportNull$$$0(13);
        }
        return hashMap;
    }

    @NotNull
    private Map<String, ConfirmedConsent> loadConfirmedConsents() {
        HashMap<String, ConfirmedConsent> result2 = new HashMap<String, ConfirmedConsent>();
        try {
            StringTokenizer tokenizer = new StringTokenizer(this.myBackend.readConfirmedConsents(), ";", false);
            while (tokenizer.hasMoreTokens()) {
                ConfirmedConsent consent = ConfirmedConsent.fromString(tokenizer.nextToken());
                if (consent == null) continue;
                result2.put(consent.getId(), consent);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        HashMap<String, ConfirmedConsent> hashMap = result2;
        if (hashMap == null) {
            ConsentOptions.$$$reportNull$$$0(14);
        }
        return hashMap;
    }

    static /* synthetic */ String access$000() {
        return ConsentOptions.getBundledResourcePath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/gdpr/ConsentOptions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "confirmedByUser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updates";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromServer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledResourcePath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/gdpr/ConsentOptions";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "fromJson";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "readConsentAttributes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "consentsToJson";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "confirmedConsentToExternalString";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDefaultConsents";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "loadConfirmedConsents";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setConsents";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "saveConfirmedConsents";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyServerChangesToDefaults";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readConsentAttributes";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "consentsToJson";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "confirmedConsentToExternalString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static interface IOBackend {
        public void writeDefaultConsents(@NotNull String var1) throws IOException;

        @NotNull
        public String readDefaultConsents() throws IOException;

        @NotNull
        public String readBundledConsents();

        public void writeConfirmedConsents(@NotNull String var1) throws IOException;

        @NotNull
        public String readConfirmedConsents() throws IOException;
    }

    public static enum Permission {
        YES,
        NO,
        UNDEFINED;

    }

    private static final class InstanceHolder {
        static final ConsentOptions ourInstance;

        private InstanceHolder() {
        }

        static {
            ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
            ourInstance = new ConsentOptions(new IOBackend(){
                private final File DEFAULT_CONSENTS_FILE = new File(Locations.getDataRoot(), ApplicationNamesInfo.getInstance().getLowercaseProductName() + "/consentOptions/cached");
                private final File CONFIRMED_CONSENTS_FILE = new File(Locations.getDataRoot(), "/consentOptions/accepted");
                private final String BUNDLED_CONSENTS_PATH = ConsentOptions.access$000();

                @Override
                public void writeDefaultConsents(@NotNull String data2) throws IOException {
                    if (data2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    FileUtil.writeToFile((File)this.DEFAULT_CONSENTS_FILE, (String)data2);
                }

                @Override
                @NotNull
                public String readDefaultConsents() throws IOException {
                    return this.loadText(new FileInputStream(this.DEFAULT_CONSENTS_FILE));
                }

                @Override
                @NotNull
                public String readBundledConsents() {
                    return this.loadText(ConsentOptions.class.getResourceAsStream(this.BUNDLED_CONSENTS_PATH));
                }

                @Override
                public void writeConfirmedConsents(@NotNull String data2) throws IOException {
                    if (data2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    FileUtil.writeToFile((File)this.CONFIRMED_CONSENTS_FILE, (String)data2);
                }

                @Override
                @NotNull
                public String readConfirmedConsents() throws IOException {
                    return this.loadText(new FileInputStream(this.CONFIRMED_CONSENTS_FILE));
                }

                /*
                 * Loose catch block
                 */
                @NotNull
                private String loadText(InputStream stream) {
                    block17: {
                        String string;
                        Throwable throwable;
                        InputStreamReader reader;
                        block15: {
                            block16: {
                                if (stream == null) break block17;
                                reader = new InputStreamReader(CharsetToolkit.inputStreamSkippingBOM((InputStream)new BufferedInputStream(stream)), StandardCharsets.UTF_8);
                                throwable = null;
                                string = new String(FileUtil.adaptiveLoadText((Reader)reader));
                                if (reader == null) break block15;
                                if (throwable == null) break block16;
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block15;
                            }
                            ((Reader)reader).close();
                        }
                        String string2 = string;
                        if (string2 == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return string2;
                        {
                            catch (Throwable throwable3) {
                                try {
                                    try {
                                        throwable = throwable3;
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        if (reader != null) {
                                            if (throwable != null) {
                                                try {
                                                    ((Reader)reader).close();
                                                }
                                                catch (Throwable throwable5) {
                                                    throwable.addSuppressed(throwable5);
                                                }
                                            } else {
                                                ((Reader)reader).close();
                                            }
                                        }
                                        throw throwable4;
                                    }
                                }
                                catch (IOException e) {
                                    LOG.info((Throwable)e);
                                }
                            }
                        }
                    }
                    return "";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 2: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "data";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ide/gdpr/ConsentOptions$InstanceHolder$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ide/gdpr/ConsentOptions$InstanceHolder$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "loadText";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "writeDefaultConsents";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "writeConfirmedConsents";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }, appInfo.isEAP() && appInfo.isVendorJetBrains());
        }
    }
}

