/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.CreateFromTemplateHandler;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DefaultCreateFromTemplateHandler
implements CreateFromTemplateHandler {
    @Override
    public boolean handlesTemplate(@NotNull FileTemplate template) {
        if (template == null) {
            DefaultCreateFromTemplateHandler.$$$reportNull$$$0(0);
        }
        return true;
    }

    @Override
    @NotNull
    public PsiElement createFromTemplate(@NotNull Project project, @NotNull PsiDirectory directory, String fileName, @NotNull FileTemplate template, @NotNull String templateText, @NotNull Map<String, Object> props) throws IncorrectOperationException {
        if (project == null) {
            DefaultCreateFromTemplateHandler.$$$reportNull$$$0(1);
        }
        if (directory == null) {
            DefaultCreateFromTemplateHandler.$$$reportNull$$$0(2);
        }
        if (template == null) {
            DefaultCreateFromTemplateHandler.$$$reportNull$$$0(3);
        }
        if (templateText == null) {
            DefaultCreateFromTemplateHandler.$$$reportNull$$$0(4);
        }
        if (props == null) {
            DefaultCreateFromTemplateHandler.$$$reportNull$$$0(5);
        }
        fileName = this.checkAppendExtension(fileName, template);
        if (FileTypeManager.getInstance().isFileIgnored(fileName)) {
            throw new IncorrectOperationException("This filename is ignored (Settings | Editor | File Types | Ignore files and folders)");
        }
        directory.checkCreateFile(fileName);
        FileType type = FileTypeRegistry.getInstance().getFileTypeByFileName(fileName);
        PsiFile file2 = PsiFileFactory.getInstance((Project)project).createFileFromText(fileName, type, (CharSequence)templateText);
        if (template.isReformatCode()) {
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)file2);
        }
        PsiFile psiFile = file2 = (PsiFile)directory.add((PsiElement)file2);
        if (psiFile == null) {
            DefaultCreateFromTemplateHandler.$$$reportNull$$$0(6);
        }
        return psiFile;
    }

    protected String checkAppendExtension(String fileName, @NotNull FileTemplate template) {
        String suggestedFileNameEnd;
        if (template == null) {
            DefaultCreateFromTemplateHandler.$$$reportNull$$$0(7);
        }
        if (!fileName.endsWith(suggestedFileNameEnd = "." + template.getExtension())) {
            fileName = fileName + suggestedFileNameEnd;
        }
        return fileName;
    }

    @Override
    public boolean canCreate(PsiDirectory @NotNull [] dirs) {
        if (dirs == null) {
            DefaultCreateFromTemplateHandler.$$$reportNull$$$0(8);
        }
        return true;
    }

    @Override
    public boolean isNameRequired() {
        return true;
    }

    @Override
    @NotNull
    public String getErrorMessage() {
        String string = IdeBundle.message((String)"title.cannot.create.file", (Object[])new Object[0]);
        if (string == null) {
            DefaultCreateFromTemplateHandler.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public void prepareProperties(@NotNull Map<String, Object> props, String filename, @NotNull FileTemplate template) {
        if (props == null) {
            DefaultCreateFromTemplateHandler.$$$reportNull$$$0(10);
        }
        if (template == null) {
            DefaultCreateFromTemplateHandler.$$$reportNull$$$0(11);
        }
        String fileName = this.checkAppendExtension(filename, template);
        props.put("FILE_NAME", fileName);
    }

    @Override
    public void prepareProperties(@NotNull Map<String, Object> props) {
        if (props == null) {
            DefaultCreateFromTemplateHandler.$$$reportNull$$$0(12);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateText";
                break;
            }
            case 5: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "props";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/fileTemplates/DefaultCreateFromTemplateHandler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/fileTemplates/DefaultCreateFromTemplateHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromTemplate";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handlesTemplate";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFromTemplate";
                break;
            }
            case 6: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkAppendExtension";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canCreate";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "prepareProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

