/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListener;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.facet.ui.FacetDependentToolWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class FacetDependentToolWindowManager
implements ProjectComponent {
    private final Project myProject;

    private FacetDependentToolWindowManager(@NotNull Project project) {
        if (project == null) {
            FacetDependentToolWindowManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public void projectOpened() {
        ProjectWideFacetListenersRegistry.getInstance((Project)this.myProject).registerListener((ProjectWideFacetListener)new ProjectWideFacetAdapter<Facet>(){

            public void facetAdded(@NotNull Facet facet) {
                if (facet == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (FacetDependentToolWindow extension : FacetDependentToolWindowManager.getDependentExtensions(facet)) {
                    FacetDependentToolWindowManager.this.ensureToolWindowExists(extension);
                }
            }

            public void facetRemoved(@NotNull Facet facet) {
                ProjectFacetManager facetManager;
                if (facet == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((facetManager = ProjectFacetManager.getInstance((Project)FacetDependentToolWindowManager.this.myProject)).hasFacets(facet.getTypeId())) {
                    return;
                }
                ToolWindowManagerEx toolWindowManager = ToolWindowManagerEx.getInstanceEx(FacetDependentToolWindowManager.this.myProject);
                for (FacetDependentToolWindow extension : FacetDependentToolWindowManager.getDependentExtensions(facet)) {
                    ToolWindow toolWindow = toolWindowManager.getToolWindow(extension.id);
                    if (toolWindow == null) continue;
                    List facetTypes = extension.getFacetTypes();
                    for (FacetType facetType : facetTypes) {
                        if (!facetManager.hasFacets(facetType.getId())) continue;
                        return;
                    }
                    toolWindow.remove();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "facet";
                objectArray2[1] = "com/intellij/facet/impl/ui/FacetDependentToolWindowManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this.myProject);
        for (FacetDependentToolWindow extension : FacetDependentToolWindow.EXTENSION_POINT_NAME.getExtensionList()) {
            this.initToolWindowIfNeeded(extension);
        }
        FacetDependentToolWindow.EXTENSION_POINT_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<FacetDependentToolWindow>(){

            public void extensionAdded(@NotNull FacetDependentToolWindow extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                FacetDependentToolWindowManager.this.initToolWindowIfNeeded(extension);
            }

            public void extensionRemoved(@NotNull FacetDependentToolWindow extension, @NotNull PluginDescriptor pluginDescriptor) {
                ToolWindow window;
                if (extension == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(3);
                }
                if ((window = ToolWindowManager.getInstance((Project)FacetDependentToolWindowManager.this.myProject).getToolWindow(extension.id)) != null) {
                    window.remove();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/facet/impl/ui/FacetDependentToolWindowManager$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this.myProject);
    }

    private void initToolWindowIfNeeded(FacetDependentToolWindow extension) {
        for (FacetType type : extension.getFacetTypes()) {
            if (!ProjectFacetManager.getInstance((Project)this.myProject).hasFacets(type.getId())) continue;
            this.ensureToolWindowExists(extension);
            return;
        }
    }

    private void ensureToolWindowExists(FacetDependentToolWindow extension) {
        ToolWindow toolWindow = ToolWindowManagerEx.getInstanceEx(this.myProject).getToolWindow(extension.id);
        if (toolWindow == null) {
            ToolWindowManagerEx.getInstanceEx(this.myProject).initToolWindow((ToolWindowEP)extension);
        }
    }

    private static List<FacetDependentToolWindow> getDependentExtensions(Facet facet) {
        return ContainerUtil.filter((Collection)FacetDependentToolWindow.EXTENSION_POINT_NAME.getExtensionList(), toolWindowEP -> {
            for (String id2 : toolWindowEP.getFacetIds()) {
                if (!facet.getType().getStringId().equals(id2)) continue;
                return true;
            }
            return false;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/facet/impl/ui/FacetDependentToolWindowManager", "<init>"));
    }
}

