/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.lineMarker;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.GutterIconDescriptor;
import com.intellij.codeInsight.daemon.LineMarkerSettings;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.execution.lineMarker.RunLineMarkerProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class RunnableStatusListener
implements DaemonCodeAnalyzer.DaemonListener {
    RunnableStatusListener() {
    }

    public void daemonFinished(@NotNull Collection<FileEditor> fileEditors) {
        if (fileEditors == null) {
            RunnableStatusListener.$$$reportNull$$$0(0);
        }
        if (!LineMarkerSettings.getSettings().isEnabled((GutterIconDescriptor)new RunLineMarkerProvider())) {
            return;
        }
        for (FileEditor fileEditor : fileEditors) {
            if (!(fileEditor instanceof TextEditor) || !fileEditor.isValid()) continue;
            Editor editor = ((TextEditor)fileEditor).getEditor();
            Project project = editor.getProject();
            VirtualFile file2 = fileEditor.getFile();
            if (file2 == null || project == null || !file2.isValid()) continue;
            boolean hasRunMarkers = ContainerUtil.findInstance(DaemonCodeAnalyzerImpl.getLineMarkers(editor.getDocument(), project), RunLineMarkerProvider.RunLineMarkerInfo.class) != null;
            FileViewProvider vp = PsiManager.getInstance((Project)project).findViewProvider(file2);
            if (!hasRunMarkers && (vp == null || !RunnableStatusListener.weMayTrustRunGutterContributors(vp))) continue;
            RunLineMarkerProvider.markRunnable(file2, hasRunMarkers);
        }
    }

    private static boolean weMayTrustRunGutterContributors(FileViewProvider vp) {
        for (PsiFile file2 : vp.getAllFiles()) {
            for (RunLineMarkerContributor contributor : RunLineMarkerContributor.EXTENSION.allForLanguage(file2.getLanguage())) {
                if (contributor.producesAllPossibleConfigurations(file2)) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditors", "com/intellij/execution/lineMarker/RunnableStatusListener", "daemonFinished"));
    }
}

