/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.text;

import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TIntArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class LineOffsetsUtil {
    public static LineOffsets create(@NotNull Document document) {
        if (document == null) {
            LineOffsetsUtil.$$$reportNull$$$0(0);
        }
        return new LineOffsetsDocumentWrapper(document);
    }

    @NotNull
    public static LineOffsets create(@NotNull CharSequence text2) {
        int lineEnd;
        if (text2 == null) {
            LineOffsetsUtil.$$$reportNull$$$0(1);
        }
        TIntArrayList ends = new TIntArrayList();
        int index = 0;
        while ((lineEnd = StringUtil.indexOf((CharSequence)text2, (char)'\n', (int)index)) != -1) {
            ends.add(lineEnd);
            index = lineEnd + 1;
        }
        ends.add(text2.length());
        return new LineOffsetsImpl(ends.toNativeArray(), text2.length());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "document";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
        }
        objectArray[1] = "com/intellij/diff/tools/util/text/LineOffsetsUtil";
        objectArray[2] = "create";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class LineOffsetsDocumentWrapper
    implements LineOffsets {
        @NotNull
        private final Document myDocument;

        LineOffsetsDocumentWrapper(@NotNull Document document) {
            if (document == null) {
                LineOffsetsDocumentWrapper.$$$reportNull$$$0(0);
            }
            this.myDocument = document;
        }

        @Override
        public int getLineStart(int line) {
            return this.myDocument.getLineStartOffset(line);
        }

        @Override
        public int getLineEnd(int line) {
            return this.myDocument.getLineEndOffset(line);
        }

        @Override
        public int getLineEnd(int line, boolean includeNewline) {
            if (this.myDocument.getLineCount() == 0) {
                return 0;
            }
            return this.myDocument.getLineEndOffset(line) + (includeNewline ? this.myDocument.getLineSeparatorLength(line) : 0);
        }

        @Override
        public int getLineNumber(int offset) {
            return this.myDocument.getLineNumber(offset);
        }

        @Override
        public int getLineCount() {
            return DiffUtil.getLineCount(this.myDocument);
        }

        @Override
        public int getTextLength() {
            return this.myDocument.getTextLength();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/tools/util/text/LineOffsetsUtil$LineOffsetsDocumentWrapper", "<init>"));
        }
    }

    private static class LineOffsetsImpl
    implements LineOffsets {
        private final int[] myLineEnds;
        private final int myTextLength;

        private LineOffsetsImpl(int[] lineEnds, int textLength) {
            this.myLineEnds = lineEnds;
            this.myTextLength = textLength;
        }

        @Override
        public int getLineStart(int line) {
            this.checkLineIndex(line);
            if (line == 0) {
                return 0;
            }
            return this.myLineEnds[line - 1] + 1;
        }

        @Override
        public int getLineEnd(int line) {
            this.checkLineIndex(line);
            return this.myLineEnds[line];
        }

        @Override
        public int getLineEnd(int line, boolean includeNewline) {
            this.checkLineIndex(line);
            return this.myLineEnds[line] + (includeNewline && line != this.myLineEnds.length - 1 ? 1 : 0);
        }

        @Override
        public int getLineNumber(int offset) {
            if (offset < 0 || offset > this.getTextLength()) {
                throw new IndexOutOfBoundsException("Wrong offset: " + offset + ". Available text length: " + this.getTextLength());
            }
            if (offset == 0) {
                return 0;
            }
            if (offset == this.getTextLength()) {
                return this.getLineCount() - 1;
            }
            int bsResult = Arrays.binarySearch(this.myLineEnds, offset);
            return bsResult >= 0 ? bsResult : -bsResult - 1;
        }

        @Override
        public int getLineCount() {
            return this.myLineEnds.length;
        }

        @Override
        public int getTextLength() {
            return this.myTextLength;
        }

        private void checkLineIndex(int index) {
            if (index < 0 || index >= this.getLineCount()) {
                throw new IndexOutOfBoundsException("Wrong line: " + index + ". Available lines count: " + this.getLineCount());
            }
        }
    }
}

