/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import org.jetbrains.annotations.NotNull;

public class SimpleDiffChange {
    private final int myIndex;
    @NotNull
    private final LineFragment myFragment;
    private final boolean myIsExcluded;
    private final boolean myIsSkipped;
    private boolean myIsValid;
    private boolean myIsDestroyed;
    private final int[] myLineStartShifts;
    private final int[] myLineEndShifts;

    public SimpleDiffChange(int index, @NotNull LineFragment fragment) {
        if (fragment == null) {
            SimpleDiffChange.$$$reportNull$$$0(0);
        }
        this(index, fragment, false, false);
    }

    public SimpleDiffChange(int index, @NotNull LineFragment fragment, boolean isExcluded, boolean isSkipped) {
        if (fragment == null) {
            SimpleDiffChange.$$$reportNull$$$0(1);
        }
        this.myIsValid = true;
        this.myLineStartShifts = new int[2];
        this.myLineEndShifts = new int[2];
        this.myIndex = index;
        this.myFragment = fragment;
        this.myIsExcluded = isExcluded;
        this.myIsSkipped = isSkipped;
    }

    public int getIndex() {
        return this.myIndex;
    }

    public int getStartLine(@NotNull Side side) {
        if (side == null) {
            SimpleDiffChange.$$$reportNull$$$0(2);
        }
        return side.getStartLine(this.myFragment) + side.select(this.myLineStartShifts);
    }

    public int getEndLine(@NotNull Side side) {
        if (side == null) {
            SimpleDiffChange.$$$reportNull$$$0(3);
        }
        return side.getEndLine(this.myFragment) + side.select(this.myLineEndShifts);
    }

    @NotNull
    public TextDiffType getDiffType() {
        TextDiffType textDiffType = DiffUtil.getLineDiffType(this.myFragment);
        if (textDiffType == null) {
            SimpleDiffChange.$$$reportNull$$$0(4);
        }
        return textDiffType;
    }

    public boolean isExcluded() {
        return this.myIsExcluded;
    }

    public boolean isSkipped() {
        return this.myIsSkipped;
    }

    public boolean isValid() {
        return this.myIsValid;
    }

    public boolean isDestroyed() {
        return this.myIsDestroyed;
    }

    @NotNull
    public LineFragment getFragment() {
        LineFragment lineFragment = this.myFragment;
        if (lineFragment == null) {
            SimpleDiffChange.$$$reportNull$$$0(5);
        }
        return lineFragment;
    }

    public boolean processDocumentChange(int oldLine1, int oldLine2, int shift, @NotNull Side side) {
        if (side == null) {
            SimpleDiffChange.$$$reportNull$$$0(6);
        }
        int line1 = this.getStartLine(side);
        int line2 = this.getEndLine(side);
        int sideIndex = side.getIndex();
        DiffUtil.UpdatedLineRange newRange = DiffUtil.updateRangeOnModification(line1, line2, oldLine1, oldLine2, shift);
        int n = sideIndex;
        this.myLineStartShifts[n] = this.myLineStartShifts[n] + (newRange.startLine - line1);
        int n2 = sideIndex;
        this.myLineEndShifts[n2] = this.myLineEndShifts[n2] + (newRange.endLine - line2);
        if (newRange.damaged) {
            this.myIsValid = false;
        }
        return newRange.damaged;
    }

    public void markDestroyed() {
        this.myIsDestroyed = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/simple/SimpleDiffChange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/simple/SimpleDiffChange";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getStartLine";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getEndLine";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processDocumentChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

