/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.applications;

import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.applications.DiffApplicationBase;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.ide.CliResult;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MergeApplication
extends DiffApplicationBase {
    MergeApplication() {
        super("merge", 3, 4);
    }

    @Override
    @NotNull
    public String getUsageMessage() {
        String scriptName = ApplicationNamesInfo.getInstance().getScriptName();
        String string = DiffBundle.message((String)"merge.application.usage.parameters.and.description", (Object[])new Object[]{scriptName});
        if (string == null) {
            MergeApplication.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public Future<CliResult> processCommand(@NotNull List<String> args, @Nullable String currentDirectory) throws Exception {
        if (args == null) {
            MergeApplication.$$$reportNull$$$0(1);
        }
        List<String> filePaths = args.subList(1, args.size());
        List<VirtualFile> files2 = MergeApplication.findFiles(filePaths, currentDirectory);
        Project project = MergeApplication.guessProject(files2);
        List<VirtualFile> contents = Arrays.asList(files2.get(0), files2.get(2), files2.get(1));
        VirtualFile outputFile = files2.get(files2.size() - 1);
        if (outputFile == null) {
            throw new Exception("Can't find output file: " + (String)ContainerUtil.getLastItem(filePaths));
        }
        contents = this.replaceNullsWithEmptyFile(contents);
        AtomicReference resultRef = new AtomicReference();
        MergeRequest request2 = DiffRequestFactory.getInstance().createMergeRequestFromFiles(project, outputFile, contents, result2 -> resultRef.set(result2));
        DiffManagerEx.getInstance().showMergeBuiltin(project, request2);
        Document document = FileDocumentManager.getInstance().getCachedDocument(outputFile);
        if (document != null) {
            FileDocumentManager.getInstance().saveDocument(document);
        }
        CompletableFuture<CliResult> completableFuture = CompletableFuture.completedFuture(new CliResult(resultRef.get() != MergeResult.CANCEL ? 0 : 1, null));
        if (completableFuture == null) {
            MergeApplication.$$$reportNull$$$0(2);
        }
        return completableFuture;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/applications/MergeApplication";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsageMessage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/applications/MergeApplication";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "processCommand";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processCommand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

