/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.ConcurrentHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ConcurrentCollectionFactory {
    @NotNull
    @Contract(pure=true)
    public static <T, V> ConcurrentMap<T, V> createMap(@NotNull TObjectHashingStrategy<T> hashStrategy) {
        if (hashStrategy == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(0);
        }
        return new ConcurrentHashMap(hashStrategy);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> ConcurrentMap<T, V> createMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<T> hashStrategy) {
        if (hashStrategy == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(1);
        }
        return new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel, hashStrategy);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> createConcurrentSet(@NotNull TObjectHashingStrategy<T> hashStrategy) {
        if (hashStrategy == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(2);
        }
        Set<T> set = Collections.newSetFromMap(ConcurrentCollectionFactory.createMap(hashStrategy));
        if (set == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> createConcurrentSet(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<T> hashStrategy) {
        if (hashStrategy == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(4);
        }
        Set<T> set = Collections.newSetFromMap(ConcurrentCollectionFactory.createMap(initialCapacity, loadFactor, concurrencyLevel, hashStrategy));
        if (set == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(5);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashStrategy";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/concurrency/ConcurrentCollectionFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/concurrency/ConcurrentCollectionFactory";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createMap";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentSet";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

