/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.offline.OfflineProblemDescriptor;
import com.intellij.codeInspection.offlineViewer.OfflineDescriptorResolveResult;
import com.intellij.codeInspection.offlineViewer.OfflineProblemDescriptorNode;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionGroupNode;
import com.intellij.codeInspection.ui.InspectionModuleNode;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionPackageNode;
import com.intellij.codeInspection.ui.InspectionResultsViewComparator;
import com.intellij.codeInspection.ui.InspectionRootNode;
import com.intellij.codeInspection.ui.InspectionSeverityGroupNode;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.ui.tree.BaseTreeModel;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.TreeTraversal;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionTreeModel
extends BaseTreeModel<InspectionTreeNode>
implements InvokerSupplier {
    private static final Logger LOG = Logger.getInstance(InspectionTreeModel.class);
    private final InspectionRootNode myRoot = new InspectionRootNode(this);
    private final Invoker myInvoker = ApplicationManager.getApplication().isUnitTestMode() ? Invoker.forEventDispatchThread((Disposable)this) : Invoker.forBackgroundThreadWithReadAction((Disposable)this);

    @Override
    public int getIndexOfChild(Object object, Object child2) {
        return ((InspectionTreeNode)object).getIndex((TreeNode)child2);
    }

    public void reload() {
        this.treeNodesChanged(null, null, null);
    }

    @Override
    public List<? extends InspectionTreeNode> getChildren(Object parent) {
        List<? extends InspectionTreeNode> children2 = ((InspectionTreeNode)parent).getChildren();
        children2.forEach(InspectionTreeNode::uiRequested);
        return children2;
    }

    @Override
    public boolean isLeaf(Object object) {
        if (object == this.myRoot) {
            return false;
        }
        return super.isLeaf(object);
    }

    @Override
    public int getChildCount(Object object) {
        return ((InspectionTreeNode)object).getChildren().size();
    }

    public InspectionRootNode getRoot() {
        return this.myRoot;
    }

    @Nullable
    public InspectionTreeNode getParent(InspectionTreeNode node) {
        return node.myParent;
    }

    public JBIterable<InspectionTreeNode> traverse(InspectionTreeNode node) {
        return TreeTraversal.PRE_ORDER_DFS.traversal((Object)node, n -> this.getChildren(n));
    }

    @NotNull
    JBIterable<InspectionTreeNode> traverseFrom(InspectionTreeNode node, boolean direction) {
        JBIterable jBIterable = JBIterable.generate((Object)node, n -> this.getParent((InspectionTreeNode)n)).filter(n -> this.getParent((InspectionTreeNode)n) != null).flatMap(n1 -> {
            InspectionTreeNode p = this.getParent((InspectionTreeNode)n1);
            int idx = this.getIndexOfChild(p, n1);
            if (idx < 0) {
                return JBIterable.empty();
            }
            assert (p != null);
            InspectionTreeNode.Children children2 = p.myChildren;
            if (children2 == null) {
                return JBIterable.empty();
            }
            InspectionTreeNode[] arr = children2.myChildren;
            List<InspectionTreeNode> sublist = direction ? Arrays.asList(arr).subList(idx + (n1 == node ? 0 : 1), arr.length) : ContainerUtil.reverse(Arrays.asList(arr).subList(0, idx));
            return TreeTraversal.PRE_ORDER_DFS.traversal(sublist, n -> direction ? this.getChildren(n) : ContainerUtil.reverse(this.getChildren(n)));
        });
        if (jBIterable == null) {
            InspectionTreeModel.$$$reportNull$$$0(0);
        }
        return jBIterable;
    }

    public void remove(@NotNull InspectionTreeNode node) {
        if (node == null) {
            InspectionTreeModel.$$$reportNull$$$0(1);
        }
        this.doRemove(node, null);
        this.treeNodesChanged(null, null, null);
        this.treeStructureChanged(null, null, null);
    }

    private synchronized void doRemove(@NotNull InspectionTreeNode node, @Nullable InspectionTreeNode skip) {
        InspectionTreeNode parent;
        if (node == null) {
            InspectionTreeModel.$$$reportNull$$$0(2);
        }
        for (InspectionTreeNode inspectionTreeNode : this.getChildren(node)) {
            this.doRemove(inspectionTreeNode, skip);
        }
        if (node != skip && (parent = this.getParent(node)) != null) {
            InspectionTreeNode.Children children2 = parent.myChildren;
            assert (children2 != null);
            children2.myChildren = (InspectionTreeNode[])ArrayUtil.remove((Object[])children2.myChildren, (Object)node);
            children2.myUserObject2Node.removeValue((Object)node);
        }
    }

    synchronized void clearTree() {
        InspectionTreeNode.Children children2 = this.myRoot.myChildren;
        if (children2 != null) {
            children2.clear();
        }
    }

    @NotNull
    public InspectionModuleNode createModuleNode(@NotNull Module module, @NotNull InspectionTreeNode parent) {
        if (module == null) {
            InspectionTreeModel.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            InspectionTreeModel.$$$reportNull$$$0(4);
        }
        InspectionModuleNode inspectionModuleNode = this.getOrAdd(module, () -> new InspectionModuleNode(module, parent), parent);
        if (inspectionModuleNode == null) {
            InspectionTreeModel.$$$reportNull$$$0(5);
        }
        return inspectionModuleNode;
    }

    @NotNull
    public InspectionPackageNode createPackageNode(String packageName, @NotNull InspectionTreeNode parent) {
        if (parent == null) {
            InspectionTreeModel.$$$reportNull$$$0(6);
        }
        InspectionPackageNode inspectionPackageNode = this.getOrAdd(packageName, () -> new InspectionPackageNode(packageName, parent), parent);
        if (inspectionPackageNode == null) {
            InspectionTreeModel.$$$reportNull$$$0(7);
        }
        return inspectionPackageNode;
    }

    @NotNull
    InspectionGroupNode createGroupNode(String group, @NotNull InspectionTreeNode parent) {
        if (parent == null) {
            InspectionTreeModel.$$$reportNull$$$0(8);
        }
        InspectionGroupNode inspectionGroupNode = this.getOrAdd(group, () -> new InspectionGroupNode(group, parent), parent);
        if (inspectionGroupNode == null) {
            InspectionTreeModel.$$$reportNull$$$0(9);
        }
        return inspectionGroupNode;
    }

    @NotNull
    InspectionSeverityGroupNode createSeverityGroupNode(SeverityRegistrar severityRegistrar, HighlightDisplayLevel level, @NotNull InspectionTreeNode parent) {
        if (parent == null) {
            InspectionTreeModel.$$$reportNull$$$0(10);
        }
        InspectionSeverityGroupNode inspectionSeverityGroupNode = this.getOrAdd(level, () -> new InspectionSeverityGroupNode(severityRegistrar, level, parent), parent);
        if (inspectionSeverityGroupNode == null) {
            InspectionTreeModel.$$$reportNull$$$0(11);
        }
        return inspectionSeverityGroupNode;
    }

    @NotNull
    public RefElementNode createRefElementNode(@Nullable RefEntity entity, @NotNull Supplier<? extends RefElementNode> supplier, @NotNull InspectionTreeNode parent) {
        if (supplier == null) {
            InspectionTreeModel.$$$reportNull$$$0(12);
        }
        if (parent == null) {
            InspectionTreeModel.$$$reportNull$$$0(13);
        }
        RefElementNode refElementNode = this.getOrAdd(entity, () -> (RefElementNode)ReadAction.compute(((Supplier)supplier)::get), parent);
        if (refElementNode == null) {
            InspectionTreeModel.$$$reportNull$$$0(14);
        }
        return refElementNode;
    }

    public <T extends InspectionTreeNode> T createCustomNode(@NotNull Object userObject, @NotNull Supplier<T> supplier, @NotNull InspectionTreeNode parent) {
        if (userObject == null) {
            InspectionTreeModel.$$$reportNull$$$0(15);
        }
        if (supplier == null) {
            InspectionTreeModel.$$$reportNull$$$0(16);
        }
        if (parent == null) {
            InspectionTreeModel.$$$reportNull$$$0(17);
        }
        return this.getOrAdd(userObject, supplier, parent);
    }

    @NotNull
    InspectionNode createInspectionNode(@NotNull InspectionToolWrapper toolWrapper, InspectionProfileImpl profile, @NotNull InspectionTreeNode parent) {
        if (toolWrapper == null) {
            InspectionTreeModel.$$$reportNull$$$0(18);
        }
        if (parent == null) {
            InspectionTreeModel.$$$reportNull$$$0(19);
        }
        InspectionNode inspectionNode = this.getOrAdd(toolWrapper.getShortName(), () -> new InspectionNode(toolWrapper, profile, parent), parent);
        if (inspectionNode == null) {
            InspectionTreeModel.$$$reportNull$$$0(20);
        }
        return inspectionNode;
    }

    public void createProblemDescriptorNode(RefEntity element2, @NotNull CommonProblemDescriptor descriptor2, @NotNull InspectionToolPresentation presentation, @NotNull InspectionTreeNode parent) {
        if (descriptor2 == null) {
            InspectionTreeModel.$$$reportNull$$$0(21);
        }
        if (presentation == null) {
            InspectionTreeModel.$$$reportNull$$$0(22);
        }
        if (parent == null) {
            InspectionTreeModel.$$$reportNull$$$0(23);
        }
        this.getOrAdd(descriptor2, () -> (ProblemDescriptionNode)ReadAction.compute(() -> new ProblemDescriptionNode(element2, descriptor2, presentation, parent)), parent);
    }

    public void createOfflineProblemDescriptorNode(@NotNull OfflineProblemDescriptor offlineDescriptor, @NotNull OfflineDescriptorResolveResult resolveResult, @NotNull InspectionToolPresentation presentation, @NotNull InspectionTreeNode parent) {
        if (offlineDescriptor == null) {
            InspectionTreeModel.$$$reportNull$$$0(24);
        }
        if (resolveResult == null) {
            InspectionTreeModel.$$$reportNull$$$0(25);
        }
        if (presentation == null) {
            InspectionTreeModel.$$$reportNull$$$0(26);
        }
        if (parent == null) {
            InspectionTreeModel.$$$reportNull$$$0(27);
        }
        this.getOrAdd(offlineDescriptor, () -> (OfflineProblemDescriptorNode)ReadAction.compute(() -> new OfflineProblemDescriptorNode(resolveResult, presentation, offlineDescriptor, parent)), parent);
    }

    private synchronized <T extends InspectionTreeNode> T getOrAdd(Object userObject, Supplier<? extends T> supplier, InspectionTreeNode parent) {
        InspectionTreeNode node;
        InspectionTreeNode.Children children2;
        LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode() || !ApplicationManager.getApplication().isDispatchThread());
        if (userObject == null) {
            userObject = ObjectUtils.NULL;
        }
        if ((children2 = parent.myChildren) == null) {
            parent.myChildren = children2 = new InspectionTreeNode.Children();
        }
        if ((node = (InspectionTreeNode)children2.myUserObject2Node.get(userObject)) == null) {
            InspectionTreeNode.Children finalChildren = children2;
            node = (InspectionTreeNode)supplier.get();
            InspectionTreeNode finalNode = node;
            int idx = (Integer)ReadAction.compute(() -> Arrays.binarySearch(finalChildren.myChildren, finalNode, InspectionResultsViewComparator.INSTANCE));
            int insertionPoint = idx >= 0 ? idx : -idx - 1;
            children2.myChildren = (InspectionTreeNode[])ArrayUtil.insert((Object[])children2.myChildren, (int)insertionPoint, (Object)node);
            children2.myUserObject2Node.put(userObject, (Object)node);
            LOG.assertTrue(children2.myChildren.length == children2.myUserObject2Node.size());
            if (node instanceof SuppressableInspectionTreeNode) {
                ((SuppressableInspectionTreeNode)node).nodeAdded();
            }
            TreePath path = TreePathUtil.pathToTreeNode(node);
            TreePath parentPath = path.getParentPath();
            this.treeNodesInserted(parentPath, null, null);
            while (parentPath != null) {
                this.treeStructureChanged(parentPath, null, null);
                if ((parentPath = parentPath.getParentPath()) != null && parentPath.getLastPathComponent() != this.myRoot) continue;
                break;
            }
        }
        return (T)node;
    }

    @Override
    @NotNull
    public Invoker getInvoker() {
        Invoker invoker = this.myInvoker;
        if (invoker == null) {
            InspectionTreeModel.$$$reportNull$$$0(28);
        }
        return invoker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/InspectionTreeModel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 17: 
            case 19: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userObject";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offlineDescriptor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "traverseFrom";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/InspectionTreeModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleNode";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createPackageNode";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createGroupNode";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createSeverityGroupNode";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createRefElementNode";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createInspectionNode";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvoker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doRemove";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createModuleNode";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPackageNode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createGroupNode";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createSeverityGroupNode";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createRefElementNode";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createCustomNode";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createInspectionNode";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createProblemDescriptorNode";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createOfflineProblemDescriptorNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

