/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.HTMLComposer;
import com.intellij.codeInspection.lang.HTMLComposerExtension;
import com.intellij.codeInspection.lang.InspectionExtensionsFactory;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefProject;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HTMLComposerImpl
extends HTMLComposer {
    private final int[] myListStack;
    private int myListStackTop = -1;
    private final Map<Key, HTMLComposerExtension> myExtensions = new HashMap<Key, HTMLComposerExtension>();
    private final Map<Language, HTMLComposerExtension> myLanguageExtensions = new HashMap<Language, HTMLComposerExtension>();
    @NonNls
    protected static final String BR = "<br>";
    @NonNls
    public static final String NBSP = "&nbsp;";
    @NonNls
    public static final String CODE_CLOSING = "</code>";
    @NonNls
    public static final String CODE_OPENING = "<code>";
    @NonNls
    public static final String B_OPENING = "<b>";
    @NonNls
    public static final String B_CLOSING = "</b>";
    @NonNls
    protected static final String CLOSE_TAG = "\">";
    @NonNls
    public static final String A_HREF_OPENING = "<a HREF=\"";
    @NonNls
    public static final String A_CLOSING = "</a>";

    protected HTMLComposerImpl() {
        this.myListStack = new int[5];
        for (InspectionExtensionsFactory factory : InspectionExtensionsFactory.EP_NAME.getExtensionList()) {
            HTMLComposerExtension extension = factory.createHTMLComposerExtension((HTMLComposer)this);
            if (extension == null) continue;
            this.myExtensions.put(extension.getID(), extension);
            this.myLanguageExtensions.put(extension.getLanguage(), extension);
        }
    }

    public abstract void compose(@NotNull StringBuilder var1, RefEntity var2);

    public void compose(@NotNull StringBuilder buf, RefEntity refElement, CommonProblemDescriptor descriptor2) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(0);
        }
    }

    protected void genPageHeader(@NotNull StringBuilder buf, RefEntity refEntity) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(1);
        }
        if (refEntity instanceof RefElement) {
            RefElement refElement = (RefElement)refEntity;
            HTMLComposerImpl.appendHeading((StringBuilder)buf, (String)AnalysisBundle.message((String)"inspection.export.results.capitalized.location", (Object[])new Object[0]));
            buf.append("<div class=\"location\">");
            this.appendShortName(buf, refElement);
            buf.append(BR);
            buf.append("in ");
            this.appendLocation(buf, refElement);
            buf.append("</div>");
            buf.append(BR).append(BR);
        }
    }

    private void appendLocation(@NotNull StringBuilder buf, RefElement refElement) {
        HTMLComposerExtension extension;
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(2);
        }
        if ((extension = this.getLanguageExtension(refElement)) != null) {
            extension.appendLocation((RefEntity)refElement, buf);
        }
        if (refElement instanceof RefFile) {
            buf.append(AnalysisBundle.message((String)"inspection.export.results.file", (Object[])new Object[0]));
            buf.append(NBSP);
            this.appendElementReference(buf, refElement, false);
        }
    }

    @Nullable
    private HTMLComposerExtension getLanguageExtension(RefElement refElement) {
        PsiElement element2 = refElement.getPsiElement();
        return element2 != null ? this.myLanguageExtensions.get(element2.getLanguage()) : null;
    }

    private void appendShortName(final @NotNull StringBuilder buf, RefElement refElement) {
        HTMLComposerExtension extension;
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(3);
        }
        if ((extension = this.getLanguageExtension(refElement)) != null) {
            extension.appendShortName((RefEntity)refElement, buf);
        } else {
            refElement.accept(new RefVisitor(){

                public void visitFile(@NotNull RefFile file2) {
                    PsiFile psiFile;
                    if (file2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((psiFile = file2.getPsiElement()) != null) {
                        buf.append(HTMLComposerImpl.B_OPENING);
                        buf.append(psiFile.getName());
                        buf.append(HTMLComposerImpl.B_CLOSING);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/ex/HTMLComposerImpl$1", "visitFile"));
                }
            });
        }
    }

    public void appendQualifiedName(@NotNull StringBuilder buf, RefEntity refEntity) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(4);
        }
        if (refEntity == null) {
            return;
        }
        StringBuilder qName = new StringBuilder();
        while (!(refEntity instanceof RefProject)) {
            HTMLComposerExtension extension;
            if (qName.length() > 0) {
                qName.insert(0, ".");
            }
            String name = null;
            if (refEntity instanceof RefElement && (extension = this.getLanguageExtension((RefElement)refEntity)) != null) {
                name = extension.getQualifiedName(refEntity);
            }
            if (name == null) {
                name = refEntity.getName();
            }
            qName.insert(0, name);
            if (Comparing.strEqual((String)refEntity.getName(), (String)refEntity.getQualifiedName())) {
                buf.append((CharSequence)qName);
                return;
            }
            refEntity = refEntity.getOwner();
        }
        buf.append((CharSequence)qName);
    }

    public void appendElementReference(@NotNull StringBuilder buf, RefElement refElement) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(5);
        }
        this.appendElementReference(buf, refElement, true);
    }

    public void appendElementReference(@NotNull StringBuilder buf, RefElement refElement, String linkText, @NonNls String frameName) {
        String url;
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(6);
        }
        if ((url = ((RefElementImpl)refElement).getURL()) != null) {
            this.appendElementReference(buf, url, linkText, frameName);
        }
    }

    public void appendElementReference(@NotNull StringBuilder buf, String url, String linkText, @NonNls String frameName) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(7);
        }
        buf.append(A_HREF_OPENING);
        buf.append(url);
        if (frameName != null) {
            String target2 = "\" target=\"";
            buf.append("\" target=\"");
            buf.append(frameName);
        }
        buf.append(CLOSE_TAG);
        buf.append(linkText);
        buf.append(A_CLOSING);
    }

    protected void appendQuickFix(@NotNull StringBuilder buf, String text2) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(8);
        }
        buf.append(text2);
    }

    public void appendElementReference(@NotNull StringBuilder buf, RefElement refElement, boolean isPackageIncluded) {
        HTMLComposerExtension extension;
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(9);
        }
        if ((extension = this.getLanguageExtension(refElement)) != null) {
            extension.appendReferencePresentation((RefEntity)refElement, buf, isPackageIncluded);
        } else if (refElement instanceof RefFile) {
            VirtualFile file2;
            buf.append(A_HREF_OPENING);
            buf.append(((RefElementImpl)refElement).getURL());
            buf.append(CLOSE_TAG);
            String refElementName = refElement.getName();
            PsiElement element2 = refElement.getPsiElement();
            if (element2 != null && (file2 = PsiUtilCore.getVirtualFile((PsiElement)element2)) != null) {
                refElementName = ProjectUtilCore.displayUrlRelativeToProject((VirtualFile)file2, (String)file2.getPresentableUrl(), (Project)element2.getProject(), (boolean)true, (boolean)false);
            }
            buf.append(refElementName);
            buf.append(A_CLOSING);
        }
    }

    public String composeNumereables(int n, String statement, String singleEnding, String multipleEnding) {
        StringBuilder buf = new StringBuilder();
        buf.append(n);
        buf.append(' ');
        buf.append(statement);
        if (n % 10 == 1 && n % 100 != 11) {
            buf.append(singleEnding);
        } else {
            buf.append(multipleEnding);
        }
        return buf.toString();
    }

    public void appendElementInReferences(@NotNull StringBuilder buf, RefElement refElement) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(10);
        }
        if (refElement.getInReferences().size() > 0) {
            HTMLComposerImpl.appendHeading((StringBuilder)buf, (String)AnalysisBundle.message((String)"inspection.export.results.used.from", (Object[])new Object[0]));
            this.startList(buf);
            for (RefElement refCaller : refElement.getInReferences()) {
                this.appendListItem(buf, refCaller);
            }
            this.doneList(buf);
        }
    }

    public void appendElementOutReferences(@NotNull StringBuilder buf, RefElement refElement) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(11);
        }
        if (refElement.getOutReferences().size() > 0) {
            HTMLComposerImpl.appendHeading((StringBuilder)buf, (String)AnalysisBundle.message((String)"inspection.export.results.uses", (Object[])new Object[0]));
            this.startList(buf);
            for (RefElement refCallee : refElement.getOutReferences()) {
                this.appendListItem(buf, refCallee);
            }
            this.doneList(buf);
        }
    }

    public void appendListItem(@NotNull StringBuilder buf, RefElement refElement) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(12);
        }
        this.startListItem(buf);
        this.appendElementReference(buf, refElement, true);
        this.appendAdditionalListItemInfo(buf, refElement);
        HTMLComposerImpl.doneListItem(buf);
    }

    protected void appendAdditionalListItemInfo(@NotNull StringBuilder buf, RefElement refElement) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(13);
        }
    }

    protected void appendResolution(@NotNull StringBuilder buf, RefEntity where, String[] quickFixes) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(14);
        }
        if (where instanceof RefElement && !where.isValid()) {
            return;
        }
        if (quickFixes != null) {
            boolean listStarted = false;
            for (String text2 : quickFixes) {
                if (text2 == null) continue;
                if (!listStarted) {
                    HTMLComposerImpl.appendHeading((StringBuilder)buf, (String)AnalysisBundle.message((String)"inspection.problem.resolution", (Object[])new Object[0]));
                    this.startList(buf);
                    listStarted = true;
                }
                this.startListItem(buf);
                this.appendQuickFix(buf, text2);
                HTMLComposerImpl.doneListItem(buf);
            }
            if (listStarted) {
                this.doneList(buf);
            }
        }
    }

    public void startList(@NotNull StringBuilder buf) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(15);
        }
        if (this.myListStackTop == -1) {
            buf.append("<div class=\"problem-description\">");
        }
        buf.append("<ul>");
        ++this.myListStackTop;
        this.myListStack[this.myListStackTop] = 0;
    }

    public void doneList(@NotNull StringBuilder buf) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(16);
        }
        buf.append("</ul>");
        if (this.myListStack[this.myListStackTop] != 0) {
            buf.append("<table cellpadding=\"0\" border=\"0\" cellspacing=\"0\"><tr><td>&nbsp;</td></tr></table>");
        }
        if (this.myListStackTop == 0) {
            buf.append("</div>");
        }
        --this.myListStackTop;
    }

    public void startListItem(@NotNull StringBuilder buf) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(17);
        }
        int n = this.myListStackTop;
        this.myListStack[n] = this.myListStack[n] + 1;
        buf.append("<li>");
    }

    public static void doneListItem(@NotNull StringBuilder buf) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(18);
        }
        buf.append("</li>");
    }

    public void appendNoProblems(@NotNull StringBuilder buf) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(19);
        }
        buf.append("<p class=\"problem-description-group\">");
        buf.append(AnalysisBundle.message((String)"inspection.export.results.no.problems.found", (Object[])new Object[0]));
        buf.append("</p>");
    }

    public <T> T getExtension(Key<T> key) {
        return (T)this.myExtensions.get(key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "buf";
        objectArray2[1] = "com/intellij/codeInspection/ex/HTMLComposerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "compose";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "genPageHeader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "appendLocation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "appendShortName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "appendQualifiedName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "appendElementReference";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "appendQuickFix";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "appendElementInReferences";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "appendElementOutReferences";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "appendListItem";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "appendAdditionalListItemInfo";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "appendResolution";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "startList";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "doneList";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "startListItem";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "doneListItem";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "appendNoProblems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

