/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.codeInsight.documentation.render.DocRenderDummyLineMarkerProvider;
import com.intellij.codeInsight.documentation.render.DocRenderItem;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiElement;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBHtmlEditorKit;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.awt.image.ImageObserver;
import java.util.HashMap;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;

class DocRenderer
implements EditorCustomElementRenderer {
    private static final int MIN_WIDTH = 350;
    private static final int MAX_WIDTH = 680;
    private static final int LEFT_INSET = 14;
    private static final int RIGHT_INSET = 12;
    private static final int TOP_BOTTOM_INSETS = 2;
    private static final int LINE_WIDTH = 2;
    private static final int ARC_RADIUS = 5;
    private static StyleSheet ourCachedStyleSheet;
    private static String ourCachedStyleSheetLinkColor;
    private static String ourCachedStyleSheetMonoFont;
    private final DocRenderItem myItem;
    private boolean myRepaintRequested;
    private boolean myContentUpdateNeeded;
    JEditorPane myPane;

    DocRenderer(@NotNull DocRenderItem item) {
        if (item == null) {
            DocRenderer.$$$reportNull$$$0(0);
        }
        this.myItem = item;
    }

    void updateContent() {
        Inlay<DocRenderer> inlay = this.myItem.inlay;
        if (inlay != null) {
            this.myContentUpdateNeeded = true;
            inlay.update();
        }
    }

    public int calcWidthInPixels(@NotNull Inlay inlay) {
        if (inlay == null) {
            DocRenderer.$$$reportNull$$$0(1);
        }
        return DocRenderer.calcInlayWidth(inlay.getEditor());
    }

    public int calcHeightInPixels(@NotNull Inlay inlay) {
        if (inlay == null) {
            DocRenderer.$$$reportNull$$$0(2);
        }
        Editor editor = inlay.getEditor();
        int width = Math.max(0, DocRenderer.calcInlayWidth(editor) - this.calcInlayStartX() + editor.getInsets().left - DocRenderer.scale(14) - DocRenderer.scale(12));
        JComponent component2 = this.getRendererComponent(inlay, width, -1);
        return Math.max(editor.getLineHeight(), component2.getPreferredSize().height + DocRenderer.scale(2) * 2 + DocRenderer.scale(DocRenderer.getTopMargin()) + DocRenderer.scale(DocRenderer.getBottomMargin()));
    }

    public void paint(@NotNull Inlay inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
        Color bgColor;
        int bottomMargin;
        int endX;
        int startX;
        if (inlay == null) {
            DocRenderer.$$$reportNull$$$0(3);
        }
        if (g == null) {
            DocRenderer.$$$reportNull$$$0(4);
        }
        if (targetRegion == null) {
            DocRenderer.$$$reportNull$$$0(5);
        }
        if (textAttributes == null) {
            DocRenderer.$$$reportNull$$$0(6);
        }
        if ((startX = this.calcInlayStartX()) >= (endX = targetRegion.x + targetRegion.width)) {
            return;
        }
        int topMargin = DocRenderer.scale(DocRenderer.getTopMargin());
        int filledHeight = targetRegion.height - topMargin - (bottomMargin = DocRenderer.scale(DocRenderer.getBottomMargin()));
        if (filledHeight <= 0) {
            return;
        }
        int filledStartY = targetRegion.y + topMargin;
        EditorEx editor = (EditorEx)inlay.getEditor();
        Color defaultBgColor = editor.getBackgroundColor();
        Color currentBgColor = textAttributes.getBackgroundColor();
        Color color = bgColor = currentBgColor == null ? defaultBgColor : ColorUtil.mix((Color)defaultBgColor, (Color)textAttributes.getBackgroundColor(), (double)Registry.doubleValue((String)"editor.render.doc.comments.bg.transparency"));
        if (currentBgColor != null) {
            g.setColor(bgColor);
            int arcDiameter = 10;
            if (endX - startX >= arcDiameter) {
                g.fillRect(startX, filledStartY, endX - startX - 5, filledHeight);
                Object savedHint = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.fillRoundRect(endX - arcDiameter, filledStartY, arcDiameter, filledHeight, arcDiameter, arcDiameter);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedHint);
            } else {
                g.fillRect(startX, filledStartY, endX - startX, filledHeight);
            }
        }
        g.setColor(editor.getColorsScheme().getColor(DefaultLanguageHighlighterColors.DOC_COMMENT_GUIDE));
        g.fillRect(startX, filledStartY, DocRenderer.scale(2), filledHeight);
        int topBottomInset = DocRenderer.scale(2);
        int componentWidth = endX - startX - DocRenderer.scale(14) - DocRenderer.scale(12);
        int componentHeight = filledHeight - topBottomInset * 2;
        if (componentWidth > 0 && componentHeight > 0) {
            JComponent component2 = this.getRendererComponent(inlay, componentWidth, componentHeight);
            component2.setBackground(bgColor);
            Graphics dg = g.create(startX + DocRenderer.scale(14), filledStartY + topBottomInset, componentWidth, componentHeight);
            GraphicsUtil.setupAntialiasing((Graphics)dg);
            component2.paint(dg);
            dg.dispose();
        }
    }

    public GutterIconRenderer calcGutterIconRenderer(@NotNull Inlay inlay) {
        DocRenderItem.MyGutterIconRenderer myGutterIconRenderer;
        if (inlay == null) {
            DocRenderer.$$$reportNull$$$0(7);
        }
        if (DocRenderDummyLineMarkerProvider.isGutterIconEnabled()) {
            DocRenderItem docRenderItem = this.myItem;
            docRenderItem.getClass();
            myGutterIconRenderer = docRenderItem.new DocRenderItem.MyGutterIconRenderer(AllIcons.Gutter.JavadocEdit);
        } else {
            myGutterIconRenderer = null;
        }
        return myGutterIconRenderer;
    }

    public ActionGroup getContextMenuGroup(@NotNull Inlay inlay) {
        if (inlay == null) {
            DocRenderer.$$$reportNull$$$0(8);
        }
        return new DefaultActionGroup(new AnAction[]{this.myItem.createToggleAction(), new DocRenderItem.ChangeFontSize()});
    }

    private static int getTopMargin() {
        return Registry.intValue((String)"editor.render.doc.comments.top.margin");
    }

    private static int getBottomMargin() {
        return Registry.intValue((String)"editor.render.doc.comments.bottom.margin");
    }

    private static int scale(int value2) {
        return (int)((float)value2 * UISettings.getDefFontScale());
    }

    static int calcInlayWidth(@NotNull Editor editor) {
        int availableWidth;
        if (editor == null) {
            DocRenderer.$$$reportNull$$$0(9);
        }
        if ((availableWidth = editor.getScrollingModel().getVisibleArea().width) <= 0) {
            return 680;
        }
        return Math.max(DocRenderer.scale(350), Math.min(DocRenderer.scale(680), availableWidth));
    }

    private int calcInlayStartX() {
        Document document = this.myItem.editor.getDocument();
        int lineStartOffset = document.getLineStartOffset(document.getLineNumber(this.myItem.highlighter.getEndOffset()) + 1);
        int contentStartOffset = CharArrayUtil.shiftForward((CharSequence)document.getImmutableCharSequence(), (int)lineStartOffset, (String)" \t");
        return this.myItem.editor.offsetToXY((int)contentStartOffset, (boolean)false, (boolean)true).x;
    }

    Point getEditorPaneLocationWithinInlay() {
        return new Point(this.calcInlayStartX() + DocRenderer.scale(14), DocRenderer.scale(DocRenderer.getTopMargin()) + DocRenderer.scale(2));
    }

    private JComponent getRendererComponent(Inlay inlay, int width, int height) {
        boolean newInstance = false;
        EditorEx editor = (EditorEx)inlay.getEditor();
        if (this.myPane == null || this.myContentUpdateNeeded) {
            newInstance = true;
            this.myPane = new JEditorPane(){

                @Override
                public void repaint(long tm, int x, int y, int width, int height) {
                    DocRenderer.this.myRepaintRequested = true;
                }
            };
            this.myPane.setEditable(false);
            this.myPane.putClientProperty("caretWidth", 0);
            this.myPane.setEditorKit((EditorKit)DocRenderer.createEditorKit(editor));
            this.myPane.setBorder((Border)JBUI.Borders.empty());
            HashMap<TextAttribute, Integer> fontAttributes = new HashMap<TextAttribute, Integer>();
            fontAttributes.put(TextAttribute.SIZE, JBUIScale.scale((int)DocumentationComponent.getQuickDocFontSize().getSize()));
            fontAttributes.put(TextAttribute.KERNING, 0);
            this.myPane.setFont(this.myPane.getFont().deriveFont(fontAttributes));
            this.myPane.setForeground(DocRenderer.getTextColor(editor.getColorsScheme()));
            UIUtil.enableEagerSoftWrapping((JTextComponent)this.myPane);
            String textToRender = this.myItem.textToRender;
            if (textToRender == null) {
                textToRender = CodeInsightBundle.message((String)"doc.render.loading.text", (Object[])new Object[0]);
            }
            this.myPane.setText(textToRender);
            this.myPane.addHyperlinkListener(e -> {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    this.activateLink(e);
                }
            });
            this.myContentUpdateNeeded = false;
        }
        AppUIUtil.targetToDevice(this.myPane, editor.getContentComponent());
        this.myPane.setSize(width, height < 0 ? (newInstance ? Integer.MAX_VALUE : this.myPane.getHeight()) : height);
        if (newInstance) {
            this.trackImageUpdates(inlay);
        }
        return this.myPane;
    }

    @NotNull
    private static Color getTextColor(@NotNull EditorColorsScheme scheme) {
        TextAttributes attributes;
        if (scheme == null) {
            DocRenderer.$$$reportNull$$$0(10);
        }
        Color color = (attributes = scheme.getAttributes(DefaultLanguageHighlighterColors.DOC_COMMENT)) == null ? null : attributes.getForegroundColor();
        Color color2 = color == null ? scheme.getDefaultForeground() : color;
        if (color2 == null) {
            DocRenderer.$$$reportNull$$$0(11);
        }
        return color2;
    }

    private void activateLink(HyperlinkEvent event) {
        PsiElement owner;
        Element element2 = event.getSourceElement();
        if (element2 == null) {
            return;
        }
        Rectangle location2 = null;
        try {
            location2 = this.myPane.modelToView(element2.getStartOffset());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (location2 == null) {
            return;
        }
        PsiDocCommentBase comment = this.myItem.getComment();
        PsiElement psiElement = owner = comment == null ? null : comment.getOwner();
        if (owner == null) {
            return;
        }
        String url = event.getDescription();
        if (DocRenderer.isGotoDeclarationEvent()) {
            DocRenderer.navigateToDeclaration(owner, url);
        } else {
            this.showDocumentation(this.myItem.editor, owner, url, location2);
        }
    }

    private static boolean isGotoDeclarationEvent() {
        KeymapManager keymapManager2 = KeymapManager.getInstance();
        if (keymapManager2 == null) {
            return false;
        }
        AWTEvent event = IdeEventQueue.getInstance().getTrueCurrentEvent();
        if (!(event instanceof MouseEvent)) {
            return false;
        }
        MouseShortcut mouseShortcut = KeymapUtil.createMouseShortcut((MouseEvent)((MouseEvent)event));
        return keymapManager2.getActiveKeymap().getActionIds(mouseShortcut).contains("GotoDeclaration");
    }

    private static void navigateToDeclaration(@NotNull PsiElement context, @NotNull String linkUrl) {
        PsiElement targetElement;
        if (context == null) {
            DocRenderer.$$$reportNull$$$0(12);
        }
        if (linkUrl == null) {
            DocRenderer.$$$reportNull$$$0(13);
        }
        if ((targetElement = DocumentationManager.getInstance(context.getProject()).getTargetElement(context, linkUrl)) instanceof Navigatable) {
            ((Navigatable)targetElement).navigate(true);
        }
    }

    private void showDocumentation(@NotNull Editor editor, @NotNull PsiElement context, @NotNull String linkUrl, @NotNull Rectangle linkLocationWithinInlay) {
        DocumentationComponent component2;
        if (editor == null) {
            DocRenderer.$$$reportNull$$$0(14);
        }
        if (context == null) {
            DocRenderer.$$$reportNull$$$0(15);
        }
        if (linkUrl == null) {
            DocRenderer.$$$reportNull$$$0(16);
        }
        if (linkLocationWithinInlay == null) {
            DocRenderer.$$$reportNull$$$0(17);
        }
        Project project = context.getProject();
        final DocumentationManager documentationManager = DocumentationManager.getInstance(project);
        if (QuickDocUtil.getActiveDocComponent(project) == null) {
            Point inlayPosition = Objects.requireNonNull(this.myItem.inlay.getBounds()).getLocation();
            Point relativePosition = this.getEditorPaneLocationWithinInlay();
            editor.putUserData(PopupFactoryImpl.ANCHOR_POPUP_POINT, (Object)new Point(inlayPosition.x + relativePosition.x + linkLocationWithinInlay.x, inlayPosition.y + relativePosition.y + linkLocationWithinInlay.y + linkLocationWithinInlay.height));
            documentationManager.showJavaDocInfo(editor, context, context, () -> editor.putUserData(PopupFactoryImpl.ANCHOR_POPUP_POINT, null), "", false, true);
        }
        if ((component2 = QuickDocUtil.getActiveDocComponent(project)) != null) {
            if (!documentationManager.hasActiveDockedDocWindow()) {
                component2.startWait();
            }
            documentationManager.navigateByLink(component2, linkUrl);
        }
        if (documentationManager.getDocInfoHint() == null) {
            editor.putUserData(PopupFactoryImpl.ANCHOR_POPUP_POINT, null);
        }
        if (documentationManager.hasActiveDockedDocWindow()) {
            documentationManager.setAllowContentUpdateFromContext(false);
            final Disposable disposable2 = Disposer.newDisposable();
            editor.getCaretModel().addCaretListener(new CaretListener(){

                public void caretPositionChanged(@NotNull CaretEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    documentationManager.resetAutoUpdateState();
                    Disposer.dispose((Disposable)disposable2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/render/DocRenderer$2", "caretPositionChanged"));
                }
            }, disposable2);
        }
    }

    private void trackImageUpdates(Inlay inlay) {
        this.myPane.getPreferredSize();
        ImageObserver observer = (img, infoflags, x, y, width, height) -> {
            SwingUtilities.invokeLater(() -> {
                if (inlay.isValid()) {
                    inlay.update();
                }
            });
            return true;
        };
        if (DocRenderer.trackImageUpdates(this.myPane.getUI().getRootView(this.myPane), observer)) {
            observer.imageUpdate(null, 0, 0, 0, 0, 0);
        }
    }

    private static boolean trackImageUpdates(View view, ImageObserver observer) {
        Image image;
        boolean result2 = false;
        if (view instanceof ImageView && (image = ((ImageView)view).getImage()) != null) {
            result2 = image.getWidth(observer) >= 0 || image.getHeight(observer) >= 0;
        }
        int childCount = view.getViewCount();
        for (int i = 0; i < childCount; ++i) {
            result2 |= DocRenderer.trackImageUpdates(view.getView(i), observer);
        }
        return result2;
    }

    void doWithRepaintTracking(Runnable task2) {
        this.myRepaintRequested = false;
        task2.run();
        Inlay<DocRenderer> inlay = this.myItem.inlay;
        if (this.myRepaintRequested && inlay != null) {
            inlay.repaint();
        }
    }

    private static JBHtmlEditorKit createEditorKit(@NotNull Editor editor) {
        if (editor == null) {
            DocRenderer.$$$reportNull$$$0(18);
        }
        JBHtmlEditorKit editorKit = new JBHtmlEditorKit(true);
        editorKit.getStyleSheet().addStyleSheet(DocRenderer.getStyleSheet(editor));
        return editorKit;
    }

    private static StyleSheet getStyleSheet(@NotNull Editor editor) {
        String linkColorHex;
        if (editor == null) {
            DocRenderer.$$$reportNull$$$0(19);
        }
        EditorColorsScheme colorsScheme = editor.getColorsScheme();
        String editorFontName = (String)ObjectUtils.notNull((Object)colorsScheme.getEditorFontName(), (Object)"Monospaced");
        Color linkColor = colorsScheme.getColor(DefaultLanguageHighlighterColors.DOC_COMMENT_LINK);
        if (linkColor == null) {
            linkColor = DocRenderer.getTextColor(colorsScheme);
        }
        if (!Objects.equals(linkColorHex = ColorUtil.toHex((Color)linkColor), ourCachedStyleSheetLinkColor) || !Objects.equals(editorFontName, ourCachedStyleSheetMonoFont)) {
            String escapedFontName = StringUtil.escapeQuotes((String)editorFontName);
            ourCachedStyleSheet = StartupUiUtil.createStyleSheet((String)("body {overflow-wrap: anywhere}code {font-family:\"" + escapedFontName + "\"}pre {font-family:\"" + escapedFontName + "\";white-space: pre-wrap}h1, h2, h3, h4, h5, h6 { margin-top: 0; padding-top: 1px; }a { color: #" + linkColorHex + "; text-decoration: none;}p { padding: 1px 0 2px 0; }ol { padding: 0 16px 0 0; }ul { padding: 0 16px 0 0; }li { padding: 1px 0 2px 0; }table p { padding-bottom: 0}th { text-align: left; }td {padding: 2px 0 2px 0}td p {padding-top: 0}.sections {border-spacing: 0}.section {padding-right: 4px; white-space: nowrap}.content {padding: 2px 0 2px 0}"));
            ourCachedStyleSheetLinkColor = linkColorHex;
            ourCachedStyleSheetMonoFont = editorFontName;
        }
        return ourCachedStyleSheet;
    }

    static {
        ourCachedStyleSheetLinkColor = "non-existing";
        ourCachedStyleSheetMonoFont = "non-existing";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlay";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRegion";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributes";
                break;
            }
            case 9: 
            case 14: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/documentation/render/DocRenderer";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkUrl";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkLocationWithinInlay";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calcWidthInPixels";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calcHeightInPixels";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calcGutterIconRenderer";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getContextMenuGroup";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calcInlayWidth";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTextColor";
                break;
            }
            case 11: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "navigateToDeclaration";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "showDocumentation";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createEditorKit";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getStyleSheet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

