/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.concurrency.JobLauncher;
import com.intellij.ide.IdeBundle;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectedGeneralHighlightingPass
extends GeneralHighlightingPass {
    InjectedGeneralHighlightingPass(@NotNull Project project, @NotNull PsiFile file2, @NotNull Document document, int startOffset, int endOffset, boolean updateAll, @NotNull ProperTextRange priorityRange, @Nullable Editor editor, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        if (project == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(1);
        }
        if (document == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(2);
        }
        if (priorityRange == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(3);
        }
        if (highlightInfoProcessor == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(4);
        }
        super(project, file2, document, startOffset, endOffset, updateAll, priorityRange, editor, highlightInfoProcessor);
    }

    @Override
    protected String getPresentableName() {
        return IdeBundle.message((String)"highlighting.pass.injected.presentable.name", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void collectInformationWithProgress(@NotNull ProgressIndicator progress2) {
        THashSet result2;
        if (progress2 == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(5);
        }
        if (!Registry.is((String)"editor.injected.highlighting.enabled")) {
            return;
        }
        ArrayList allDivided = new ArrayList();
        Divider.divideInsideAndOutsideAllRoots(this.myFile, this.myRestrictRange, (TextRange)this.myPriorityRange, (Condition<? super PsiFile>)SHOULD_HIGHLIGHT_FILTER, (Processor<? super Divider.DividedElements>)new CommonProcessors.CollectProcessor(allDivided));
        List allInsideElements = ContainerUtil.concat((Iterable)ContainerUtil.map(allDivided, d -> d.inside));
        List allOutsideElements = ContainerUtil.concat((Iterable)ContainerUtil.map(allDivided, d -> d.outside));
        Set<PsiFile> injected = this.getInjectedPsiFiles(allInsideElements, allOutsideElements, progress2);
        this.setProgressLimit(injected.size());
        THashSet injectedResult = new THashSet();
        if (!this.addInjectedPsiHighlights(injected, progress2, Collections.synchronizedSet(injectedResult))) {
            throw new ProcessCanceledException();
        }
        THashSet tHashSet = injectedResult;
        synchronized (tHashSet) {
            result2 = injectedResult;
        }
        THashSet gotHighlights = new THashSet(100);
        ArrayList<HighlightInfo> injectionsOutside = new ArrayList<HighlightInfo>(gotHighlights.size());
        for (HighlightInfo info : result2) {
            if (this.myRestrictRange.contains((Segment)info)) {
                gotHighlights.add(info);
                continue;
            }
            injectionsOutside.add(info);
        }
        if (!injectionsOutside.isEmpty()) {
            ProperTextRange priorityIntersection = this.myPriorityRange.intersection(this.myRestrictRange);
            if (!(allInsideElements.isEmpty() && gotHighlights.isEmpty() || priorityIntersection == null)) {
                ArrayList toApplyInside = new ArrayList(gotHighlights);
                this.myHighlights.addAll(toApplyInside);
                gotHighlights.clear();
                this.myHighlightInfoProcessor.highlightsInsideVisiblePartAreProduced(this.myHighlightingSession, this.getEditor(), toApplyInside, (TextRange)this.myPriorityRange, this.myRestrictRange, this.getId());
            }
            ArrayList<HighlightInfo> toApply = new ArrayList<HighlightInfo>();
            for (HighlightInfo info : gotHighlights) {
                if (!this.myRestrictRange.contains((Segment)info) || this.myPriorityRange.contains((Segment)info)) continue;
                toApply.add(info);
            }
            toApply.addAll(injectionsOutside);
            this.myHighlightInfoProcessor.highlightsOutsideVisiblePartAreProduced(this.myHighlightingSession, this.getEditor(), toApply, this.myRestrictRange, (TextRange)new ProperTextRange(0, this.myDocument.getTextLength()), this.getId());
        } else {
            this.myHighlights.addAll(gotHighlights);
            this.myHighlightInfoProcessor.highlightsInsideVisiblePartAreProduced(this.myHighlightingSession, this.getEditor(), this.myHighlights, this.myRestrictRange, this.myRestrictRange, this.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private Set<PsiFile> getInjectedPsiFiles(@NotNull List<? extends PsiElement> elements1, @NotNull List<? extends PsiElement> elements2, @NotNull ProgressIndicator progress2) {
        if (elements1 == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(6);
        }
        if (elements2 == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(7);
        }
        if (progress2 == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        List injected = InjectedLanguageManager.getInstance((Project)this.myProject).getCachedInjectedDocumentsInRange(this.myFile, this.myFile.getTextRange());
        THashSet hosts = new THashSet(elements1.size() + elements2.size() + injected.size());
        for (DocumentWindow documentRange : injected) {
            PsiLanguageInjectionHost context;
            PsiFile file2;
            ProgressManager.checkCanceled();
            if (!documentRange.isValid() || (file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile((Document)documentRange)) == null || (context = InjectedLanguageManager.getInstance((Project)file2.getProject()).getInjectionHost((PsiElement)file2)) == null || !context.isValid() || file2.getProject().isDisposed() || !this.myUpdateAll && !this.myRestrictRange.intersects(context.getTextRange())) continue;
            hosts.add(context);
        }
        InjectedLanguageManagerImpl injectedLanguageManager = InjectedLanguageManagerImpl.getInstanceImpl(this.myProject);
        Processor collectInjectableProcessor = Processors.cancelableCollectProcessor((Collection)hosts);
        injectedLanguageManager.processInjectableElements(elements1, (Processor<? super PsiElement>)collectInjectableProcessor);
        injectedLanguageManager.processInjectableElements(elements2, (Processor<? super PsiElement>)collectInjectableProcessor);
        THashSet outInjected = new THashSet();
        PsiLanguageInjectionHost.InjectedPsiVisitor visitor = (arg_0, arg_1) -> InjectedGeneralHighlightingPass.lambda$getInjectedPsiFiles$2((Set)outInjected, arg_0, arg_1);
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList(hosts), progress2, element2 -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            InjectedLanguageManager.getInstance((Project)this.myFile.getProject()).enumerateEx(element2, this.myFile, false, visitor);
            return true;
        })) {
            throw new ProcessCanceledException();
        }
        THashSet tHashSet2 = outInjected;
        // MONITORENTER : tHashSet2
        THashSet tHashSet = outInjected.isEmpty() ? Collections.emptySet() : new THashSet((Collection)outInjected);
        // MONITOREXIT : tHashSet2
        if (tHashSet != null) return tHashSet;
        InjectedGeneralHighlightingPass.$$$reportNull$$$0(9);
        return tHashSet;
    }

    private boolean addInjectedPsiHighlights(@NotNull Set<? extends PsiFile> injectedFiles, @NotNull ProgressIndicator progress2, @NotNull Collection<? super HighlightInfo> outInfos) {
        if (injectedFiles == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(10);
        }
        if (progress2 == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(11);
        }
        if (outInfos == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(12);
        }
        if (injectedFiles.isEmpty()) {
            return true;
        }
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)this.myProject);
        TextAttributes injectedAttributes = this.myGlobalScheme.getAttributes(EditorColors.createInjectedLanguageFragmentKey((Language)this.myFile.getLanguage()));
        return JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList<PsiFile>(injectedFiles), progress2, injectedPsi -> this.addInjectedPsiHighlights((PsiFile)injectedPsi, injectedAttributes, outInfos, injectedLanguageManager));
    }

    @Override
    protected void queueInfoToUpdateIncrementally(@NotNull HighlightInfo info) {
        if (info == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(13);
        }
    }

    private boolean addInjectedPsiHighlights(@NotNull PsiFile injectedPsi, @Nullable TextAttributes injectedAttributes, @NotNull Collection<? super HighlightInfo> outInfos, @NotNull InjectedLanguageManager injectedLanguageManager) {
        DocumentWindow documentWindow;
        if (injectedPsi == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(14);
        }
        if (outInfos == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(15);
        }
        if (injectedLanguageManager == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(16);
        }
        if ((documentWindow = (DocumentWindow)PsiDocumentManager.getInstance((Project)this.myProject).getCachedDocument(injectedPsi)) == null) {
            return true;
        }
        Place places = InjectedLanguageUtil.getShreds(injectedPsi);
        boolean addTooltips = places.size() < 100;
        Iterator iterator2 = places.iterator();
        while (iterator2.hasNext()) {
            TextRange textRange;
            PsiLanguageInjectionHost.Shred place = (PsiLanguageInjectionHost.Shred)iterator2.next();
            PsiLanguageInjectionHost host = place.getHost();
            if (host == null || (textRange = place.getRangeInsideHost().shiftRight(host.getTextRange().getStartOffset())).isEmpty()) continue;
            HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_BACKGROUND).range(textRange);
            if (injectedAttributes != null && InjectedLanguageUtil.isHighlightInjectionBackground(host)) {
                builder2.textAttributes(injectedAttributes);
            }
            if (addTooltips) {
                String desc = injectedPsi.getLanguage().getDisplayName() + ": " + injectedPsi.getText();
                builder2.unescapedToolTip(desc);
            }
            HighlightInfo info = builder2.createUnconditionally();
            info.setFromInjection(true);
            outInfos.add(info);
        }
        HighlightInfoHolder holder = this.createInfoHolder(injectedPsi);
        this.runHighlightVisitorsForInjected(injectedPsi, holder);
        for (int i = 0; i < holder.size(); ++i) {
            HighlightInfo info = holder.get(i);
            int startOffset = documentWindow.injectedToHost(info.startOffset);
            TextRange fixedTextRange = InjectedGeneralHighlightingPass.getFixedTextRange(documentWindow, startOffset);
            InjectedGeneralHighlightingPass.addPatchedInfos(info, injectedPsi, documentWindow, injectedLanguageManager, fixedTextRange, outInfos);
        }
        int injectedStart = holder.size();
        this.highlightInjectedSyntax(injectedPsi, holder);
        for (int i = injectedStart; i < holder.size(); ++i) {
            HighlightInfo info = holder.get(i);
            int startOffset = info.startOffset;
            TextRange fixedTextRange = InjectedGeneralHighlightingPass.getFixedTextRange(documentWindow, startOffset);
            if (fixedTextRange == null) {
                info.setFromInjection(true);
                outInfos.add(info);
                continue;
            }
            HighlightInfo patched = new HighlightInfo(info.forcedTextAttributes, info.forcedTextAttributesKey, info.type, fixedTextRange.getStartOffset(), fixedTextRange.getEndOffset(), info.getDescription(), info.getToolTip(), info.type.getSeverity(null), info.isAfterEndOfLine(), null, false, 0, info.getProblemGroup(), info.getInspectionToolId(), info.getGutterIconRenderer(), info.getGroup());
            patched.setFromInjection(true);
            outInfos.add(patched);
        }
        if (!this.isDumbMode()) {
            ArrayList todos = new ArrayList();
            InjectedGeneralHighlightingPass.highlightTodos(injectedPsi, injectedPsi.getText(), 0, injectedPsi.getTextLength(), this.myPriorityRange, todos, todos);
            for (HighlightInfo info : todos) {
                InjectedGeneralHighlightingPass.addPatchedInfos(info, injectedPsi, documentWindow, injectedLanguageManager, null, outInfos);
            }
        }
        this.advanceProgress(1L);
        return true;
    }

    @Nullable(value="null means invalid")
    private static @Nullable(value="null means invalid") TextRange getFixedTextRange(@NotNull DocumentWindow documentWindow, int startOffset) {
        ProperTextRange fixedTextRange;
        TextRange textRange;
        if (documentWindow == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(17);
        }
        if ((textRange = documentWindow.getHostRange(startOffset)) == null) {
            textRange = InjectedGeneralHighlightingPass.findNearestTextRange(documentWindow, startOffset);
            if (textRange == null) {
                return null;
            }
            boolean isBefore = startOffset < textRange.getStartOffset();
            fixedTextRange = new ProperTextRange(isBefore ? textRange.getStartOffset() - 1 : textRange.getEndOffset(), isBefore ? textRange.getStartOffset() : textRange.getEndOffset() + 1);
        } else {
            fixedTextRange = null;
        }
        return fixedTextRange;
    }

    private static void addPatchedInfos(@NotNull HighlightInfo info, @NotNull PsiFile injectedPsi, @NotNull DocumentWindow documentWindow, @NotNull InjectedLanguageManager injectedLanguageManager, @Nullable TextRange fixedTextRange, @NotNull Collection<? super HighlightInfo> out) {
        if (info == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(18);
        }
        if (injectedPsi == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(19);
        }
        if (documentWindow == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(20);
        }
        if (injectedLanguageManager == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(21);
        }
        if (out == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(22);
        }
        ProperTextRange textRange = new ProperTextRange(info.startOffset, info.endOffset);
        List editables = injectedLanguageManager.intersectWithAllEditableFragments(injectedPsi, (TextRange)textRange);
        for (TextRange editable : editables) {
            TextRange hostRange = fixedTextRange == null ? documentWindow.injectedToHost(editable) : fixedTextRange;
            boolean isAfterEndOfLine = info.isAfterEndOfLine();
            if (isAfterEndOfLine) {
                int hostEndOffset = hostRange.getEndOffset();
                int lineNumber = documentWindow.getDelegate().getLineNumber(hostEndOffset);
                int hostLineEndOffset = documentWindow.getDelegate().getLineEndOffset(lineNumber);
                if (hostEndOffset < hostLineEndOffset) {
                    isAfterEndOfLine = false;
                    hostRange = new ProperTextRange(hostRange.getStartOffset(), hostEndOffset + 1);
                }
            }
            HighlightInfo patched = new HighlightInfo(info.forcedTextAttributes, info.forcedTextAttributesKey, info.type, hostRange.getStartOffset(), hostRange.getEndOffset(), info.getDescription(), info.getToolTip(), info.type.getSeverity(null), isAfterEndOfLine, null, false, 0, info.getProblemGroup(), info.getInspectionToolId(), info.getGutterIconRenderer(), info.getGroup());
            patched.setHint(info.hasHint());
            if (info.quickFixActionRanges != null) {
                for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair : info.quickFixActionRanges) {
                    TextRange quickfixTextRange = (TextRange)pair.getSecond();
                    List editableQF = injectedLanguageManager.intersectWithAllEditableFragments(injectedPsi, quickfixTextRange);
                    for (TextRange editableRange : editableQF) {
                        HighlightInfo.IntentionActionDescriptor descriptor2 = (HighlightInfo.IntentionActionDescriptor)pair.getFirst();
                        if (patched.quickFixActionRanges == null) {
                            patched.quickFixActionRanges = new ArrayList<Pair<HighlightInfo.IntentionActionDescriptor, TextRange>>();
                        }
                        TextRange hostEditableRange = documentWindow.injectedToHost(editableRange);
                        patched.quickFixActionRanges.add((Pair<HighlightInfo.IntentionActionDescriptor, TextRange>)Pair.create((Object)descriptor2, (Object)hostEditableRange));
                    }
                }
            }
            patched.setFromInjection(true);
            out.add(patched);
        }
    }

    @Nullable(value="null means invalid")
    private static @Nullable(value="null means invalid") TextRange findNearestTextRange(DocumentWindow documentWindow, int startOffset) {
        Segment marker;
        ProperTextRange curRange;
        ProperTextRange textRange = null;
        Segment[] segmentArray = documentWindow.getHostRanges();
        int n = segmentArray.length;
        for (int i = 0; i < n && ((curRange = ProperTextRange.create((Segment)(marker = segmentArray[i]))).getStartOffset() <= startOffset || textRange == null); ++i) {
            textRange = curRange;
        }
        return textRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runHighlightVisitorsForInjected(@NotNull PsiFile injectedPsi, @NotNull HighlightInfoHolder holder) {
        if (injectedPsi == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(23);
        }
        if (holder == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(24);
        }
        HighlightVisitor[] filtered2 = this.getHighlightVisitors(injectedPsi);
        try {
            List<PsiElement> elements2 = CollectHighlightsUtil.getElementsInRange((PsiElement)injectedPsi, 0, injectedPsi.getTextLength());
            for (HighlightVisitor visitor : filtered2) {
                visitor.analyze(injectedPsi, true, holder, () -> {
                    for (PsiElement element2 : elements2) {
                        ProgressManager.checkCanceled();
                        visitor.visit(element2);
                    }
                });
            }
        }
        finally {
            this.incVisitorUsageCount(-1);
        }
    }

    private void highlightInjectedSyntax(@NotNull PsiFile injectedPsi, @NotNull HighlightInfoHolder holder) {
        List<InjectedLanguageUtil.TokenInfo> tokens;
        if (injectedPsi == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(25);
        }
        if (holder == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(26);
        }
        if ((tokens = InjectedLanguageUtil.getHighlightTokens(injectedPsi)) == null) {
            return;
        }
        TextAttributes defaultAttrs = this.myGlobalScheme.getAttributes(HighlighterColors.TEXT);
        Place shreds = InjectedLanguageUtil.getShreds(injectedPsi);
        int shredIndex = -1;
        int injectionHostTextRangeStart = -1;
        for (InjectedLanguageUtil.TokenInfo token : tokens) {
            HighlightInfo info;
            TextAttributes forcedAttributes;
            ProgressManager.checkCanceled();
            ProperTextRange range2 = token.rangeInsideInjectionHost;
            if (range2.getLength() == 0) continue;
            if (shredIndex != token.shredIndex) {
                shredIndex = token.shredIndex;
                PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)shreds.get(shredIndex);
                PsiLanguageInjectionHost host = shred.getHost();
                if (host == null) {
                    return;
                }
                injectionHostTextRangeStart = host.getTextRange().getStartOffset();
            }
            TextRange annRange = range2.shiftRight(injectionHostTextRangeStart);
            TextAttributes attributes = token.attributes;
            if (attributes == null || attributes.isEmpty() || attributes.equals((Object)defaultAttrs)) {
                forcedAttributes = TextAttributes.ERASE_MARKER;
            } else {
                info = HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT).range(annRange).textAttributes(TextAttributes.ERASE_MARKER).createUnconditionally();
                holder.add(info);
                forcedAttributes = new TextAttributes(attributes.getForegroundColor(), attributes.getBackgroundColor(), attributes.getEffectColor(), attributes.getEffectType(), attributes.getFontType());
            }
            info = HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT).range(annRange).textAttributes(forcedAttributes).createUnconditionally();
            holder.add(info);
        }
    }

    @Override
    protected void applyInformationWithProgress() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$getInjectedPsiFiles$2(Set outInjected, PsiFile injectedPsi, List places) {
        Set set = outInjected;
        synchronized (set) {
            ProgressManager.checkCanceled();
            outInjected.add(injectedPsi);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoProcessor";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements1";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements2";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedFiles";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outInfos";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 14: 
            case 19: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedPsi";
                break;
            }
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedLanguageManager";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentWindow";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedPsiFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectInformationWithProgress";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedPsiFiles";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addInjectedPsiHighlights";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "queueInfoToUpdateIncrementally";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getFixedTextRange";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addPatchedInfos";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "runHighlightVisitorsForInjected";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "highlightInjectedSyntax";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

