/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.DaemonTooltipUtil;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoNextErrorHandler
implements CodeInsightActionHandler {
    private final boolean myGoForward;

    public GotoNextErrorHandler(boolean goForward) {
        this.myGoForward = goForward;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            GotoNextErrorHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            GotoNextErrorHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            GotoNextErrorHandler.$$$reportNull$$$0(2);
        }
        int caretOffset = editor.getCaretModel().getOffset();
        this.gotoNextError(project, editor, file2, caretOffset);
    }

    public boolean startInWriteAction() {
        return false;
    }

    private void gotoNextError(Project project, Editor editor, PsiFile file2, int caretOffset) {
        int maxSeverity;
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(project);
        for (int idx = maxSeverity = (settings = DaemonCodeAnalyzerSettings.getInstance()).isNextErrorActionGoesToErrorsFirst() ? severityRegistrar.getSeveritiesCount() - 1 : 1; idx >= 1; --idx) {
            HighlightSeverity minSeverity = severityRegistrar.getSeverityByIndex(idx);
            HighlightInfo infoToGo = this.findInfo(project, editor, caretOffset, minSeverity);
            if (infoToGo == null) continue;
            GotoNextErrorHandler.navigateToError(project, editor, infoToGo, () -> {
                if (Registry.is((String)"error.navigation.show.tooltip")) {
                    HighlightInfo fullInfo = ((DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project)).findHighlightByOffset(editor.getDocument(), editor.getCaretModel().getOffset(), false);
                    DaemonTooltipUtil.showInfoTooltip(fullInfo != null ? fullInfo : infoToGo, editor, editor.getCaretModel().getOffset(), 0, false, true);
                }
            });
            return;
        }
        GotoNextErrorHandler.showMessageWhenNoHighlights(project, file2, editor);
    }

    private HighlightInfo findInfo(Project project, Editor editor, int caretOffset, HighlightSeverity minSeverity) {
        Document document = editor.getDocument();
        HighlightInfo[][] infoToGo = new HighlightInfo[2][2];
        int caretOffsetIfNoLuck = this.myGoForward ? -1 : document.getTextLength();
        DaemonCodeAnalyzerEx.processHighlights(document, project, minSeverity, 0, document.getTextLength(), (Processor<? super HighlightInfo>)((Processor)info -> {
            int startOffset = GotoNextErrorHandler.getNavigationPositionFor(info, document);
            if (SeverityRegistrar.isGotoBySeverityEnabled(info.getSeverity())) {
                infoToGo[0][0] = this.getBetterInfoThan(infoToGo[0][0], caretOffset, startOffset, (HighlightInfo)info);
                infoToGo[1][0] = this.getBetterInfoThan(infoToGo[1][0], caretOffsetIfNoLuck, startOffset, (HighlightInfo)info);
            }
            infoToGo[0][1] = this.getBetterInfoThan(infoToGo[0][1], caretOffset, startOffset, (HighlightInfo)info);
            infoToGo[1][1] = this.getBetterInfoThan(infoToGo[1][1], caretOffsetIfNoLuck, startOffset, (HighlightInfo)info);
            return true;
        }));
        if (infoToGo[0][0] == null) {
            infoToGo[0][0] = infoToGo[1][0];
        }
        if (infoToGo[0][1] == null) {
            infoToGo[0][1] = infoToGo[1][1];
        }
        if (infoToGo[0][0] == null) {
            infoToGo[0][0] = infoToGo[0][1];
        }
        return infoToGo[0][0];
    }

    private HighlightInfo getBetterInfoThan(HighlightInfo infoToGo, int caretOffset, int startOffset, HighlightInfo info) {
        if (this.isBetterThan(infoToGo, caretOffset, startOffset)) {
            infoToGo = info;
        }
        return infoToGo;
    }

    private boolean isBetterThan(HighlightInfo oldInfo, int caretOffset, int newOffset) {
        if (oldInfo == null) {
            return true;
        }
        int oldOffset = GotoNextErrorHandler.getNavigationPositionFor(oldInfo, oldInfo.getHighlighter().getDocument());
        if (this.myGoForward) {
            return caretOffset < oldOffset != caretOffset < newOffset ? caretOffset < newOffset : newOffset < oldOffset;
        }
        return caretOffset <= oldOffset != caretOffset <= newOffset ? caretOffset > newOffset : newOffset > oldOffset;
    }

    private static void showMessageWhenNoHighlights(Project project, PsiFile file2, Editor editor) {
        DaemonCodeAnalyzerImpl codeHighlighter = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project);
        String message = codeHighlighter.isErrorAnalyzingFinished(file2) ? InspectionsBundle.message((String)"no.errors.found.in.this.file", (Object[])new Object[0]) : InspectionsBundle.message((String)"error.analysis.is.in.progress", (Object[])new Object[0]);
        HintManager.getInstance().showInformationHint(editor, message);
    }

    static void navigateToError(Project project, Editor editor, HighlightInfo info, @Nullable Runnable postNavigateRunnable) {
        int oldOffset = editor.getCaretModel().getOffset();
        int offset = GotoNextErrorHandler.getNavigationPositionFor(info, editor.getDocument());
        int endOffset = info.getActualEndOffset();
        ScrollingModel scrollingModel = editor.getScrollingModel();
        if (offset != oldOffset) {
            ScrollType scrollType = offset > oldOffset ? ScrollType.CENTER_DOWN : ScrollType.CENTER_UP;
            editor.getSelectionModel().removeSelection();
            editor.getCaretModel().removeSecondaryCarets();
            editor.getCaretModel().moveToOffset(offset);
            scrollingModel.scrollToCaret(scrollType);
            FoldRegion regionAtOffset = editor.getFoldingModel().getCollapsedRegionAtOffset(offset);
            if (regionAtOffset != null) {
                editor.getFoldingModel().runBatchFoldingOperation(() -> regionAtOffset.setExpanded(true));
            }
        }
        scrollingModel.runActionOnScrollingFinished(() -> {
            int maxOffset = editor.getDocument().getTextLength() - 1;
            if (maxOffset == -1) {
                return;
            }
            scrollingModel.scrollTo(editor.offsetToLogicalPosition(Math.min(maxOffset, endOffset)), ScrollType.MAKE_VISIBLE);
            scrollingModel.scrollTo(editor.offsetToLogicalPosition(Math.min(maxOffset, offset)), ScrollType.MAKE_VISIBLE);
            if (postNavigateRunnable != null) {
                postNavigateRunnable.run();
            }
        });
        IdeDocumentHistory.getInstance(project).includeCurrentCommandAsNavigation();
    }

    private static int getNavigationPositionFor(HighlightInfo info, Document document) {
        int start2 = info.getActualStartOffset();
        if (start2 >= document.getTextLength()) {
            return document.getTextLength();
        }
        char c = document.getCharsSequence().charAt(start2);
        int shift = info.isAfterEndOfLine() && c != '\n' ? 1 : info.navigationShift;
        int offset = info.getActualStartOffset() + shift;
        return Math.min(offset, document.getTextLength());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/daemon/impl/GotoNextErrorHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

