/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.ProjectTopics;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.LineMarkerProviders;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.DaemonTooltipUtil;
import com.intellij.codeInsight.daemon.impl.EditorTrackerListener;
import com.intellij.codeInsight.daemon.impl.ErrorStripeUpdateManager;
import com.intellij.codeInsight.daemon.impl.GotoNextErrorHandler;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.IntentionsUI;
import com.intellij.codeInsight.daemon.impl.PsiChangeHandler;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerAdapter;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.lang.ExternalLanguageAnnotators;
import com.intellij.lang.LanguageAnnotators;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEventMulticasterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorMouseHoverPopupControl;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.RefResolveService;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.ThreeState;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DaemonListeners
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DaemonListeners.class);
    private final Project myProject;
    private final DaemonCodeAnalyzerImpl myDaemonCodeAnalyzer;
    private boolean myEscPressed;
    private volatile boolean cutOperationJustHappened;
    private final DaemonCodeAnalyzer.DaemonListener myDaemonEventPublisher;
    private List<Editor> myActiveEditors;
    private static final Key<Boolean> DAEMON_INITIALIZED = Key.create((String)"DAEMON_INITIALIZED");

    public static DaemonListeners getInstance(Project project) {
        return (DaemonListeners)project.getComponent(DaemonListeners.class);
    }

    public DaemonListeners(final @NotNull Project project) {
        if (project == null) {
            DaemonListeners.$$$reportNull$$$0(0);
        }
        this.myActiveEditors = Collections.emptyList();
        this.myProject = project;
        this.myDaemonCodeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)this.myProject);
        boolean replaced = ((UserDataHolderEx)this.myProject).replace(DAEMON_INITIALIZED, null, (Object)Boolean.TRUE);
        if (!replaced) {
            LOG.error("Daemon listeners already initialized for the project " + this.myProject);
        }
        MessageBus messageBus = this.myProject.getMessageBus();
        this.myDaemonEventPublisher = (DaemonCodeAnalyzer.DaemonListener)messageBus.syncPublisher(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC);
        if (project.isDefault()) {
            return;
        }
        MessageBusConnection connection = messageBus.connect();
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            @Override
            public void appClosing() {
                DaemonListeners.this.stopDaemon(false, "App closing");
            }
        });
        EditorFactory editorFactory = EditorFactory.getInstance();
        EditorEventMulticasterEx eventMulticaster = (EditorEventMulticasterEx)editorFactory.getEventMulticaster();
        eventMulticaster.addDocumentListener(new DocumentListener(){

            public void beforeDocumentChange(@NotNull DocumentEvent e) {
                Project project;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                Document document = e.getDocument();
                VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
                Project project2 = project = virtualFile == null ? null : ProjectUtil.guessProjectForFile((VirtualFile)virtualFile);
                if (DaemonListeners.this.worthBothering(document, project) && ApplicationManager.getApplication().isDispatchThread()) {
                    DaemonListeners.this.stopDaemon(true, "Document change");
                    UpdateHighlightersUtil.updateHighlightersByTyping(DaemonListeners.this.myProject, e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/daemon/impl/DaemonListeners$2", "beforeDocumentChange"));
            }
        }, this);
        eventMulticaster.addCaretListener(new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                Editor editor = e.getEditor();
                Application app = ApplicationManager.getApplication();
                if ((editor.getComponent().isShowing() || app.isHeadlessEnvironment()) && DaemonListeners.this.worthBothering(editor.getDocument(), editor.getProject()) && !app.isUnitTestMode()) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if ((editor.getComponent().isShowing() || app.isHeadlessEnvironment()) && !DaemonListeners.this.myProject.isDisposed()) {
                            IntentionsUI.getInstance(DaemonListeners.this.myProject).invalidate();
                        }
                    }, ModalityState.current());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/daemon/impl/DaemonListeners$3", "caretPositionChanged"));
            }
        }, this);
        eventMulticaster.addEditorMouseMotionListener(new MyEditorMouseMotionListener(), this);
        eventMulticaster.addEditorMouseListener(new MyEditorMouseListener(TooltipController.getInstance()), this);
        connection.subscribe(EditorTrackerListener.TOPIC, activeEditors -> {
            if (this.myActiveEditors.equals(activeEditors)) {
                return;
            }
            this.myActiveEditors = activeEditors;
            this.stopDaemon(true, "Active editor change");
            if (ApplicationManager.getApplication().isDispatchThread() && LaterInvocator.isInModalContext()) {
                this.myDaemonCodeAnalyzer.setUpdateByTimerEnabled(true);
            }
            ErrorStripeUpdateManager errorStripeUpdateManager = ErrorStripeUpdateManager.getInstance(this.myProject);
            for (Editor editor : activeEditors) {
                errorStripeUpdateManager.repaintErrorStripePanel(editor);
            }
        });
        editorFactory.addEditorFactoryListener(new EditorFactoryListener(){

            public void editorCreated(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                Editor editor = event.getEditor();
                Document document = editor.getDocument();
                Project editorProject = editor.getProject();
                PsiFile file2 = editorProject == null ? null : PsiDocumentManager.getInstance((Project)editorProject).getPsiFile(document);
                boolean showing2 = editor.getComponent().isShowing();
                boolean worthBothering = DaemonListeners.this.worthBothering(document, editorProject);
                if (!showing2 || !worthBothering) {
                    LOG.debug("Not worth bothering about editor created for : " + file2 + " because editor isShowing(): " + showing2 + "; project is open and file is mine: " + worthBothering);
                    return;
                }
                ErrorStripeUpdateManager.getInstance(DaemonListeners.this.myProject).repaintErrorStripePanel(editor);
            }

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(1);
                }
                UIUtil.invokeLaterIfNeeded(() -> {
                    IntentionsUI intentionUI = (IntentionsUI)DaemonListeners.this.myProject.getServiceIfCreated(IntentionsUI.class);
                    if (intentionUI != null) {
                        intentionUI.invalidate();
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonListeners$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "editorCreated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "editorReleased";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
        PsiChangeHandler changeHandler = new PsiChangeHandler(this.myProject, connection);
        Disposer.register((Disposable)this, (Disposable)changeHandler);
        PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)changeHandler, (Disposable)changeHandler);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    5.$$$reportNull$$$0(0);
                }
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Project roots changed");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/daemon/impl/DaemonListeners$5", "rootsChanged"));
            }
        });
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Dumb mode started");
            }

            public void exitDumbMode() {
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Dumb mode finished");
            }
        });
        connection.subscribe(PowerSaveMode.TOPIC, () -> this.stopDaemon(true, "Power save mode change"));
        connection.subscribe(EditorColorsManager.TOPIC, __ -> this.stopDaemonAndRestartAllFiles("Editor color scheme changed"));
        connection.subscribe(CommandListener.TOPIC, (Object)new MyCommandListener());
        connection.subscribe(ProfileChangeAdapter.TOPIC, (Object)new MyProfileChangeListener());
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new MyApplicationListener(), (Disposable)project);
        connection.subscribe(TodoConfiguration.PROPERTY_CHANGE, (Object)new MyTodoListener());
        connection.subscribe(AnActionListener.TOPIC, (Object)new MyAnActionListener());
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    7.$$$reportNull$$$0(0);
                }
                boolean isDaemonShouldBeStopped = false;
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent instanceof VFilePropertyChangeEvent)) continue;
                    VFilePropertyChangeEvent e = (VFilePropertyChangeEvent)vFileEvent;
                    String propertyName = e.getPropertyName();
                    if ("name".equals(propertyName)) {
                        this.fileRenamed(e);
                    }
                    if (isDaemonShouldBeStopped || propertyName.equals("writable")) continue;
                    isDaemonShouldBeStopped = true;
                }
                if (isDaemonShouldBeStopped) {
                    DaemonListeners.this.stopDaemon(true, "Virtual file property change");
                }
            }

            private void fileRenamed(@NotNull VFilePropertyChangeEvent event) {
                PsiFile psiFile;
                if (event == null) {
                    7.$$$reportNull$$$0(1);
                }
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Virtual file name changed");
                VirtualFile virtualFile = event.getFile();
                PsiFile psiFile2 = psiFile = !virtualFile.isValid() ? null : PsiManagerEx.getInstanceEx(DaemonListeners.this.myProject).getFileManager().getCachedPsiFile(virtualFile);
                if (psiFile == null || DaemonListeners.this.myDaemonCodeAnalyzer.isHighlightingAvailable(psiFile)) {
                    return;
                }
                Document document = FileDocumentManager.getInstance().getCachedDocument(virtualFile);
                if (document == null) {
                    return;
                }
                UpdateHighlightersUtil.setHighlightersToEditor(DaemonListeners.this.myProject, document, 0, document.getTextLength(), Collections.emptyList(), null, 4);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "events";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonListeners$7";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "after";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileRenamed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    8.$$$reportNull$$$0(0);
                }
                IntentionsUI.getInstance(project).invalidate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/daemon/impl/DaemonListeners$8", "fileTypesChanged"));
            }
        });
        eventMulticaster.addErrorStripeListener(e -> {
            RangeHighlighter highlighter = e.getHighlighter();
            if (!highlighter.isValid()) {
                return;
            }
            HighlightInfo info = HighlightInfo.fromRangeHighlighter(highlighter);
            if (info != null) {
                GotoNextErrorHandler.navigateToError(this.myProject, e.getEditor(), info, null);
            }
        }, this);
        LaterInvocator.addModalityStateListener(__ -> {
            boolean inModalContext = Registry.is((String)"ide.perProjectModality") || LaterInvocator.isInModalContext();
            this.stopDaemon(inModalContext, "Modality change. Was modal: " + inModalContext);
            this.myDaemonCodeAnalyzer.setUpdateByTimerEnabled(inModalContext);
        }, this);
        connection.subscribe(SeverityRegistrar.SEVERITIES_CHANGED_TOPIC, () -> this.stopDaemonAndRestartAllFiles("Severities changed"));
        if (RefResolveService.ENABLED) {
            RefResolveService resolveService = RefResolveService.getInstance((Project)project);
            resolveService.addListener((Disposable)this, new RefResolveService.Listener(){

                public void allFilesResolved() {
                    DaemonListeners.this.stopDaemon(true, "RefResolveService is up to date");
                }
            });
        }
        connection.subscribe(FacetManager.FACETS_TOPIC, (Object)new FacetManagerAdapter(){

            public void facetRenamed(@NotNull Facet facet, @NotNull String oldName) {
                if (facet == null) {
                    10.$$$reportNull$$$0(0);
                }
                if (oldName == null) {
                    10.$$$reportNull$$$0(1);
                }
                DaemonListeners.this.stopDaemonAndRestartAllFiles("facet renamed: " + oldName + " -> " + facet.getName());
            }

            public void facetAdded(@NotNull Facet facet) {
                if (facet == null) {
                    10.$$$reportNull$$$0(2);
                }
                DaemonListeners.this.stopDaemonAndRestartAllFiles("facet added: " + facet.getName());
            }

            public void facetRemoved(@NotNull Facet facet) {
                if (facet == null) {
                    10.$$$reportNull$$$0(3);
                }
                DaemonListeners.this.stopDaemonAndRestartAllFiles("facet removed: " + facet.getName());
            }

            public void facetConfigurationChanged(@NotNull Facet facet) {
                if (facet == null) {
                    10.$$$reportNull$$$0(4);
                }
                DaemonListeners.this.stopDaemonAndRestartAllFiles("facet changed: " + facet.getName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "facet";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldName";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonListeners$10";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetRenamed";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetAdded";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetRemoved";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetConfigurationChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.restartOnExtensionChange(LanguageAnnotators.EP_NAME, "annotators list changed");
        this.restartOnExtensionChange(LineMarkerProviders.EP_NAME, "line marker providers list changed");
        this.restartOnExtensionChange(ExternalLanguageAnnotators.EP_NAME, "external annotators list changed");
        connection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    11.$$$reportNull$$$0(0);
                }
                ((PsiModificationTrackerImpl)PsiManager.getInstance((Project)DaemonListeners.this.myProject).getModificationTracker()).incCounter();
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Plugin installed");
            }

            @Override
            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    11.$$$reportNull$$$0(1);
                }
                ((PsiModificationTrackerImpl)PsiManager.getInstance((Project)DaemonListeners.this.myProject).getModificationTracker()).incCounter();
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Plugin will be uninstalled");
                DaemonListeners.this.removeQuickFixesContributedByPlugin(pluginDescriptor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "pluginDescriptor";
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonListeners$11";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginLoaded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforePluginUnload";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private <T, U extends KeyedLazyInstance<T>> void restartOnExtensionChange(ExtensionPointName<U> name, String message) {
        name.addExtensionPointListener(() -> this.stopDaemonAndRestartAllFiles(message), (Disposable)this);
    }

    private boolean worthBothering(Document document, Project project) {
        if (document == null) {
            return true;
        }
        if (project != null && project != this.myProject) {
            return false;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getCachedPsiFile(document);
        return psiFile != null && psiFile.isPhysical() && psiFile.getOriginalFile() == psiFile;
    }

    public void dispose() {
        this.stopDaemonAndRestartAllFiles("Project closed");
        boolean replaced = ((UserDataHolderEx)this.myProject).replace(DAEMON_INITIALIZED, (Object)Boolean.TRUE, (Object)Boolean.FALSE);
        LOG.assertTrue(replaced, (Object)("Daemon listeners already disposed for the project " + this.myProject));
    }

    public static boolean canChangeFileSilently(@NotNull PsiFileSystemItem file2) {
        Project project;
        DaemonListeners listeners;
        if (file2 == null) {
            DaemonListeners.$$$reportNull$$$0(1);
        }
        if ((listeners = DaemonListeners.getInstance(project = file2.getProject())) == null) {
            return true;
        }
        if (listeners.cutOperationJustHappened) {
            return false;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        if (file2 instanceof PsiCodeFragment) {
            return true;
        }
        if (ScratchUtil.isScratch(virtualFile)) {
            return listeners.canUndo(virtualFile);
        }
        if (!ModuleUtilCore.projectContainsFile((Project)project, (VirtualFile)virtualFile, (boolean)false)) {
            return false;
        }
        ThreeState vcs = listeners.mayChangeBasedOnVcsStatus(virtualFile);
        if (vcs != ThreeState.UNSURE) {
            return vcs.toBoolean();
        }
        return listeners.canUndo(virtualFile);
    }

    private boolean canUndo(@NotNull VirtualFile virtualFile) {
        FileEditor[] editors;
        if (virtualFile == null) {
            DaemonListeners.$$$reportNull$$$0(2);
        }
        if ((editors = FileEditorManager.getInstance((Project)this.myProject).getEditors(virtualFile)).length == 0) {
            return false;
        }
        UndoManager undoManager = UndoManager.getInstance((Project)this.myProject);
        for (FileEditor editor : editors) {
            if (!undoManager.isUndoAvailable(editor)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private ThreeState mayChangeBasedOnVcsStatus(@NotNull VirtualFile virtualFile) {
        boolean vcsIsThinking;
        AbstractVcs activeVcs;
        if (virtualFile == null) {
            DaemonListeners.$$$reportNull$$$0(3);
        }
        if ((activeVcs = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(virtualFile)) == null) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                DaemonListeners.$$$reportNull$$$0(4);
            }
            return threeState;
        }
        FilePath path = VcsUtil.getFilePath((VirtualFile)virtualFile);
        boolean bl = vcsIsThinking = !VcsDirtyScopeManager.getInstance((Project)this.myProject).whatFilesDirty(Collections.singletonList(path)).isEmpty();
        if (vcsIsThinking) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                DaemonListeners.$$$reportNull$$$0(5);
            }
            return threeState;
        }
        FileStatus status = FileStatusManager.getInstance((Project)this.myProject).getStatus(virtualFile);
        if (status == FileStatus.UNKNOWN) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                DaemonListeners.$$$reportNull$$$0(6);
            }
            return threeState;
        }
        if (status == FileStatus.MERGE || status == FileStatus.MERGED_WITH_CONFLICTS || status == FileStatus.MERGED_WITH_BOTH_CONFLICTS || status == FileStatus.MERGED_WITH_PROPERTY_CONFLICTS) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                DaemonListeners.$$$reportNull$$$0(7);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.fromBoolean((status != FileStatus.NOT_CHANGED ? 1 : 0) != 0);
        if (threeState == null) {
            DaemonListeners.$$$reportNull$$$0(8);
        }
        return threeState;
    }

    private void stopDaemon(boolean toRestartAlarm, @NonNls @NotNull String reason) {
        if (reason == null) {
            DaemonListeners.$$$reportNull$$$0(9);
        }
        if (this.myDaemonCodeAnalyzer.stopProcess(toRestartAlarm, reason)) {
            this.myDaemonEventPublisher.daemonCancelEventOccurred(reason);
        }
    }

    private void stopDaemonAndRestartAllFiles(@NotNull String reason) {
        if (reason == null) {
            DaemonListeners.$$$reportNull$$$0(10);
        }
        if (this.myDaemonCodeAnalyzer.doRestart(reason) && !this.myProject.isDisposed()) {
            this.myDaemonEventPublisher.daemonCancelEventOccurred(reason);
        }
    }

    private void removeQuickFixesContributedByPlugin(@NotNull IdeaPluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            DaemonListeners.$$$reportNull$$$0(11);
        }
        for (FileEditor fileEditor : FileEditorManager.getInstance((Project)this.myProject).getAllEditors()) {
            if (!(fileEditor instanceof TextEditor)) continue;
            Editor editor = ((TextEditor)fileEditor).getEditor();
            DaemonListeners.removeHighlightersContributedByPlugin(pluginDescriptor, editor.getMarkupModel().getAllHighlighters());
            MarkupModel documentMarkupModel = DocumentMarkupModel.forDocument(editor.getDocument(), this.myProject, false);
            if (documentMarkupModel == null) continue;
            DaemonListeners.removeHighlightersContributedByPlugin(pluginDescriptor, documentMarkupModel.getAllHighlighters());
        }
    }

    private static void removeHighlightersContributedByPlugin(@NotNull IdeaPluginDescriptor pluginDescriptor, RangeHighlighter[] highlighters) {
        if (pluginDescriptor == null) {
            DaemonListeners.$$$reportNull$$$0(12);
        }
        for (RangeHighlighter highlighter : highlighters) {
            List<Pair<HighlightInfo.IntentionActionDescriptor, RangeMarker>> markers;
            HighlightInfo info = HighlightInfo.fromRangeHighlighter(highlighter);
            if (info == null) continue;
            List<Pair<HighlightInfo.IntentionActionDescriptor, TextRange>> ranges = info.quickFixActionRanges;
            if (ranges != null) {
                ranges.removeIf(pair -> DaemonListeners.isContributedByPlugin((HighlightInfo.IntentionActionDescriptor)pair.first, pluginDescriptor));
            }
            if ((markers = info.quickFixActionMarkers) == null) continue;
            markers.removeIf(pair -> DaemonListeners.isContributedByPlugin((HighlightInfo.IntentionActionDescriptor)pair.first, pluginDescriptor));
        }
    }

    private static boolean isContributedByPlugin(@NotNull HighlightInfo.IntentionActionDescriptor intentionActionDescriptor, @NotNull IdeaPluginDescriptor descriptor2) {
        if (intentionActionDescriptor == null) {
            DaemonListeners.$$$reportNull$$$0(13);
        }
        if (descriptor2 == null) {
            DaemonListeners.$$$reportNull$$$0(14);
        }
        IntentionAction action2 = intentionActionDescriptor.getAction();
        PluginId pluginId = PluginManagerCore.getPluginByClassName(action2.getClass().getName());
        return descriptor2.getPluginId().equals(pluginId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/DaemonListeners";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentionActionDescriptor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonListeners";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "mayChangeBasedOnVcsStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "canChangeFileSilently";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canUndo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "mayChangeBasedOnVcsStatus";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "stopDaemon";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "stopDaemonAndRestartAllFiles";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeQuickFixesContributedByPlugin";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeHighlightersContributedByPlugin";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isContributedByPlugin";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyEditorMouseMotionListener
    implements EditorMouseMotionListener {
        private MyEditorMouseMotionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseMoved(@NotNull EditorMouseEvent e) {
            if (e == null) {
                MyEditorMouseMotionListener.$$$reportNull$$$0(0);
            }
            if (Registry.is((String)"ide.disable.editor.tooltips") || Registry.is((String)"editor.new.mouse.hover.popups")) {
                return;
            }
            Editor editor = e.getEditor();
            if (DaemonListeners.this.myProject != editor.getProject()) {
                return;
            }
            if (EditorMouseHoverPopupControl.arePopupsDisabled(editor)) {
                return;
            }
            boolean shown = false;
            try {
                if (e.getArea() == EditorMouseEventArea.EDITING_AREA && !UIUtil.isControlKeyDown((MouseEvent)e.getMouseEvent()) && DocumentationManager.getInstance(DaemonListeners.this.myProject).getDocInfoHint() == null && EditorUtil.isPointOverText(editor, e.getMouseEvent().getPoint())) {
                    LogicalPosition logical = editor.xyToLogicalPosition(e.getMouseEvent().getPoint());
                    int offset = editor.logicalPositionToOffset(logical);
                    HighlightInfo info = DaemonListeners.this.myDaemonCodeAnalyzer.findHighlightByOffset(editor.getDocument(), offset, false);
                    if (info == null || info.getDescription() == null || info.getHighlighter() != null && FoldingUtil.isHighlighterFolded(editor, info.getHighlighter())) {
                        IdeTooltipManager.getInstance().hideCurrent(e.getMouseEvent());
                        return;
                    }
                    DaemonTooltipUtil.showInfoTooltip(info, editor, offset);
                    shown = true;
                }
            }
            finally {
                if (!shown && !TooltipController.getInstance().shouldSurvive(e.getMouseEvent())) {
                    DaemonTooltipUtil.cancelTooltips();
                }
            }
        }

        public void mouseDragged(@NotNull EditorMouseEvent e) {
            if (e == null) {
                MyEditorMouseMotionListener.$$$reportNull$$$0(1);
            }
            if (Registry.is((String)"editor.new.mouse.hover.popups")) {
                return;
            }
            TooltipController.getInstance().cancelTooltips();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonListeners$MyEditorMouseMotionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseMoved";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseDragged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyEditorMouseListener
    implements EditorMouseListener {
        @NotNull
        private final TooltipController myTooltipController;

        MyEditorMouseListener(@NotNull TooltipController tooltipController) {
            if (tooltipController == null) {
                MyEditorMouseListener.$$$reportNull$$$0(0);
            }
            this.myTooltipController = tooltipController;
        }

        public void mouseExited(@NotNull EditorMouseEvent e) {
            if (e == null) {
                MyEditorMouseListener.$$$reportNull$$$0(1);
            }
            if (Registry.is((String)"editor.new.mouse.hover.popups")) {
                return;
            }
            if (!this.myTooltipController.shouldSurvive(e.getMouseEvent())) {
                DaemonTooltipUtil.cancelTooltips();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tooltipController";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonListeners$MyEditorMouseListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseExited";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyAnActionListener
    implements AnActionListener {
        private AnAction cachedEscapeAction;

        private MyAnActionListener() {
        }

        public void beforeActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
            if (action2 == null) {
                MyAnActionListener.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                MyAnActionListener.$$$reportNull$$$0(1);
            }
            if (event == null) {
                MyAnActionListener.$$$reportNull$$$0(2);
            }
            if (this.cachedEscapeAction == null) {
                DaemonListeners.this.myEscPressed = "EditorEscape".equals(event.getActionManager().getId(action2));
                if (DaemonListeners.this.myEscPressed) {
                    this.cachedEscapeAction = action2;
                }
            } else {
                DaemonListeners.this.myEscPressed = this.cachedEscapeAction == action2;
            }
        }

        public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
            Editor editor;
            if (dataContext == null) {
                MyAnActionListener.$$$reportNull$$$0(3);
            }
            if ((editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext)) != null && !DaemonListeners.this.worthBothering(editor.getDocument(), editor.getProject())) {
                return;
            }
            DaemonListeners.this.stopDaemon(true, "Editor typing");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonListeners$MyAnActionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeActionPerformed";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeEditorTyping";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyProfileChangeListener
    implements ProfileChangeAdapter {
        private MyProfileChangeListener() {
        }

        public void profileChanged(InspectionProfile profile) {
            DaemonListeners.this.stopDaemonAndRestartAllFiles("Profile changed");
        }

        public void profileActivated(InspectionProfile oldProfile, @Nullable InspectionProfile profile) {
            DaemonListeners.this.stopDaemonAndRestartAllFiles("Profile activated");
        }

        public void profilesInitialized() {
            UIUtil.invokeLaterIfNeeded(() -> {
                if (DaemonListeners.this.myProject.isDisposed()) {
                    return;
                }
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Inspection profiles activated");
            });
        }
    }

    private class MyTodoListener
    implements PropertyChangeListener {
        private MyTodoListener() {
        }

        @Override
        public void propertyChange(@NotNull PropertyChangeEvent evt) {
            if (evt == null) {
                MyTodoListener.$$$reportNull$$$0(0);
            }
            if ("todoPatterns".equals(evt.getPropertyName())) {
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Todo patterns changed");
            } else if ("multiLine".equals(evt.getPropertyName())) {
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Todo multi-line detection changed");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evt", "com/intellij/codeInsight/daemon/impl/DaemonListeners$MyTodoListener", "propertyChange"));
        }
    }

    private class MyCommandListener
    implements CommandListener {
        private MyCommandListener() {
        }

        public void commandStarted(@NotNull CommandEvent event) {
            Document affectedDocument;
            if (event == null) {
                MyCommandListener.$$$reportNull$$$0(0);
            }
            if (!DaemonListeners.this.worthBothering(affectedDocument = this.extractDocumentFromCommand(event), event.getProject())) {
                return;
            }
            DaemonListeners.this.cutOperationJustHappened = Comparing.strEqual((String)Holder.myCutActionName, (String)event.getCommandName());
            if (!DaemonListeners.this.myDaemonCodeAnalyzer.isRunning()) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("cancelling code highlighting by command:" + event.getCommand());
            }
            DaemonListeners.this.stopDaemon(false, "Command start");
        }

        @Nullable
        private Document extractDocumentFromCommand(@NotNull CommandEvent event) {
            Document affectedDocument;
            if (event == null) {
                MyCommandListener.$$$reportNull$$$0(1);
            }
            if ((affectedDocument = event.getDocument()) != null) {
                return affectedDocument;
            }
            Object id2 = event.getCommandGroupId();
            if (id2 instanceof Document) {
                affectedDocument = (Document)id2;
            } else if (id2 instanceof DocCommandGroupId) {
                affectedDocument = ((DocCommandGroupId)id2).getDocument();
            }
            return affectedDocument;
        }

        public void commandFinished(@NotNull CommandEvent event) {
            Document affectedDocument;
            if (event == null) {
                MyCommandListener.$$$reportNull$$$0(2);
            }
            if (!DaemonListeners.this.worthBothering(affectedDocument = this.extractDocumentFromCommand(event), event.getProject())) {
                return;
            }
            if (DaemonListeners.this.myEscPressed) {
                DaemonListeners.this.myEscPressed = false;
                if (affectedDocument != null && !DaemonListeners.this.myDaemonCodeAnalyzer.getFileStatusMap().allDirtyScopesAreNull(affectedDocument)) {
                    DaemonListeners.this.stopDaemon(true, "Command finish");
                }
            } else if (!DaemonListeners.this.myDaemonCodeAnalyzer.isRunning()) {
                DaemonListeners.this.stopDaemon(true, "Command finish");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonListeners$MyCommandListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "commandStarted";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extractDocumentFromCommand";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "commandFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Holder {
        private static final String myCutActionName = ActionManager.getInstance().getAction("EditorCut").getTemplatePresentation().getText();

        private Holder() {
        }
    }

    private class MyApplicationListener
    implements ApplicationListener {
        private MyApplicationListener() {
        }

        public void beforeWriteActionStart(@NotNull Object action2) {
            if (action2 == null) {
                MyApplicationListener.$$$reportNull$$$0(0);
            }
            if (!DaemonListeners.this.myDaemonCodeAnalyzer.isRunning()) {
                return;
            }
            DaemonListeners.this.stopDaemon(true, "Write action start");
        }

        public void writeActionFinished(@NotNull Object action2) {
            if (action2 == null) {
                MyApplicationListener.$$$reportNull$$$0(1);
            }
            DaemonListeners.this.stopDaemon(true, "Write action finish");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "action";
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonListeners$MyApplicationListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeWriteActionStart";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeActionFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

