/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.codeInsight.actions.LastRunReformatCodeOptionsProvider;
import com.intellij.codeInsight.actions.ReformatFilesOptions;
import com.intellij.codeInsight.actions.TextRangeType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.psi.search.SearchScope;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReformatFilesDialog
extends DialogWrapper
implements ReformatFilesOptions {
    private JPanel myPanel;
    private JCheckBox myOptimizeImports;
    private JCheckBox myOnlyChangedText;
    private JCheckBox myRearrangeEntriesCb;
    private JCheckBox myCleanupCode;
    private final LastRunReformatCodeOptionsProvider myLastRunSettings;

    public ReformatFilesDialog(@NotNull Project project, VirtualFile @NotNull [] files2) {
        if (project == null) {
            ReformatFilesDialog.$$$reportNull$$$0(0);
        }
        if (files2 == null) {
            ReformatFilesDialog.$$$reportNull$$$0(1);
        }
        super(project, true);
        this.$$$setupUI$$$();
        this.myLastRunSettings = new LastRunReformatCodeOptionsProvider(PropertiesComponent.getInstance());
        boolean canTargetVcsChanges = FormatChangedTextUtil.hasChanges(files2, project);
        this.myOnlyChangedText.setEnabled(canTargetVcsChanges);
        this.myOnlyChangedText.setSelected(canTargetVcsChanges && this.myLastRunSettings.getLastTextRangeType() == TextRangeType.VCS_CHANGED_TEXT);
        this.myOptimizeImports.setSelected(this.myLastRunSettings.getLastOptimizeImports());
        this.myCleanupCode.setSelected(this.myLastRunSettings.getLastCodeCleanup());
        this.myRearrangeEntriesCb.setSelected(this.myLastRunSettings.getLastRearrangeCode());
        this.myRearrangeEntriesCb.setEnabled(ReformatFilesDialog.containsAtLeastOneFileToRearrange(files2));
        this.setTitle(CodeInsightBundle.message((String)"dialog.reformat.files.title", (Object[])new Object[0]));
        this.init();
    }

    private static boolean containsAtLeastOneFileToRearrange(VirtualFile @NotNull [] files2) {
        if (files2 == null) {
            ReformatFilesDialog.$$$reportNull$$$0(2);
        }
        for (VirtualFile file2 : files2) {
            Language language;
            FileType fileType = file2.getFileType();
            if (!(fileType instanceof LanguageFileType) || Rearranger.EXTENSION.forLanguage(language = ((LanguageFileType)fileType).getLanguage()) == null) continue;
            return true;
        }
        return false;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Override
    public boolean isOptimizeImports() {
        return this.myOptimizeImports.isSelected();
    }

    @Override
    public TextRangeType getTextRangeType() {
        return this.myOnlyChangedText.isEnabled() && this.myOnlyChangedText.isSelected() ? TextRangeType.VCS_CHANGED_TEXT : TextRangeType.WHOLE_FILE;
    }

    @Override
    public boolean isRearrangeCode() {
        return this.myRearrangeEntriesCb.isSelected();
    }

    @Override
    public boolean isCodeCleanup() {
        return this.myCleanupCode.isSelected();
    }

    protected void doOKAction() {
        super.doOKAction();
        this.myLastRunSettings.saveOptimizeImportsState(this.isOptimizeImports());
        this.myLastRunSettings.saveCodeCleanupState(this.isCodeCleanup());
        if (this.myRearrangeEntriesCb.isEnabled()) {
            this.myLastRunSettings.saveRearrangeCodeState(this.isRearrangeCode());
        }
        if (this.myOnlyChangedText.isEnabled()) {
            this.myLastRunSettings.saveProcessVcsChangedTextState(this.getTextRangeType() == TextRangeType.VCS_CHANGED_TEXT);
        }
    }

    @Override
    @Nullable
    public SearchScope getSearchScope() {
        return null;
    }

    @Override
    @Nullable
    public String getFileTypeMask() {
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 4, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/CodeInsightBundle", ReformatFilesDialog.class).getString("dialog.reformat.files.reformat.selected.files.label"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOptimizeImports = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/CodeInsightBundle", ReformatFilesDialog.class).getString("dialog.reformat.files.optimize.imports.checkbox"));
        jPanel2.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myOnlyChangedText = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/CodeInsightBundle", ReformatFilesDialog.class).getString("reformat.option.vcs.changed.region"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myRearrangeEntriesCb = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/CodeInsightBundle", ReformatFilesDialog.class).getString("checkbox.rearrange.entries"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCleanupCode = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/CodeInsightBundle", ReformatFilesDialog.class).getString("reformat.option.code.cleanup"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/actions/ReformatFilesDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "containsAtLeastOneFileToRearrange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

