/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.group;

import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.application.options.codeStyle.arrangement.ui.ArrangementEditorAware;
import com.intellij.application.options.codeStyle.arrangement.ui.ArrangementRepresentationAware;
import com.intellij.application.options.codeStyle.arrangement.util.ArrangementRuleIndexControl;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementUiComponent;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokenUiRole;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementGroupingComponent
extends JPanel
implements ArrangementRepresentationAware,
ArrangementEditorAware {
    @NotNull
    private final ArrangementUiComponent myGroupingTypeToken;
    @NotNull
    private final ArrangementRuleIndexControl myRowIndexControl;
    @Nullable
    private final ArrangementUiComponent myOrderTypeToken;

    public ArrangementGroupingComponent(@NotNull CompositeArrangementSettingsToken token, @NotNull ArrangementColorsProvider colorsProvider, @NotNull ArrangementStandardSettingsManager settingsManager) throws IllegalArgumentException {
        if (token == null) {
            ArrangementGroupingComponent.$$$reportNull$$$0(0);
        }
        if (colorsProvider == null) {
            ArrangementGroupingComponent.$$$reportNull$$$0(1);
        }
        if (settingsManager == null) {
            ArrangementGroupingComponent.$$$reportNull$$$0(2);
        }
        ArrayList<ArrangementSettingsToken> children2 = new ArrayList<ArrangementSettingsToken>();
        StdArrangementTokenUiRole childRole = null;
        for (CompositeArrangementSettingsToken child2 : token.getChildren()) {
            if (childRole == null) {
                childRole = child2.getRole();
                children2.add(child2.getToken());
                continue;
            }
            if (!childRole.equals((Object)child2.getRole())) {
                throw new IllegalArgumentException(String.format("Can't build a grouping component for token '%s'. Reason: its children has different UI roles (%s and %s)", token, childRole, child2.getRole()));
            }
            children2.add(child2.getToken());
        }
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        int maxWidth = 0;
        for (int i = 0; i <= 99; ++i) {
            maxWidth = Math.max(metrics.stringWidth(String.valueOf(i)), maxWidth);
        }
        int height = metrics.getHeight() - metrics.getDescent() - metrics.getLeading();
        int diameter = Math.max(maxWidth, height) * 5 / 3;
        this.myRowIndexControl = new ArrangementRuleIndexControl(diameter, height);
        this.myGroupingTypeToken = ArrangementUtil.buildUiComponent((StdArrangementTokenUiRole)token.getRole(), Collections.singletonList(token.getToken()), (ArrangementColorsProvider)colorsProvider, (ArrangementStandardSettingsManager)settingsManager);
        if (children2.size() <= 0) {
            this.myOrderTypeToken = null;
        } else {
            assert (childRole != null);
            this.myOrderTypeToken = ArrangementUtil.buildUiComponent((StdArrangementTokenUiRole)childRole, children2, (ArrangementColorsProvider)colorsProvider, (ArrangementStandardSettingsManager)settingsManager);
            this.myGroupingTypeToken.setListener(new ArrangementUiComponent.Listener(){

                public void stateChanged() {
                    ArrangementGroupingComponent.this.myOrderTypeToken.setEnabled(ArrangementGroupingComponent.this.myGroupingTypeToken.isSelected());
                }
            });
        }
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.myRowIndexControl, new GridBag().anchor(10).insets(0, 8, 0, 10));
        this.add((Component)this.myGroupingTypeToken.getUiComponent(), new GridBag().anchor(17).insets(0, 0, 0, 2));
        if (this.myOrderTypeToken != null) {
            this.add((Component)this.myOrderTypeToken.getUiComponent(), new GridBag().anchor(17));
        }
        this.add((Component)new JLabel(" "), new GridBag().weightx(1.0).fillCellHorizontally());
        this.setBackground(UIUtil.getListBackground());
        this.setBorder(JBUI.Borders.empty((int)3));
        this.setOpaque(!UIUtil.isUnderIntelliJLaF() && !UIUtil.isUnderNativeMacLookAndFeel() && !StartupUiUtil.isUnderDarcula());
    }

    @Override
    protected void paintComponent(Graphics g) {
        int baseline;
        Dimension size = this.getSize();
        if (size != null && (baseline = this.myGroupingTypeToken.getBaselineToUse(size.width, size.height)) > 0) {
            this.myRowIndexControl.setBaseLine(baseline -= this.myRowIndexControl.getBounds().y);
        }
        if (UIUtil.isUnderIntelliJLaF() || StartupUiUtil.isUnderDarcula() || UIUtil.isUnderNativeMacLookAndFeel()) {
            g.setColor(this.getBackground());
            g.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
        }
        super.paintComponent(g);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        ArrangementGroupingComponent arrangementGroupingComponent = this;
        if (arrangementGroupingComponent == null) {
            ArrangementGroupingComponent.$$$reportNull$$$0(3);
        }
        return arrangementGroupingComponent;
    }

    public boolean isSelected() {
        return this.myGroupingTypeToken.isSelected();
    }

    public void setSelected(boolean selected2) {
        this.myGroupingTypeToken.setSelected(selected2);
        this.refreshControl();
    }

    private void refreshControl() {
        boolean checked = this.isSelected();
        if (this.myOrderTypeToken != null) {
            this.myOrderTypeToken.setEnabled(checked);
        }
    }

    @NotNull
    public ArrangementSettingsToken getGroupingType() {
        ArrangementSettingsToken token = this.myGroupingTypeToken.getToken();
        assert (token != null);
        ArrangementSettingsToken arrangementSettingsToken = token;
        if (arrangementSettingsToken == null) {
            ArrangementGroupingComponent.$$$reportNull$$$0(4);
        }
        return arrangementSettingsToken;
    }

    public void setOrderType(@NotNull ArrangementSettingsToken type) {
        if (type == null) {
            ArrangementGroupingComponent.$$$reportNull$$$0(5);
        }
        if (this.myOrderTypeToken != null) {
            this.myOrderTypeToken.chooseToken(type);
        }
    }

    public void setRowIndex(int row) {
        this.myRowIndexControl.setIndex(row);
    }

    public void setHighlight(boolean highlight) {
        this.setBackground(highlight ? UIUtil.getDecoratedRowColor() : UIUtil.getListBackground());
    }

    @Nullable
    public ArrangementSettingsToken getOrderType() {
        return this.myOrderTypeToken == null ? null : this.myOrderTypeToken.getToken();
    }

    @Override
    public String toString() {
        return this.myGroupingTypeToken.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsManager";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/arrangement/group/ArrangementGroupingComponent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/arrangement/group/ArrangementGroupingComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupingType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setOrderType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

