/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.lang.html.parser;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.angular2.codeInsight.template.Angular2TemplateElementsScopeProvider;
import org.angular2.lang.Angular2Bundle;
import org.angular2.lang.html.parser.Angular2AttributeType;
import org.angular2.lang.html.psi.Angular2HtmlEvent;
import org.angular2.lang.html.psi.PropertyBindingType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Angular2AttributeNameParser {
    @NonNls
    private static final Map<String, String> ATTR_TO_PROP_MAPPING = ContainerUtil.newHashMap((Pair)Pair.pair((Object)"class", (Object)"className"), (Pair[])new Pair[]{Pair.pair((Object)"for", (Object)"htmlFor"), Pair.pair((Object)"formaction", (Object)"formAction"), Pair.pair((Object)"innerHtml", (Object)"innerHTML"), Pair.pair((Object)"readonly", (Object)"readOnly"), Pair.pair((Object)"tabindex", (Object)"tabIndex")});

    @NotNull
    public static AttributeInfo parseBound(@NotNull String name) {
        if (name == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(0);
        }
        AttributeInfo info = Angular2AttributeNameParser.parse(name);
        return info.type != Angular2AttributeType.REGULAR ? info : new PropertyBindingInfo(info.name, info.isCanonical, false, PropertyBindingType.PROPERTY);
    }

    public static AttributeInfo parse(@NotNull String name) {
        if (name == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(1);
        }
        return Angular2AttributeNameParser.parse(name, "ng-template");
    }

    @NotNull
    public static AttributeInfo parse(@NotNull String name, @Nullable XmlTag tag) {
        if (name == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(2);
        }
        return Angular2AttributeNameParser.parse(name, tag != null ? tag.getLocalName() : "ng-template");
    }

    @NotNull
    public static AttributeInfo parse(@NotNull String name, @NotNull String tagName) {
        if (name == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(3);
        }
        if (tagName == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(4);
        }
        if ((name = Angular2AttributeNameParser.normalizeAttributeName(name)).startsWith("bindon-")) {
            return Angular2AttributeNameParser.parsePropertyBindingCanonical(name.substring(7), true);
        }
        if (name.startsWith("[(") && name.endsWith(")]")) {
            return Angular2AttributeNameParser.parsePropertyBindingShort(name.substring(2, name.length() - 2), true);
        }
        if (name.startsWith("bind-")) {
            return Angular2AttributeNameParser.parsePropertyBindingCanonical(name.substring(5), false);
        }
        if (name.startsWith("[") && name.endsWith("]")) {
            return Angular2AttributeNameParser.parsePropertyBindingShort(name.substring(1, name.length() - 1), false);
        }
        if (name.startsWith("on-")) {
            return Angular2AttributeNameParser.parseEvent(name.substring(3), true);
        }
        if (name.startsWith("(") && name.endsWith(")")) {
            return Angular2AttributeNameParser.parseEvent(name.substring(1, name.length() - 1), false);
        }
        if (name.startsWith("*")) {
            return Angular2AttributeNameParser.parseTemplateBindings(name.substring(1));
        }
        if (name.startsWith("let-")) {
            return Angular2AttributeNameParser.parseVariable(name.substring(4), Angular2TemplateElementsScopeProvider.isTemplateTag(tagName));
        }
        if (name.startsWith("#")) {
            return Angular2AttributeNameParser.parseReference(name.substring(1), false);
        }
        if (name.startsWith("ref-")) {
            return Angular2AttributeNameParser.parseReference(name.substring(4), true);
        }
        if (name.startsWith("@")) {
            return new PropertyBindingInfo(name.substring(1), false, false, PropertyBindingType.ANIMATION);
        }
        if (name.equals("select") && tagName.equals("ng-content")) {
            return new AttributeInfo(name, false, Angular2AttributeType.NG_CONTENT_SELECTOR);
        }
        if (name.startsWith("i18n-")) {
            return new AttributeInfo(name.substring(5), false, Angular2AttributeType.I18N);
        }
        return new AttributeInfo(name, false, Angular2AttributeType.REGULAR);
    }

    @NotNull
    public static String normalizeAttributeName(@NotNull String name) {
        if (name == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(5);
        }
        if (StringUtil.startsWithIgnoreCase((String)name, (String)"data-")) {
            String string = name.substring(5);
            if (string == null) {
                Angular2AttributeNameParser.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = name;
        if (string == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static AttributeInfo parsePropertyBindingShort(@NotNull String name, boolean bananaBoxBinding) {
        if (name == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(8);
        }
        if (!bananaBoxBinding && name.startsWith("@")) {
            return new PropertyBindingInfo(name.substring(1), false, false, PropertyBindingType.ANIMATION);
        }
        return Angular2AttributeNameParser.parsePropertyBindingRest(name, false, bananaBoxBinding);
    }

    @NotNull
    private static AttributeInfo parsePropertyBindingCanonical(@NotNull String name, boolean bananaBoxBinding) {
        if (name == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(9);
        }
        if (!bananaBoxBinding && name.startsWith("animate-")) {
            return new PropertyBindingInfo(name.substring(8), true, false, PropertyBindingType.ANIMATION);
        }
        return Angular2AttributeNameParser.parsePropertyBindingRest(name, true, bananaBoxBinding);
    }

    @NotNull
    private static AttributeInfo parsePropertyBindingRest(@NotNull String name, boolean isCanonical, boolean bananaBoxBinding) {
        if (name == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(10);
        }
        if (name.startsWith("attr.")) {
            return new PropertyBindingInfo(name.substring(5), isCanonical, bananaBoxBinding, PropertyBindingType.ATTRIBUTE);
        }
        if (name.startsWith("class.")) {
            return new PropertyBindingInfo(name.substring(6), isCanonical, bananaBoxBinding, PropertyBindingType.CLASS);
        }
        if (name.startsWith("style.")) {
            return new PropertyBindingInfo(name.substring(6), isCanonical, bananaBoxBinding, PropertyBindingType.STYLE);
        }
        return new PropertyBindingInfo(name, isCanonical, bananaBoxBinding, PropertyBindingType.PROPERTY);
    }

    @NotNull
    private static AttributeInfo parseEvent(@NotNull String name, boolean isCanonical) {
        if (name == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(11);
        }
        if (name.startsWith("@")) {
            name = name.substring(1);
        } else if (name.startsWith("animate-")) {
            name = name.substring(8);
        } else {
            return new EventInfo(name, isCanonical);
        }
        return Angular2AttributeNameParser.parseAnimationEvent(name, isCanonical);
    }

    @NotNull
    private static AttributeInfo parseTemplateBindings(@NotNull String name) {
        if (name == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(12);
        }
        return new AttributeInfo(name, false, Angular2AttributeType.TEMPLATE_BINDINGS);
    }

    @NotNull
    private static AttributeInfo parseAnimationEvent(@NotNull String name, boolean isCanonical) {
        int dot;
        if (name == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(13);
        }
        if ((dot = name.indexOf(46)) < 0) {
            return new EventInfo(name, isCanonical, Angular2HtmlEvent.AnimationPhase.INVALID, Angular2Bundle.message("angular.parse.template.animation-trigger-missing-phase-value", name));
        }
        String phase = StringUtil.toLowerCase((String)name.substring(dot + 1));
        name = name.substring(0, dot);
        if ("done".equals(phase)) {
            return new EventInfo(name, isCanonical, Angular2HtmlEvent.AnimationPhase.DONE);
        }
        if ("start".equals(phase)) {
            return new EventInfo(name, isCanonical, Angular2HtmlEvent.AnimationPhase.START);
        }
        return new EventInfo(name, isCanonical, Angular2HtmlEvent.AnimationPhase.INVALID, Angular2Bundle.message("angular.parse.template.animation-trigger-wrong-output-phase", phase, name.substring(0, dot)));
    }

    @NotNull
    private static AttributeInfo parseVariable(@NotNull String varName, boolean isInTemplateTag) {
        if (varName == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(14);
        }
        if (!isInTemplateTag) {
            return new AttributeInfo(varName, false, Angular2AttributeType.REGULAR, Angular2Bundle.message("angular.parse.template.let-only-on-ng-template", new Object[0]));
        }
        if (varName.contains("-")) {
            return new AttributeInfo(varName, false, Angular2AttributeType.REGULAR, Angular2Bundle.message("angular.parse.template.let-dash-not-allowed-in-name", new Object[0]));
        }
        return new AttributeInfo(varName, false, Angular2AttributeType.VARIABLE);
    }

    @NotNull
    private static AttributeInfo parseReference(@NotNull String refName, boolean isCanonical) {
        if (refName == null) {
            Angular2AttributeNameParser.$$$reportNull$$$0(15);
        }
        if (refName.contains("-")) {
            return new AttributeInfo(refName, false, Angular2AttributeType.REGULAR, Angular2Bundle.message("angular.parse.template.ref-var-dash-not-allowed-in-name", new Object[0]));
        }
        if (refName.isEmpty()) {
            return new AttributeInfo("", false, Angular2AttributeType.REGULAR);
        }
        return new AttributeInfo(refName, isCanonical, Angular2AttributeType.REFERENCE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/lang/html/parser/Angular2AttributeNameParser";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/lang/html/parser/Angular2AttributeNameParser";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeAttributeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseBound";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "normalizeAttributeName";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parsePropertyBindingShort";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parsePropertyBindingCanonical";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parsePropertyBindingRest";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseEvent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseTemplateBindings";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseAnimationEvent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseVariable";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class EventInfo
    extends AttributeInfo {
        @Nullable
        public final Angular2HtmlEvent.AnimationPhase animationPhase;
        @NotNull
        public final Angular2HtmlEvent.EventType eventType;

        public EventInfo(@NotNull String name, boolean isCanonical) {
            if (name == null) {
                EventInfo.$$$reportNull$$$0(0);
            }
            super(name, isCanonical, Angular2AttributeType.EVENT);
            this.eventType = Angular2HtmlEvent.EventType.REGULAR;
            this.animationPhase = null;
        }

        public EventInfo(@NotNull String name, boolean isCanonical, @NotNull Angular2HtmlEvent.AnimationPhase animationPhase) {
            if (name == null) {
                EventInfo.$$$reportNull$$$0(1);
            }
            if (animationPhase == null) {
                EventInfo.$$$reportNull$$$0(2);
            }
            this(name, isCanonical, animationPhase, null);
        }

        public EventInfo(@NotNull String name, boolean isCanonical, @NotNull Angular2HtmlEvent.AnimationPhase animationPhase, @Nullable String error) {
            if (name == null) {
                EventInfo.$$$reportNull$$$0(3);
            }
            if (animationPhase == null) {
                EventInfo.$$$reportNull$$$0(4);
            }
            super(name, isCanonical, Angular2AttributeType.EVENT, error);
            this.animationPhase = animationPhase;
            this.eventType = Angular2HtmlEvent.EventType.ANIMATION;
        }

        @Override
        public boolean isEquivalent(@Nullable AttributeInfo otherInfo) {
            return otherInfo instanceof EventInfo && this.eventType == ((EventInfo)otherInfo).eventType && this.animationPhase == ((EventInfo)otherInfo).animationPhase && super.isEquivalent(otherInfo);
        }

        @Override
        public String getFullName() {
            if (this.eventType == Angular2HtmlEvent.EventType.ANIMATION) {
                if (this.animationPhase != null) {
                    switch (this.animationPhase) {
                        case DONE: {
                            return "@" + this.name + ".done";
                        }
                        case START: {
                            return "@" + this.name + ".start";
                        }
                    }
                }
                return "@" + this.name;
            }
            return this.name;
        }

        @Override
        public String toString() {
            return "<" + this.name + ", " + (Object)((Object)this.eventType) + (this.eventType == Angular2HtmlEvent.EventType.ANIMATION ? ", " + (Object)((Object)this.animationPhase) : "") + ">";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "animationPhase";
                    break;
                }
            }
            objectArray[1] = "org/angular2/lang/html/parser/Angular2AttributeNameParser$EventInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PropertyBindingInfo
    extends AttributeInfo {
        @NotNull
        public final PropertyBindingType bindingType;

        public PropertyBindingInfo(@NotNull String name, boolean isCanonical, boolean bananaBoxBinding, @NotNull PropertyBindingType bindingType) {
            if (name == null) {
                PropertyBindingInfo.$$$reportNull$$$0(0);
            }
            if (bindingType == null) {
                PropertyBindingInfo.$$$reportNull$$$0(1);
            }
            super(ATTR_TO_PROP_MAPPING.getOrDefault(name, name), isCanonical, bananaBoxBinding ? Angular2AttributeType.BANANA_BOX_BINDING : Angular2AttributeType.PROPERTY_BINDING);
            this.bindingType = bindingType;
        }

        @Override
        public boolean isEquivalent(@Nullable AttributeInfo otherInfo) {
            return otherInfo instanceof PropertyBindingInfo && this.bindingType == ((PropertyBindingInfo)otherInfo).bindingType && super.isEquivalent(otherInfo);
        }

        @Override
        public String getFullName() {
            switch (this.bindingType) {
                case ANIMATION: {
                    return (this.isCanonical ? "animate-" : "@") + this.name;
                }
                case ATTRIBUTE: {
                    return "attr." + this.name;
                }
                case STYLE: {
                    return "style." + this.name;
                }
                case CLASS: {
                    return "class." + this.name;
                }
            }
            return this.name;
        }

        @Override
        public String toString() {
            return "<" + this.name + "," + (Object)((Object)this.bindingType) + ">";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "bindingType";
                    break;
                }
            }
            objectArray[1] = "org/angular2/lang/html/parser/Angular2AttributeNameParser$PropertyBindingInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class AttributeInfo {
        @NotNull
        public final String name;
        @Nullable
        public final String error;
        @NotNull
        public final Angular2AttributeType type;
        public final boolean isCanonical;

        public AttributeInfo(@NotNull String name, boolean isCanonical, @NotNull Angular2AttributeType type) {
            if (name == null) {
                AttributeInfo.$$$reportNull$$$0(0);
            }
            if (type == null) {
                AttributeInfo.$$$reportNull$$$0(1);
            }
            this(name, isCanonical, type, null);
        }

        public AttributeInfo(@NotNull String name, boolean isCanonical, @NotNull Angular2AttributeType type, @Nullable String error) {
            if (name == null) {
                AttributeInfo.$$$reportNull$$$0(2);
            }
            if (type == null) {
                AttributeInfo.$$$reportNull$$$0(3);
            }
            this.name = name;
            this.error = error;
            this.type = type;
            this.isCanonical = isCanonical;
        }

        public boolean isEquivalent(@Nullable AttributeInfo otherInfo) {
            return otherInfo != null && this.name.equals(otherInfo.name) && this.type == otherInfo.type;
        }

        public String getFullName() {
            return this.name;
        }

        public String toString() {
            return "<" + this.name + ">";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
            }
            objectArray[1] = "org/angular2/lang/html/parser/Angular2AttributeNameParser$AttributeInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

