/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.index;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.impl.JSPropertyImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.stubs.JSClassStub;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElementStructure;
import com.intellij.lang.javascript.psi.stubs.TypeScriptClassStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.angular2.Angular2DecoratorUtil;
import org.angular2.entities.Angular2Component;
import org.angular2.entities.Angular2EntitiesProvider;
import org.angular2.entities.Angular2EntityUtils;
import org.angular2.entities.ivy.Angular2IvySymbolDef;
import org.angular2.index.Angular2IvyDirectiveIndex;
import org.angular2.index.Angular2IvyModuleIndex;
import org.angular2.index.Angular2IvyPipeIndex;
import org.angular2.index.Angular2SourceDirectiveIndex;
import org.angular2.index.Angular2SourceModuleIndex;
import org.angular2.index.Angular2SourcePipeIndex;
import org.angular2.index.Angular2TemplateUrlIndex;
import org.angular2.lang.Angular2Bundle;
import org.angular2.lang.expr.Angular2Language;
import org.angular2.lang.html.Angular2HtmlLanguage;
import org.angularjs.index.AngularIndexUtil;
import org.angularjs.index.AngularSymbolIndex;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Angular2IndexingHandler
extends FrameworkIndexingHandler {
    public static final String REQUIRE = "require";
    @NonNls
    private static final String ANGULAR2_TEMPLATE_URLS_INDEX_USER_STRING = "a2tui";
    @NonNls
    private static final String ANGULAR2_PIPE_INDEX_USER_STRING = "a2pi";
    @NonNls
    private static final String ANGULAR2_DIRECTIVE_INDEX_USER_STRING = "a2di";
    @NonNls
    private static final String ANGULAR2_MODULE_INDEX_USER_STRING = "a2mi";
    @NonNls
    private static final String PIPE_TYPE = "P;;;";
    @NonNls
    private static final String DIRECTIVE_TYPE = "D;;;";
    @NonNls
    private static final String MODULE_TYPE = "M;;;";
    @NonNls
    public static final String NG_MODULE_INDEX_NAME = "ngModule";
    @NonNls
    private static final String STYLESHEET_INDEX_PREFIX = "ss/";
    public static final TokenSet TS_CLASS_TOKENS = TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.TYPESCRIPT_CLASS, JSStubElementTypes.TYPESCRIPT_CLASS_EXPRESSION});
    private static final Set<String> STUBBED_PROPERTIES = ContainerUtil.newHashSet((Object[])new String[]{"templateUrl", "styleUrls", "selector", "inputs", "outputs"});
    private static final Set<String> STUBBED_DECORATORS_STRING_ARGS = ContainerUtil.newHashSet((Object[])new String[]{"Input", "Output", "Attribute"});
    private static final Map<String, StubIndexKey<String, JSImplicitElementProvider>> INDEX_MAP = new HashMap<String, StubIndexKey<String, JSImplicitElementProvider>>();

    public static boolean isPipe(@NotNull JSImplicitElement element) {
        if (element == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(0);
        }
        return element instanceof JSImplicitElementImpl && PIPE_TYPE.equals(element.getTypeString());
    }

    public static boolean isDirective(@NotNull JSImplicitElement element) {
        if (element == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(1);
        }
        if (!(element instanceof JSImplicitElementImpl)) {
            return false;
        }
        String type = element.getTypeString();
        if (type == null) {
            return false;
        }
        return type.startsWith(DIRECTIVE_TYPE);
    }

    public static boolean isModule(@NotNull JSImplicitElement element) {
        if (element == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(2);
        }
        return element instanceof JSImplicitElementImpl && MODULE_TYPE.equals(element.getTypeString());
    }

    public static boolean isDecoratorStringArgStubbed(@NotNull ES6Decorator decorator) {
        if (decorator == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(3);
        }
        return STUBBED_DECORATORS_STRING_ARGS.contains(decorator.getDecoratorName());
    }

    public boolean shouldCreateStubForLiteral(ASTNode node) {
        return this.checkIsInterestingPropertyValue(node.getTreeParent());
    }

    public boolean shouldCreateStubForCallExpression(ASTNode node) {
        ASTNode parent = node.getTreeParent();
        if (parent != null && parent.getElementType() == JSStubElementTypes.ES6_DECORATOR) {
            ASTNode methodExpression = node.getFirstChildNode();
            if (methodExpression.getElementType() != JSElementTypes.REFERENCE_EXPRESSION) {
                return false;
            }
            ASTNode referencedNameElement = methodExpression.getFirstChildNode();
            String decoratorName = referencedNameElement.getText();
            return STUBBED_DECORATORS_STRING_ARGS.contains(decoratorName);
        }
        return false;
    }

    private boolean checkIsInterestingPropertyValue(@Nullable ASTNode parent) {
        if (parent == null) {
            return false;
        }
        if (parent.getElementType() == JSElementTypes.ARGUMENT_LIST) {
            ASTNode grandParent = parent.getTreeParent();
            return grandParent != null && grandParent.getElementType() == JSStubElementTypes.CALL_EXPRESSION && this.shouldCreateStubForCallExpression(grandParent);
        }
        if (parent.getElementType() == JSElementTypes.ARRAY_LITERAL_EXPRESSION) {
            parent = parent.getTreeParent();
        }
        if (parent != null && parent.getElementType() == JSStubElementTypes.PROPERTY) {
            ASTNode identifier = JSPropertyImpl.findNameIdentifier((ASTNode)parent);
            String propName = identifier != null ? JSPsiImplUtils.getNameFromIdentifier((ASTNode)identifier) : null;
            return propName != null && STUBBED_PROPERTIES.contains(propName);
        }
        return false;
    }

    public boolean hasSignificantValue(@NotNull JSLiteralExpression expression) {
        if (expression == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(4);
        }
        return this.shouldCreateStubForLiteral(expression.getNode());
    }

    @Nullable
    public JSElementIndexingDataImpl processDecorator(@NotNull ES6Decorator decorator, @Nullable JSElementIndexingDataImpl data) {
        TypeScriptClass enclosingClass;
        if (decorator == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(5);
        }
        if ((enclosingClass = Angular2DecoratorUtil.getClassForDecoratorElement((PsiElement)decorator)) != null) {
            String decoratorName = decorator.getDecoratorName();
            boolean isComponent = false;
            if ("Pipe".equals(decoratorName)) {
                if (data == null) {
                    data = new JSElementIndexingDataImpl();
                }
                Angular2IndexingHandler.addPipe(enclosingClass, (Consumer<? super JSImplicitElement>)((Consumer)arg_0 -> ((JSElementIndexingDataImpl)data).addImplicitElement(arg_0)), Angular2DecoratorUtil.getPropertyValue(decorator, "name"));
            } else if ("Directive".equals(decoratorName) || (isComponent = "Component".equals(decoratorName))) {
                if (data == null) {
                    data = new JSElementIndexingDataImpl();
                }
                String selector = Angular2DecoratorUtil.getPropertyValue(decorator, "selector");
                Angular2IndexingHandler.addDirective(enclosingClass, (Consumer<? super JSImplicitElement>)((Consumer)arg_0 -> ((JSElementIndexingDataImpl)data).addImplicitElement(arg_0)), selector);
                if (isComponent) {
                    Angular2IndexingHandler.addComponentExternalFilesRefs(decorator, "", (Consumer<? super JSImplicitElement>)((Consumer)arg_0 -> ((JSElementIndexingDataImpl)data).addImplicitElement(arg_0)), ContainerUtil.packNullables((Object[])new String[]{Angular2IndexingHandler.getTemplateFileUrl(decorator)}));
                    Angular2IndexingHandler.addComponentExternalFilesRefs(decorator, STYLESHEET_INDEX_PREFIX, (Consumer<? super JSImplicitElement>)((Consumer)arg_0 -> ((JSElementIndexingDataImpl)data).addImplicitElement(arg_0)), Angular2IndexingHandler.getStylesUrls(decorator));
                }
            } else if ("NgModule".equals(decoratorName)) {
                if (data == null) {
                    data = new JSElementIndexingDataImpl();
                }
                Angular2IndexingHandler.addModule(enclosingClass, (Consumer<JSImplicitElement>)((Consumer)arg_0 -> ((JSElementIndexingDataImpl)data).addImplicitElement(arg_0)));
            }
        }
        return data;
    }

    public boolean indexImplicitElement(@NotNull JSImplicitElementStructure element, @Nullable IndexSink sink) {
        StubIndexKey<String, JSImplicitElementProvider> index;
        if (element == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(6);
        }
        if (sink == null) {
            return false;
        }
        String userID = element.getUserString();
        StubIndexKey<String, JSImplicitElementProvider> stubIndexKey = index = userID != null ? INDEX_MAP.get(userID) : null;
        if (index == Angular2SourceDirectiveIndex.KEY) {
            String type = element.toImplicitElement(null).getTypeString();
            if (type != null && type.startsWith(DIRECTIVE_TYPE)) {
                type = type.substring(DIRECTIVE_TYPE.length());
                StringUtil.split((String)type, (String)"/").forEach(name -> sink.occurrence(index, name));
            }
            return true;
        }
        if (index != null) {
            sink.occurrence(index, (Object)element.getName());
            if (index == Angular2SourcePipeIndex.KEY) {
                sink.occurrence(AngularSymbolIndex.KEY, (Object)element.getName());
            } else {
                return true;
            }
        }
        return false;
    }

    public void indexClassStub(@NotNull JSClassStub<?> jsClassStub, @NotNull IndexSink sink) {
        Angular2IvySymbolDef.Entity entityDef;
        if (jsClassStub == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(7);
        }
        if (sink == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(8);
        }
        if (jsClassStub instanceof TypeScriptClassStub && (entityDef = Angular2IvySymbolDef.get((TypeScriptClassStub)jsClassStub)) != null) {
            String selector;
            if (entityDef instanceof Angular2IvySymbolDef.Module) {
                sink.occurrence(Angular2IvyModuleIndex.KEY, (Object)NG_MODULE_INDEX_NAME);
            } else if (entityDef instanceof Angular2IvySymbolDef.Pipe) {
                String name = ((Angular2IvySymbolDef.Pipe)entityDef).getName();
                if (name != null) {
                    sink.occurrence(Angular2IvyPipeIndex.KEY, (Object)name);
                    sink.occurrence(AngularSymbolIndex.KEY, (Object)name);
                }
            } else if (entityDef instanceof Angular2IvySymbolDef.Directive && (selector = ((Angular2IvySymbolDef.Directive)entityDef).getSelector()) != null) {
                for (String indexName : Angular2EntityUtils.getDirectiveIndexNames(selector.trim())) {
                    sink.occurrence(Angular2IvyDirectiveIndex.KEY, (Object)indexName);
                }
            }
        }
    }

    private static void addComponentExternalFilesRefs(@NotNull ES6Decorator decorator, @NotNull String namePrefix, @NotNull Consumer<? super JSImplicitElement> processor, @NotNull List<String> fileUrls) {
        if (decorator == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(9);
        }
        if (namePrefix == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(11);
        }
        if (fileUrls == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(12);
        }
        for (String fileUrl : fileUrls) {
            int lastSlash = fileUrl.lastIndexOf(47);
            String name = fileUrl.substring(lastSlash + 1);
            if ((lastSlash <= 0 || lastSlash == 1 && fileUrl.charAt(0) == '.') && FileUtilRt.getNameWithoutExtension((String)name).equals(FileUtilRt.getNameWithoutExtension((String)decorator.getContainingFile().getOriginalFile().getName()))) continue;
            JSImplicitElementImpl.Builder elementBuilder = new JSImplicitElementImpl.Builder(namePrefix + name, (PsiElement)decorator).setUserString(ANGULAR2_TEMPLATE_URLS_INDEX_USER_STRING);
            processor.consume((Object)elementBuilder.toImplicitElement());
        }
    }

    private static void addDirective(@NotNull TypeScriptClass directiveClass, @NotNull Consumer<? super JSImplicitElement> processor, @NonNls @Nullable String selector) {
        Set<Object> indexNames;
        if (directiveClass == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(13);
        }
        if (processor == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(14);
        }
        if (selector == null) {
            selector = "<null>";
            indexNames = Collections.emptySet();
        } else {
            indexNames = Angular2EntityUtils.getDirectiveIndexNames(selector.trim());
        }
        JSImplicitElementImpl directive = new JSImplicitElementImpl.Builder((String)ObjectUtils.notNull((Object)directiveClass.getName(), (Object)selector), (PsiElement)directiveClass).setType(JSImplicitElement.Type.Class).setTypeString(DIRECTIVE_TYPE + StringUtil.join(indexNames, (String)"/")).setUserString(ANGULAR2_DIRECTIVE_INDEX_USER_STRING).toImplicitElement();
        processor.consume((Object)directive);
    }

    private static void addPipe(@NotNull TypeScriptClass pipeClass, @NotNull Consumer<? super JSImplicitElement> processor, @NonNls @Nullable String pipe) {
        if (pipeClass == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(15);
        }
        if (processor == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(16);
        }
        if (pipe == null) {
            pipe = Angular2Bundle.message("angular.description.unnamed", new Object[0]);
        }
        JSImplicitElementImpl pipeElement = new JSImplicitElementImpl.Builder(pipe, (PsiElement)pipeClass).setUserString(ANGULAR2_PIPE_INDEX_USER_STRING).setTypeString(PIPE_TYPE).setType(JSImplicitElement.Type.Class).toImplicitElement();
        processor.consume((Object)pipeElement);
    }

    private static void addModule(@NotNull TypeScriptClass moduleClass, @NotNull Consumer<JSImplicitElement> processor) {
        if (moduleClass == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(17);
        }
        if (processor == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(18);
        }
        JSImplicitElementImpl pipeElement = new JSImplicitElementImpl.Builder(NG_MODULE_INDEX_NAME, (PsiElement)moduleClass).setUserString(ANGULAR2_MODULE_INDEX_USER_STRING).setTypeString(MODULE_TYPE).setType(JSImplicitElement.Type.Class).toImplicitElement();
        processor.consume((Object)pipeElement);
    }

    @Nullable
    public static TypeScriptClass findComponentClass(@NotNull PsiElement context) {
        if (context == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(19);
        }
        return (TypeScriptClass)ContainerUtil.getFirstItem(Angular2IndexingHandler.findComponentClasses(context));
    }

    @NotNull
    public static List<TypeScriptClass> findComponentClasses(@NotNull PsiElement context) {
        PsiFile file;
        if (context == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(20);
        }
        if ((file = context.getContainingFile()) == null || !file.getLanguage().isKindOf((Language)Angular2HtmlLanguage.INSTANCE) && !file.getLanguage().is((Language)Angular2Language.INSTANCE) && !Angular2IndexingHandler.isStylesheet(file)) {
            List<TypeScriptClass> list = Collections.emptyList();
            if (list == null) {
                Angular2IndexingHandler.$$$reportNull$$$0(21);
            }
            return list;
        }
        PsiFile hostFile = Angular2IndexingHandler.getHostFile(context);
        if (hostFile == null) {
            List<TypeScriptClass> list = Collections.emptyList();
            if (list == null) {
                Angular2IndexingHandler.$$$reportNull$$$0(22);
            }
            return list;
        }
        if (!file.getOriginalFile().equals(hostFile) && DialectDetector.isTypeScript((PsiElement)hostFile)) {
            List list = ContainerUtil.packNullables((Object[])new TypeScriptClass[]{Angular2DecoratorUtil.getClassForDecoratorElement((PsiElement)InjectedLanguageManager.getInstance((Project)context.getProject()).getInjectionHost((PsiElement)file.getOriginalFile()))});
            if (list == null) {
                Angular2IndexingHandler.$$$reportNull$$$0(23);
            }
            return list;
        }
        SmartList result = new SmartList(Angular2IndexingHandler.resolveComponentsFromSimilarFile(hostFile));
        if (!result.isEmpty() && !Angular2IndexingHandler.isStylesheet(file)) {
            SmartList smartList = result;
            if (smartList == null) {
                Angular2IndexingHandler.$$$reportNull$$$0(24);
            }
            return smartList;
        }
        result.addAll(Angular2IndexingHandler.resolveComponentsFromIndex(hostFile));
        SmartList smartList = result;
        if (smartList == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(25);
        }
        return smartList;
    }

    @NotNull
    private static List<TypeScriptClass> resolveComponentsFromSimilarFile(@NotNull PsiFile file) {
        PsiFile directiveFile;
        if (file == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(26);
        }
        String name = file.getViewProvider().getVirtualFile().getNameWithoutExtension();
        PsiDirectory dir = file.getParent();
        PsiFile psiFile = directiveFile = dir != null ? dir.findFile(name + ".ts") : null;
        if (directiveFile != null) {
            List list = ((StreamEx)StreamEx.of((Collection)JSStubBasedPsiTreeUtil.findDescendants(directiveFile, (TokenSet)TS_CLASS_TOKENS)).select(TypeScriptClass.class).filter(cls -> {
                ES6Decorator dec = Angular2DecoratorUtil.findDecorator((JSAttributeListOwner)cls, "Component");
                return Angular2IndexingHandler.hasFileReference(dec, file);
            })).toList();
            if (list == null) {
                Angular2IndexingHandler.$$$reportNull$$$0(27);
            }
            return list;
        }
        List<TypeScriptClass> list = Collections.emptyList();
        if (list == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(28);
        }
        return list;
    }

    @NotNull
    private static List<TypeScriptClass> resolveComponentsFromIndex(@NotNull PsiFile file) {
        if (file == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(29);
        }
        String name = (Angular2IndexingHandler.isStylesheet(file) ? STYLESHEET_INDEX_PREFIX : "") + file.getViewProvider().getVirtualFile().getName();
        SmartList result = new SmartList();
        AngularIndexUtil.multiResolve(file.getProject(), Angular2TemplateUrlIndex.KEY, name, (Processor<? super JSImplicitElement>)((Processor)arg_0 -> Angular2IndexingHandler.lambda$resolveComponentsFromIndex$2(file, (List)result, arg_0)));
        SmartList smartList = result;
        if (smartList == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(30);
        }
        return smartList;
    }

    private static boolean hasFileReference(@Nullable ES6Decorator componentDecorator, @NotNull PsiFile file) {
        Angular2Component component;
        if (file == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(31);
        }
        if ((component = Angular2EntitiesProvider.getComponent((PsiElement)componentDecorator)) != null) {
            return Angular2IndexingHandler.isStylesheet(file) ? component.getCssFiles().contains(file) : file.equals(component.getTemplateFile());
        }
        return false;
    }

    private static boolean isStylesheet(@NotNull PsiFile file) {
        if (file == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(32);
        }
        return file instanceof StylesheetFile;
    }

    @Nullable
    private static String getTemplateFileUrl(@NotNull ES6Decorator decorator) {
        String templateUrl;
        if (decorator == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(33);
        }
        if ((templateUrl = Angular2DecoratorUtil.getPropertyValue(decorator, "templateUrl")) != null) {
            return templateUrl;
        }
        JSProperty property = Angular2DecoratorUtil.getProperty(decorator, "template");
        if (property != null) {
            return Angular2IndexingHandler.getExprReferencedFileUrl(property.getValue());
        }
        return null;
    }

    @NotNull
    private static List<String> getStylesUrls(@NotNull ES6Decorator decorator) {
        if (decorator == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(34);
        }
        SmartList result = new SmartList();
        BiConsumer<String, Function> urlsGetts = (arg_0, arg_1) -> Angular2IndexingHandler.lambda$getStylesUrls$4(decorator, (List)result, arg_0, arg_1);
        urlsGetts.accept("styleUrls", Angular2DecoratorUtil::getExpressionStringValue);
        urlsGetts.accept("styles", Angular2IndexingHandler::getExprReferencedFileUrl);
        SmartList smartList = result;
        if (smartList == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(35);
        }
        return smartList;
    }

    @Nullable
    public static String getExprReferencedFileUrl(@Nullable JSExpression expression) {
        if (expression instanceof JSReferenceExpression) {
            for (PsiElement resolvedElement : AngularIndexUtil.resolveLocally((JSReferenceExpression)expression)) {
                ES6FromClause from;
                if (!(resolvedElement instanceof ES6ImportedBinding) || (from = (ES6FromClause)ObjectUtils.doIfNotNull((Object)((ES6ImportedBinding)resolvedElement).getDeclaration(), ES6ImportExportDeclaration::getFromClause)) == null) continue;
                return (String)ObjectUtils.doIfNotNull((Object)from.getReferenceText(), StringUtil::unquoteString);
            }
        } else if (expression instanceof JSCallExpression) {
            JSReferenceExpression referenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)((JSCallExpression)expression).getMethodExpression(), JSReferenceExpression.class);
            JSExpression[] arguments = ((JSCallExpression)expression).getArguments();
            if (arguments.length == 1 && arguments[0] instanceof JSLiteralExpression && ((JSLiteralExpression)arguments[0]).isQuotedLiteral() && referenceExpression != null && referenceExpression.getQualifier() == null && REQUIRE.equals(referenceExpression.getReferenceName())) {
                return ((JSLiteralExpression)arguments[0]).getStringValue();
            }
        }
        return null;
    }

    @Nullable
    private static PsiFile getHostFile(@NotNull PsiElement context) {
        PsiElement original;
        if (context == null) {
            Angular2IndexingHandler.$$$reportNull$$$0(36);
        }
        PsiFile hostFile = FileContextUtil.getContextFile((PsiElement)((original = CompletionUtil.getOriginalOrSelf((PsiElement)context)) != context ? original : context.getContainingFile().getOriginalFile()));
        return hostFile != null ? hostFile.getOriginalFile() : null;
    }

    private static /* synthetic */ void lambda$getStylesUrls$4(ES6Decorator decorator, List result, String name, Function func) {
        List cfr_ignored_0 = (List)StreamEx.of((Object)name).map(prop -> Angular2DecoratorUtil.getProperty(decorator, prop)).nonNull().map(JSProperty::getValue).select(JSArrayLiteralExpression.class).flatArray(JSArrayLiteralExpression::getExpressions).map(func).nonNull().into((Collection)result);
    }

    private static /* synthetic */ boolean lambda$resolveComponentsFromIndex$2(PsiFile file, List result, JSImplicitElement el) {
        PsiElement componentDecorator;
        if (el != null && (componentDecorator = el.getParent()) instanceof ES6Decorator && Angular2IndexingHandler.hasFileReference((ES6Decorator)componentDecorator, file)) {
            ContainerUtil.addIfNotNull((Collection)result, (Object)Angular2DecoratorUtil.getClassForDecoratorElement(componentDecorator));
        }
        return true;
    }

    static {
        INDEX_MAP.put(ANGULAR2_TEMPLATE_URLS_INDEX_USER_STRING, Angular2TemplateUrlIndex.KEY);
        INDEX_MAP.put(ANGULAR2_DIRECTIVE_INDEX_USER_STRING, Angular2SourceDirectiveIndex.KEY);
        INDEX_MAP.put(ANGULAR2_PIPE_INDEX_USER_STRING, Angular2SourcePipeIndex.KEY);
        INDEX_MAP.put(ANGULAR2_MODULE_INDEX_USER_STRING, Angular2SourceModuleIndex.KEY);
        for (String key : INDEX_MAP.keySet()) {
            JSImplicitElement.ourUserStringsRegistry.registerUserString(key);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClassStub";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namePrefix";
                break;
            }
            case 11: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileUrls";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directiveClass";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pipeClass";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleClass";
                break;
            }
            case 19: 
            case 20: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/index/Angular2IndexingHandler";
                break;
            }
            case 26: 
            case 29: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/index/Angular2IndexingHandler";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "findComponentClasses";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveComponentsFromSimilarFile";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveComponentsFromIndex";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getStylesUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isPipe";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isDirective";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isModule";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isDecoratorStringArgStubbed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasSignificantValue";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processDecorator";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "indexImplicitElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "indexClassStub";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addComponentExternalFilesRefs";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addDirective";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addPipe";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addModule";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findComponentClass";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findComponentClasses";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 35: {
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "resolveComponentsFromSimilarFile";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "resolveComponentsFromIndex";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "hasFileReference";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isStylesheet";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateFileUrl";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getStylesUrls";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getHostFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

