/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.cli;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.javascript.JSRunConfigurationBuilder;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.packageJson.notification.PackageJsonGetDependenciesAction;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import icons.AngularJSIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.angular2.cli.config.AngularConfig;
import org.angular2.cli.config.AngularConfigProvider;
import org.angular2.lang.Angular2Bundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularCliUtil {
    private static final NotificationGroup ANGULAR_CLI_NOTIFICATIONS = new NotificationGroup("Angular CLI", NotificationDisplayType.BALLOON, false, null, AngularJSIcons.Angular2, Angular2Bundle.message("angular.description.angular-cli", new Object[0]), null);
    @NonNls
    private static final List<String> ANGULAR_JSON_NAMES = ContainerUtil.newArrayList((Object[])new String[]{"angular.json", ".angular-cli.json", "angular-cli.json"});
    @NonNls
    private static final String NG_CLI_DEFAULT_ADDRESS = "http://localhost:4200";

    @Nullable
    public static VirtualFile findCliJson(@Nullable VirtualFile dir) {
        if (dir == null || !dir.isValid()) {
            return null;
        }
        for (String name : ANGULAR_JSON_NAMES) {
            VirtualFile cliJson = dir.findChild(name);
            if (cliJson == null) continue;
            return cliJson;
        }
        return null;
    }

    @Nullable
    public static VirtualFile findAngularCliFolder(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            AngularCliUtil.$$$reportNull$$$0(0);
        }
        for (VirtualFile current = file; current != null; current = current.getParent()) {
            if (!current.isDirectory() || AngularCliUtil.findCliJson(current) == null) continue;
            return current;
        }
        if (AngularCliUtil.findCliJson(project.getBaseDir()) != null) {
            return project.getBaseDir();
        }
        return null;
    }

    public static boolean hasAngularCLIPackageInstalled(@NotNull Project project, @NotNull VirtualFile cli) {
        if (project == null) {
            AngularCliUtil.$$$reportNull$$$0(1);
        }
        if (cli == null) {
            AngularCliUtil.$$$reportNull$$$0(2);
        }
        ArrayList modules = new ArrayList();
        NodeModuleSearchUtil.findModulesWithName(modules, (String)"@angular/cli", (VirtualFile)cli, null);
        return !modules.isEmpty() && ((CompletionModuleInfo)modules.get(0)).getVirtualFile() != null;
    }

    public static boolean isAngularJsonFile(@NotNull String fileName) {
        if (fileName == null) {
            AngularCliUtil.$$$reportNull$$$0(3);
        }
        return ANGULAR_JSON_NAMES.contains(fileName);
    }

    public static void notifyAngularCliNotInstalled(@NotNull Project project, @NotNull VirtualFile cliFolder, @NotNull String message) {
        if (project == null) {
            AngularCliUtil.$$$reportNull$$$0(4);
        }
        if (cliFolder == null) {
            AngularCliUtil.$$$reportNull$$$0(5);
        }
        if (message == null) {
            AngularCliUtil.$$$reportNull$$$0(6);
        }
        VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile((VirtualFile)cliFolder);
        Notification notification = ANGULAR_CLI_NOTIFICATIONS.createNotification(message, Angular2Bundle.message("angular.notify.cli.required-package-not-installed", new Object[0]), NotificationType.WARNING, null);
        if (packageJson != null) {
            notification.addAction((AnAction)new PackageJsonGetDependenciesAction(project, packageJson, notification));
        }
        notification.notify(project);
    }

    public static void createRunConfigurations(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            AngularCliUtil.$$$reportNull$$$0(7);
        }
        if (baseDir == null) {
            AngularCliUtil.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
            AngularConfig config;
            if (project.isDisposed()) {
                return;
            }
            String packageJsonPath = AngularCliUtil.getPackageJson(baseDir);
            if (packageJsonPath == null || (config = AngularConfigProvider.getAngularConfig(project, baseDir)) == null) {
                return;
            }
            AngularCliUtil.createKarmaConfigurations(project, config);
            AngularCliUtil.createProtractorConfigurations(project, config);
            String nameSuffix = ModuleManager.getInstance((Project)project).getModules().length > 1 ? " (" + baseDir.getName() + ")" : "";
            AngularCliUtil.createJSDebugConfiguration(project, "Angular Application" + nameSuffix, NG_CLI_DEFAULT_ADDRESS);
            RunManager.getInstance((Project)project).setSelectedConfiguration(AngularCliUtil.createNpmConfiguration(project, packageJsonPath, "Angular CLI Server" + nameSuffix, "start"));
        }));
    }

    @Nullable
    private static String getPackageJson(@NotNull VirtualFile baseDir) {
        VirtualFile pkg;
        if (baseDir == null) {
            AngularCliUtil.$$$reportNull$$$0(9);
        }
        if ((pkg = PackageJsonUtil.findChildPackageJsonFile((VirtualFile)baseDir)) != null) {
            return pkg.getPath();
        }
        return null;
    }

    private static void createJSDebugConfiguration(@NotNull Project project, @NotNull @NonNls String label, @NotNull String url) {
        if (project == null) {
            AngularCliUtil.$$$reportNull$$$0(10);
        }
        if (label == null) {
            AngularCliUtil.$$$reportNull$$$0(11);
        }
        if (url == null) {
            AngularCliUtil.$$$reportNull$$$0(12);
        }
        AngularCliUtil.createIfNoSimilar("jsdebug", project, label, null, null, ContainerUtil.newHashMap((Pair)Pair.pair((Object)"uri", (Object)url), (Pair[])new Pair[0]));
    }

    @Nullable
    private static RunnerAndConfigurationSettings createNpmConfiguration(@NotNull Project project, @NotNull String packageJsonPath, @NotNull @NonNls String label, @NotNull String scriptName) {
        if (project == null) {
            AngularCliUtil.$$$reportNull$$$0(13);
        }
        if (packageJsonPath == null) {
            AngularCliUtil.$$$reportNull$$$0(14);
        }
        if (label == null) {
            AngularCliUtil.$$$reportNull$$$0(15);
        }
        if (scriptName == null) {
            AngularCliUtil.$$$reportNull$$$0(16);
        }
        return AngularCliUtil.createIfNoSimilar("npm", project, label, null, packageJsonPath, ContainerUtil.newHashMap((Pair)Pair.pair((Object)"run-script", (Object)scriptName), (Pair[])new Pair[0]));
    }

    private static void createKarmaConfigurations(@NotNull Project project, @NotNull AngularConfig config) {
        if (project == null) {
            AngularCliUtil.$$$reportNull$$$0(17);
        }
        if (config == null) {
            AngularCliUtil.$$$reportNull$$$0(18);
        }
        ((StreamEx)StreamEx.of(config.getProjects()).filter(ngProject -> ngProject.getKarmaConfigFile() != null && ngProject.getRootDir() != null)).forEach(ngProject -> AngularCliUtil.createIfNoSimilar("karma", project, "Tests (" + ngProject.getName() + ")", ngProject.getRootDir(), ngProject.getKarmaConfigFile().getPath(), Collections.emptyMap()));
    }

    private static void createProtractorConfigurations(@NotNull Project project, @NotNull AngularConfig config) {
        if (project == null) {
            AngularCliUtil.$$$reportNull$$$0(19);
        }
        if (config == null) {
            AngularCliUtil.$$$reportNull$$$0(20);
        }
        ((StreamEx)StreamEx.of(config.getProjects()).filter(ngProject -> ngProject.getProtractorConfigFile() != null && ngProject.getRootDir() != null)).forEach(ngProject -> AngularCliUtil.createIfNoSimilar("protractor", project, "E2E Tests (" + ngProject.getName() + ")", ngProject.getRootDir(), ngProject.getProtractorConfigFile().getPath(), Collections.emptyMap()));
    }

    @Nullable
    private static RunnerAndConfigurationSettings createIfNoSimilar(@NotNull @NonNls String rcType, @NotNull Project project, @NonNls @NotNull String label, VirtualFile baseDir, String configPath, @NotNull Map<String, Object> options) {
        if (rcType == null) {
            AngularCliUtil.$$$reportNull$$$0(21);
        }
        if (project == null) {
            AngularCliUtil.$$$reportNull$$$0(22);
        }
        if (label == null) {
            AngularCliUtil.$$$reportNull$$$0(23);
        }
        if (options == null) {
            AngularCliUtil.$$$reportNull$$$0(24);
        }
        return (RunnerAndConfigurationSettings)ObjectUtils.doIfNotNull((Object)JSRunConfigurationBuilder.getForName((String)rcType, (Project)project), builder -> (RunnerAndConfigurationSettings)ObjectUtils.notNull((Object)builder.findSimilarRunConfiguration(baseDir, configPath, options), () -> builder.createRunConfiguration(label, baseDir, configPath, options)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cli";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cliFolder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 11: 
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonPath";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptName";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rcType";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        objectArray2[1] = "org/angular2/cli/AngularCliUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findAngularCliFolder";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasAngularCLIPackageInstalled";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isAngularJsonFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyAngularCliNotInstalled";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createRunConfigurations";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getPackageJson";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "createJSDebugConfiguration";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "createNpmConfiguration";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "createKarmaConfigurations";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "createProtractorConfigurations";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "createIfNoSimilar";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

