/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.intellij.datalore.services;

import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.webcore.packaging.InstalledPackage;
import com.intellij.webcore.packaging.PackageManagementService;
import com.jetbrains.intellij.datalore.models.PackageItem;
import com.jetbrains.python.packaging.PyPackageManagers;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DatalorePackageService", storages={@Storage(value="datalore.xml")})
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0018\u0019B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\r\u001a\u00020\u000eJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0014\u0010\u0016\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/intellij/datalore/services/PackageService;", "Lcom/intellij/openapi/components/PersistentStateComponentWithModificationTracker;", "Lcom/jetbrains/intellij/datalore/services/PackageService$PackageState;", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myState", "getActivePackages", "", "Lcom/jetbrains/intellij/datalore/models/PackageItem;", "getInstalledPackages", "", "Lcom/intellij/webcore/packaging/InstalledPackage;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getPackagesWithSelection", "getState", "getStateModificationCount", "", "loadState", "", "state", "setActivePackages", "packages", "Companion", "PackageState", "datalore-intellij-plugin"})
public final class PackageService
implements PersistentStateComponentWithModificationTracker<PackageState> {
    private PackageState myState;
    private final Project myProject;
    private static final Logger LOG;
    public static final Companion Companion;

    @Nullable
    public PackageState getState() {
        return this.myState;
    }

    public void loadState(@NotNull PackageState state) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)state), (String)"state");
        this.myState = state;
    }

    public long getStateModificationCount() {
        return this.myState.getModificationCount();
    }

    @NotNull
    public final Collection<InstalledPackage> getInstalledPackages(@NotNull Sdk sdk) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)sdk, (String)"sdk");
        try {
            PackageManagementService packageManagementService = PyPackageManagers.getInstance().getManagementService(this.myProject, sdk);
            Intrinsics.checkExpressionValueIsNotNull((Object)packageManagementService, (String)"PyPackageManagers.getIns\u2026ntService(myProject, sdk)");
            Collection collection2 = packageManagementService.getInstalledPackages();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"PyPackageManagers.getIns\u2026t, sdk).installedPackages");
            collection = collection2;
        }
        catch (IOException e) {
            LOG.error("Could not get installed packages: " + e.getMessage());
            boolean bl = false;
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    @NotNull
    public final Set<PackageItem> getActivePackages() {
        return this.myState.getPackages();
    }

    public final void setActivePackages(@NotNull Collection<PackageItem> packages) {
        Intrinsics.checkParameterIsNotNull(packages, (String)"packages");
        this.myState.setPackages((Set<PackageItem>)new TreeSet<PackageItem>(packages));
    }

    @NotNull
    public final Set<PackageItem> getPackagesWithSelection(@NotNull Sdk sdk) {
        Intrinsics.checkParameterIsNotNull((Object)sdk, (String)"sdk");
        TreeSet<PackageItem> allPackages = new TreeSet<PackageItem>();
        Iterable $this$forEach$iv = this.getInstalledPackages(sdk);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InstalledPackage p = (InstalledPackage)element$iv;
            boolean bl = false;
            allPackages.add(new PackageItem(p));
        }
        Set<PackageItem> activePackages = this.getActivePackages();
        Iterable $this$forEach$iv2 = allPackages;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            PackageItem p = (PackageItem)element$iv;
            boolean bl = false;
            if (!activePackages.contains(p)) continue;
            p.setSelected(true);
        }
        return allPackages;
    }

    private PackageService(Project myProject) {
        this.myProject = myProject;
        this.myState = new PackageState();
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(PackageService.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(PackageService::class.java)");
        LOG = logger;
    }

    @JvmStatic
    @NotNull
    public static final PackageService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R7\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/jetbrains/intellij/datalore/services/PackageService$PackageState;", "Lcom/intellij/openapi/components/BaseState;", "()V", "<set-?>", "", "Lcom/jetbrains/intellij/datalore/models/PackageItem;", "packages", "getPackages", "()Ljava/util/Set;", "setPackages", "(Ljava/util/Set;)V", "packages$delegate", "Lkotlin/properties/ReadWriteProperty;", "datalore-intellij-plugin"})
    public static final class PackageState
    extends BaseState {
        static final /* synthetic */ KProperty[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty packages$delegate = this.treeSet().provideDelegate((Object)this, $$delegatedProperties[0]);

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PackageState.class), "packages", "getPackages()Ljava/util/Set;"))};
        }

        @NotNull
        public final Set<PackageItem> getPackages() {
            return (Set)this.packages$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public final void setPackages(@NotNull Set<PackageItem> set) {
            Intrinsics.checkParameterIsNotNull(set, (String)"<set-?>");
            this.packages$delegate.setValue((Object)this, $$delegatedProperties[0], set);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/intellij/datalore/services/PackageService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/jetbrains/intellij/datalore/services/PackageService;", "project", "Lcom/intellij/openapi/project/Project;", "datalore-intellij-plugin"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final PackageService getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(PackageService.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getService(T::class.java)");
            return (PackageService)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

