/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.renderer;

import com.intellij.openapi.graph.builder.renderer.BasicNodeCellRenderer;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public abstract class AbstractColoredNodeCellRenderer
extends BasicNodeCellRenderer {
    private static final Color BORDER_COLOR = JBColor.LIGHT_GRAY;
    public static final String GRAPH_NODE_SELECTED = "GRAPH_NODE_SELECTED";

    protected AbstractColoredNodeCellRenderer(ModificationTracker modificationTracker) {
        super(modificationTracker);
    }

    @Override
    protected JComponent getRendererComponent(Graph2DView view, NodeRealizer realizer, Object object, boolean isSelected) {
        CellRendererPanel panel = new CellRendererPanel();
        panel.setLayout((LayoutManager)new BorderLayout());
        if (GraphViewUtil.isPrintMode()) {
            panel.setBorder((Border)new LineBorder((Color)Gray._168, 2));
        } else if (!StartupUiUtil.isUnderDarcula()) {
            panel.setBorder((Border)(isSelected ? new LineBorder(this.getSelectionColor(), this.getSelectionBorderWidth(), true) : new LineBorder(BORDER_COLOR)));
        } else {
            panel.setBorder((Border)new LineBorder(isSelected ? this.getSelectionColor() : Gray._120));
        }
        panel.setFocusable(false);
        panel.putClientProperty((Object)GRAPH_NODE_SELECTED, (Object)isSelected);
        this.tuneNode(realizer, (JPanel)panel);
        return panel;
    }

    public abstract void tuneNode(NodeRealizer var1, JPanel var2);

    protected int getSelectionBorderWidth() {
        return 1;
    }

    protected Color getSelectionColor() {
        return new JBColor(Color.ORANGE, (Color)JBColor.blue);
    }
}

