/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.javascript.debugger.FileResolverByContentKt;
import com.intellij.javascript.debugger.sourcemap.SourceMapLoaderKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.AsarFileSystem;
import com.intellij.util.io.FileItem;
import java.nio.file.Path;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.ScriptDebuggerUrls;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eR/\u0010\u0003\u001a#\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/util/io/AsarFileFinder;", "", "()V", "pathToAsarFs", "Ljava/util/concurrent/ConcurrentMap;", "", "kotlin.jvm.PlatformType", "Lcom/intellij/util/io/AsarFileSystem;", "Lorg/jetbrains/annotations/NotNull;", "findFileIfAsar", "Lcom/intellij/openapi/vfs/VirtualFile;", "url", "Lcom/intellij/util/Url;", "project", "Lcom/intellij/openapi/project/Project;", "getAsarFs", "path", "intellij.javascript.debugger"})
public final class AsarFileFinder {
    private final ConcurrentMap<String, AsarFileSystem> pathToAsarFs;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final VirtualFile findFileIfAsar(@NotNull Url url, @NotNull Project project) {
        Collection files2;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (!url.isInLocalFileSystem()) {
            return null;
        }
        String string = ScriptDebuggerUrls.INSTANCE.toFilePath(url);
        if (string == null) {
            return null;
        }
        String scriptPath = string;
        int index = StringsKt.indexOf$default((CharSequence)scriptPath, (String)".asar/", (int)0, (boolean)false, (int)6, null);
        if (index <= 0) {
            return null;
        }
        String string2 = scriptPath;
        int n = 0;
        int n2 = index + 5;
        AsarFileFinder asarFileFinder = this;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string5 = string4;
        AsarFileSystem asarFileSystem = asarFileFinder.getAsarFs(string5, project);
        if (asarFileSystem == null) {
            return null;
        }
        AsarFileSystem fs = asarFileSystem;
        String string6 = scriptPath;
        n2 = index + ".asar/".length();
        bl = false;
        String string7 = string6;
        if (string7 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string8 = string7.substring(n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
        String scriptRelativePath = string8;
        FileItem fileItem = fs.getFile(scriptRelativePath);
        if (fileItem == null) {
            return null;
        }
        FileItem fileItem2 = fileItem;
        VirtualFile virtualFile = fs.getVfsRoot();
        if (virtualFile != null) {
            VirtualFile virtualFile2 = virtualFile;
            bl = false;
            boolean bl2 = false;
            VirtualFile it = virtualFile2;
            boolean bl3 = false;
            VirtualFile virtualFile3 = it.findFileByRelativePath(scriptRelativePath);
            if (virtualFile3 != null) {
                VirtualFile virtualFile4 = virtualFile3;
                boolean bl4 = false;
                boolean bl5 = false;
                VirtualFile it2 = virtualFile4;
                boolean bl6 = false;
                return it2;
            }
        }
        GlobalSearchScope globalSearchScope = ProjectScope.getContentScope((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"ProjectScope.getContentScope(project)");
        GlobalSearchScope scope = globalSearchScope;
        boolean $i$f$runReadAction22 = false;
        Object object = ApplicationManager.getApplication().runReadAction(new Computable<T>(project, scriptRelativePath, scope){
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ String $scriptRelativePath$inlined;
            final /* synthetic */ GlobalSearchScope $scope$inlined;
            {
                this.$project$inlined = project;
                this.$scriptRelativePath$inlined = string;
                this.$scope$inlined = globalSearchScope;
            }

            public final T compute() {
                boolean bl = false;
                return (T)FilenameIndex.getVirtualFilesByName((Project)this.$project$inlined, (String)PathUtilRt.getFileName((String)this.$scriptRelativePath$inlined), (GlobalSearchScope)this.$scope$inlined);
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"runReadAction { Filename\u2026ptRelativePath), scope) }");
        Iterable $i$f$runReadAction22 = files2 = (Collection)object;
        boolean it = false;
        if (!$i$f$runReadAction22.isEmpty()) {
            void $this$filterTo$iv;
            $i$f$runReadAction22 = files2;
            Collection destination$iv = (Collection)new SmartList();
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                VirtualFile it3 = (VirtualFile)element$iv;
                boolean bl7 = false;
                VirtualFile virtualFile5 = it3;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile5, (String)"it");
                String string9 = virtualFile5.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"it.path");
                if (!FileUtilKt.endsWithName((String)string9, (String)scriptRelativePath)) continue;
                destination$iv.add(element$iv);
            }
            Collection collection = files2 = destination$iv;
            boolean bl8 = false;
            if (!collection.isEmpty()) {
                return FileResolverByContentKt.selectMostSimilarFile$default(files2, fs.loadText(fileItem2), null, 4, null);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final AsarFileSystem getAsarFs(@NotNull String path, @NotNull Project project) {
        void fs;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = (AsarFileSystem)this.pathToAsarFs.get(path);
        if ((AsarFileSystem)fs.element == null) {
            Path path2 = SourceMapLoaderKt.regularFile(path);
            if (path2 == null) {
                return null;
            }
            Path path3 = path2;
            void var17_5 = fs;
            boolean bl = false;
            boolean bl2 = false;
            Path it = path3;
            boolean bl3 = false;
            AsarFileSystem asarFileSystem = new AsarFileSystem(it);
            var17_5.element = asarFileSystem;
            String packageJson = "package.json";
            FileItem fileItem = ((AsarFileSystem)fs.element).getFile(packageJson);
            if (fileItem != null) {
                Collection files2;
                FileItem fileItem2 = fileItem;
                bl2 = false;
                boolean bl4 = false;
                FileItem fileItem3 = fileItem2;
                boolean bl5 = false;
                GlobalSearchScope globalSearchScope = ProjectScope.getContentScope((Project)project);
                Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"ProjectScope.getContentScope(project)");
                GlobalSearchScope scope = globalSearchScope;
                boolean $i$f$runReadAction = false;
                Object object = ApplicationManager.getApplication().runReadAction(new Computable<T>(scope, project, packageJson, (Ref.ObjectRef)fs){
                    final /* synthetic */ GlobalSearchScope $scope$inlined;
                    final /* synthetic */ Project $project$inlined;
                    final /* synthetic */ String $packageJson$inlined;
                    final /* synthetic */ Ref.ObjectRef $fs$inlined;
                    {
                        this.$scope$inlined = globalSearchScope;
                        this.$project$inlined = project;
                        this.$packageJson$inlined = string;
                        this.$fs$inlined = objectRef;
                    }

                    public final T compute() {
                        boolean bl = false;
                        return (T)FilenameIndex.getVirtualFilesByName((Project)this.$project$inlined, (String)this.$packageJson$inlined, (GlobalSearchScope)this.$scope$inlined);
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"runReadAction { Filename\u2026ct, packageJson, scope) }");
                Collection collection = files2 = (Collection)object;
                boolean bl6 = false;
                if (!collection.isEmpty()) {
                    VirtualFile virtualFile = FileResolverByContentKt.selectMostSimilarFile$default(files2, ((AsarFileSystem)fs.element).loadText(fileItem3), null, 4, null);
                    if (virtualFile != null) {
                        collection = virtualFile;
                        bl6 = false;
                        boolean bl7 = false;
                        Collection it2 = collection;
                        boolean bl8 = false;
                        ((AsarFileSystem)fs.element).setVfsRoot(it2.getParent());
                    }
                }
            }
            AsarFileSystem asarFileSystem2 = this.pathToAsarFs.putIfAbsent(path, (AsarFileSystem)fs.element);
            if (asarFileSystem2 != null) {
                AsarFileSystem asarFileSystem3 = asarFileSystem2;
                bl2 = false;
                boolean bl9 = false;
                AsarFileSystem it3 = asarFileSystem3;
                boolean bl10 = false;
                return it3;
            }
        }
        return (AsarFileSystem)fs.element;
    }

    public AsarFileFinder() {
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.newConcurr\u2026String, AsarFileSystem>()");
        this.pathToAsarFs = concurrentMap;
    }
}

