/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap;

import com.google.gson.stream.JsonToken;
import com.intellij.icons.AllIcons;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.JsonReaderEx;

public final class SourceMapFileType
extends LanguageFileType {
    public static final SourceMapFileType INSTANCE = new SourceMapFileType();
    public static final String DOT_DEFAULT_EXTENSION = ".map";

    private SourceMapFileType() {
        super((Language)JsonLanguage.INSTANCE, true);
    }

    @NotNull
    public String getName() {
        return "SourceMap";
    }

    @NotNull
    public String getDescription() {
        return "SourceMap";
    }

    @NotNull
    public String getDefaultExtension() {
        return "map";
    }

    public Icon getIcon() {
        return AllIcons.FileTypes.Json;
    }

    static final class MyFileTypeDetector
    implements FileTypeRegistry.FileTypeDetector {
        MyFileTypeDetector() {
        }

        @Nullable
        public FileType detect(@NotNull VirtualFile file2, @NotNull ByteSequence firstBytes, @Nullable CharSequence firstCharsIfText) {
            if (file2 == null) {
                MyFileTypeDetector.$$$reportNull$$$0(0);
            }
            if (firstBytes == null) {
                MyFileTypeDetector.$$$reportNull$$$0(1);
            }
            if (!StringUtil.endsWith((CharSequence)file2.getNameSequence(), (CharSequence)SourceMapFileType.DOT_DEFAULT_EXTENSION) || firstCharsIfText == null) {
                return null;
            }
            try {
                JsonReaderEx jsonReader = new JsonReaderEx(firstCharsIfText);
                if (jsonReader.peek() != JsonToken.BEGIN_OBJECT) {
                    return null;
                }
                jsonReader.beginObject();
                String firstName = jsonReader.nextName();
                return firstName.equals("version") && jsonReader.peek() == JsonToken.NUMBER || firstName.equals("names") && jsonReader.peek() == JsonToken.BEGIN_ARRAY ? INSTANCE : null;
            }
            catch (Exception ignored) {
                return null;
            }
        }

        public int getDesiredContentPrefixLength() {
            return 128;
        }

        public int getVersion() {
            return 1;
        }

        @NotNull
        public Collection<? extends FileType> getDetectedFileTypes() {
            Set<SourceMapFileType> set2 = Collections.singleton(INSTANCE);
            if (set2 == null) {
                MyFileTypeDetector.$$$reportNull$$$0(2);
            }
            return set2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstBytes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/debugger/sourcemap/SourceMapFileType$MyFileTypeDetector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/debugger/sourcemap/SourceMapFileType$MyFileTypeDetector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDetectedFileTypes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "detect";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

