/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.execution;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ui.CommonProgramParametersPanel;
import com.intellij.execution.ui.MacroComboBoxWithBrowseButton;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.execution.DebuggableProcessRunConfigurationBase;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TextAccessor;
import com.intellij.util.PathUtil;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggableProcessRunConfigurationEditor<T extends DebuggableProcessRunConfigurationBase>
extends SettingsEditor<T> {
    protected DebuggableProgramParametersPanel panel;
    private final Project project;

    public DebuggableProcessRunConfigurationEditor(@NotNull Project project) {
        if (project == null) {
            DebuggableProcessRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        this.project = project;
    }

    protected void resetEditorFrom(@NotNull T configuration) {
        if (configuration == null) {
            DebuggableProcessRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        this.panel.reset((CommonProgramRunConfigurationParameters)configuration);
    }

    protected void applyEditorTo(@NotNull T configuration) throws ConfigurationException {
        if (configuration == null) {
            DebuggableProcessRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        this.panel.applyTo((CommonProgramRunConfigurationParameters)configuration);
    }

    @NotNull
    protected DebuggableProgramParametersPanel createEditor() {
        DebuggableProgramParametersPanel debuggableProgramParametersPanel = this.panel = new DebuggableProgramParametersPanel(this.project, this.createExePathDescriptor(), this.createInputPathDescriptor());
        if (debuggableProgramParametersPanel == null) {
            DebuggableProcessRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        return debuggableProgramParametersPanel;
    }

    protected FileChooserDescriptor createExePathDescriptor() {
        return FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor();
    }

    protected FileChooserDescriptor createInputPathDescriptor() {
        return FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/debugger/execution/DebuggableProcessRunConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/debugger/execution/DebuggableProcessRunConfigurationEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class DebuggableProgramParametersPanel
    extends CommonProgramParametersPanel {
        private final Project project;
        private LabeledComponent<JComponent> exePathComponent;
        private LabeledComponent<JComponent> inputPathComponent;
        private final MacroComboBoxWithBrowseButton exePathComboBox;
        private final MacroComboBoxWithBrowseButton inputPathComboBox;
        private final PathMacroManager pathMacroManager;

        public DebuggableProgramParametersPanel(@NotNull Project project, FileChooserDescriptor exePathDescriptor, FileChooserDescriptor inputPathDescriptor) {
            if (project == null) {
                DebuggableProgramParametersPanel.$$$reportNull$$$0(0);
            }
            super(false);
            this.project = project;
            this.exePathComboBox = new MacroComboBoxWithBrowseButton(exePathDescriptor, this.getProject());
            this.inputPathComboBox = new MacroComboBoxWithBrowseButton(inputPathDescriptor, this.getProject());
            this.pathMacroManager = PathMacroManager.getInstance((ComponentManager)this.getProject());
            this.init();
        }

        @NotNull
        protected Project getProject() {
            Project project = this.project;
            if (project == null) {
                DebuggableProgramParametersPanel.$$$reportNull$$$0(1);
            }
            return project;
        }

        protected void addComponents() {
            this.inputPathComponent = LabeledComponent.create((JComponent)this.inputPathComboBox, (String)JSDebuggerBundle.message("js.DebuggableProcessRunConfigurationEditor.label", new Object[0]));
            this.exePathComponent = LabeledComponent.create((JComponent)this.exePathComboBox, (String)"");
            this.inputPathComponent.setLabelLocation("West");
            this.exePathComponent.setLabelLocation("West");
            this.add((Component)this.inputPathComponent);
            super.addComponents();
            this.add((Component)this.exePathComponent);
        }

        public DebuggableProgramParametersPanel inputPathLabel(@NotNull String label) {
            if (label == null) {
                DebuggableProgramParametersPanel.$$$reportNull$$$0(2);
            }
            this.inputPathComponent.setText(label);
            return this;
        }

        public DebuggableProgramParametersPanel programParametersLabel(@NotNull String label) {
            if (label == null) {
                DebuggableProgramParametersPanel.$$$reportNull$$$0(3);
            }
            this.setProgramParametersLabel(label);
            return this;
        }

        public DebuggableProgramParametersPanel exePathLabel(@NotNull String label) {
            if (label == null) {
                DebuggableProgramParametersPanel.$$$reportNull$$$0(4);
            }
            this.exePathComponent.setText(label);
            return this;
        }

        public void setAnchor(JComponent anchor) {
            super.setAnchor(anchor);
            this.inputPathComponent.setAnchor(anchor);
            this.exePathComponent.setAnchor(anchor);
        }

        public void applyTo(CommonProgramRunConfigurationParameters c) {
            super.applyTo(c);
            DebuggableProcessRunConfigurationBase configuration = (DebuggableProcessRunConfigurationBase)c;
            configuration.setInputPath(this.fromTextField((TextAccessor)this.inputPathComboBox, configuration));
            configuration.setExePath(this.fromTextField((TextAccessor)this.exePathComboBox, configuration));
        }

        public void reset(CommonProgramRunConfigurationParameters c) {
            super.reset(c);
            DebuggableProcessRunConfigurationBase configuration = (DebuggableProcessRunConfigurationBase)c;
            this.inputPathComboBox.setText(this.pathToTextField(configuration.getInputPath()));
            this.setProgramParameters(this.pathMacroManager.collapsePath(configuration.getProgramParameters()));
            String workingDirectory = this.pathToTextField(configuration.getWorkingDirectory());
            if (workingDirectory == null) {
                workingDirectory = this.project.getBasePath();
            }
            this.setWorkingDirectory(workingDirectory);
            String exePath = this.pathToTextField(configuration.getExePath());
            if (exePath == null) {
                exePath = configuration.computeDefaultExePath();
            }
            this.exePathComboBox.setText(exePath);
        }

        private String pathToTextField(@Nullable String path) {
            if ((path = PathUtil.toSystemDependentName((String)path)) == null || !path.contains("PROJECT_DIR") || this.project.isDefault()) {
                return path;
            }
            ExpandMacroToPathMap map = new ExpandMacroToPathMap();
            map.addMacroExpand("PROJECT_DIR", this.project.getBasePath());
            return map.substitute(path, false);
        }

        @Nullable
        protected String fromTextField(@NotNull TextAccessor textAccessor, @NotNull CommonProgramRunConfigurationParameters c) {
            String path;
            if (textAccessor == null) {
                DebuggableProgramParametersPanel.$$$reportNull$$$0(5);
            }
            if (c == null) {
                DebuggableProgramParametersPanel.$$$reportNull$$$0(6);
            }
            if ((path = StringUtil.nullize((String)super.fromTextField(textAccessor, c), (boolean)true)) == null) {
                return null;
            }
            if (textAccessor != this.getProgramParametersComponent().getComponent()) {
                DebuggableProcessRunConfigurationBase configuration = (DebuggableProcessRunConfigurationBase)c;
                if (textAccessor == this.exePathComboBox ? path.equals(configuration.computeDefaultExePath()) : textAccessor == this.getWorkingDirectoryAccessor() && path.equals(this.project.getBasePath())) {
                    return null;
                }
                path = PathUtil.toSystemIndependentName((String)path);
            }
            return this.pathMacroManager.collapsePath(path);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/debugger/execution/DebuggableProcessRunConfigurationEditor$DebuggableProgramParametersPanel";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textAccessor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/debugger/execution/DebuggableProcessRunConfigurationEditor$DebuggableProgramParametersPanel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "inputPathLabel";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "programParametersLabel";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "exePathLabel";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "fromTextField";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

