/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.coverage;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageHelper;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageRunnerData;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.DebuggableFileFinderImpl;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebugEngine;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinder;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinderKt;
import com.intellij.javascript.debugger.coverage.WipCoverageProgramRunner;
import com.intellij.javascript.debugger.coverage.WipCoverageProgramRunner$startSession$;
import com.intellij.javascript.debugger.coverage.WipCoverageReportProcessor;
import com.intellij.javascript.debugger.coverage.WipCoverageRunner;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.debugger.execution.JavaScriptDebugRunner;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.javascript.testFramework.coverage.CoverageSerializationUtils;
import com.intellij.javascript.testFramework.coverage.LcovCoverageReport;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.Function;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.org.jetbrains.wip.WipCssManager;
import org.jetbrains.wip.protocol.css.CSSKt;
import org.jetbrains.wip.protocol.css.TakeCoverageDeltaResult;
import org.jetbrains.wip.protocol.profiler.ProfilerKt;
import org.jetbrains.wip.protocol.profiler.TakePreciseCoverageResult;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\nH\u0016J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\"\u0010\u001a\u001a\u00020\u00042\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J&\u0010 \u001a\u0006\u0012\u0002\b\u00030\u00122\u0010\u0010!\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001c2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J,\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0&H\u0002J\u0018\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020,H\u0002\u00a8\u0006-"}, d2={"Lcom/intellij/javascript/debugger/coverage/WipCoverageProgramRunner;", "Lcom/intellij/javascript/debugger/execution/JavaScriptDebugRunner;", "()V", "addNotification", "", "session", "Lcom/intellij/xdebugger/XDebugSession;", "canRun", "", "executorId", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "createConfigurationData", "Lcom/intellij/execution/configurations/RunnerSettings;", "settingsProvider", "Lcom/intellij/execution/configurations/ConfigurationInfoProvider;", "execute", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/ui/RunContentDescriptor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "getRunnerId", "hideDebuggerTabs", "onProtocolStart", "jsDebugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "Lorg/jetbrains/debugger/connection/VmConnection;", "vm", "Lorg/jetbrains/wip/WipVm;", "onProtocolStop", "javaScriptDebugProcess", "startSession", "project", "Lcom/intellij/openapi/project/Project;", "engineAndBrowser", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/javascript/debugger/JavaScriptDebugEngine;", "Lcom/intellij/ide/browsers/WebBrowser;", "updateCoverageView", "env", "coverageReport", "Ljava/io/File;", "intellij.javascript.debugger"})
public final class WipCoverageProgramRunner
extends JavaScriptDebugRunner {
    @Override
    @NotNull
    public String getRunnerId() {
        return "WipCoverageProgramRunner";
    }

    @Override
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkParameterIsNotNull((Object)executorId, (String)"executorId");
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        return profile instanceof JavaScriptDebugConfiguration && Intrinsics.areEqual((Object)executorId, (Object)"Coverage");
    }

    @Override
    @NotNull
    protected Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) {
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        RunProfile runProfile = environment.getRunProfile();
        if (runProfile == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration");
        }
        JavaScriptDebugConfiguration configuration = (JavaScriptDebugConfiguration)runProfile;
        Pair<JavaScriptDebugEngine, WebBrowser> engineAndBrowser = this.findEngineAndBrowser(configuration.getEngineId(), false);
        JavaScriptDebugEngine javaScriptDebugEngine = (JavaScriptDebugEngine)engineAndBrowser.first;
        Project project = environment.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"environment.project");
        Object object = engineAndBrowser.second;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"engineAndBrowser.second");
        Promise promise2 = javaScriptDebugEngine.prepareDebugger(project, (WebBrowser)object).then(new Function<T, SUB_RESULT>(this, environment, engineAndBrowser){
            final /* synthetic */ WipCoverageProgramRunner this$0;
            final /* synthetic */ ExecutionEnvironment $environment;
            final /* synthetic */ Pair $engineAndBrowser;

            @NotNull
            public final RunContentDescriptor fun(Unit it) {
                FileDocumentManager.getInstance().saveAllDocuments();
                Project project = this.$environment.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"environment.project");
                XDebugSession session = WipCoverageProgramRunner.access$startSession(this.this$0, project, this.$environment, this.$engineAndBrowser);
                WipCoverageProgramRunner.access$hideDebuggerTabs(this.this$0, session);
                WipCoverageProgramRunner.access$addNotification(this.this$0, session);
                return session.getRunContentDescriptor();
            }
            {
                this.this$0 = wipCoverageProgramRunner;
                this.$environment = executionEnvironment;
                this.$engineAndBrowser = pair;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"engineAndBrowser.first.p\u2026ContentDescriptor\n      }");
        return promise2;
    }

    private final void addNotification(XDebugSession session) {
        XDebugProcess xDebugProcess = session.getDebugProcess();
        if (xDebugProcess == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.javascript.debugger.JavaScriptDebugProcess<org.jetbrains.debugger.connection.VmConnection<out org.jetbrains.wip.WipVm>>");
        }
        JavaScriptDebugProcess jsDebugProcess = (JavaScriptDebugProcess)xDebugProcess;
        jsDebugProcess.getConnection().addDebugListener(new DebugEventListener(jsDebugProcess){
            final /* synthetic */ JavaScriptDebugProcess $jsDebugProcess;

            public void navigated(@Nullable String newUrl) {
                block0: {
                    ConsoleView jsConsoleView;
                    super.navigated(newUrl);
                    ConsoleView consoleView = jsConsoleView = this.$jsDebugProcess.getJSConsoleView(false);
                    if (consoleView == null) break block0;
                    consoleView.print(JSDebuggerBundle.message("js.coverage.notification", new Object[0]), ConsoleViewContentType.SYSTEM_OUTPUT);
                }
            }
            {
                this.$jsDebugProcess = $captured_local_variable$0;
            }
        });
    }

    private final void hideDebuggerTabs(XDebugSession session) {
        block3: {
            Content it;
            boolean bl;
            boolean bl2;
            Content content;
            RunnerLayoutUi runnerLayoutUi = session.getUI();
            Intrinsics.checkExpressionValueIsNotNull((Object)runnerLayoutUi, (String)"session.ui");
            ContentManager contentManager = runnerLayoutUi.getContentManager();
            Intrinsics.checkExpressionValueIsNotNull((Object)contentManager, (String)"session.ui.contentManager");
            ContentManager contentManager2 = contentManager;
            Content variables = contentManager2.findContent("Variables");
            Content frames = contentManager2.findContent("Frames");
            Content scripts = contentManager2.findContent("Scripts");
            Content elements = contentManager2.findContent("Elements");
            Content content2 = variables;
            if (content2 != null) {
                content = content2;
                bl2 = false;
                bl = false;
                it = content;
                boolean bl3 = false;
                contentManager2.removeContent(it, true);
            }
            Content content3 = frames;
            if (content3 != null) {
                content = content3;
                bl2 = false;
                bl = false;
                it = content;
                boolean bl4 = false;
                contentManager2.removeContent(it, true);
            }
            Content content4 = scripts;
            if (content4 != null) {
                content = content4;
                bl2 = false;
                bl = false;
                it = content;
                boolean bl5 = false;
                contentManager2.removeContent(it, true);
            }
            Content content5 = elements;
            if (content5 == null) break block3;
            content = content5;
            bl2 = false;
            bl = false;
            it = content;
            boolean bl6 = false;
            contentManager2.removeContent(it, true);
        }
    }

    private final XDebugSession startSession(Project project, ExecutionEnvironment environment, Pair<JavaScriptDebugEngine, WebBrowser> engineAndBrowser) {
        DebuggableFileFinder debuggableFileFinder;
        RunProfile runProfile = environment.getRunProfile();
        if (runProfile == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration");
        }
        JavaScriptDebugConfiguration configuration = (JavaScriptDebugConfiguration)runProfile;
        String string = configuration.getUri();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"configuration.uri!!");
        Url url = Urls.newFromIdea((CharSequence)string);
        DebuggableFileFinderImpl defaultFileFinder = new DebuggableFileFinderImpl(project, url);
        if (url.isInLocalFileSystem()) {
            debuggableFileFinder = defaultFileFinder;
        } else {
            List<RemoteUrlMappingBean> list = configuration.getMappings();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"configuration.mappings");
            debuggableFileFinder = new RemoteDebuggingFileFinder(RemoteDebuggingFileFinderKt.createUrlToLocalMap(list), defaultFileFinder);
        }
        DebuggableFileFinder fileFinder = debuggableFileFinder;
        boolean $i$f$startSession = false;
        ExecutionEnvironment executionEnvironment = environment;
        XDebuggerManager xDebuggerManager = XDebuggerManager.getInstance((Project)environment.getProject());
        boolean $i$f$xDebugProcessStarter = false;
        XDebugProcessStarter xDebugProcessStarter = new XDebugProcessStarter(this, engineAndBrowser, fileFinder, url, environment){
            final /* synthetic */ WipCoverageProgramRunner this$0;
            final /* synthetic */ Pair $engineAndBrowser$inlined;
            final /* synthetic */ DebuggableFileFinder $fileFinder$inlined;
            final /* synthetic */ Url $url$inlined;
            final /* synthetic */ ExecutionEnvironment $environment$inlined;
            {
                this.this$0 = wipCoverageProgramRunner;
                this.$engineAndBrowser$inlined = pair;
                this.$fileFinder$inlined = debuggableFileFinder;
                this.$url$inlined = url;
                this.$environment$inlined = executionEnvironment;
            }

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
                XDebugSession session2 = session;
                boolean bl = false;
                JavaScriptDebugEngine javaScriptDebugEngine = (JavaScriptDebugEngine)this.$engineAndBrowser$inlined.first;
                Object object = this.$engineAndBrowser$inlined.second;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"engineAndBrowser.second");
                JavaScriptDebugProcess<VmConnection<?>> debugProcess = javaScriptDebugEngine.createDebugProcess(session2, (WebBrowser)object, this.$fileFinder$inlined, this.$url$inlined, null, true);
                debugProcess.getConnection().executeOnStart((Function1)new Function1<Vm, Unit>(debugProcess, this){
                    final /* synthetic */ JavaScriptDebugProcess $debugProcess;
                    final /* synthetic */ startSession$$inlined$startSession$1 this$0;
                    {
                        this.$debugProcess = javaScriptDebugProcess;
                        this.this$0 = var2_2;
                        super(1);
                    }

                    public final void invoke(@NotNull Vm it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        WipCoverageProgramRunner.access$onProtocolStart(this.this$0.this$0, this.$debugProcess, (WipVm)it);
                    }
                });
                debugProcess.setBeforeStopAction((Function0)new Function0<Promise<?>>(debugProcess, this){
                    final /* synthetic */ JavaScriptDebugProcess $debugProcess;
                    final /* synthetic */ startSession$$inlined$startSession$1 this$0;
                    {
                        this.$debugProcess = javaScriptDebugProcess;
                        this.this$0 = var2_2;
                        super(0);
                    }

                    @NotNull
                    public final Promise<?> invoke() {
                        return WipCoverageProgramRunner.access$onProtocolStop(this.this$0.this$0, this.$debugProcess, this.this$0.$environment$inlined);
                    }
                });
                return (XDebugProcess)debugProcess;
            }
        };
        XDebugSession xDebugSession = xDebuggerManager.startSession(executionEnvironment, xDebugProcessStarter);
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"XDebuggerManager.getInst\u2026gProcessStarter(starter))");
        XDebugSession session = xDebugSession;
        session.setBreakpointMuted(true);
        return session;
    }

    private final void onProtocolStart(JavaScriptDebugProcess<? extends VmConnection<?>> jsDebugProcess, WipVm vm) {
        vm.getCommandProcessor().send((Request)ProfilerKt.Enable());
        WipCssManager wipCssManager = jsDebugProcess.getCssManager();
        if (wipCssManager == null) {
            Intrinsics.throwNpe();
        }
        wipCssManager.enable();
        vm.getCommandProcessor().send((Request)ProfilerKt.StartPreciseCoverage((Boolean)true, (Boolean)true));
        vm.getCommandProcessor().send((Request)CSSKt.StartRuleUsageTracking());
    }

    private final Promise<?> onProtocolStop(JavaScriptDebugProcess<? extends VmConnection<?>> javaScriptDebugProcess, ExecutionEnvironment environment) {
        Vm vm = javaScriptDebugProcess.getVm();
        if (!(vm instanceof WipVm)) {
            vm = null;
        }
        WipVm wipVm = (WipVm)vm;
        if (wipVm == null) {
            return Promises.nullPromise();
        }
        WipVm vm2 = wipVm;
        Ref.ObjectRef coverageReport = new Ref.ObjectRef();
        Promise promise2 = vm2.getCommandProcessor().send((Request)ProfilerKt.TakePreciseCoverage()).thenAsync(new Function<T, Promise<SUB_RESULT>>(javaScriptDebugProcess){
            final /* synthetic */ JavaScriptDebugProcess $javaScriptDebugProcess;

            @NotNull
            public final Promise<LcovCoverageReport> fun(TakePreciseCoverageResult it) {
                return WipCoverageReportProcessor.INSTANCE.convertCoverageFormat(this.$javaScriptDebugProcess, it.result());
            }
            {
                this.$javaScriptDebugProcess = javaScriptDebugProcess;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"vm.commandProcessor.send\u2026ess, it.result())\n      }");
        Promise jsPromise2 = promise2;
        Promise promise3 = vm2.getCommandProcessor().send((Request)CSSKt.TakeCoverageDelta()).thenAsync(new Function<T, Promise<SUB_RESULT>>(javaScriptDebugProcess){
            final /* synthetic */ JavaScriptDebugProcess $javaScriptDebugProcess;

            @NotNull
            public final Promise<LcovCoverageReport> fun(TakeCoverageDeltaResult it) {
                return WipCoverageReportProcessor.INSTANCE.convertCssCoverageFormat(this.$javaScriptDebugProcess, it.coverage());
            }
            {
                this.$javaScriptDebugProcess = javaScriptDebugProcess;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise3, (String)"vm.commandProcessor.send\u2026s, it.coverage())\n      }");
        Promise cssPromise2 = promise3;
        Promise promise4 = Promises.collectResults((Collection)CollectionsKt.listOf((Object[])new Promise[]{jsPromise2, cssPromise2}), (boolean)false).thenAsync(new Function<T, Promise<SUB_RESULT>>(this, coverageReport, environment, vm2){
            final /* synthetic */ WipCoverageProgramRunner this$0;
            final /* synthetic */ Ref.ObjectRef $coverageReport;
            final /* synthetic */ ExecutionEnvironment $environment;
            final /* synthetic */ WipVm $vm;

            @NotNull
            public final Promise<Unit> fun(List<? extends LcovCoverageReport> reports) {
                List<? extends LcovCoverageReport> list = reports;
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"reports");
                LcovCoverageReport lcov = (LcovCoverageReport)CollectionsKt.first(list);
                lcov.mergeReport((LcovCoverageReport)CollectionsKt.last(reports));
                this.$coverageReport.element = FileUtil.createTempFile((String)"covData", null);
                File file2 = (File)this.$coverageReport.element;
                if (file2 == null) {
                    Intrinsics.throwNpe();
                }
                CoverageSerializationUtils.writeLCOV((LcovCoverageReport)lcov, (File)file2);
                Application application = ApplicationManager.getApplication();
                Runnable runnable = new Runnable(this){
                    final /* synthetic */ onProtocolStop.1 this$0;

                    public final void run() {
                        WipCoverageProgramRunner wipCoverageProgramRunner = this.this$0.this$0;
                        ExecutionEnvironment executionEnvironment = this.this$0.$environment;
                        File file2 = (File)this.this$0.$coverageReport.element;
                        if (file2 == null) {
                            Intrinsics.throwNpe();
                        }
                        WipCoverageProgramRunner.access$updateCoverageView(wipCoverageProgramRunner, executionEnvironment, file2);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                };
                Project project = this.$environment.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"environment.project");
                application.invokeLater(runnable, project.getDisposed());
                return this.$vm.getCommandProcessor().send((Request)ProfilerKt.StopPreciseCoverage());
            }
            {
                this.this$0 = wipCoverageProgramRunner;
                this.$coverageReport = objectRef;
                this.$environment = executionEnvironment;
                this.$vm = wipVm;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise4, (String)"listOf<Promise<LcovCover\u2026reciseCoverage())\n      }");
        return promise4;
    }

    @Nullable
    public RunnerSettings createConfigurationData(@NotNull ConfigurationInfoProvider settingsProvider) {
        Intrinsics.checkParameterIsNotNull((Object)settingsProvider, (String)"settingsProvider");
        return (RunnerSettings)new CoverageRunnerData();
    }

    private final void updateCoverageView(ExecutionEnvironment env, File coverageReport) {
        RunProfile runProfile = env.getRunProfile();
        if (runProfile == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.execution.configurations.RunConfigurationBase<*>");
        }
        RunConfigurationBase runConfiguration = (RunConfigurationBase)runProfile;
        CoverageHelper.resetCoverageSuit((RunConfigurationBase)runConfiguration);
        CoverageEnabledConfiguration coverageEnabledConfiguration = CoverageEnabledConfiguration.getOrCreate((RunConfigurationBase)runConfiguration);
        Intrinsics.checkExpressionValueIsNotNull((Object)coverageEnabledConfiguration, (String)"CoverageEnabledConfigura\u2026rCreate(runConfiguration)");
        CoverageEnabledConfiguration coverageEnabledConfiguration2 = coverageEnabledConfiguration;
        String string = coverageEnabledConfiguration2.getCoverageFilePath();
        if (string == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"coverageEnabledConfigura\u2026overageFilePath ?: return");
        String coverageFilePath = string;
        try {
            FileUtil.copy((File)coverageReport, (File)new File(coverageFilePath));
        }
        catch (IOException e) {
            return;
        }
        RunnerSettings runnerSettings = env.getRunnerSettings();
        if (runnerSettings != null) {
            WipCoverageRunner coverageRunner = (WipCoverageRunner)CoverageRunner.getInstance(WipCoverageRunner.class);
            Project project = env.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"env.project");
            coverageRunner.setWorkingDirectory(project.getBasePath());
            CoverageDataManager.getInstance((Project)env.getProject()).processGatheredCoverage(runConfiguration, runnerSettings);
        }
    }

    public static final /* synthetic */ XDebugSession access$startSession(WipCoverageProgramRunner $this, Project project, ExecutionEnvironment environment, Pair engineAndBrowser) {
        return $this.startSession(project, environment, (Pair<JavaScriptDebugEngine, WebBrowser>)engineAndBrowser);
    }

    public static final /* synthetic */ void access$hideDebuggerTabs(WipCoverageProgramRunner $this, XDebugSession session) {
        $this.hideDebuggerTabs(session);
    }

    public static final /* synthetic */ void access$addNotification(WipCoverageProgramRunner $this, XDebugSession session) {
        $this.addNotification(session);
    }

    public static final /* synthetic */ void access$onProtocolStart(WipCoverageProgramRunner $this, JavaScriptDebugProcess jsDebugProcess, WipVm vm) {
        $this.onProtocolStart(jsDebugProcess, vm);
    }

    public static final /* synthetic */ Promise access$onProtocolStop(WipCoverageProgramRunner $this, JavaScriptDebugProcess javaScriptDebugProcess, ExecutionEnvironment environment) {
        return $this.onProtocolStop(javaScriptDebugProcess, environment);
    }

    public static final /* synthetic */ void access$updateCoverageView(WipCoverageProgramRunner $this, ExecutionEnvironment env, File coverageReport) {
        $this.updateCoverageView(env, coverageReport);
    }
}

