/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.actions;

import com.intellij.CommonBundle;
import com.intellij.DynamicBundle;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.RecentsManager;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

class OpenUrlDialog
extends DialogWrapper {
    @NonNls
    private static final String RECENT_URLS_KEY = "OPEN_URL_DIALOG";
    private static final String HTTP = "http://";
    private JComboBox myUrlComboBox;
    private JPanel myMainPanel;
    private final Project myProject;

    OpenUrlDialog(Project project) {
        super(project, true);
        this.myProject = project;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(JSDebuggerBundle.message("action.JavaScriptDebugger.OpenUrl.dialog.title", objectArray));
        List urls = RecentsManager.getInstance((Project)project).getRecentEntries(RECENT_URLS_KEY);
        if (ContainerUtil.isEmpty((Collection)urls)) {
            this.myUrlComboBox.setSelectedItem(HTTP);
        } else {
            for (String url : urls) {
                this.myUrlComboBox.addItem(url);
            }
        }
        this.init();
        this.initValidation();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        this.getOKAction().setEnabled(this.isUrlValid());
        return null;
    }

    private boolean isUrlValid() {
        String url = ((JTextComponent)this.myUrlComboBox.getEditor().getEditorComponent()).getText();
        if (StringUtil.isEmpty((String)url)) {
            return false;
        }
        try {
            Url parsed = Urls.parseEncoded((String)url);
            if (parsed == null) {
                return false;
            }
            parsed.toExternalForm();
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    protected void doOKAction() {
        String url = this.getUrl();
        VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(url);
        if (file2 == null) {
            Messages.showErrorDialog((Project)this.myProject, (String)JSDebuggerBundle.message("action.JavaScriptDebugger.OpenUrl.dialog.error", url), (String)CommonBundle.getErrorTitle());
        } else {
            super.doOKAction();
            RecentsManager.getInstance((Project)this.myProject).registerRecentEntry(RECENT_URLS_KEY, url);
            FileEditorManager.getInstance((Project)this.myProject).openFile(file2, true);
        }
    }

    private String getUrl() {
        return (String)this.myUrlComboBox.getSelectedItem();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myUrlComboBox;
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/JSDebuggerBundle", OpenUrlDialog.class).getString("action.JavaScriptDebugger.OpenUrl.dialog.label"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myUrlComboBox = jComboBox = new JComboBox();
        jComboBox.setEditable(true);
        jPanel.add(jComboBox, new GridConstraints(1, 0, 1, 1, 8, 1, 2, 0, null, new Dimension(300, -1), null, 1));
        jLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

