/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.jetbrains.javascript.debugger.FileUrlMapper;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebBrowserUrlProviderKt;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0016J(\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/javascript/debugger/BuiltInWebServerFileUrlMapper;", "Lcom/jetbrains/javascript/debugger/FileUrlMapper;", "()V", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "url", "Lcom/intellij/util/Url;", "project", "Lcom/intellij/openapi/project/Project;", "requestor", "getUrls", "", "file", "currentAuthority", "", "intellij.javascript.debugger"})
final class BuiltInWebServerFileUrlMapper
extends FileUrlMapper {
    @NotNull
    public List<Url> getUrls(@NotNull VirtualFile file2, @NotNull Project project, @Nullable String currentAuthority) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return BuiltInWebBrowserUrlProviderKt.getBuiltInServerUrls((VirtualFile)file2, (Project)project, (String)currentAuthority, (boolean)false);
    }

    @Nullable
    public VirtualFile getFile(@NotNull Url url, @NotNull Project project, @Nullable Url requestor) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (!BuiltInWebBrowserUrlProviderKt.compareAuthority((String)url.getAuthority())) {
            return null;
        }
        String string2 = project.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"project.name");
        String projectName = string2;
        String string3 = url.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"url.path");
        String path = string3;
        if (!StringsKt.regionMatches((String)path, (int)1, (String)projectName, (int)0, (int)projectName.length(), (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0) && !BuiltInWebServerKt.compareNameAndProjectBasePath((String)projectName, (Project)project)) {
            return null;
        }
        int offset = StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)1, (boolean)false, (int)4, null);
        WebServerPathToFileManager webServerPathToFileManager = WebServerPathToFileManager.Companion.getInstance(project);
        if (offset == -1 || offset == path.length() - 1) {
            string = "";
        } else {
            String string4 = path;
            int n = offset + 1;
            WebServerPathToFileManager webServerPathToFileManager2 = webServerPathToFileManager;
            boolean bl = false;
            String string5 = string4;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            String string7 = string6;
            webServerPathToFileManager = webServerPathToFileManager2;
            string = string7;
        }
        return WebServerPathToFileManager.findVirtualFile$default((WebServerPathToFileManager)webServerPathToFileManager, (String)string, (boolean)false, null, (int)6, null);
    }
}

