/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.schema.parser.handlers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.language.schema.descriptors.EditorConfigDescriptor;
import org.editorconfig.language.schema.parser.EditorConfigJsonSchemaException;
import org.editorconfig.language.schema.parser.EditorConfigJsonSchemaParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H$J\u0016\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001f\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0005H\u0004\u00a2\u0006\u0002\u0010\u0018J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u001f\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0005H\u0004\u00a2\u0006\u0002\u0010\u001dJ\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0005H\u0004R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lorg/editorconfig/language/schema/parser/handlers/EditorConfigDescriptorParseHandlerBase;", "", "()V", "forbiddenChildren", "", "", "getForbiddenChildren", "()Ljava/util/List;", "optionalKeys", "getOptionalKeys", "requiredKeys", "getRequiredKeys", "assertContents", "", "jsonObject", "Lcom/google/gson/JsonObject;", "parser", "Lorg/editorconfig/language/schema/parser/EditorConfigJsonSchemaParser;", "doHandle", "Lorg/editorconfig/language/schema/descriptors/EditorConfigDescriptor;", "handle", "tryGetBoolean", "", "key", "(Lcom/google/gson/JsonObject;Ljava/lang/String;)Ljava/lang/Boolean;", "tryGetElement", "Lcom/google/gson/JsonElement;", "tryGetInt", "", "(Lcom/google/gson/JsonObject;Ljava/lang/String;)Ljava/lang/Integer;", "tryGetString", "intellij.editorconfig"})
public abstract class EditorConfigDescriptorParseHandlerBase {
    @NotNull
    private final List<String> optionalKeys = CollectionsKt.listOf((Object[])new String[]{"documentation", "type_alias", "deprecated"});
    @NotNull
    private final List<String> forbiddenChildren = CollectionsKt.emptyList();

    @NotNull
    protected abstract List<String> getRequiredKeys();

    @NotNull
    protected List<String> getOptionalKeys() {
        return this.optionalKeys;
    }

    @NotNull
    public List<String> getForbiddenChildren() {
        return this.forbiddenChildren;
    }

    @NotNull
    protected abstract EditorConfigDescriptor doHandle(@NotNull JsonObject var1, @NotNull EditorConfigJsonSchemaParser var2);

    @NotNull
    public final EditorConfigDescriptor handle(@NotNull JsonObject jsonObject, @NotNull EditorConfigJsonSchemaParser parser) {
        Intrinsics.checkParameterIsNotNull((Object)jsonObject, (String)"jsonObject");
        Intrinsics.checkParameterIsNotNull((Object)parser, (String)"parser");
        this.assertContents(jsonObject, parser);
        EditorConfigDescriptor result2 = this.doHandle(jsonObject, parser);
        String alias = this.tryGetString(jsonObject, "type_alias");
        if (alias != null) {
            parser.registerTypeAlias(alias, jsonObject);
        }
        return result2;
    }

    private final void assertContents(JsonObject jsonObject, EditorConfigJsonSchemaParser parser) {
        boolean bl;
        Set keys;
        block5: {
            keys = jsonObject.keySet();
            if (!keys.containsAll((Collection)this.getRequiredKeys())) {
                throw (Throwable)new EditorConfigJsonSchemaException((JsonElement)jsonObject);
            }
            Set set = keys;
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"keys");
            Iterable $this$all$iv = set;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (this.getRequiredKeys().contains(it) || this.getOptionalKeys().contains(it)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (!bl) {
            parser.warn("Unexpected option value descriptor key in " + keys);
        }
    }

    private final JsonElement tryGetElement(JsonObject jsonObject, String key) {
        return jsonObject.has(key) ? jsonObject.get(key) : null;
    }

    @Nullable
    protected final String tryGetString(@NotNull JsonObject jsonObject, @NotNull String key) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)jsonObject, (String)"jsonObject");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        try {
            JsonElement jsonElement = this.tryGetElement(jsonObject, key);
            string = jsonElement != null ? jsonElement.getAsString() : null;
        }
        catch (ClassCastException ex) {
            string = null;
        }
        catch (IllegalStateException ex) {
            string = null;
        }
        return string;
    }

    @Nullable
    protected final Integer tryGetInt(@NotNull JsonObject jsonObject, @NotNull String key) {
        Integer n;
        Intrinsics.checkParameterIsNotNull((Object)jsonObject, (String)"jsonObject");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        try {
            JsonElement jsonElement = this.tryGetElement(jsonObject, key);
            n = jsonElement != null ? Integer.valueOf(jsonElement.getAsInt()) : null;
        }
        catch (ClassCastException ex) {
            n = null;
        }
        catch (IllegalStateException ex) {
            n = null;
        }
        return n;
    }

    @Nullable
    protected final Boolean tryGetBoolean(@NotNull JsonObject jsonObject, @NotNull String key) {
        Boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)jsonObject, (String)"jsonObject");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        try {
            JsonElement jsonElement = this.tryGetElement(jsonObject, key);
            bl = jsonElement != null ? Boolean.valueOf(jsonElement.getAsBoolean()) : null;
        }
        catch (ClassCastException ex) {
            bl = null;
        }
        catch (IllegalStateException ex) {
            bl = null;
        }
        return bl;
    }
}

