/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.changes.committed.RepositoryLocationGroup;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipper;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.history.SvnRepositoryLocationGroup;

public class SvnCommittedListsZipper
implements VcsCommittedListsZipper {
    private static final Logger LOG = Logger.getInstance(SvnCommittedListsZipper.class);
    @NotNull
    private final SvnVcs myVcs;

    public SvnCommittedListsZipper(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            SvnCommittedListsZipper.$$$reportNull$$$0(0);
        }
        this.myVcs = vcs;
    }

    @NotNull
    public Pair<List<RepositoryLocationGroup>, List<RepositoryLocation>> groupLocations(@NotNull List<? extends RepositoryLocation> in) {
        if (in == null) {
            SvnCommittedListsZipper.$$$reportNull$$$0(1);
        }
        ArrayList<SvnRepositoryLocationGroup> groups = new ArrayList<SvnRepositoryLocationGroup>();
        ArrayList<Object> singles = new ArrayList<Object>();
        MultiMap map = new MultiMap();
        for (RepositoryLocation repositoryLocation : in) {
            SvnRepositoryLocation svnLocation = (SvnRepositoryLocation)repositoryLocation;
            Url root = svnLocation.getRepositoryUrl();
            if (root == null) {
                root = SvnUtil.getRepositoryRoot(this.myVcs, svnLocation.getURL());
            }
            if (root == null) {
                LOG.info("repository root not found for location:" + repositoryLocation.toPresentableString());
                singles.add(repositoryLocation);
                continue;
            }
            map.putValue((Object)root, (Object)svnLocation);
        }
        Set keys = map.keySet();
        for (Url key : keys) {
            Collection repositoryLocations = map.get((Object)key);
            if (repositoryLocations.size() == 1) {
                singles.add(repositoryLocations.iterator().next());
                continue;
            }
            SvnRepositoryLocationGroup group = new SvnRepositoryLocationGroup(key, repositoryLocations);
            groups.add(group);
        }
        Pair pair = Pair.create(groups, singles);
        if (pair == null) {
            SvnCommittedListsZipper.$$$reportNull$$$0(2);
        }
        return pair;
    }

    @NotNull
    public CommittedChangeList zip(@NotNull RepositoryLocationGroup group, @NotNull List<? extends CommittedChangeList> lists) {
        if (group == null) {
            SvnCommittedListsZipper.$$$reportNull$$$0(3);
        }
        if (lists == null) {
            SvnCommittedListsZipper.$$$reportNull$$$0(4);
        }
        return new SvnChangeList(lists, new SvnRepositoryLocation(group.toPresentableString()));
    }

    public long getNumber(@NotNull CommittedChangeList list) {
        if (list == null) {
            SvnCommittedListsZipper.$$$reportNull$$$0(5);
        }
        return list.getNumber();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/history/SvnCommittedListsZipper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lists";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/history/SvnCommittedListsZipper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "groupLocations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "groupLocations";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "zip";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNumber";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

