/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.ui.BundleAccessor;
import com.intellij.remote.ui.SdkScopeController;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshConfigProjectLevelSetupForm {
    private static final Logger LOG = Logger.getInstance(SshConfigProjectLevelSetupForm.class);
    private JPanel myMainPanel;
    private JPanel myProjectLevelSshConfigSetupPanel;
    private HyperlinkLabel mySshLevelWarningLabel;
    private ActionLink mySshMoveSshConfigLink;
    private JBLabel myMoveSshConfigLabel;
    private JPanel myCustomActionPanel;
    @Nullable
    private Project myProject;
    @NotNull
    private final Listener myListener;
    @Nullable
    private String mySshConfigName;
    @Nullable
    private final BundleAccessor myBundleAccessor;
    @NotNull
    private final SdkScopeController mySdkScopeController;

    public SshConfigProjectLevelSetupForm(@Nullable Project project, @Nullable BundleAccessor bundleAccessor, @NotNull Listener listener, @NotNull SdkScopeController sdkScopeController) {
        if (listener == null) {
            SshConfigProjectLevelSetupForm.$$$reportNull$$$0(0);
        }
        if (sdkScopeController == null) {
            SshConfigProjectLevelSetupForm.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myBundleAccessor = bundleAccessor;
        this.myListener = listener;
        this.mySdkScopeController = sdkScopeController;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        String moveTooltip = RemoteSdkBundle.message("ssh.config.will.be.visible.for.all.projects", objectArray);
        this.mySshMoveSshConfigLink.setToolTipText(moveTooltip);
        this.myMoveSshConfigLabel.setToolTipText(moveTooltip);
        this.myProjectLevelSshConfigSetupPanel.setBorder((Border)JBUI.Borders.emptyTop((int)JBUIScale.scale((int)10)));
        this.configureSshLevelWarning();
        if (bundleAccessor != null) {
            this.mySshMoveSshConfigLink.setText(StringUtil.notNullize((String)bundleAccessor.messageOrNull("remote.interpreter.move.ssh.config.action.link", new Object[0]), (String)RemoteSdkBundle.message("move.label", new Object[0])));
            this.myMoveSshConfigLabel.setText(StringUtil.notNullize((String)bundleAccessor.messageOrNull("remote.interpreter.move.ssh.config.label", new Object[0]), (String)RemoteSdkBundle.message("this.config.to.IDE.settings", new Object[0])));
        }
        if (sdkScopeController.isProjectLevelSupported()) {
            this.configureMoveInterpreterAction();
        }
    }

    private void configureSshLevelWarning() {
        String warningMessage;
        String customMessage;
        String string = customMessage = this.myBundleAccessor == null ? null : this.myBundleAccessor.messageOrNull("remote.interpreter.ssh.level.incompatibility", new Object[0]);
        if (customMessage != null) {
            warningMessage = customMessage;
        } else {
            String message = this.myBundleAccessor == null ? null : this.myBundleAccessor.messageOrNull("remote.interpreter.entity.name", new Object[0]);
            warningMessage = RemoteSdkBundle.message("0.is.saved.in.a.href.ide.settings.a.so.it.needs.the.ssh.config.to.be.saved.there.too", StringUtil.notNullize((String)message, (String)RemoteSdkBundle.message("remote.sdk", new Object[0])));
        }
        this.mySshLevelWarningLabel.setHtmlText(warningMessage);
        this.mySshLevelWarningLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HelpManager.getInstance().invokeHelp("concepts.project.settings");
                }
            }
        });
    }

    private void configureMoveInterpreterAction() {
        String moveTooltip = RemoteSdkBundle.message("remote.interpreter.move.interpreter.tooltip", new Object[0]);
        ActionLink interpreterMoveLink = new ActionLink(RemoteSdkBundle.message("remote.interpreter.move.interpreter.action.link", new Object[0]), new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                SshConfigProjectLevelSetupForm.this.mySdkScopeController.setProjectLevel(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/remotesdk/ui/SshConfigProjectLevelSetupForm$2", "actionPerformed"));
            }
        });
        interpreterMoveLink.setToolTipText(moveTooltip);
        this.myCustomActionPanel.add((Component)interpreterMoveLink);
        JBLabel label = new JBLabel(RemoteSdkBundle.message("remote.interpreter.move.interpreter.label", new Object[0]));
        label.setToolTipText(moveTooltip);
        this.myCustomActionPanel.add((Component)label);
    }

    protected void createUIComponents() {
        this.mySshMoveSshConfigLink = new ActionLink(RemoteSdkBundle.message("move.label", new Object[0]), new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                SshConfigManager instance = SshConfigManager.getInstance((Project)SshConfigProjectLevelSetupForm.this.myProject);
                SshUiData data = instance.findCurrentDataByName(SshConfigProjectLevelSetupForm.this.mySshConfigName);
                LOG.assertTrue(data != null, (Object)("SSH configuration with name " + SshConfigProjectLevelSetupForm.this.mySshConfigName + " not found"));
                LOG.assertTrue(data.getConfig().isProjectLevel(), (Object)"IDE-level SSH configuration with actions shown");
                SshUiData movedData = instance.moveDataConfig(data);
                SshConfigProjectLevelSetupForm.this.myListener.onConfigMoved(movedData.getConfig());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/remotesdk/ui/SshConfigProjectLevelSetupForm$3", "actionPerformed"));
            }
        });
    }

    @NotNull
    public JPanel getMainPanel() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            SshConfigProjectLevelSetupForm.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    public void setSshConfigName(@Nullable String sshConfigName) {
        this.mySshConfigName = sshConfigName;
    }

    public void setProject(@Nullable Project project) {
        this.myProject = project;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        HyperlinkLabel hyperlinkLabel;
        JPanel jPanel;
        JBLabel jBLabel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myProjectLevelSshConfigSetupPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0, 1, -1));
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        ActionLink actionLink = this.mySshMoveSshConfigLink;
        actionLink.setHorizontalTextPosition(10);
        this.$$$loadLabelText$$$((JLabel)actionLink, DynamicBundle.getBundle((String)"messages/RemoteSdk", SshConfigProjectLevelSetupForm.class).getString("move.label"));
        Component component = jPanel4.add((Component)actionLink);
        this.myMoveSshConfigLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/RemoteSdk", SshConfigProjectLevelSetupForm.class).getString("this.config.to.IDE.settings"));
        Component component2 = jPanel4.add((Component)jBLabel);
        this.myCustomActionPanel = jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, -1, -1));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(0, -1, -1));
        jPanel2.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySshLevelWarningLabel = hyperlinkLabel = new HyperlinkLabel();
        hyperlinkLabel.setText("");
        Component component3 = jPanel5.add((Component)hyperlinkLabel);
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkScopeController";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/ui/SshConfigProjectLevelSetupForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/ui/SshConfigProjectLevelSetupForm";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Listener {
        public void onConfigMoved(@NotNull SshConfig var1);
    }
}

