/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.transport;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.remote.AuthType;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.AgentProxyConnectorFactory;
import com.intellij.ssh.SessionConfig;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshBackendLibrary;
import com.intellij.ssh.SshConnectionService;
import com.intellij.ssh.SshConnectionUtil;
import com.intellij.ssh.SshHostKeyVerifier;
import com.intellij.ssh.SshPasswordProvider;
import com.intellij.ssh.SshSessionKey;
import com.intellij.ssh.config.OpenSSHClientConfig;
import com.intellij.ssh.config.OpenSSHConfigService;
import com.intellij.ssh.interaction.ConnectionOwner;
import com.intellij.ssh.interaction.ConnectionOwnerFactory;
import com.intellij.ssh.interaction.RemoteProcessUserInfo;
import com.intellij.ssh.legacy.SftpIdentityInfo;
import com.intellij.util.EventDispatcher;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.SocketFactory;
import com.jetbrains.plugins.remotesdk.transport.SshConnectionServiceUtil$WhenMappings;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.commons.vfs2.provider.sftp.SftpClientFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000P\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u001b\u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u001a:\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007\u001a(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u001a\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0014\u001a\u00020\u0015*\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u001a\u0016\u0010\u0018\u001a\u00020\u0019*\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u00a8\u0006\u001a"}, d2={"getIdentities", "", "Lcom/intellij/ssh/legacy/SftpIdentityInfo;", "data", "Lcom/intellij/remote/RemoteCredentials;", "(Lcom/intellij/remote/RemoteCredentials;)[Lcom/intellij/ssh/legacy/SftpIdentityInfo;", "remoteCredentialsToSessionConfig", "Lcom/intellij/ssh/SessionConfig;", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "project", "Lcom/intellij/openapi/project/Project;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "sshPasswordProvider", "Lcom/intellij/ssh/SshPasswordProvider;", "remoteCredentialsToSessionKey", "Lcom/intellij/ssh/SshSessionKey;", "computePort", "", "openSSHConfig", "Lcom/intellij/ssh/config/OpenSSHClientConfig;", "computeUserName", "", "intellij.remoteRun"})
@JvmName(name="SshConnectionServiceUtil")
public final class SshConnectionServiceUtil {
    @Nullable
    public static final SftpIdentityInfo[] getIdentities(@NotNull RemoteCredentials data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        if (data.getAuthType() == AuthType.KEY_PAIR) {
            String string = data.getPrivateKeyFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"data.privateKeyFile");
            String privateKeyFile = string;
            CharSequence charSequence = privateKeyFile;
            boolean bl = false;
            if (charSequence.length() > 0) {
                byte[] byArray;
                String currentPassphrase = data.getPassphrase();
                CharSequence charSequence2 = currentPassphrase;
                boolean bl2 = false;
                boolean bl3 = false;
                if (charSequence2 == null || charSequence2.length() == 0) {
                    byArray = null;
                } else {
                    charSequence2 = currentPassphrase;
                    Charset charset = Charsets.UTF_8;
                    bl3 = false;
                    CharSequence charSequence3 = charSequence2;
                    if (charSequence3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    byte[] byArray2 = ((String)charSequence3).getBytes(charset);
                    byArray = byArray2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
                }
                byte[] passphrase = byArray;
                return new SftpIdentityInfo[]{new SftpIdentityInfo(new File(privateKeyFile), null, passphrase, 2, null)};
            }
        }
        return null;
    }

    @NotNull
    public static final SshSessionKey remoteCredentialsToSessionKey(@NotNull RemoteCredentials data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        String string = data.getUserName();
        if (string == null) {
            string = "";
        }
        String string2 = data.getHost();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"data.host");
        return new SshSessionKey(string, string2, data.getPort(), data.getPassword(), SshConnectionServiceUtil.getIdentities(data), data.getAuthType() == AuthType.OPEN_SSH ? SshConnectionService.Companion.getInstance().getAgentProxyConnectorFactory() : null, null, 64, null);
    }

    @JvmOverloads
    @NotNull
    public static final SessionConfig remoteCredentialsToSessionConfig(@NotNull RemoteCredentials data, long timeout, @NotNull TimeUnit timeUnit, @Nullable Project project, @Nullable ProgressIndicator progressIndicator) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)((Object)timeUnit), (String)"timeUnit");
        ConnectionOwner connectionOwner = ConnectionOwnerFactory.createConnectionOwnerWithDialogMessages((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)connectionOwner, (String)"ConnectionOwnerFactory.c\u2026thDialogMessages(project)");
        ConnectionOwner connectionOwner2 = connectionOwner;
        RemoteProcessUserInfo sshPasswordProvider = new RemoteProcessUserInfo(connectionOwner2, data, progressIndicator);
        return SshConnectionServiceUtil.remoteCredentialsToSessionConfig(data, timeout, timeUnit, (SshPasswordProvider)sshPasswordProvider);
    }

    public static /* synthetic */ SessionConfig remoteCredentialsToSessionConfig$default(RemoteCredentials remoteCredentials, long l, TimeUnit timeUnit, Project project, ProgressIndicator progressIndicator, int n, Object object) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            timeUnit = TimeUnit.SECONDS;
        }
        if ((n & 0x10) != 0) {
            progressIndicator = null;
        }
        return SshConnectionServiceUtil.remoteCredentialsToSessionConfig(remoteCredentials, l, timeUnit, project, progressIndicator);
    }

    @JvmOverloads
    @NotNull
    public static final SessionConfig remoteCredentialsToSessionConfig(@NotNull RemoteCredentials data, long timeout, @NotNull TimeUnit timeUnit, @Nullable Project project) {
        return SshConnectionServiceUtil.remoteCredentialsToSessionConfig$default(data, timeout, timeUnit, project, null, 16, null);
    }

    @JvmOverloads
    @NotNull
    public static final SessionConfig remoteCredentialsToSessionConfig(@NotNull RemoteCredentials data, long timeout, @Nullable Project project) {
        return SshConnectionServiceUtil.remoteCredentialsToSessionConfig$default(data, timeout, null, project, null, 20, null);
    }

    @JvmOverloads
    @NotNull
    public static final SessionConfig remoteCredentialsToSessionConfig(@NotNull RemoteCredentials data, @Nullable Project project) {
        return SshConnectionServiceUtil.remoteCredentialsToSessionConfig$default(data, 0L, null, project, null, 22, null);
    }

    @NotNull
    public static final SessionConfig remoteCredentialsToSessionConfig(@NotNull RemoteCredentials data, long timeout, @NotNull TimeUnit timeUnit, @Nullable SshPasswordProvider sshPasswordProvider) {
        AgentProxyConnectorFactory agentProxyConnectorFactory;
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)((Object)timeUnit), (String)"timeUnit");
        int timeoutInMillis = SshConnectionUtil.toTimeoutInMillis((long)timeout, (TimeUnit)timeUnit);
        File knownHostsFile = null;
        File knownHostsFileCandidate = new File(SftpClientFactory.findSshDir(), "known_hosts");
        if (knownHostsFileCandidate.isFile() && knownHostsFileCandidate.canRead()) {
            knownHostsFile = knownHostsFileCandidate;
        }
        SftpIdentityInfo[] identities = null;
        if (data.getAuthType() == AuthType.KEY_PAIR) {
            byte[] byArray;
            SftpIdentityInfo[] sftpIdentityInfoArray = new SftpIdentityInfo[1];
            SftpIdentityInfo[] sftpIdentityInfoArray2 = sftpIdentityInfoArray;
            SftpIdentityInfo[] sftpIdentityInfoArray3 = sftpIdentityInfoArray;
            int n = 0;
            File file = new File(data.getPrivateKeyFile());
            File file2 = null;
            String string = data.getPassphrase();
            if (string != null) {
                String string2 = string;
                File file3 = file2;
                File file4 = file;
                int n2 = n;
                SftpIdentityInfo[] sftpIdentityInfoArray4 = sftpIdentityInfoArray2;
                SftpIdentityInfo[] sftpIdentityInfoArray5 = sftpIdentityInfoArray3;
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray2 = string3.getBytes(charset);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] byArray3 = byArray2;
                sftpIdentityInfoArray3 = sftpIdentityInfoArray5;
                sftpIdentityInfoArray2 = sftpIdentityInfoArray4;
                n = n2;
                file = file4;
                file2 = file3;
                byArray = byArray3;
            } else {
                byArray = null;
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n3 = 2;
            byte[] byArray4 = byArray;
            File file5 = file2;
            File file6 = file;
            sftpIdentityInfoArray2[n] = new SftpIdentityInfo(file6, file5, byArray4, n3, defaultConstructorMarker);
            identities = sftpIdentityInfoArray3;
        } else {
            identities = null;
        }
        OpenSSHClientConfig openSSHConfig = data.getAuthType() == AuthType.OPEN_SSH ? OpenSSHConfigService.Companion.getInstance().getConfig() : null;
        SshBackendLibrary sshBackendLibrary = SshBackendLibrary.Companion.get();
        Properties config = Ssh.createSessionConfig((SshBackendLibrary)sshBackendLibrary);
        String string = SshConnectionServiceUtil.computeUserName(data, openSSHConfig);
        String string4 = data.getHost();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"data.host");
        int n = SshConnectionServiceUtil.computePort(data, openSSHConfig);
        Integer n4 = timeoutInMillis;
        switch (SshConnectionServiceUtil$WhenMappings.$EnumSwitchMapping$0[data.getAuthType().ordinal()]) {
            case 1: {
                agentProxyConnectorFactory = SshConnectionService.Companion.getInstance().getAgentProxyConnectorFactory();
                break;
            }
            default: {
                agentProxyConnectorFactory = null;
            }
        }
        SshBackendLibrary sshBackendLibrary2 = sshBackendLibrary;
        OpenSSHClientConfig openSSHClientConfig = openSSHConfig;
        EventDispatcher eventDispatcher = null;
        File file = knownHostsFile;
        AgentProxyConnectorFactory agentProxyConnectorFactory2 = agentProxyConnectorFactory;
        SshHostKeyVerifier sshHostKeyVerifier = null;
        SftpIdentityInfo[] sftpIdentityInfoArray = identities;
        boolean bl = false;
        Integer n5 = null;
        Integer n6 = null;
        SocketFactory socketFactory = null;
        Proxy proxy = null;
        SshPasswordProvider sshPasswordProvider2 = sshPasswordProvider;
        Properties properties = config;
        Integer n7 = n4;
        return new SessionConfig(string, string4, n, null, properties, n7, sshPasswordProvider2, proxy, socketFactory, n6, n5, bl, file, sshHostKeyVerifier, sftpIdentityInfoArray, agentProxyConnectorFactory2, eventDispatcher, sshBackendLibrary2, openSSHClientConfig, 77704, null);
    }

    private static final String computeUserName(@NotNull RemoteCredentials $this$computeUserName, OpenSSHClientConfig openSSHConfig) {
        String userName = $this$computeUserName.getUserName();
        if (userName == null) {
            if (openSSHConfig == null) {
                throw (Throwable)new IllegalStateException("User is not specified in connection settings");
            }
            userName = openSSHConfig.getConfig($this$computeUserName.getHost()).getUser();
            if (userName == null) {
                throw (Throwable)new IllegalStateException("User is neither specified in connection settings nor in OpenSSH client config");
            }
        }
        return userName;
    }

    private static final int computePort(@NotNull RemoteCredentials $this$computePort, OpenSSHClientConfig openSSHConfig) {
        int port = $this$computePort.getPort();
        if (port == -1) {
            if (openSSHConfig == null) {
                throw (Throwable)new IllegalStateException("Port is not specified in connection settings");
            }
            port = openSSHConfig.getConfig($this$computePort.getHost()).getPort();
            if (port == -1) {
                throw (Throwable)new IllegalStateException("Port is neither specified in connection settings nor in OpenSSH client config");
            }
        }
        return port;
    }
}

