/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pyramid;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import com.jetbrains.pyramid.project.PyramidUtils;
import com.jetbrains.pyramid.templates.ChameleonLanguage;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.templateLanguages.TemplatesService;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class PyramidProjectConfigurator
implements DirectoryProjectConfigurator {
    public void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Ref<Module> moduleRef, boolean newProject) {
        Module module;
        if (project == null) {
            PyramidProjectConfigurator.$$$reportNull$$$0(0);
        }
        if (baseDir == null) {
            PyramidProjectConfigurator.$$$reportNull$$$0(1);
        }
        if (moduleRef == null) {
            PyramidProjectConfigurator.$$$reportNull$$$0(2);
        }
        if ((module = (Module)moduleRef.get()) != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (PyramidProjectConfigurator.isPyramidProject(module, baseDir)) {
                    PyramidProjectConfigurator.configurePyramidProject(module, baseDir, TemplatesService.getInstance((Module)module));
                }
            }, ModalityState.current(), module.getDisposed());
        }
    }

    private static boolean isPyramidProject(@NotNull Module module, @NotNull VirtualFile baseDir) {
        VirtualFile developmentIni;
        if (module == null) {
            PyramidProjectConfigurator.$$$reportNull$$$0(3);
        }
        if (baseDir == null) {
            PyramidProjectConfigurator.$$$reportNull$$$0(4);
        }
        if ((developmentIni = baseDir.findChild("development.ini")) == null) {
            return false;
        }
        List requires = PyPackageUtil.findSetupPyRequires((Module)module);
        if (requires == null) {
            return false;
        }
        return requires.stream().anyMatch(requirement -> requirement.getName().startsWith("pyramid"));
    }

    private static void configurePyramidProject(@NotNull Module module, @NotNull VirtualFile baseDir, @NotNull TemplatesService service) {
        VirtualFile templates;
        VirtualFile app;
        if (module == null) {
            PyramidProjectConfigurator.$$$reportNull$$$0(5);
        }
        if (baseDir == null) {
            PyramidProjectConfigurator.$$$reportNull$$$0(6);
        }
        if (service == null) {
            PyramidProjectConfigurator.$$$reportNull$$$0(7);
        }
        if (service.getTemplateFolders().isEmpty() && (app = baseDir.findChild(baseDir.getName().toLowerCase(Locale.getDefault()))) != null && (templates = app.findChild("templates")) != null) {
            service.setTemplateFolderPaths(new String[]{templates.getPath()});
        }
        if (service.getTemplateLanguage() == "None") {
            service.setTemplateLanguage(ChameleonLanguage.INSTANCE.getTemplateLanguageName());
        }
        PyramidUtils.createRunConfigurations((Module)module, (VirtualFile)baseDir);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRef";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/pyramid/PyramidProjectConfigurator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "configureProject";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isPyramidProject";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "configurePyramidProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

