/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.remote.CredentialsType;
import com.jetbrains.django.facet.DjangoProjectCreateWizardPanel;
import com.jetbrains.django.facet.DjangoWizardSettingsHolder;
import com.jetbrains.django.model.DjangoProjectCreatorAndConfigurator;
import com.jetbrains.django.run.DjangoServerRunConfiguration;
import com.jetbrains.django.run.DjangoServerRunConfigurationType;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.PythonStringUtil;
import com.jetbrains.python.newProject.PyFrameworkProjectGenerator;
import com.jetbrains.python.newProject.PythonProjectGenerator;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.remote.PyProjectSynchronizer;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.remote.PySyncDirection;
import com.jetbrains.python.run.PyRunConfigurationFactory;
import com.jetbrains.python.run.PyRunConfigurationFactoryEx;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.templateLanguages.PyTemplatesUtil;
import com.jetbrains.python.templateLanguages.TemplateSettingsHolder;
import com.jetbrains.python.templateLanguages.TemplatesService;
import icons.PythonUltimateIcons;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoProjectGenerator
extends PythonProjectGenerator<DjangoWizardSettingsHolder>
implements PyFrameworkProjectGenerator {
    private static final String VAGRANT_CREDENTIALS_TYPE_NAME = "Vagrant";
    private DjangoProjectCreateWizardPanel myWizardPanel;

    public DjangoProjectGenerator() {
        super(true);
    }

    @NotNull
    @Nls
    public String getName() {
        String string = DjangoBundle.message((String)"django", (Object[])new Object[0]);
        if (string == null) {
            DjangoProjectGenerator.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFrameworkTitle() {
        return "Django";
    }

    public boolean isFrameworkInstalled(@NotNull Sdk sdk) {
        List packages;
        if (sdk == null) {
            DjangoProjectGenerator.$$$reportNull$$$0(1);
        }
        return PyPsiPackageUtil.findPackage((List)(packages = PyPackageUtil.refreshAndGetPackagesModally((Sdk)sdk)), (String)"django") != null;
    }

    public void locationChanged(@NotNull String newLocation) {
        if (newLocation == null) {
            DjangoProjectGenerator.$$$reportNull$$$0(2);
        }
        super.locationChanged(newLocation);
        this.myWizardPanel.setProjectName(newLocation);
    }

    public boolean supportsPython3() {
        return true;
    }

    @Nullable
    public Icon getLogo() {
        return PythonUltimateIcons.Django.Django;
    }

    @Nullable
    public JComponent getSettingsPanel(File baseDir) throws ProcessCanceledException {
        this.myWizardPanel = new DjangoProjectCreateWizardPanel(this.myErrorCallback);
        this.myWizardPanel.setProjectName(baseDir.getName());
        this.myWizardPanel.registerValidators(new FacetValidatorsManager(){

            public void registerValidator(FacetEditorValidator validator, JComponent ... componentsToWatch) {
                throw new UnsupportedOperationException();
            }

            public void validate() {
                DjangoProjectGenerator.this.fireStateChanged();
            }
        });
        return this.myWizardPanel;
    }

    public DjangoWizardSettingsHolder getProjectSettings() {
        DjangoWizardSettingsHolder settingsHolder = new DjangoWizardSettingsHolder();
        this.myWizardPanel.saveSettings(settingsHolder);
        return settingsHolder;
    }

    public final void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull DjangoWizardSettingsHolder settings, @NotNull Module module, @Nullable PyProjectSynchronizer synchronizer) {
        if (project == null) {
            DjangoProjectGenerator.$$$reportNull$$$0(3);
        }
        if (baseDir == null) {
            DjangoProjectGenerator.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            DjangoProjectGenerator.$$$reportNull$$$0(5);
        }
        if (module == null) {
            DjangoProjectGenerator.$$$reportNull$$$0(6);
        }
        Sdk sdk = settings.getSdk() != null ? settings.getSdk() : PythonSdkUtil.findPythonSdk((Module)module);
        DjangoProjectGenerator.installFrameworkIfNeeded((Project)project, (String)"Django", (String)"django", (Sdk)sdk, (boolean)settings.installFramework(), () -> {
            if (sdk != null) {
                TemplatesService.getInstance((Module)module).installTemplateEngine((TemplateSettingsHolder)settings, sdk, project, "django-");
                try {
                    DjangoProjectGenerator.doConfigureProject(project, baseDir, settings, module, synchronizer, sdk);
                }
                catch (ExecutionException e) {
                    Messages.showErrorDialog((Project)project, (String)DjangoBundle.message((String)"django.error.creating.django.application.0", (Object[])new Object[]{e.getMessage()}), (String)DjangoBundle.message((String)"django.create.django.application", (Object[])new Object[0]));
                }
            }
        });
    }

    private static void doConfigureProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull DjangoWizardSettingsHolder settings, @NotNull Module module, @Nullable PyProjectSynchronizer synchronizer, Sdk sdk) throws ExecutionException {
        if (project == null) {
            DjangoProjectGenerator.$$$reportNull$$$0(7);
        }
        if (baseDir == null) {
            DjangoProjectGenerator.$$$reportNull$$$0(8);
        }
        if (settings == null) {
            DjangoProjectGenerator.$$$reportNull$$$0(9);
        }
        if (module == null) {
            DjangoProjectGenerator.$$$reportNull$$$0(10);
        }
        Consumer<Consumer> syncCallBack = synchronizer != null ? callback -> synchronizer.syncProject(module, PySyncDirection.REMOTE_TO_LOCAL, callback, new String[0]) : null;
        DjangoProjectCreatorAndConfigurator.createProject((VirtualFile)baseDir, (Sdk)settings.getSdk(), (DjangoWizardSettingsHolder)settings, (Module)module, syncCallBack);
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
            RunnerAndConfigurationSettings configuration = ((PyRunConfigurationFactoryEx)PyRunConfigurationFactory.getInstance()).createRunConfiguration(module, (ConfigurationFactory)DjangoServerRunConfigurationType.getInstance().getDjangoFactory());
            PyRemoteSdkAdditionalData sdkAdditionalData = (PyRemoteSdkAdditionalData)PyUtil.as((Object)sdk.getSdkAdditionalData(), PyRemoteSdkAdditionalData.class);
            if (sdkAdditionalData != null) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> DjangoProjectGenerator.configureCorrectHost(configuration, sdkAdditionalData));
            }
            ApplicationManager.getApplication().invokeLater(() -> DjangoProjectGenerator.openFilesInEditor(project, baseDir.findChild(settings.getProjectName()), "settings.py", "urls.py"));
        });
    }

    private static void configureCorrectHost(@NotNull RunnerAndConfigurationSettings configuration, @NotNull PyRemoteSdkAdditionalData sdkAdditionalData) {
        if (configuration == null) {
            DjangoProjectGenerator.$$$reportNull$$$0(11);
        }
        if (sdkAdditionalData == null) {
            DjangoProjectGenerator.$$$reportNull$$$0(12);
        }
        DjangoServerRunConfiguration djangoServerRunConfiguration = (DjangoServerRunConfiguration)configuration.getConfiguration();
        if (DjangoProjectGenerator.isVagrantCredentialsType(sdkAdditionalData.getRemoteConnectionType())) {
            djangoServerRunConfiguration.setHost("0.0.0.0");
            return;
        }
        String host = null;
        try {
            host = sdkAdditionalData.getRemoteSdkCredentials(false).getHost();
            InetAddress remotePublic = InetAddress.getByName(host);
            djangoServerRunConfiguration.setHost(remotePublic.getHostAddress());
        }
        catch (UnknownHostException ignored) {
            if (host != null) {
                djangoServerRunConfiguration.setHost(host);
            }
        }
        catch (ExecutionException | InterruptedException throwable) {
            // empty catch block
        }
    }

    private static boolean isVagrantCredentialsType(@NotNull CredentialsType<?> credentialsType) {
        if (credentialsType == null) {
            DjangoProjectGenerator.$$$reportNull$$$0(13);
        }
        return VAGRANT_CREDENTIALS_TYPE_NAME.equals(credentialsType.getName());
    }

    @NotNull
    public ValidationResult validate(@NotNull String baseDirPath) {
        String projectName;
        ValidationResult result;
        if (baseDirPath == null) {
            DjangoProjectGenerator.$$$reportNull$$$0(14);
        }
        if ((result = DjangoProjectCreateWizardPanel.validateProjectName((String)(projectName = PythonStringUtil.getLastSuffix((String)baseDirPath, (String)String.valueOf(File.separatorChar))))).isOk() && this.myWizardPanel != null && (result = this.myWizardPanel.validateDjangoNames(projectName)).isOk()) {
            result = this.myWizardPanel.getValidationResult();
        }
        ValidationResult validationResult = result;
        if (validationResult == null) {
            DjangoProjectGenerator.$$$reportNull$$$0(15);
        }
        return validationResult;
    }

    public ValidationResult warningValidation(@Nullable Sdk sdk) {
        if (this.myWizardPanel == null) {
            return ValidationResult.OK;
        }
        ValidationResult result = PyTemplatesUtil.checkInstalled((Sdk)sdk, (String)this.myWizardPanel.getTemplatesPanel().getTemplateLanguage(), (String)"django-");
        return result == null ? super.warningValidation(sdk) : result;
    }

    public static void openFilesInEditor(Project project, VirtualFile baseDir, String ... fileNames) {
        if (baseDir == null) {
            return;
        }
        PsiDirectory psiBaseDir = PsiManager.getInstance((Project)project).findDirectory(baseDir);
        if (psiBaseDir != null) {
            for (String fileName : fileNames) {
                PsiFile appYaml = psiBaseDir.findFile(fileName);
                if (appYaml == null) continue;
                appYaml.navigate(fileName == fileNames[fileNames.length - 1]);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/DjangoProjectGenerator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newLocation";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkAdditionalData";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentialsType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/DjangoProjectGenerator";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isFrameworkInstalled";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "locationChanged";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "configureProject";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doConfigureProject";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "configureCorrectHost";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isVagrantCredentialsType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

