/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.appengine.facet.AppEngineFacet;
import com.jetbrains.appengine.facet.AppEngineFacetConfiguration;
import com.jetbrains.appengine.facet.AppEngineFacetType;
import com.jetbrains.appengine.facet.AppEngineNewProjectPanel;
import com.jetbrains.appengine.facet.AppEngineWizardSettingsHolder;
import com.jetbrains.appengine.run.AppEngineServerRunConfigurationType;
import com.jetbrains.appengine.ui.AppEngineBundle;
import com.jetbrains.appengine.util.AppEngineProjectCreator;
import com.jetbrains.appengine.util.AppEngineUtil;
import com.jetbrains.django.DjangoProjectGenerator;
import com.jetbrains.django.facet.DjangoWizardSettingsHolder;
import com.jetbrains.django.model.DjangoProjectCreatorAndConfigurator;
import com.jetbrains.python.newProject.PyFrameworkProjectGenerator;
import com.jetbrains.python.newProject.PythonProjectGenerator;
import com.jetbrains.python.packaging.PyCondaPackageManagerImpl;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyRequirementsKt;
import com.jetbrains.python.remote.PyProjectSynchronizer;
import com.jetbrains.python.run.PyRunConfigurationFactory;
import com.jetbrains.python.run.PyRunConfigurationFactoryEx;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.templateLanguages.PyTemplatesUtil;
import com.jetbrains.python.templateLanguages.TemplateLanguagePanel;
import com.jetbrains.python.templateLanguages.TemplateSettingsHolder;
import com.jetbrains.python.templateLanguages.TemplatesService;
import icons.PythonUltimateIcons;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppEngineProjectGenerator
extends PythonProjectGenerator<AppEngineWizardSettingsHolder>
implements PyFrameworkProjectGenerator {
    private AppEngineNewProjectPanel mySettingsPanel;

    @NotNull
    @Nls
    public String getName() {
        String string = AppEngineBundle.message((String)"python.app.engine.project.name", (Object[])new Object[0]);
        if (string == null) {
            AppEngineProjectGenerator.$$$reportNull$$$0(0);
        }
        return string;
    }

    public JComponent getSettingsPanel(File baseDir) throws ProcessCanceledException {
        this.mySettingsPanel = new AppEngineNewProjectPanel(baseDir.getName());
        this.mySettingsPanel.registerValidators(new FacetValidatorsManager(){

            public void registerValidator(FacetEditorValidator validator, JComponent ... componentsToWatch) {
                throw new UnsupportedOperationException();
            }

            public void validate() {
                AppEngineProjectGenerator.this.fireStateChanged();
            }
        });
        return this.mySettingsPanel;
    }

    public ValidationResult warningValidation(@Nullable Sdk sdk) {
        if (this.mySettingsPanel == null) {
            return ValidationResult.OK;
        }
        TemplateLanguagePanel panel = this.mySettingsPanel.getTemplatesPanel();
        if (panel == null) {
            return super.warningValidation(sdk);
        }
        ValidationResult result = PyTemplatesUtil.checkInstalled((Sdk)sdk, (String)panel.getTemplateLanguage(), (String)"pyramid_");
        return result == null ? super.warningValidation(sdk) : result;
    }

    public AppEngineWizardSettingsHolder getProjectSettings() {
        AppEngineWizardSettingsHolder settingsHolder = new AppEngineWizardSettingsHolder();
        this.mySettingsPanel.saveSettings(settingsHolder);
        return settingsHolder;
    }

    public void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull AppEngineWizardSettingsHolder settings, @NotNull Module module, @Nullable PyProjectSynchronizer synchronizer) {
        if (project == null) {
            AppEngineProjectGenerator.$$$reportNull$$$0(1);
        }
        if (baseDir == null) {
            AppEngineProjectGenerator.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            AppEngineProjectGenerator.$$$reportNull$$$0(3);
        }
        if (module == null) {
            AppEngineProjectGenerator.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                SdkConfigurationUtil.setDirectoryProjectSdk((Project)project, (Sdk)settings.getSdk());
                AppEngineProjectCreator.createProject((VirtualFile)baseDir, (AppEngineWizardSettingsHolder)settings);
            }
            catch (IOException e) {
                Messages.showErrorDialog((Project)project, (String)AppEngineBundle.message((String)"python.app.engine.project.create.error", (Object[])new Object[]{e.getMessage()}), (String)AppEngineBundle.message((String)"python.app.engine.project.create", (Object[])new Object[0]));
            }
        });
        AppEngineProjectGenerator.setupThirdPartyLibs(project, baseDir, settings, module);
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
            AppEngineProjectGenerator.configureAppEngineFacet(module, settings, baseDir.getPath());
            AppEngineUtil.initAppEngineModuleLibrary((Module)module, null, (String)settings.getAppEngineSdkFolder(), (String)baseDir.getPath());
            ApplicationManager.getApplication().runWriteAction(() -> {
                String templatesFolder;
                if (settings.getProjectName() == null && (templatesFolder = settings.getTemplatesFolder()) != null) {
                    TemplatesService.getInstance((Module)module).generateTemplates((TemplateSettingsHolder)settings, baseDir);
                }
            });
            baseDir.getFileSystem().refresh(false);
            DjangoProjectGenerator.openFilesInEditor(project, baseDir, "app.yaml", "main.py");
        });
    }

    private static void setupThirdPartyLibs(Project project, VirtualFile baseDir, final AppEngineWizardSettingsHolder settings, Module module) {
        if ("Django".equals(settings.getThirdPartyLib())) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                VirtualFile djangoFolder = AppEngineUtil.getDjangoBinFolder((String)settings.getAppEngineSdkFolder());
                if (djangoFolder == null) {
                    Messages.showErrorDialog((Project)project, (String)AppEngineBundle.message((String)"python.app.engine.project.create.no.django", (Object[])new Object[0]), (String)AppEngineBundle.message((String)"python.app.engine.project.create", (Object[])new Object[0]));
                } else {
                    try {
                        DjangoProjectCreatorAndConfigurator.createProject((VirtualFile)baseDir, (Sdk)settings.getSdk(), (DjangoWizardSettingsHolder)settings, (Module)module, null);
                    }
                    catch (ExecutionException e) {
                        Messages.showErrorDialog((Project)project, (String)AppEngineBundle.message((String)"python.app.engine.project.django.error", (Object[])new Object[]{e.getMessage()}), (String)AppEngineBundle.message((String)"python.app.engine.project.create", (Object[])new Object[0]));
                    }
                }
            });
        }
        if ("Flask".equals(settings.getThirdPartyLib())) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    VfsUtil.createDirectoryIfMissing((VirtualFile)baseDir, (String)"lib");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            final VirtualFile lib = baseDir.findChild("lib");
            if (lib == null) {
                return;
            }
            ProgressManager.getInstance().run((Task)new Task.Modal(project, AppEngineBundle.message((String)"python.app.engine.project.installing.flask.title", (Object[])new Object[0]), false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    indicator.setText(AppEngineBundle.message((String)"python.app.engine.project.installing.flask.progress", (Object[])new Object[0]));
                    Sdk targetSdk = settings.getSdk();
                    if (targetSdk == null) {
                        AppEngineProjectGenerator.reportPackageInstallationFailure((String)"Flask", (Pair)null);
                        return;
                    }
                    PyPackageManager packageManager = PyPackageManager.getInstance((Sdk)targetSdk);
                    if (packageManager instanceof PyCondaPackageManagerImpl) {
                        ((PyCondaPackageManagerImpl)packageManager).useConda(false);
                    }
                    try {
                        packageManager.install(Collections.singletonList(PyRequirementsKt.pyRequirement((String)"Flask")), (List)Lists.newArrayList((Object[])new String[]{"-t", lib.getPath()}));
                        packageManager.refresh();
                        if (packageManager instanceof PyCondaPackageManagerImpl) {
                            ((PyCondaPackageManagerImpl)packageManager).useConda(true);
                        }
                    }
                    catch (ExecutionException e) {
                        AppEngineProjectGenerator.reportPackageInstallationFailure((String)"Flask", (Pair)Pair.create((Object)targetSdk, (Object)((Object)e)));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/appengine/AppEngineProjectGenerator$2", "run"));
                }
            });
            AppEngineProjectGenerator.markSourceRoot(project, baseDir, lib);
        }
    }

    private static void markSourceRoot(Project project, VirtualFile baseDir, @NotNull VirtualFile lib) {
        Module[] modules;
        if (lib == null) {
            AppEngineProjectGenerator.$$$reportNull$$$0(5);
        }
        if ((modules = ModuleManager.getInstance((Project)project).getModules()).length > 0) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                ContentEntry[] contentEntries;
                ModifiableRootModel model = ModuleRootManager.getInstance((Module)modules[0]).getModifiableModel();
                for (ContentEntry contentEntry : contentEntries = model.getContentEntries()) {
                    if (!Comparing.equal((Object)contentEntry.getFile(), (Object)baseDir)) continue;
                    contentEntry.addSourceFolder(lib, false);
                }
                model.commit();
            });
        }
    }

    @NotNull
    public ValidationResult validate(@NotNull String baseDirPath) {
        if (baseDirPath == null) {
            AppEngineProjectGenerator.$$$reportNull$$$0(6);
        }
        ValidationResult validationResult = this.mySettingsPanel != null ? this.mySettingsPanel.getAppEngineWizardSettingsPanel().getValidationResult() : ValidationResult.OK;
        if (validationResult == null) {
            AppEngineProjectGenerator.$$$reportNull$$$0(7);
        }
        return validationResult;
    }

    private static void configureAppEngineFacet(Module module, AppEngineWizardSettingsHolder settings, String path) {
        AppEngineFacet facet = AppEngineFacet.getInstance((Module)module);
        if (facet == null) {
            AppEngineFacetConfiguration configuration = AppEngineFacetType.getDefaultConfiguration((Project)module.getProject());
            configuration.setSdkFolder(settings.getAppEngineSdkFolder());
            configuration.setProjectRoot(path);
            AppEngineFacetType.createAppEngineFacet((Module)module, (AppEngineFacetConfiguration)configuration);
        }
        ((PyRunConfigurationFactoryEx)PyRunConfigurationFactory.getInstance()).createRunConfiguration(module, (ConfigurationFactory)AppEngineServerRunConfigurationType.getInstance().getConfigurationFactory());
    }

    @NotNull
    public String getFrameworkTitle() {
        return "App Engine";
    }

    public boolean isFrameworkInstalled(@NotNull Sdk sdk) {
        if (sdk == null) {
            AppEngineProjectGenerator.$$$reportNull$$$0(8);
        }
        return PythonSdkType.getLanguageLevelForSdk((Sdk)sdk).isPython2();
    }

    public boolean supportsPython3() {
        return false;
    }

    @Nullable
    public Icon getLogo() {
        return PythonUltimateIcons.Appengine.AppEngine;
    }

    public void locationChanged(@NotNull String newLocation) {
        if (newLocation == null) {
            AppEngineProjectGenerator.$$$reportNull$$$0(9);
        }
        this.mySettingsPanel.getAppEngineWizardSettingsPanel().setApplicationId(newLocation);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/appengine/AppEngineProjectGenerator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lib";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/appengine/AppEngineProjectGenerator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "configureProject";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "markSourceRoot";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isFrameworkInstalled";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "locationChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

