/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.startUpPerformanceReporter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.ActivityImpl;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.diagnostic.startUpPerformanceReporter.ExposingCharArrayWriter;
import com.intellij.diagnostic.startUpPerformanceReporter.IdeaFormatWriterKt;
import com.intellij.diagnostic.startUpPerformanceReporter.MyJsonPrettyPrinter;
import com.intellij.diagnostic.startUpPerformanceReporter.ServiceReporterKt;
import com.intellij.diagnostic.startUpPerformanceReporter.StartUpPerformanceReporter;
import com.intellij.diagnostic.startUpPerformanceReporter.StartUpPerformanceReporterKt;
import com.intellij.diagnostic.startUpPerformanceReporter.ThreadNameManager;
import com.intellij.diagnostic.startUpPerformanceReporter.TraceEventFormatWriter;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.util.containers.ObjectLongHashMap;
import java.io.Closeable;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BA\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0014\u001a\u00020\u0015JH\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001b2\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0004JF\u0010 \u001a\u00020\u00172\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00060\u001b2\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00042\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\b\b\u0002\u0010&\u001a\u00020\u0019H\u0002J(\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#H\u0002J\u000e\u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020.R \u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/diagnostic/startUpPerformanceReporter/IdeaFormatWriter;", "", "activities", "", "", "", "Lcom/intellij/diagnostic/ActivityImpl;", "pluginCostMap", "", "Lcom/intellij/util/containers/ObjectLongHashMap;", "threadNameManager", "Lcom/intellij/diagnostic/startUpPerformanceReporter/ThreadNameManager;", "(Ljava/util/Map;Ljava/util/Map;Lcom/intellij/diagnostic/startUpPerformanceReporter/ThreadNameManager;)V", "logPrefix", "publicStatMetrics", "Lcom/intellij/util/containers/ObjectIntHashMap;", "getPublicStatMetrics", "()Lcom/intellij/util/containers/ObjectIntHashMap;", "stringWriter", "Lcom/intellij/diagnostic/startUpPerformanceReporter/ExposingCharArrayWriter;", "toByteBuffer", "Ljava/nio/ByteBuffer;", "write", "", "timeOffset", "", "items", "", "services", "instantEvents", "end", "projectName", "writeActivities", "offset", "writer", "Lcom/fasterxml/jackson/core/JsonGenerator;", "fieldName", "ownDurations", "measureThreshold", "writeItemTimeInfo", "item", "duration", "writeParallelActivities", "startTime", "writeToLog", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.diagnostic"})
public final class IdeaFormatWriter {
    private final String logPrefix = "=== Start: StartUp Measurement ===\n";
    private final ExposingCharArrayWriter stringWriter;
    @NotNull
    private final ObjectIntHashMap<String> publicStatMetrics;
    private final Map<String, List<ActivityImpl>> activities;
    private final Map<String, ObjectLongHashMap<String>> pluginCostMap;
    private final ThreadNameManager threadNameManager;

    @NotNull
    public final ObjectIntHashMap<String> getPublicStatMetrics() {
        return this.publicStatMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void write(long timeOffset, @NotNull List<ActivityImpl> items, @NotNull List<ActivityImpl> services, @NotNull List<ActivityImpl> instantEvents, long end, @NotNull String projectName) {
        JsonGenerator writer;
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        Intrinsics.checkParameterIsNotNull(services, (String)"services");
        Intrinsics.checkParameterIsNotNull(instantEvents, (String)"instantEvents");
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        this.stringWriter.write(this.logPrefix);
        JsonGenerator jsonGenerator = writer = new JsonFactory().createGenerator((Writer)this.stringWriter);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonGenerator, (String)"writer");
        jsonGenerator.setPrettyPrinter((PrettyPrinter)new MyJsonPrettyPrinter());
        Closeable closeable = (Closeable)writer;
        boolean bl = false;
        Throwable throwable = null;
        try {
            void $this$array$iv;
            void $this$array$iv2;
            Object element$iv2;
            boolean bl2;
            Iterable $this$any$iv;
            JsonGenerator $this$obj$iv;
            block13: {
                ApplicationInfo appInfo;
                JsonGenerator it = (JsonGenerator)closeable;
                boolean bl3 = false;
                $this$obj$iv = writer;
                String fieldName$iv = null;
                boolean $i$f$obj = false;
                $this$obj$iv.writeStartObject();
                boolean bl4 = false;
                writer.writeStringField("version", "19");
                ApplicationInfo applicationInfo = appInfo = ApplicationInfo.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfo, (String)"appInfo");
                writer.writeStringField("build", applicationInfo.getBuild().asStringWithoutProductCode());
                writer.writeStringField("buildDate", ZonedDateTime.ofInstant(appInfo.getBuildDate().toInstant(), ZoneId.systemDefault()).format(DateTimeFormatter.RFC_1123_DATE_TIME));
                BuildNumber buildNumber = appInfo.getBuild();
                Intrinsics.checkExpressionValueIsNotNull((Object)buildNumber, (String)"appInfo.build");
                writer.writeStringField("productCode", buildNumber.getProductCode());
                writer.writeStringField("generated", ZonedDateTime.now().format(DateTimeFormatter.RFC_1123_DATE_TIME));
                writer.writeStringField("os", SystemInfo.getOsNameAndVersion());
                writer.writeStringField("runtime", SystemInfo.JAVA_VENDOR + " " + SystemInfo.JAVA_VERSION + " " + SystemInfo.JAVA_RUNTIME_VERSION);
                RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
                Intrinsics.checkExpressionValueIsNotNull((Object)runtimeMXBean, (String)"ManagementFactory.getRuntimeMXBean()");
                List<String> list = runtimeMXBean.getInputArguments();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"ManagementFactory.getRun\u2026meMXBean().inputArguments");
                $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        String it2 = (String)element$iv2;
                        boolean bl5 = false;
                        if (!(Intrinsics.areEqual((Object)it2, (Object)"-Xshare:auto") || Intrinsics.areEqual((Object)it2, (Object)"-Xshare:on"))) continue;
                        bl2 = true;
                        break block13;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                writer.writeBooleanField("cds", true);
            }
            writer.writeStringField("project", IdeaFormatWriterKt.access$safeHashValue(projectName));
            ServiceReporterKt.writeServiceStats(writer);
            IdeaFormatWriterKt.access$writeIcons(writer);
            $this$any$iv = writer;
            String fieldName$iv = "traceEvents";
            boolean $i$f$array = false;
            element$iv2 = fieldName$iv;
            boolean bl6 = false;
            boolean bl7 = false;
            Object it$iv = element$iv2;
            boolean bl8 = false;
            $this$array$iv2.writeFieldName(it$iv);
            $this$array$iv2.writeStartArray();
            boolean bl9 = false;
            TraceEventFormatWriter traceEventFormatWriter = new TraceEventFormatWriter(timeOffset, instantEvents, this.threadNameManager);
            traceEventFormatWriter.writeInstantEvents(writer);
            traceEventFormatWriter.writeServiceEvents(writer, services, this.pluginCostMap);
            $this$array$iv2.writeEndArray();
            long totalDuration = 0L;
            fieldName$iv = writer;
            String fieldName$iv2 = "items";
            boolean $i$f$array2 = false;
            String string = fieldName$iv2;
            bl7 = false;
            boolean bl10 = false;
            String it$iv2 = string;
            $i$a$-let-JacksonKt$array$1$iv = false;
            $this$array$iv.writeFieldName(it$iv2);
            $this$array$iv.writeStartArray();
            boolean bl11 = false;
            boolean bl12 = false;
            for (ActivityImpl item : (Iterable)items) {
                void index;
                JsonGenerator $this$obj$iv2 = writer;
                String fieldName$iv3 = null;
                boolean $i$f$obj = false;
                $this$obj$iv2.writeStartObject();
                boolean bl13 = false;
                writer.writeStringField("name", item.getName());
                if (item.getDescription() != null) {
                    writer.writeStringField("description", item.getDescription());
                }
                long duration = item.getEnd() - item.getStart();
                if (!StartUpPerformanceReporterKt.isSubItem(item, (int)index, items)) {
                    totalDuration += duration;
                }
                if (Intrinsics.areEqual((Object)item.getName(), (Object)"bootstrap") || Intrinsics.areEqual((Object)item.getName(), (Object)"app initialization")) {
                    this.publicStatMetrics.put((Object)item.getName(), (int)TimeUnit.NANOSECONDS.toMillis(duration));
                }
                this.writeItemTimeInfo(item, duration, timeOffset, writer);
                $this$obj$iv2.writeEndObject();
                ++index;
            }
            $this$array$iv.writeEndArray();
            this.writeParallelActivities(timeOffset, writer);
            writer.writeNumberField("totalDurationComputed", TimeUnit.NANOSECONDS.toMillis(totalDuration += end - ((ActivityImpl)CollectionsKt.last(items)).getEnd()));
            long totalDurationActual = TimeUnit.NANOSECONDS.toMillis(end - timeOffset);
            writer.writeNumberField("totalDurationActual", totalDurationActual);
            this.publicStatMetrics.put((Object)"totalDuration", (int)totalDurationActual);
            $this$obj$iv.writeEndObject();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final ByteBuffer toByteBuffer() {
        return this.stringWriter.toByteBuffer(this.logPrefix.length());
    }

    public final void writeToLog(@NotNull Logger log) {
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        this.stringWriter.write("\n=== Stop: StartUp Measurement ===");
        log.info(this.stringWriter.toString());
    }

    private final void writeParallelActivities(long startTime, JsonGenerator writer) {
        for (String name : CollectionsKt.sorted((Iterable)this.activities.keySet())) {
            List list = (List)MapsKt.getValue(this.activities, (Object)name);
            StartUpPerformanceReporter.Companion.sortItems$intellij_platform_diagnostic(list);
            long measureThreshold = Intrinsics.areEqual((Object)name, (Object)ActivityCategory.APP_INIT.getJsonName()) || Intrinsics.areEqual((Object)name, (Object)ActivityCategory.REOPENING_EDITOR.getJsonName()) ? -1L : StartUpMeasurer.MEASURE_THRESHOLD;
            this.writeActivities(list, startTime, writer, IdeaFormatWriterKt.access$activityNameToJsonFieldName(name), (ObjectLongHashMap<ActivityImpl>)new ObjectLongHashMap(), measureThreshold);
        }
    }

    private final void writeActivities(List<ActivityImpl> activities, long offset, JsonGenerator writer, String fieldName, ObjectLongHashMap<ActivityImpl> ownDurations, long measureThreshold) {
        if (activities.isEmpty()) {
            return;
        }
        JsonGenerator $this$array$iv = writer;
        boolean $i$f$array = false;
        String string = fieldName;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it$iv = string2;
            boolean bl3 = false;
            $this$array$iv.writeFieldName(it$iv);
        }
        $this$array$iv.writeStartArray();
        boolean bl = false;
        long skippedDuration = 0L;
        for (ActivityImpl item : activities) {
            long duration;
            long computedOwnDuration = ownDurations.get((Object)item);
            long l = duration = computedOwnDuration == -1L ? item.getEnd() - item.getStart() : computedOwnDuration;
            if (item.getPluginId() != null) {
                String string3;
                boolean bl4 = false;
                boolean bl5 = false;
                String it = string3;
                boolean bl6 = false;
                Object object = item.getCategory();
                if (object == null || (object = object.name()) == null) {
                    object = "unknown";
                }
                StartUpMeasurer.doAddPluginCost((String)it, (String)object, (long)duration, this.pluginCostMap);
            }
            if (Intrinsics.areEqual((Object)fieldName, (Object)"prepareAppInitActivities") && Intrinsics.areEqual((Object)item.getName(), (Object)"splash initialization")) {
                this.publicStatMetrics.put((Object)"splash", (int)TimeUnit.NANOSECONDS.toMillis(duration));
            }
            if (duration <= measureThreshold) {
                skippedDuration += duration;
                continue;
            }
            JsonGenerator $this$obj$iv = writer;
            String fieldName$iv = null;
            boolean $i$f$obj = false;
            $this$obj$iv.writeStartObject();
            boolean bl7 = false;
            writer.writeStringField("name", item.getName());
            this.writeItemTimeInfo(item, duration, offset, writer);
            $this$obj$iv.writeEndObject();
        }
        if (skippedDuration > 0L) {
            JsonGenerator $this$obj$iv = writer;
            String fieldName$iv = null;
            boolean $i$f$obj = false;
            $this$obj$iv.writeStartObject();
            boolean bl8 = false;
            writer.writeStringField("name", "Other");
            writer.writeNumberField("duration", TimeUnit.NANOSECONDS.toMillis(skippedDuration));
            writer.writeNumberField("start", TimeUnit.NANOSECONDS.toMillis(((ActivityImpl)CollectionsKt.last(activities)).getStart() - offset));
            writer.writeNumberField("end", TimeUnit.NANOSECONDS.toMillis(((ActivityImpl)CollectionsKt.last(activities)).getEnd() - offset));
            $this$obj$iv.writeEndObject();
        }
        $this$array$iv.writeEndArray();
    }

    static /* synthetic */ void writeActivities$default(IdeaFormatWriter ideaFormatWriter, List list, long l, JsonGenerator jsonGenerator, String string, ObjectLongHashMap objectLongHashMap, long l2, int n, Object object) {
        if ((n & 0x20) != 0) {
            l2 = StartUpMeasurer.MEASURE_THRESHOLD;
        }
        ideaFormatWriter.writeActivities(list, l, jsonGenerator, string, (ObjectLongHashMap<ActivityImpl>)objectLongHashMap, l2);
    }

    private final void writeItemTimeInfo(ActivityImpl item, long duration, long offset, JsonGenerator writer) {
        writer.writeNumberField("duration", TimeUnit.NANOSECONDS.toMillis(duration));
        writer.writeNumberField("start", TimeUnit.NANOSECONDS.toMillis(item.getStart() - offset));
        writer.writeNumberField("end", TimeUnit.NANOSECONDS.toMillis(item.getEnd() - offset));
        writer.writeStringField("thread", this.threadNameManager.getThreadName(item));
        if (item.getPluginId() != null) {
            writer.writeStringField("plugin", item.getPluginId());
        }
    }

    public IdeaFormatWriter(@NotNull Map<String, ? extends List<ActivityImpl>> activities, @NotNull Map<String, ObjectLongHashMap<String>> pluginCostMap, @NotNull ThreadNameManager threadNameManager) {
        Intrinsics.checkParameterIsNotNull(activities, (String)"activities");
        Intrinsics.checkParameterIsNotNull(pluginCostMap, (String)"pluginCostMap");
        Intrinsics.checkParameterIsNotNull((Object)threadNameManager, (String)"threadNameManager");
        this.activities = activities;
        this.pluginCostMap = pluginCostMap;
        this.threadNameManager = threadNameManager;
        this.logPrefix = "=== Start: StartUp Measurement ===\n";
        this.stringWriter = new ExposingCharArrayWriter();
        this.publicStatMetrics = new ObjectIntHashMap();
    }
}

