/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.model.DataType;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class JdbcUtil {
    private JdbcUtil() {
    }

    public static boolean hasScaleAndPrecision(int jdbcType) {
        switch (jdbcType) {
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static boolean hasLength(int jdbcType) {
        switch (jdbcType) {
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static String getJdbcTypeName(@NotNull DataType dataType) {
        if (dataType == null) {
            JdbcUtil.$$$reportNull$$$0(0);
        }
        return JdbcUtil.getJdbcTypeName(dataType, true);
    }

    @NotNull
    public static String getJdbcTypeName(@NotNull DataType dataType, boolean addLength) {
        String typeName;
        String sqlType;
        if (dataType == null) {
            JdbcUtil.$$$reportNull$$$0(1);
        }
        if (StringUtil.isNotEmpty((String)(sqlType = dataType.typeName)) && sqlType.indexOf(40) > -1) {
            String string = sqlType;
            if (string == null) {
                JdbcUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        int jdbcType = dataType.jdbcType;
        String string = typeName = StringUtil.isNotEmpty((String)sqlType) ? sqlType : JdbcUtil.getJdbcTypeName(jdbcType);
        if (addLength) {
            int scale;
            boolean hasLength = JdbcUtil.hasLength(jdbcType);
            boolean hasScaleAndPrecision = !hasLength && JdbcUtil.hasScaleAndPrecision(jdbcType);
            int length = hasLength || hasScaleAndPrecision ? dataType.getLength() : -1;
            int n = scale = hasScaleAndPrecision ? dataType.getScale() : -1;
            if (hasLength && length > 0) {
                String string2 = typeName + "(" + length + ")";
                if (string2 == null) {
                    JdbcUtil.$$$reportNull$$$0(3);
                }
                return string2;
            }
            if (hasScaleAndPrecision && length > 0 && scale >= 0) {
                String string3 = typeName + "(" + length + ", " + scale + ")";
                if (string3 == null) {
                    JdbcUtil.$$$reportNull$$$0(4);
                }
                return string3;
            }
        }
        String string4 = typeName;
        if (string4 == null) {
            JdbcUtil.$$$reportNull$$$0(5);
        }
        return string4;
    }

    @NotNull
    public static String getJdbcTypeName(int jdbcType) {
        String result;
        switch (jdbcType) {
            case -7: {
                result = "BIT";
                break;
            }
            case -6: {
                result = "TINYINT";
                break;
            }
            case 5: {
                result = "SMALLINT";
                break;
            }
            case 4: {
                result = "INTEGER";
                break;
            }
            case -5: {
                result = "BIGINT";
                break;
            }
            case 6: {
                result = "FLOAT";
                break;
            }
            case 7: {
                result = "REAL";
                break;
            }
            case 8: {
                result = "DOUBLE";
                break;
            }
            case 2: {
                result = "NUMERIC";
                break;
            }
            case 3: {
                result = "DECIMAL";
                break;
            }
            case 1: {
                result = "CHAR";
                break;
            }
            case 12: {
                result = "VARCHAR";
                break;
            }
            case -1: {
                result = "LONGVARCHAR";
                break;
            }
            case 91: {
                result = "DATE";
                break;
            }
            case 92: {
                result = "TIME";
                break;
            }
            case 93: {
                result = "TIMESTAMP";
                break;
            }
            case -2: {
                result = "BINARY";
                break;
            }
            case -3: {
                result = "VARBINARY";
                break;
            }
            case -4: {
                result = "LONGVARBINARY";
                break;
            }
            case 0: {
                result = "NULL";
                break;
            }
            case 1111: {
                result = "OTHER";
                break;
            }
            case 2000: {
                result = "JAVA_OBJECT";
                break;
            }
            case 2001: {
                result = "DISTINCT";
                break;
            }
            case 2002: {
                result = "STRUCT";
                break;
            }
            case 2003: {
                result = "ARRAY";
                break;
            }
            case 2004: {
                result = "BLOB";
                break;
            }
            case 2005: {
                result = "CLOB";
                break;
            }
            case 2006: {
                result = "REF";
                break;
            }
            case 70: {
                result = "DATALINK";
                break;
            }
            case 16: {
                result = "BOOLEAN";
                break;
            }
            default: {
                result = "UNKNOWN";
            }
        }
        String string = result;
        if (string == null) {
            JdbcUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static int guessJdbcTypeByName(String name) {
        if (StringUtil.isEmpty((String)name)) {
            return 1111;
        }
        String fixed = StringUtil.toUpperCase((String)name);
        if (fixed.contains("BINARY")) {
            return -3;
        }
        if (fixed.contains("BIT")) {
            return -7;
        }
        if (fixed.contains("BOOL")) {
            return 16;
        }
        if (fixed.contains("DATE")) {
            return 91;
        }
        if (fixed.contains("TIMESTAMP")) {
            return 93;
        }
        if (fixed.contains("TIME")) {
            return 92;
        }
        if (fixed.contains("REAL") || fixed.contains("NUMBER")) {
            return 7;
        }
        if (fixed.contains("FLOAT")) {
            return 6;
        }
        if (fixed.contains("DOUBLE")) {
            return 8;
        }
        if (fixed.equals("CHAR") && !fixed.contains("VAR")) {
            return 1;
        }
        if (fixed.contains("INT") && !fixed.contains("INTERVAL")) {
            return 4;
        }
        if (fixed.contains("DECIMAL")) {
            return 3;
        }
        if (fixed.contains("NUMERIC")) {
            return 2;
        }
        if (fixed.contains("CHAR") || fixed.contains("TEXT")) {
            return 12;
        }
        if (fixed.contains("BLOB")) {
            return 2004;
        }
        if (fixed.contains("CLOB")) {
            return 2005;
        }
        if (fixed.contains("REFERENCE")) {
            return 2006;
        }
        return 1111;
    }

    public static boolean isNumberType(int jdbcType) {
        boolean result;
        switch (jdbcType) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public static boolean isStringType(int jdbcType) {
        switch (jdbcType) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: 
            case 2011: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDateTimeType(int jdbcType) {
        switch (jdbcType) {
            case 91: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static String getLongMessage(@NotNull Throwable e) {
        if (e == null) {
            JdbcUtil.$$$reportNull$$$0(7);
        }
        String string = JdbcUtil.getMessagePrefix(e) + JdbcUtil.getMessage(e);
        if (string == null) {
            JdbcUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static String getMessage(@NotNull Throwable t) {
        String m;
        if (t == null) {
            JdbcUtil.$$$reportNull$$$0(9);
        }
        String string = StringUtil.isNotEmpty((String)(m = t.getMessage())) ? m.trim() : t.getClass().getName();
        if (string == null) {
            JdbcUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static String getMessagePrefix(@NotNull Throwable t) {
        if (t == null) {
            JdbcUtil.$$$reportNull$$$0(11);
        }
        if (!(t instanceof SQLException)) {
            return "";
        }
        SQLException e = (SQLException)t;
        String state = e.getSQLState();
        int code = e.getErrorCode();
        if (StringUtil.isEmpty((String)state)) {
            return code != 0 ? "[" + code + "] " : "";
        }
        if (code != 0) {
            String string = "[" + state + "][" + code + "] ";
            if (string == null) {
                JdbcUtil.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = "[" + state + "] ";
        if (string == null) {
            JdbcUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/JdbcUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/JdbcUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdbcTypeName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLongMessage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessagePrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getJdbcTypeName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLongMessage";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMessagePrefix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

