/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.psi.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.LESSElementTypes;
import org.jetbrains.plugins.less.psi.LESSElementGenerator;
import org.jetbrains.plugins.less.psi.LESSVariableDeclaration;
import org.jetbrains.plugins.less.psi.LessElement;
import org.jetbrains.plugins.less.psi.impl.LESSElementVisitor;
import org.jetbrains.plugins.less.psi.impl.LessNamedArgument;
import org.jetbrains.plugins.less.psi.impl.LessVariableInterpolationImpl;
import org.jetbrains.plugins.less.references.LESSVariableReference;
import org.jetbrains.plugins.less.references.LessNamedArgumentReference;
import org.jetbrains.plugins.less.references.LessPropertyAsVariableReference;

public class LESSVariableImpl
extends CompositePsiElement
implements LessElement,
PsiNamedElement {
    protected LESSVariableImpl() {
        super(LESSElementTypes.LESS_VARIABLE);
    }

    public PsiReference getReference() {
        if (this.getParent() instanceof LessNamedArgument) {
            return new LessNamedArgumentReference(this);
        }
        if (this.getParent() instanceof LESSVariableDeclaration) {
            return null;
        }
        if (this.isPropertyAsVariable()) {
            return new LessPropertyAsVariableReference(this);
        }
        return new LESSVariableReference(this);
    }

    public PsiElement setName(@NotNull String newName) {
        if (newName == null) {
            LESSVariableImpl.$$$reportNull$$$0(0);
        }
        LESSVariableImpl variable = this.getParent() instanceof LessVariableInterpolationImpl ? LESSElementGenerator.createVariableInInterpolation(this.getProject(), newName) : LESSElementGenerator.createVariable(this.getProject(), this.createNewName(newName));
        return variable != null ? this.replace((PsiElement)variable) : this;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            LESSVariableImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof LESSElementVisitor) {
            ((LESSElementVisitor)visitor).visitLESSVariable(this);
            return;
        }
        super.accept(visitor);
    }

    public int getTextOffset() {
        String text = this.getText();
        if (StringUtil.startsWith((CharSequence)text, (CharSequence)"@@")) {
            return this.getStartOffset() + 2;
        }
        if (StringUtil.startsWithChar((CharSequence)text, (char)'@') || StringUtil.startsWithChar((CharSequence)text, (char)'$')) {
            return this.getStartOffset() + 1;
        }
        return this.getStartOffset();
    }

    public boolean isPropertyAsVariable() {
        return StringUtil.startsWithChar((CharSequence)this.getText(), (char)'$');
    }

    @NotNull
    public String getName() {
        String text = this.getText();
        if (StringUtil.startsWith((CharSequence)text, (CharSequence)"@@")) {
            String string = text.substring(2);
            if (string == null) {
                LESSVariableImpl.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (StringUtil.startsWithChar((CharSequence)text, (char)'@') || StringUtil.startsWithChar((CharSequence)text, (char)'$')) {
            String string = text.substring(1);
            if (string == null) {
                LESSVariableImpl.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = text;
        if (string == null) {
            LESSVariableImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    private String createNewName(String name) {
        String text = this.getText();
        if (text.startsWith("@@")) {
            return "@@" + StringUtil.trimLeading((String)name, (char)'@');
        }
        return "@" + StringUtil.trimLeading((String)name, (char)'@');
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/less/psi/impl/LESSVariableImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/less/psi/impl/LESSVariableImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

