/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CachedSingletonsRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public abstract class ProjectLocator {
    private static ProjectLocator ourInstance = CachedSingletonsRegistry.markCachedField(ProjectLocator.class);
    private static final ThreadLocal<Map<VirtualFile, Project>> ourPreferredProjects = ThreadLocal.withInitial(() -> new HashMap());

    public static ProjectLocator getInstance() {
        ProjectLocator result = ourInstance;
        if (result == null) {
            ourInstance = result = (ProjectLocator)ApplicationManager.getApplication().getService(ProjectLocator.class);
        }
        return result;
    }

    @Nullable
    public abstract Project guessProjectForFile(@Nullable VirtualFile var1);

    @NotNull
    public abstract Collection<Project> getProjectsForFile(@NotNull VirtualFile var1);

    @NotNull
    public static AccessToken runWithPreferredProject(final @NotNull VirtualFile file, @NotNull Project preferredProject) {
        if (file == null) {
            ProjectLocator.$$$reportNull$$$0(0);
        }
        if (preferredProject == null) {
            ProjectLocator.$$$reportNull$$$0(1);
        }
        final Map<VirtualFile, Project> local = ourPreferredProjects.get();
        local.put(file, preferredProject);
        return new AccessToken(){

            public void finish() {
                local.remove(file);
            }
        };
    }

    @Nullable
    static Project getPreferredProject(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectLocator.$$$reportNull$$$0(2);
        }
        return ourPreferredProjects.get().get(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferredProject";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/project/ProjectLocator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runWithPreferredProject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getPreferredProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

