/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ReflectionUtil;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CharsetUtil {
    private static final Map<String, Boolean> ourSupportsCharsetDetection = new ConcurrentHashMap<String, Boolean>();

    private static boolean overridesExtractCharsetFromContent(LanguageFileType fileType) {
        Class<?> ftClass = fileType.getClass();
        String methodName = "extractCharsetFromFileContent";
        Class declaring1 = ReflectionUtil.getMethodDeclaringClass(ftClass, (String)methodName, (Class[])new Class[]{Project.class, VirtualFile.class, String.class});
        Class declaring2 = ReflectionUtil.getMethodDeclaringClass(ftClass, (String)methodName, (Class[])new Class[]{Project.class, VirtualFile.class, CharSequence.class});
        return !LanguageFileType.class.equals((Object)declaring1) || !LanguageFileType.class.equals((Object)declaring2);
    }

    public static Charset extractCharsetFromFileContent(@Nullable Project project, @Nullable VirtualFile virtualFile2, @Nullable FileType fileType, @NotNull CharSequence text) {
        if (text == null) {
            CharsetUtil.$$$reportNull$$$0(0);
        }
        if (fileType instanceof LanguageFileType && ourSupportsCharsetDetection.computeIfAbsent(fileType.getName(), __ -> CharsetUtil.overridesExtractCharsetFromContent((LanguageFileType)fileType)).booleanValue()) {
            return ((LanguageFileType)fileType).extractCharsetFromFileContent(project, virtualFile2, text);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/fileTypes/CharsetUtil", "extractCharsetFromFileContent"));
    }
}

